/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

public enum MessageType {
    Nil(0),
    sp1m_cmd_lower_bound(1),
    ExecuteDirect(2),
    Prepare(3),
    ABAPStream(4),
    XA_Start(5),
    XA_Join(6),
    XA_Commit(7),
    XA_Rollback(8),
    ExecQidNextItab(9),
    sp1m_cfill5(10),
    sp1m_cmd_upper_bound(11),
    sp1m_no_cmd_lower_bound(12),
    Execute(13),
    sp1m_ncfill0(14),
    sp1m_putval(15),
    ReadLOB(16),
    WriteLOB(17),
    FindLOB(18),
    sp1m_ncfill1(19),
    sp1m_ncfill2(20),
    sp1m_ncfill3(21),
    sp1m_ncfill4(22),
    sp1m_ncfill5(23),
    sp1m_no_cmd_upper_bound(24),
    Ping(25),
    sp1m_util_lower_bound(26),
    sp1m_utility(27),
    sp1m_incopy(28),
    sp1m_page_transport(29),
    sp1m_outcopy(30),
    sp1m_diag_outcopy(31),
    sp1m_ufill3(32),
    sp1m_ufill4(33),
    sp1m_ufill5(34),
    sp1m_ufill6(35),
    sp1m_ufill7(36),
    sp1m_util_upper_bound(37),
    sp1m_specials_lower_bound(38),
    sp1m_switch(39),
    sp1m_switchlimit(40),
    sp1m_buflength(41),
    sp1m_minbuf(42),
    sp1m_maxbuf(43),
    sp1m_state_utility(44),
    sp1m_get_challenge(45),
    sp1m_sfill3(46),
    sp1m_sfill4(47),
    sp1m_sfill5(48),
    sp1m_specials_upper_bound(49),
    sp1m_wait_for_event(50),
    sp1m_procserv_lower_bound(51),
    sp1m_procserv_call(52),
    sp1m_procserv_reply(53),
    sp1m_procserv_fill1(54),
    sp1m_procserv_fill2(55),
    sp1m_procserv_fill3(56),
    sp1m_procserv_fill4(57),
    sp1m_procserv_fill5(58),
    sp1m_procserv_upper_bound(59),
    sp1m_dataagent_lower_bound(60),
    sp1m_dataagent_command(61),
    sp1m_dataagent_execute(62),
    sp1m_dataagent_parse(63),
    sp1m_dataagent_upper_bound(64),
    Authenticate(65),
    Connect(66),
    Commit(67),
    Rollback(68),
    CloseResultSet(69),
    DropStatementID(70),
    FetchNext(71),
    FetchAbsolute(72),
    FetchRelative(73),
    FetchFirst(74),
    FetchLast(75),
    FetchLastWithRowNo(76),
    Disconnect(77),
    ExecuteItab(78),
    FetchNextItab(79),
    InsertNextItab(80),
    BatchPrepare(81),
    DBConnectInfo(82),
    XOpen_XAStart(83),
    XOpen_XAEnd(84),
    XOpen_XAPrepare(85),
    XOpen_XACommit(86),
    XOpen_XARollback(87),
    XOpen_XARecover(88),
    XOpen_XAForget(89),
    Unknown(-1);

    private static final MessageType[] VALUES;

    public static MessageType decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return MessageType.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private MessageType(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = MessageType.values();
    }
}

