/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.BuildPlatform;
import com.sap.db.jdbc.packet.ClientContextOption;
import com.sap.db.jdbc.packet.CommandInfo;
import com.sap.db.jdbc.packet.CommandOption;
import com.sap.db.jdbc.packet.CommitOption;
import com.sap.db.jdbc.packet.ConnectOption;
import com.sap.db.jdbc.packet.DBConnectInfoOption;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.DistributionProtocolVersion;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.MessageType;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.ProfileElement;
import com.sap.db.jdbc.packet.SegmentKind;
import com.sap.db.jdbc.packet.SessionContextOption;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.packet.XATransactionInfoOption;
import com.sap.db.jdbcext.XidSAP;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.StringUtils;
import com.sap.db.util.security.AbstractAuthenticationManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.Xid;

public class HRequestPacket {
    public static final int DEFAULT_REQUEST_PACKET_SIZE = 130000;
    public static final int MAX_SEGMENT_COUNT = Short.MAX_VALUE;
    private static final boolean FILL_ON_INIT = false;
    private static final byte FILLER = -2;
    private static final long DUMMY_PROFILE_TIME = -1L;
    private static final String UNKNOWN_HOST_NAME = "unknown";
    private static final int MAX_LOB_READ_CHUNK_SIZE = 200000;
    private byte[] _packet;
    private List<Segment> _segments;
    private int _packetLength;
    private short _segmentCount;
    private int _segmentIndex;
    private int _segmentOffset;
    private short _partCount;
    private int _partIndex;
    private int _partOffset;
    private int _argumentCount;
    private int _sendTimeOffset;
    private int _receiveTimeOffset;

    public static HRequestPacket newInstance(byte[] packet) {
        return new HRequestPacket(packet);
    }

    private HRequestPacket(byte[] packet) {
        this._packet = packet;
        this._segments = new ArrayList<Segment>(1);
        this._initPacket();
    }

    public byte[] getRawPacketArray() {
        return this._packet;
    }

    public int getSize() {
        return this._packet.length;
    }

    public int getLength() {
        return this._packetLength;
    }

    public int getAvailableSpace() {
        int availableSpace = this._packet.length - this._packetLength;
        return availableSpace;
    }

    public int getArgumentCount() {
        return this._argumentCount;
    }

    public HAuthenticationPart initAuthenticate() {
        this._initPacket();
        this._newSegment(MessageType.Authenticate, null, null);
        this._addClientContextPart();
        return this._addAuthenticationPart();
    }

    public void initConnect(AbstractAuthenticationManager authenticationManager, ConnectionSapDB connection, Session session, String userName, String passwd, String userNameFromServer) throws SQLException {
        Session anchorSession = null;
        this._initPacket();
        this._newSegment(MessageType.Connect, null, null);
        if (connection != null && session != null && (anchorSession = connection.getSessionPool().getAnchorSession()) != null && anchorSession.isPrimarySite() && anchorSession.getSiteVolumeID().getSiteID() != session.getSiteVolumeID().getSiteID()) {
            this._addSessionContextPart(connection);
        }
        HAuthenticationPart authenticationPart = this._addAuthenticationPart();
        authenticationManager.setClientProofPart(authenticationPart, StringUtils.stripUserName(userNameFromServer != null ? userNameFromServer : userName), passwd);
        authenticationPart.close();
        this._addClientIDPart(connection.getTermID());
        this._addConnectOptionsPart(connection, anchorSession);
        this._closeSegment();
        this._closePacket();
    }

    public void initDBConnectInfo(String databaseName) {
        this._initPacket();
        this._newSegment(MessageType.DBConnectInfo, null, null);
        this._addDBConnectInfoPart(databaseName);
        this._closeSegment();
        this._closePacket();
    }

    public void initDisconnect() {
        this._initPacket();
        this._newSegment(MessageType.Disconnect, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public boolean initExecuteDirect(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, String sql, String sourceModule, int lineNumber) {
        return this.initExecuteDirect(connection, session, resultSetHoldability, queryTimeout, sql, sourceModule, lineNumber, true, false);
    }

    public boolean initExecuteDirect(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, String sql, String sourceModule, int lineNumber, boolean isFirstStatementInPacket, boolean isBatch) {
        int availableSpace;
        int requiredSpace;
        boolean doAddCommandInfoPart;
        boolean bl = doAddCommandInfoPart = sourceModule != null && lineNumber != -1;
        if (isFirstStatementInPacket) {
            this._initPacket();
            this._newSegment(MessageType.ExecuteDirect, connection, session, resultSetHoldability, queryTimeout, true);
            requiredSpace = 0;
        } else {
            boolean willIncludeQueryTimeout;
            if (!isFirstStatementInPacket && this._segmentCount >= Short.MAX_VALUE) {
                return false;
            }
            requiredSpace = 24;
            byte[] statementContext = connection.getStatementContext();
            boolean willIncludeStatementSequenceInfo = statementContext != null;
            boolean bl2 = willIncludeQueryTimeout = connection.getEngineFeatures().isQueryTimeoutSupported() && queryTimeout > 0;
            if (willIncludeStatementSequenceInfo || willIncludeQueryTimeout) {
                requiredSpace += 16;
                if (willIncludeStatementSequenceInfo) {
                    requiredSpace += statementContext.length + 4;
                }
                if (willIncludeQueryTimeout) {
                    requiredSpace += 10;
                }
            }
        }
        requiredSpace += 16 + Cesu8Utils.getByteLength(sql);
        if (doAddCommandInfoPart) {
            requiredSpace += 16 + Cesu8Utils.getByteLength(sourceModule) + 4;
        }
        if (requiredSpace > (availableSpace = this.getAvailableSpace())) {
            if (isFirstStatementInPacket) {
                this._resize(this._packetLength + requiredSpace);
            } else {
                return false;
            }
        }
        if (!isFirstStatementInPacket) {
            this._newSegment(MessageType.ExecuteDirect, connection, session, resultSetHoldability, queryTimeout, false);
        }
        this._addCommandPart(sql);
        if (doAddCommandInfoPart) {
            this._addCommandInfoPart(sourceModule, lineNumber);
        }
        this._closeSegment();
        if (!isBatch) {
            this._closePacket();
        }
        return true;
    }

    public void initPrepare(ConnectionSapDB connection, Session session, int resultSetHoldability, String sql) {
        this._initPacket();
        this._newSegment(MessageType.Prepare, connection, session, resultSetHoldability, 0, true);
        int requiredSpace = 16 + Cesu8Utils.getByteLength(sql);
        int availableSpace = this.getAvailableSpace();
        if (requiredSpace > availableSpace) {
            this._resize(this._packetLength + requiredSpace);
        }
        this._addCommandPart(sql);
        this._closeSegment();
        this._closePacket();
    }

    public HDataPart initExecute(ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, ParseID parseID, boolean hasInputParameters) {
        this._initPacket();
        this._newSegment(MessageType.Execute, connection, session, resultSetHoldability, queryTimeout, true);
        this._addStatementIDPart(parseID);
        return hasInputParameters ? this._addParametersPart() : null;
    }

    public void initReadLOB(ConnectionSapDB connection, Session session, byte[] locatorID, long position) {
        this._initPacket();
        this._newSegment(MessageType.ReadLOB, connection, session);
        this._addReadLOBRequestPart(locatorID, position);
        this._closeSegment();
        this._closePacket();
    }

    public HDataPart initWriteLOB(ConnectionSapDB connection, Session session) throws SQLException {
        this._initPacket();
        this._newSegment(MessageType.WriteLOB, connection, session);
        return this._addWriteLOBRequestPart();
    }

    public void initFetchNext(ConnectionSapDB connection, Session session, CursorID cursorID, int fetchSize) {
        this._initPacket();
        this._newSegment(MessageType.FetchNext, connection, session);
        this._addResultSetIDPart(cursorID);
        this._addFetchSizePart(fetchSize);
        this._closeSegment();
        this._closePacket();
    }

    public void initCloseResultSet(ConnectionSapDB connection, Session session, CursorID cursorID) {
        this._initPacket();
        this._newSegment(MessageType.CloseResultSet, connection, session);
        this._addResultSetIDPart(cursorID);
        this._closeSegment();
        this._closePacket();
    }

    public void initDropStatementID(ConnectionSapDB connection, Session session, ParseID parseID) {
        this._initPacket();
        this._newSegment(MessageType.DropStatementID, connection, session);
        this._addStatementIDPart(parseID);
        this._closeSegment();
        this._closePacket();
    }

    public void initCommit(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.Commit, connection, session);
        this._addCommitOptionsPart();
        this._closeSegment();
        this._closePacket();
    }

    public void initRollback(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.Rollback, connection, session);
        this._closeSegment();
        this._closePacket();
    }

    public void initStartDistributedTransaction(ConnectionSapDB connection, Session session) {
        this._initPacket();
        this._newSegment(MessageType.XA_Start, connection, session);
        this._closeSegment();
        this._closePacket();
    }

    public void initJoinDistributedTransaction(ConnectionSapDB connection, Session session, byte[] transactionID) {
        this._initPacket();
        this._newSegment(MessageType.XA_Join, connection, session);
        this._addTransactionIDPart(transactionID);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAStart(ConnectionSapDB connection, Session session, Xid xid, int flags) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAStart, connection, session);
        this._addXATransactionInfoPart(xid, flags, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAEnd(ConnectionSapDB connection, Session session, Xid xid, int flags) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAEnd, connection, session);
        this._addXATransactionInfoPart(xid, flags, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAPrepare(ConnectionSapDB connection, Session session, Xid xid) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAPrepare, connection, session);
        this._addXATransactionInfoPart(xid, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXACommit(ConnectionSapDB connection, Session session, Xid xid, boolean onePhase) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XACommit, connection, session);
        this._addXATransactionInfoPart(xid, null, onePhase);
        this._closeSegment();
        this._closePacket();
    }

    public void initXARollback(ConnectionSapDB connection, Session session, Xid xid) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XARollback, connection, session);
        this._addXATransactionInfoPart(xid, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXARecover(ConnectionSapDB connection, Session session, int flags) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XARecover, connection, session);
        this._addXATransactionInfoPart(null, flags, null);
        this._closeSegment();
        this._closePacket();
    }

    public void initXAForget(ConnectionSapDB connection, Session session, Xid xid) {
        this._initPacket();
        this._newSegment(MessageType.XOpen_XAForget, connection, session);
        this._addXATransactionInfoPart(xid, null, null);
        this._closeSegment();
        this._closePacket();
    }

    public void addPartAttribute(PartAttribute partAttribute) {
        int offset = this._partOffset + 1;
        byte currentAttributes = ByteUtils.getByte(this._packet, offset);
        int newAttributes = currentAttributes | partAttribute.getValue();
        ByteUtils.putByte(newAttributes, this._packet, offset);
    }

    public void setAutoCommit(boolean autoCommit) {
        ByteUtils.putByte(autoCommit ? 1 : 0, this._packet, this._segmentOffset + 14);
    }

    public void setStatementContextAndProfileTimes(byte[] statementContext, long sendTime, long receiveTime) {
        if (statementContext != null) {
            for (Segment segment : this._segments) {
                if (segment._statementContextOffset == -1) continue;
                ByteUtils.putBytes(statementContext, this._packet, segment._statementContextOffset);
            }
        }
        if (this._sendTimeOffset != -1) {
            ByteUtils.putLong(sendTime, this._packet, this._sendTimeOffset);
        }
        if (this._receiveTimeOffset != -1) {
            ByteUtils.putLong(receiveTime, this._packet, this._receiveTimeOffset);
        }
    }

    public void close() {
        this._closePacket();
    }

    protected void _resize(int requiredSize) {
        int alignedSize = PacketAnalyzer.align(requiredSize);
        byte[] packet = new byte[alignedSize];
        System.arraycopy(this._packet, 0, packet, 0, this._packetLength);
        this._packet = packet;
    }

    protected void _closePart(int argumentCount, int partLength) {
        this._packetLength += partLength;
        this._argumentCount = argumentCount;
        this._closePart();
    }

    private void _initPacket() {
        this._segments.clear();
        this._packetLength = 32;
        this._segmentCount = 0;
        this._segmentIndex = -1;
        this._segmentOffset = -1;
        this._partCount = (short)-1;
        this._partIndex = -1;
        this._partOffset = -1;
        this._argumentCount = -1;
        this._sendTimeOffset = -1;
        this._receiveTimeOffset = -1;
        ByteUtils.putByte(0, this._packet, 22);
    }

    private void _newSegment(MessageType messageType, ConnectionSapDB connection, Session session) {
        this._newSegment(messageType, connection, session, 2, 0, true);
    }

    private void _newSegment(MessageType messageType, ConnectionSapDB connection, Session session, int resultSetHoldability, int queryTimeout, boolean addAnyPart) {
        int commitImmediately;
        this._closeSegment();
        this._segmentIndex = this._segmentCount;
        this._segmentCount = (short)(this._segmentCount + 1);
        this._segmentOffset = this._packetLength;
        this._partCount = 0;
        this._partIndex = -1;
        this._partOffset = -1;
        this._argumentCount = -1;
        this._packetLength += 24;
        this._segments.add(new Segment(this._segmentOffset));
        switch (messageType) {
            case ExecuteDirect: 
            case Execute: 
            case ReadLOB: 
            case FetchNext: {
                commitImmediately = connection.isAutoCommit() ? 1 : 0;
                break;
            }
            default: {
                commitImmediately = 0;
            }
        }
        int commandOptions = resultSetHoldability == 1 ? CommandOption.HOLD_CURSORS_OVER_COMMIT.getValue() : 0;
        ByteUtils.putInt(this._segmentOffset - 32, this._packet, this._segmentOffset + 4);
        ByteUtils.putShort(this._segmentIndex + 1, this._packet, this._segmentOffset + 10);
        ByteUtils.putByte(SegmentKind.Cmd.getValue(), this._packet, this._segmentOffset + 12);
        ByteUtils.putByte(messageType.getValue(), this._packet, this._segmentOffset + 13);
        ByteUtils.putByte(commitImmediately, this._packet, this._segmentOffset + 14);
        ByteUtils.putByte(commandOptions, this._packet, this._segmentOffset + 15);
        switch (messageType) {
            case Authenticate: 
            case Connect: 
            case Disconnect: 
            case DBConnectInfo: {
                break;
            }
            default: {
                this._addStatementContextPart(connection, queryTimeout);
                if (!addAnyPart) break;
                this._addProfilePart(connection);
            }
        }
        if (addAnyPart && connection != null && session != null) {
            if (session.isSendSessionContextFlagSet()) {
                this._addSessionContextPart(connection);
                session.clearSendSessionContextFlag();
            }
            if (session.isSendSessionVariablesFlagSet() || session.isSendClientInfoFlagSet()) {
                this._addClientInfoPart(connection, session);
                session.clearSendSessionVariablesAndClientInfoFlags(connection);
            }
        }
    }

    private void _newPart(PartKind partKind) {
        this._closePart();
        this._partIndex = this._partCount;
        this._partCount = (short)(this._partCount + 1);
        this._partOffset = this._packetLength;
        this._argumentCount = 0;
        this._packetLength += 16;
        this._segments.get(this._segmentIndex)._parts.add(new Part(this._partOffset));
        ByteUtils.putByte(partKind.getValue(), this._packet, this._partOffset + 0);
        ByteUtils.putByte(0, this._packet, this._partOffset + 1);
        ByteUtils.putInt(0, this._packet, this._partOffset + 4);
    }

    private void _closePart() {
        if (this._partIndex == -1) {
            return;
        }
        int partLength = this._packetLength - this._partOffset - 16;
        ByteUtils.putShort(this._argumentCount, this._packet, this._partOffset + 2);
        ByteUtils.putInt(partLength, this._packet, this._partOffset + 8);
        ((Part)this._segments.get(this._segmentIndex)._parts.get(this._partIndex))._length = partLength;
        this._packetLength = PacketAnalyzer.align(this._packetLength);
        this._partIndex = -1;
        this._partOffset = -1;
        this._argumentCount = -1;
    }

    private void _closeSegment() {
        if (this._segmentIndex == -1) {
            return;
        }
        this._closePart();
        int segmentLength = this._packetLength - this._segmentOffset;
        ByteUtils.putInt(segmentLength, this._packet, this._segmentOffset + 0);
        ByteUtils.putShort(this._partCount, this._packet, this._segmentOffset + 8);
        this._segments.get(this._segmentIndex)._length = segmentLength;
        this._segmentIndex = -1;
        this._segmentOffset = -1;
        this._partCount = (short)-1;
    }

    private void _closePacket() {
        this._closeSegment();
        for (Segment segment : this._segments) {
            for (Part part : segment._parts) {
                ByteUtils.putInt(this._packetLength - part._offset - 16 - part._length, this._packet, part._offset + 12);
            }
        }
        ByteUtils.putInt(this._packetLength - 32, this._packet, 12);
        ByteUtils.putInt(this._packetLength - 32, this._packet, 16);
        ByteUtils.putShort(this._segmentCount, this._packet, 20);
    }

    private HAuthenticationPart _addAuthenticationPart() {
        this._newPart(PartKind.Authentication);
        return new HAuthenticationPart(this, this._packetLength);
    }

    private HOptionsPart _addOptionsPart(PartKind partKind) {
        this._newPart(partKind);
        return new HOptionsPart(this, this._packetLength);
    }

    private void _addStatementContextPart(ConnectionSapDB connection, int queryTimeout) {
        boolean includeQueryTimeout;
        byte[] statementContext = connection.getStatementContext();
        boolean includeStatementSequenceInfo = statementContext != null;
        boolean bl = includeQueryTimeout = connection.getEngineFeatures().isQueryTimeoutSupported() && queryTimeout > 0;
        if (!includeStatementSequenceInfo && !includeQueryTimeout) {
            return;
        }
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.StatementContext);
        if (includeStatementSequenceInfo) {
            optionsPart.addBinaryOption(StatementContextOption.StatementSequenceInfo.getValue(), statementContext);
            this._segments.get(this._segmentIndex)._statementContextOffset = this._packetLength + 4;
        }
        if (includeQueryTimeout) {
            optionsPart.addLongOption(StatementContextOption.QueryTimeout.getValue(), queryTimeout);
        }
        optionsPart.close();
    }

    private void _addProfilePart(ConnectionSapDB connection) {
        if (this._sendTimeOffset != -1 || !connection.getEngineFeatures().ignoresUnknownParts()) {
            return;
        }
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.Profile);
        optionsPart.addLongOption(ProfileElement.SendTime.getValue(), -1L);
        this._sendTimeOffset = this._packetLength + 2;
        optionsPart.addLongOption(ProfileElement.ReceiveTime.getValue(), -1L);
        this._receiveTimeOffset = this._packetLength + 12;
        optionsPart.close();
    }

    private void _addSessionContextPart(ConnectionSapDB connection) {
        int anchorPortNumber;
        String anchorHostName;
        int anchorConnectionID;
        int primaryPortNumber;
        String primaryHostName;
        int primaryConnectionID;
        Location location;
        SessionPool sessionPool = connection.getSessionPool();
        Session primarySession = sessionPool.getPrimarySession();
        Session anchorSession = sessionPool.getAnchorSession();
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.SessionContext);
        if (primarySession != null) {
            location = primarySession.getLocation();
            primaryConnectionID = primarySession.getConnectionID();
            primaryHostName = location.getHostName();
            primaryPortNumber = location.getPortNumber();
        } else {
            primaryConnectionID = 0;
            primaryHostName = UNKNOWN_HOST_NAME;
            primaryPortNumber = 0;
        }
        if (anchorSession != null) {
            location = anchorSession.getLocation();
            anchorConnectionID = anchorSession.getConnectionID();
            anchorHostName = location.getHostName();
            anchorPortNumber = location.getPortNumber();
        } else {
            anchorConnectionID = 0;
            anchorHostName = UNKNOWN_HOST_NAME;
            anchorPortNumber = 0;
        }
        optionsPart.addIntOption(SessionContextOption.PrimaryConnectionID.getValue(), primaryConnectionID);
        optionsPart.addStringOption(SessionContextOption.PrimaryHostName.getValue(), primaryHostName);
        optionsPart.addIntOption(SessionContextOption.PrimaryHostPortNumber.getValue(), primaryPortNumber);
        optionsPart.addIntOption(SessionContextOption.AnchorConnectionID.getValue(), anchorConnectionID);
        optionsPart.addStringOption(SessionContextOption.AnchorHostName.getValue(), anchorHostName);
        optionsPart.addIntOption(SessionContextOption.AnchorHostPortNumber.getValue(), anchorPortNumber);
        optionsPart.close();
    }

    private void _addClientInfoPart(ConnectionSapDB connection, Session session) {
        Map<String, String> transform = connection.generateClientInfoTransform(session);
        this._newPart(PartKind.ClientInfo);
        for (Map.Entry<String, String> entry : transform.entrySet()) {
            this._addVariableStringArg(entry.getKey());
            this._addVariableStringArg(entry.getValue());
        }
        this._closePart();
    }

    private void _addClientContextPart() {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.ClientContext);
        optionsPart.addStringOption(ClientContextOption.ClientVersion.getValue(), Driver.getVersionInfo().toShortVersionNumberString());
        optionsPart.addStringOption(ClientContextOption.ClientType.getValue(), "JDBC");
        optionsPart.addStringOption(ClientContextOption.ClientApplicationProgram.getValue(), "UNKNOWN");
        optionsPart.close();
    }

    private void _addClientIDPart(String clientID) {
        this._newPart(PartKind.ClientID);
        this._addDataStringArg(clientID);
        this._closePart();
    }

    private void _addConnectOptionsPart(ConnectionSapDB connection, Session anchorSession) {
        int distributionMode;
        String osUser;
        Properties connectProperties = connection.getConnectProperties();
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.ConnectOptions);
        optionsPart.addStringOption(ConnectOption.FullVersionString.getValue(), Driver.getVersionInfo().toShortVersionNumberString());
        String databaseName = connectProperties.getProperty("databaseName");
        if (databaseName != null && !databaseName.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.DatabaseName.getValue(), databaseName);
        }
        optionsPart.addIntOption(ConnectOption.BuildPlatform.getValue(), BuildPlatform.Java.getValue());
        String locale = connectProperties.getProperty("locale");
        if (locale != null && !locale.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.ClientLocale.getValue(), locale);
        }
        int newerFormatVersion = DataFormatVersion.Level1.getValue();
        String requestedDataFormat = connectProperties.getProperty("dataFormatSupport", String.valueOf(DataFormatVersion.Level7.getValue()));
        try {
            int dataFormatVersion = Integer.parseInt(requestedDataFormat);
            if (dataFormatVersion >= DataFormatVersion.Level4.getValue() && dataFormatVersion <= DataFormatVersion.Level7.getValue()) {
                newerFormatVersion = dataFormatVersion;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        optionsPart.addIntOption(ConnectOption.DataFormatVersion.getValue(), DataFormatVersion.Level1.getValue());
        optionsPart.addIntOption(ConnectOption.DataFormatVersion2.getValue(), newerFormatVersion);
        String connectionID = connectProperties.getProperty("associatedConnectionID");
        if (connectionID != null && !connectionID.isEmpty()) {
            try {
                optionsPart.addIntOption(ConnectOption.AssociatedConnectionID.getValue(), Integer.parseInt(connectionID));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((osUser = System.getProperty("user.name")) != null && !osUser.isEmpty()) {
            optionsPart.addStringOption(ConnectOption.OSUser.getValue(), osUser);
        }
        if ((distributionMode = connection.getDistributionMode().getValue()) > DistributionMode.Off.getValue()) {
            optionsPart.addBooleanOption(ConnectOption.DistributionEnabled.getValue(), true);
        }
        optionsPart.addIntOption(ConnectOption.ClientDistributionMode.getValue(), distributionMode);
        optionsPart.addIntOption(ConnectOption.DistributionProtocolVersion.getValue(), DistributionProtocolVersion.RangePartitionSpecSupported.getValue());
        optionsPart.addIntOption(ConnectOption.ActiveActiveProtocolVersion.getValue(), ConnectionProperty.getIntProperty(connectProperties, "systemReplicationProtocolVersion", ActiveActiveProtocolVersion.Level2.getValue()));
        Location.SiteType siteType = anchorSession != null ? anchorSession.getLocation().getSiteType() : Location.SiteType.NONE;
        optionsPart.addIntOption(ConnectOption.ActiveActiveConnectionOriginSite.getValue(), siteType.getValue());
        optionsPart.addBooleanOption(ConnectOption.CompleteArrayExecution.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.SelectForUpdateSupported.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.EnableArrayType.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.XOpenXAProtocolSupported.getValue(), true);
        optionsPart.addBooleanOption(ConnectOption.QueryTimeoutSupported.getValue(), true);
        optionsPart.close();
    }

    private void _addDBConnectInfoPart(String databaseName) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.DBConnectInfo);
        optionsPart.addStringOption(DBConnectInfoOption.DatabaseName.getValue(), databaseName);
        optionsPart.close();
    }

    private void _addCommandPart(String sql) {
        this._newPart(PartKind.Command);
        this._addStringArg(sql);
        this._closePart();
    }

    private void _addCommandInfoPart(String sourceModule, int lineNumber) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.CommandInfo);
        optionsPart.addIntOption(CommandInfo.LineNumber.getValue(), lineNumber);
        optionsPart.addStringOption(CommandInfo.SourceModule.getValue(), sourceModule);
        optionsPart.close();
    }

    private HDataPart _addParametersPart() {
        this._newPart(PartKind.Parameters);
        return HDataPart.createParametersPart(this, this._packetLength);
    }

    private void _addReadLOBRequestPart(byte[] locatorID, long position) {
        this._newPart(PartKind.ReadLOBRequest);
        ByteUtils.putBytes(locatorID, this._packet, this._packetLength + 0);
        ByteUtils.putLong(position, this._packet, this._packetLength + 8);
        ByteUtils.putInt(200000, this._packet, this._packetLength + 16);
        ByteUtils.putInt(0, this._packet, this._packetLength + 20);
        this._packetLength += 24;
        ++this._argumentCount;
        this._closePart();
    }

    private HDataPart _addWriteLOBRequestPart() {
        this._newPart(PartKind.WriteLOBRequest);
        return HDataPart.createWriteLobRequestPart(this, this._packetLength);
    }

    private void _addResultSetIDPart(CursorID cursorID) {
        this._newPart(PartKind.ResultSetID);
        this._addBytesArg(cursorID.getCursorID());
        this._closePart();
    }

    private void _addFetchSizePart(int fetchSize) {
        this._newPart(PartKind.FetchSize);
        this._addIntArg(fetchSize);
        this._closePart();
    }

    private void _addStatementIDPart(ParseID parseID) {
        this._newPart(PartKind.StatementID);
        this._addBytesArg(parseID.getParseID());
        this._closePart();
    }

    private void _addCommitOptionsPart() {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.CommitOptions);
        optionsPart.addBooleanOption(CommitOption.HoldCursorOverCommit.getValue(), true);
        optionsPart.close();
    }

    private void _addTransactionIDPart(byte[] transactionID) {
        this._newPart(PartKind.TransactionID);
        this._addBytesArg(transactionID);
        this._closePart();
    }

    private void _addXATransactionInfoPart(Xid xid, Integer flags, Boolean onePhase) {
        HOptionsPart optionsPart = this._addOptionsPart(PartKind.XOpen_XATransactionInfo);
        if (xid != null) {
            optionsPart.addLongOption(XATransactionInfoOption.NumberOfXID.getValue(), 1L);
            optionsPart.addBinaryOption(XATransactionInfoOption.XIDList.getValue(), XidSAP.getBytes(xid));
        }
        if (flags != null) {
            optionsPart.addIntOption(XATransactionInfoOption.Flags.getValue(), flags);
        }
        if (onePhase != null) {
            optionsPart.addBooleanOption(XATransactionInfoOption.OnePhase.getValue(), onePhase);
        }
        optionsPart.close();
    }

    private void _addIntArg(int value) {
        ByteUtils.putInt(value, this._packet, this._packetLength);
        this._packetLength += 4;
        ++this._argumentCount;
    }

    private void _addStringArg(String value) {
        this._packetLength += Cesu8Utils.putBytes(value, this._packet, this._packetLength);
        ++this._argumentCount;
    }

    private void _addDataStringArg(String value) {
        ByteUtils.putByte(32, this._packet, this._packetLength);
        ++this._packetLength;
        this._addStringArg(value);
    }

    private void _addVariableStringArg(String value) {
        int dataOffset = this._packetLength++;
        if (value == null) {
            ByteUtils.putByte(255, this._packet, dataOffset);
            ++this._argumentCount;
        } else {
            int length = Cesu8Utils.getByteLength(value);
            if (length <= 245) {
                ByteUtils.putByte(length, this._packet, dataOffset);
                ++this._packetLength;
            } else if (length <= Short.MAX_VALUE) {
                ByteUtils.putByte(246, this._packet, dataOffset);
                ByteUtils.putShort(length, this._packet, dataOffset + 1);
                this._packetLength += 3;
            } else {
                ByteUtils.putByte(247, this._packet, dataOffset);
                ByteUtils.putInt(length, this._packet, dataOffset + 1);
                this._packetLength += 5;
            }
            this._packetLength += Cesu8Utils.putBytes(value, this._packet, this._packetLength);
            ++this._argumentCount;
        }
    }

    private void _addBytesArg(byte[] value) {
        ByteUtils.putBytes(value, this._packet, this._packetLength);
        this._packetLength += value.length;
        ++this._argumentCount;
    }

    private static class Part {
        private final int _offset;
        private int _length;

        private Part(int offset) {
            this._offset = offset;
        }

        public String toString() {
            return this._offset + ":" + this._length;
        }
    }

    private static class Segment {
        private final int _offset;
        private final List<Part> _parts;
        private int _statementContextOffset;
        private int _length;

        private Segment(int offset) {
            this._offset = offset;
            this._parts = new ArrayList<Part>();
            this._statementContextOffset = -1;
        }

        public String toString() {
            return this._offset + ":" + this._length + "(" + this._parts.size() + ")";
        }
    }
}

