/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import java.math.BigDecimal;

public class HPart {
    public static final int MAX_ARGUMENT_COUNT = Short.MAX_VALUE;
    protected final int _offset;
    protected final int _length;
    protected final boolean _isReadOnly;
    protected byte[] _packet;

    public HPart(byte[] packet, int offset, int length, boolean isReadOnly) {
        this._packet = packet;
        this._offset = offset;
        this._length = length;
        this._isReadOnly = isReadOnly;
    }

    public byte[] getRawPacketArray() {
        return this._packet;
    }

    public boolean getBoolean(int off) {
        return ByteUtils.getBoolean(this._packet, this._offset + off);
    }

    public int getUByte(int off) {
        return ByteUtils.getUByte(this._packet, this._offset + off);
    }

    public byte getByte(int off) {
        return ByteUtils.getByte(this._packet, this._offset + off);
    }

    public void putByte(int val, int off) {
        this._checkModifiable();
        ByteUtils.putByte(val, this._packet, this._offset + off);
    }

    public short getShort(int off) {
        return ByteUtils.getShort(this._packet, this._offset + off);
    }

    public void putShort(int val, int off) {
        this._checkModifiable();
        ByteUtils.putShort(val, this._packet, this._offset + off);
    }

    public int getInt(int off) {
        return ByteUtils.getInt(this._packet, this._offset + off);
    }

    public void putInt(int val, int off) {
        this._checkModifiable();
        ByteUtils.putInt(val, this._packet, this._offset + off);
    }

    public long getLong(int off) {
        return ByteUtils.getLong(this._packet, this._offset + off);
    }

    public void putLong(long val, int off) {
        this._checkModifiable();
        ByteUtils.putLong(val, this._packet, this._offset + off);
    }

    public float getFloat(int off) {
        return ByteUtils.getFloat(this._packet, this._offset + off);
    }

    public double getDouble(int off) {
        return ByteUtils.getDouble(this._packet, this._offset + off);
    }

    public BigDecimal getBigDecimal(int off, int fraction) {
        return ByteUtils.getBigDecimal(this._packet, this._offset + off, fraction);
    }

    public String getString(int off, int len) {
        return Cesu8Utils.getString(this._packet, this._offset + off, len);
    }

    public int putString(String val, int off) {
        this._checkModifiable();
        return Cesu8Utils.putBytes(val, this._packet, this._offset + off);
    }

    public byte[] getBytes(int off, int len) {
        return ByteUtils.getBytes(this._packet, this._offset + off, len);
    }

    public byte[] getBytes(int off, int len, byte[] buffer) {
        return ByteUtils.getBytes(this._packet, this._offset + off, len, buffer);
    }

    public void putBytes(byte[] val, int off) {
        this._checkModifiable();
        ByteUtils.putBytes(val, this._packet, this._offset + off);
    }

    protected void _checkModifiable() {
        if (this._isReadOnly) {
            throw new AssertionError((Object)"Part is read-only");
        }
    }
}

