/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HPart;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.translators.AbstractPutval;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.Cesu8Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.List;

public class HDataPart
extends HPart {
    private final HRequestPacket _requestPacket;
    private final boolean _isLastPacket;
    private final boolean _isRowNotFound;
    private final boolean _isResultSetClosedOnServer;
    private int _recordCount;
    private int _currentRecordOffset;
    private int _currentFieldOffset;
    private int _currentRecordIndex;
    private int _currentFieldIndex;
    private DataFormatDescription _dataFormatDescription;

    public static HDataPart createEmptyPart() {
        return new HDataPart(null, null, 0, 0, Type.EMPTY);
    }

    public static HDataPart createArrayPart(HDataPart rsDataPart, int fieldIndex, AbstractTranslator translator) {
        rsDataPart.moveToField(fieldIndex);
        int elementCount = rsDataPart.getValueAsInt();
        int offset = rsDataPart._offset + rsDataPart._getNonNullDataOffset() + 4;
        int length = rsDataPart._getNonNullDataLength() - 4;
        HDataPart dataPart = new HDataPart(null, rsDataPart._packet, offset, length, Type.ARRAY);
        final int f_elementCount = elementCount;
        final AbstractTranslator f_translator = translator;
        dataPart.setDataFormatDescription(new DataFormatDescription(){

            @Override
            public int getOutputFieldCount() {
                return f_elementCount;
            }

            @Override
            public DataType getOutputFieldDataType(int outputFieldPos) {
                return f_translator.getDataType();
            }

            @Override
            public int getResultSetColumnCount() {
                return 0;
            }

            @Override
            public AbstractTranslator getResultSetTranslator(int columnIndex) {
                return null;
            }
        });
        return dataPart;
    }

    public static HDataPart createResultSetPart(byte[] packet, int offset, int length) {
        return new HDataPart(null, packet, offset, length, Type.RESULT_SET);
    }

    public static HDataPart createOutputParametersPart(byte[] packet, int offset, int length) {
        return new HDataPart(null, packet, offset, length, Type.OUTPUT_PARAMETERS);
    }

    public static HDataPart createParametersPart(HRequestPacket requestPacket, int offset) {
        return new HDataPart(requestPacket, requestPacket.getRawPacketArray(), offset, -1, Type.PARAMETERS);
    }

    public static HDataPart createWriteLobRequestPart(HRequestPacket requestPacket, int offset) {
        return new HDataPart(requestPacket, requestPacket.getRawPacketArray(), offset, -1, Type.WRITE_LOB_REQUEST);
    }

    private HDataPart(HRequestPacket requestPacket, byte[] packet, int offset, int length, Type type) {
        super(packet, offset, length, type != Type.PARAMETERS && type != Type.WRITE_LOB_REQUEST);
        this._requestPacket = requestPacket;
        switch (type) {
            case EMPTY: {
                this._recordCount = 0;
                this._isLastPacket = true;
                this._isRowNotFound = true;
                this._isResultSetClosedOnServer = true;
                break;
            }
            case ARRAY: {
                this._recordCount = 1;
                this._isLastPacket = true;
                this._isRowNotFound = true;
                this._isResultSetClosedOnServer = true;
                this._currentRecordOffset = 0;
                this._currentFieldOffset = 0;
                this._currentRecordIndex = 1;
                this._currentFieldIndex = 1;
                break;
            }
            case RESULT_SET: 
            case OUTPUT_PARAMETERS: {
                byte attributes = this.getByte(1);
                this._recordCount = this.getShort(2);
                this._isLastPacket = (attributes & PartAttribute.LastPacket.getValue()) != 0;
                this._isRowNotFound = (attributes & PartAttribute.RowNotFound.getValue()) != 0;
                boolean bl = this._isResultSetClosedOnServer = (attributes & PartAttribute.ResultSetClosed.getValue()) != 0;
                if (this._recordCount <= 0) break;
                this._currentRecordOffset = 16;
                this._currentFieldOffset = 16;
                this._currentRecordIndex = 1;
                this._currentFieldIndex = 1;
                break;
            }
            case PARAMETERS: 
            case WRITE_LOB_REQUEST: {
                this._recordCount = 0;
                this._isLastPacket = true;
                this._isRowNotFound = true;
                this._isResultSetClosedOnServer = true;
                this._currentRecordOffset = 0;
                this._currentFieldOffset = 0;
                this._currentRecordIndex = 1;
                this._currentFieldIndex = 1;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type: " + (Object)((Object)type)));
            }
        }
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public boolean isLastPacket() {
        return this._isLastPacket;
    }

    public boolean isRowNotFound() {
        return this._isRowNotFound;
    }

    public boolean isResultSetClosedOnServer() {
        return this._isResultSetClosedOnServer;
    }

    public int getAvailableSpace() {
        return this._requestPacket.getAvailableSpace() - this._currentFieldOffset;
    }

    public int getCurrentFieldOffset() {
        return this._currentFieldOffset;
    }

    public DataFormatDescription getDataFormatDescription() {
        return this._dataFormatDescription;
    }

    public void setDataFormatDescription(DataFormatDescription dataFormatDescription) {
        this._dataFormatDescription = dataFormatDescription;
    }

    public int getNonNullDataOffset() {
        return this._offset + this._getNonNullDataOffset();
    }

    public int getNonNullDataLength() {
        return this._getNonNullDataLength();
    }

    public void close() {
        this.close(this._recordCount);
    }

    public void close(int recordCount) {
        this._checkModifiable();
        this._requestPacket._closePart(recordCount, this._currentFieldOffset);
    }

    public boolean nextRecord() {
        if (this._currentRecordIndex >= this._recordCount) {
            return false;
        }
        while (this._currentFieldIndex <= this._dataFormatDescription.getOutputFieldCount()) {
            this._nextField();
        }
        this._currentRecordOffset = this._currentFieldOffset;
        ++this._currentRecordIndex;
        this._currentFieldIndex = 1;
        return true;
    }

    public void moveToField(int fieldIndex) {
        if (fieldIndex > this._dataFormatDescription.getOutputFieldCount()) {
            throw new AssertionError((Object)("Invalid field index: " + fieldIndex + " > " + this._dataFormatDescription.getOutputFieldCount()));
        }
        if (fieldIndex < this._currentFieldIndex) {
            this._currentFieldOffset = this._currentRecordOffset;
            this._currentFieldIndex = 1;
        }
        while (this._currentFieldIndex < fieldIndex) {
            this._nextField();
        }
    }

    public void moveToLOBField(int fieldIndex) {
        this.moveToField(fieldIndex);
        switch (this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex)) {
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex))));
            }
        }
    }

    public boolean isNull(SQLParamController controller) {
        DataFormatDescription.NullIndicator nullIndicator = this._getNullIndicator();
        controller.setNullIndicator(nullIndicator);
        return nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    public DataFormatDescription.NullIndicator getNullIndicator(SQLParamController controller) {
        DataFormatDescription.NullIndicator nullIndicator = this._getNullIndicator();
        controller.setNullIndicator(nullIndicator);
        return nullIndicator;
    }

    public boolean getValueAsBoolean() {
        return this.getBoolean(this._getNonNullDataOffset());
    }

    public int getValueAsUByte() {
        return this.getUByte(this._getNonNullDataOffset());
    }

    public byte getValueAsByte() {
        return this.getByte(this._getNonNullDataOffset());
    }

    public short getValueAsShort() {
        return this.getShort(this._getNonNullDataOffset());
    }

    public int getValueAsInt() {
        return this.getInt(this._getNonNullDataOffset());
    }

    public long getValueAsLong() {
        return this.getLong(this._getNonNullDataOffset());
    }

    public float getValueAsFloat() {
        return this.getFloat(this._getNonNullDataOffset());
    }

    public double getValueAsDouble() {
        return this.getDouble(this._getNonNullDataOffset());
    }

    public BigDecimal getValueAsBigDecimal(int fraction) {
        return this.getBigDecimal(this._getNonNullDataOffset(), fraction);
    }

    public String getValueAsString() {
        return this.getString(this._getNonNullDataOffset(), this._getNonNullDataLength());
    }

    public byte[] getValueAsBytes() {
        return this.getBytes(this._getNonNullDataOffset(), this._getNonNullDataLength());
    }

    public boolean getLOBIsLastChunk() {
        return (this.getByte(this._currentFieldOffset + 1) & 4) != 0;
    }

    public long getLOBCharLength() {
        return this.getLong(this._currentFieldOffset + 4);
    }

    public long getLOBByteLength() {
        return this.getLong(this._currentFieldOffset + 12);
    }

    public byte[] getLOBLocatorID() {
        return this.getBytes(this._currentFieldOffset + 20, 8);
    }

    public int getLOBChunkSize() {
        return this.getInt(this._currentFieldOffset + 28);
    }

    public ByteBuffer getLOBByteBuffer() {
        return ByteBuffer.wrap(this._packet, this._offset + this._currentFieldOffset + 32, this.getInt(this._currentFieldOffset + 28)).slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    public boolean putInputArgs(List<AbstractTranslator> translators, Object[] inputArgs) {
        Object inputArg;
        if (this._recordCount >= 32766) {
            return false;
        }
        int requiredSpace = 0;
        int i = 0;
        for (AbstractTranslator translator : translators) {
            inputArg = inputArgs[i];
            requiredSpace += translator.getInputArgLength(inputArg);
            ++i;
        }
        int availableSpace = this.getAvailableSpace();
        if (requiredSpace > availableSpace) {
            if (this._recordCount == 0) {
                this._requestPacket._resize(this._requestPacket.getLength() + this._currentFieldOffset + requiredSpace);
                this._packet = this._requestPacket.getRawPacketArray();
            } else {
                return false;
            }
        }
        i = 0;
        for (AbstractTranslator translator : translators) {
            if (!translator.putInputArg(this, inputArg = inputArgs[i])) {
                throw new AssertionError((Object)"Packet size insufficient for input arguments");
            }
            ++i;
        }
        ++this._recordCount;
        return true;
    }

    public int addNull(DataType dataType) {
        this._checkModifiable();
        if (this.getAvailableSpace() < 1) {
            return -1;
        }
        this.putByte(dataType.getTypeCode() + 128, this._currentFieldOffset);
        ++this._currentFieldOffset;
        return 1;
    }

    public int addRawBytes(byte[] value) {
        this._checkModifiable();
        int len = value.length;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        this.putBytes(value, this._currentFieldOffset);
        this._currentFieldOffset += len;
        return len;
    }

    public int addDescriptor(AbstractPutval.State state, DataType dataType, byte[] locatorID) {
        int len;
        this._checkModifiable();
        boolean addParameterDescriptor = state == AbstractPutval.State.EXECUTE || locatorID == null;
        int n = len = addParameterDescriptor ? 10 : 21;
        if (this.getAvailableSpace() < len) {
            return -1;
        }
        if (addParameterDescriptor) {
            this.putByte(dataType.getTypeCode(), this._currentFieldOffset + 0);
            this.putByte(0, this._currentFieldOffset + 1);
            this.putInt(0, this._currentFieldOffset + 2);
            this.putInt(0, this._currentFieldOffset + 6);
        } else {
            this.putBytes(locatorID, this._currentFieldOffset + 0);
            this.putByte(0, this._currentFieldOffset + 8);
            this.putLong(0L, this._currentFieldOffset + 9);
            this.putInt(0, this._currentFieldOffset + 17);
        }
        this._currentFieldOffset += len;
        return len;
    }

    public boolean canAddDescriptor(int descriptorLength) {
        return this._requestPacket.getArgumentCount() < Short.MAX_VALUE && this.getAvailableSpace() > descriptorLength;
    }

    public boolean fillWithStream(InputStream stream, int descriptorOffset, boolean isExecute) throws SQLException {
        this._checkModifiable();
        boolean isStreamExhausted = false;
        int availableSpace = this.getAvailableSpace();
        int options = 2;
        int position = this._currentFieldOffset;
        try {
            while (!isStreamExhausted && availableSpace > 0) {
                int bytesRead = stream.read(this._packet, this._offset + this._currentFieldOffset, availableSpace);
                if (bytesRead == -1) {
                    isStreamExhausted = true;
                    options |= 4;
                    continue;
                }
                this._currentFieldOffset += bytesRead;
                availableSpace -= bytesRead;
            }
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        int chunkLength = this._currentFieldOffset - position;
        this._updateDescriptor(isExecute, descriptorOffset, options, chunkLength, position);
        return isStreamExhausted;
    }

    public boolean fillWithReader(Reader reader, int descriptorOffset, boolean isExecute) throws SQLException {
        this._checkModifiable();
        boolean isStreamExhausted = false;
        int availableSpace = this.getAvailableSpace();
        int options = 2;
        int position = this._currentFieldOffset;
        try {
            while (!isStreamExhausted && availableSpace > 3) {
                int bytesWritten = Cesu8Utils.putBytes(reader, this._packet, this._offset + this._currentFieldOffset, availableSpace);
                if (bytesWritten == -1) {
                    isStreamExhausted = true;
                    options |= 4;
                    continue;
                }
                this._currentFieldOffset += bytesWritten;
                availableSpace -= bytesWritten;
            }
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        int chunkLength = this._currentFieldOffset - position;
        this._updateDescriptor(isExecute, descriptorOffset, options, chunkLength, position);
        return isStreamExhausted;
    }

    private void _nextField() {
        this._currentFieldOffset += this._getFieldLength();
        ++this._currentFieldIndex;
    }

    private int _getFieldLength() {
        switch (this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex)) {
            case BOOLEAN: {
                return 1;
            }
            case TINYINT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 2;
            }
            case SMALLINT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 3;
            }
            case INT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 5;
            }
            case BIGINT: {
                return this.getByte(this._currentFieldOffset) == 0 ? 1 : 9;
            }
            case REAL: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 16;
            }
            case DATE: 
            case TIME: 
            case DAYDATE: 
            case SECONDTIME: {
                return 4;
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return 8;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case VARCHAR2: 
            case STRING: 
            case NSTRING: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                int lengthIndicator = this.getUByte(this._currentFieldOffset);
                switch (lengthIndicator) {
                    case 246: {
                        return this.getShort(this._currentFieldOffset + 1) + 3;
                    }
                    case 247: {
                        return this.getInt(this._currentFieldOffset + 1) + 5;
                    }
                    case 255: {
                        return 1;
                    }
                }
                if (lengthIndicator <= 245) {
                    return lengthIndicator + 1;
                }
                throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return this.getByte(this._currentFieldOffset + 1) == 1 ? 2 : 32 + this.getInt(this._currentFieldOffset + 28);
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex))));
    }

    private DataFormatDescription.NullIndicator _getNullIndicator() {
        switch (this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex)) {
            case BOOLEAN: {
                return this._isNull((this.getByte(this._currentFieldOffset) & 1) == 1);
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return this._isNull(this.getByte(this._currentFieldOffset) == 0);
            }
            case REAL: {
                return this._isNull(this.getInt(this._currentFieldOffset) == -1);
            }
            case DOUBLE: {
                return this._isNull(this.getLong(this._currentFieldOffset) == -1L);
            }
            case DECIMAL: {
                return this._isNull((this.getByte(this._currentFieldOffset + 15) & 0x70) == 112);
            }
            case DATE: {
                return this._isNull((this.getByte(this._currentFieldOffset + 1) & 0x80) == 0);
            }
            case TIME: {
                return this._isNull((this.getByte(this._currentFieldOffset) & 0x80) == 0);
            }
            case TIMESTAMP: {
                return this._isNull((this.getByte(this._currentFieldOffset + 1) & 0x80) == 0 && (this.getByte(this._currentFieldOffset + 4) & 0x80) == 0);
            }
            case DAYDATE: {
                int val = this.getInt(this._currentFieldOffset);
                if (val == 0) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 3652062) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case SECONDTIME: {
                int val = this.getInt(this._currentFieldOffset);
                if (val == 0) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 86402) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case SECONDDATE: {
                long val = this.getLong(this._currentFieldOffset);
                if (val == 0L) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 315538070401L) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case LONGDATE: {
                long val = this.getLong(this._currentFieldOffset);
                if (val == 0L) {
                    return DataFormatDescription.NullIndicator.SPECIAL_NULL;
                }
                if (val == 3155380704000000001L) {
                    return DataFormatDescription.NullIndicator.NULL;
                }
                return DataFormatDescription.NullIndicator.NOT_NULL;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case VARCHAR2: 
            case STRING: 
            case NSTRING: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                return this._isNull(this.getUByte(this._currentFieldOffset) == 255);
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return this._isNull(this.getByte(this._currentFieldOffset + 1) == 1);
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex))));
    }

    private DataFormatDescription.NullIndicator _isNull(boolean isNull) {
        return isNull ? DataFormatDescription.NullIndicator.NULL : DataFormatDescription.NullIndicator.NOT_NULL;
    }

    private int _getNonNullDataOffset() {
        switch (this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex)) {
            case BOOLEAN: {
                return this._currentFieldOffset;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return this._currentFieldOffset + 1;
            }
            case REAL: 
            case DOUBLE: 
            case DECIMAL: {
                return this._currentFieldOffset;
            }
            case DATE: 
            case TIME: 
            case DAYDATE: 
            case SECONDTIME: 
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return this._currentFieldOffset;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case VARCHAR2: 
            case STRING: 
            case NSTRING: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                int lengthIndicator = this.getUByte(this._currentFieldOffset);
                switch (lengthIndicator) {
                    case 246: {
                        return this._currentFieldOffset + 3;
                    }
                    case 247: {
                        return this._currentFieldOffset + 5;
                    }
                    case 255: {
                        throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
                    }
                }
                if (lengthIndicator <= 245) {
                    return this._currentFieldOffset + 1;
                }
                throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return this._currentFieldOffset;
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex))));
    }

    private int _getNonNullDataLength() {
        switch (this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex)) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case INT: 
            case REAL: {
                return 4;
            }
            case BIGINT: 
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 16;
            }
            case DATE: 
            case TIME: 
            case DAYDATE: 
            case SECONDTIME: {
                return 4;
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return 8;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case VARCHAR2: 
            case STRING: 
            case NSTRING: 
            case ALPHANUM: 
            case BINARY: 
            case VARBINARY: 
            case BSTRING: 
            case GEOMETRY: 
            case POINT: 
            case ARRAY: {
                int lengthIndicator = this.getUByte(this._currentFieldOffset);
                switch (lengthIndicator) {
                    case 246: {
                        return this.getShort(this._currentFieldOffset + 1);
                    }
                    case 247: {
                        return this.getInt(this._currentFieldOffset + 1);
                    }
                    case 255: {
                        throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
                    }
                }
                if (lengthIndicator <= 245) {
                    return lengthIndicator;
                }
                throw new AssertionError((Object)("Unexpected length indicator: " + lengthIndicator));
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: 
            case BLOB: 
            case BLOCATOR: {
                return 32;
            }
        }
        throw new AssertionError((Object)("Unexpected data type: " + (Object)((Object)this._dataFormatDescription.getOutputFieldDataType(this._currentFieldIndex))));
    }

    private void _updateDescriptor(boolean isExecute, int descriptorOffset, int options, int chunkLength, int position) {
        if (isExecute) {
            this.putByte(options, descriptorOffset + 1);
            this.putInt(chunkLength, descriptorOffset + 2);
            this.putInt(chunkLength == 0 ? 0 : position + 1, descriptorOffset + 6);
        } else {
            this.putByte(options, descriptorOffset + 8);
            this.putLong(0L, descriptorOffset + 9);
            this.putInt(chunkLength, descriptorOffset + 17);
        }
    }

    private static enum Type {
        EMPTY,
        ARRAY,
        RESULT_SET,
        OUTPUT_PARAMETERS,
        PARAMETERS,
        WRITE_LOB_REQUEST;

    }
}

