/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

public enum ErrorLevel {
    Warning(0),
    Error(1),
    FatalError(2),
    Unknown(-1);

    private static final ErrorLevel[] VALUES;

    public static ErrorLevel decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return ErrorLevel.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private ErrorLevel(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = ErrorLevel.values();
    }
}

