/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.packet.DBConnectInfoOption;
import com.sap.db.jdbc.packet.HOptionsPart;

public final class DBConnectInfo {
    private final String _host;
    private final int _port;
    private final boolean _isOnCorrectDatabase;

    public DBConnectInfo(HOptionsPart optionsPart) {
        String host = null;
        int port = 0;
        boolean isOnCorrectDatabase = false;
        do {
            switch (DBConnectInfoOption.decode(optionsPart.getOptionName())) {
                case Host: {
                    host = optionsPart.getOptionStringValue();
                    break;
                }
                case Port: {
                    port = optionsPart.getOptionIntValue();
                    break;
                }
                case OnCorrectDatabase: {
                    isOnCorrectDatabase = optionsPart.getOptionBooleanValue();
                }
            }
        } while (optionsPart.nextOption());
        this._host = host;
        this._port = port;
        this._isOnCorrectDatabase = isOnCorrectDatabase;
    }

    public String toString() {
        return this._host + ":" + this._port + (this._isOnCorrectDatabase ? " connected" : " not connected");
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isOnCorrectDatabase() {
        return this._isOnCorrectDatabase;
    }
}

