/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.exceptions;

import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.util.MessageTranslator;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

public class BatchUpdateExceptionSapDB
extends BatchUpdateException
implements SQLExceptionSapDBInterface {
    private final RteReturnCode _rteReturnCode;
    private final SQLException _nextSQLException;

    public BatchUpdateExceptionSapDB(String reason, int[] updateCounts) {
        super(reason, updateCounts);
        this._rteReturnCode = RteReturnCode.SQLOK;
        this._nextSQLException = null;
    }

    public BatchUpdateExceptionSapDB(String reason, String sqlState, int[] updateCounts) {
        super(reason, sqlState, updateCounts);
        this._rteReturnCode = RteReturnCode.SQLOK;
        this._nextSQLException = null;
    }

    public BatchUpdateExceptionSapDB(int[] updateCounts, SQLException e) {
        super(e.getMessage(), e.getSQLState(), e.getErrorCode(), updateCounts);
        this._rteReturnCode = e instanceof SQLExceptionSapDBInterface ? ((SQLExceptionSapDBInterface)((Object)e)).getRTEReturnCode() : RteReturnCode.SQLOK;
        this._nextSQLException = e;
    }

    public BatchUpdateExceptionSapDB(int[] updateCounts, SQLException e, Integer inputPos) {
        super(e.getMessage() + MessageTranslator.translate("inputpos", inputPos), e.getSQLState(), e.getErrorCode(), updateCounts);
        this._rteReturnCode = e instanceof SQLExceptionSapDBInterface ? ((SQLExceptionSapDBInterface)((Object)e)).getRTEReturnCode() : RteReturnCode.SQLOK;
        this._nextSQLException = e;
    }

    @Override
    public int getErrorPos() {
        return 0;
    }

    @Override
    public RteReturnCode getRTEReturnCode() {
        return this._rteReturnCode;
    }

    @Override
    public int[] getUpdateCountsFromLastPacket() {
        return SQLExceptionSapDB.NO_UPDATE_COUNTS;
    }

    @Override
    public boolean isConnectionReleasing() {
        return false;
    }

    @Override
    public SQLException getNextException() {
        return this._nextSQLException.getNextException();
    }

    @Override
    public void setNextException(SQLException e) {
        this._nextSQLException.setNextException(e);
    }
}

