/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.HexUtils;
import java.sql.SQLException;

public class Transaction {
    private final byte[] _txIDBuffer = new byte[156];
    private final SessionPool _sessionPool;
    private final Tracer _tracer;
    private boolean _autoCommit;
    private TransactionState _transactionState;
    private int _numberOfSessionsInvolved;
    private byte[] _transactionID;

    Transaction(SessionPool sessionPool, Tracer tracer) {
        this._sessionPool = sessionPool;
        this._tracer = tracer;
        this._autoCommit = true;
        this._transactionState = TransactionState.None;
    }

    boolean getAutoCommit() {
        return this._autoCommit;
    }

    void setAutoCommit(boolean autoCommit) {
        this._autoCommit = autoCommit;
    }

    TransactionState getTransactionState() {
        return this._transactionState;
    }

    boolean isWriteTransaction() {
        return this._transactionState == TransactionState.WriteTransaction || this._transactionState == TransactionState.DistributedTransaction;
    }

    void setTransactionState(TransactionState newState, Session session) {
        if (!this._checkSession(session)) {
            return;
        }
        if (this._transactionState == TransactionState.None && (newState == TransactionState.ReadTransaction || newState == TransactionState.WriteTransaction) || this._transactionState == TransactionState.ReadTransaction && newState == TransactionState.WriteTransaction) {
            this._sessionPool.setPrimarySession(session);
        }
        this._transactionState = newState;
        if (this._tracer.on()) {
            this._tracer.printDistribution("Change Tx " + HexUtils.toDisplayHexString(this._transactionID) + " state to " + this._transactionState.name() + " on session " + session.getLocation().getAsShortString());
        }
    }

    boolean setTransactionState(ConnectionSapDB connection, Session session, FunctionCode functionCode, boolean isDDLCommitted) {
        TransactionState newState;
        if (!this._checkSession(session)) {
            return false;
        }
        boolean isImplicitCommit = false;
        switch (functionCode) {
            case Insert: 
            case Delete: 
            case Update: 
            case DBProcedureCall: 
            case DBProcedureCallWithResultSet: 
            case SelectForUpdate: {
                newState = TransactionState.WriteTransaction;
                break;
            }
            case Commit: 
            case Rollback: 
            case Connect: 
            case Disconnect: {
                newState = TransactionState.None;
                break;
            }
            case XAStart: 
            case XAJoin: {
                return false;
            }
            case DDL: {
                if (isDDLCommitted) {
                    newState = TransactionState.None;
                    this.clearTransaction(connection);
                    isImplicitCommit = true;
                    break;
                }
                newState = TransactionState.WriteTransaction;
                break;
            }
            default: {
                newState = TransactionState.ReadTransaction;
            }
        }
        this.setTransactionState(newState, session);
        return isImplicitCommit;
    }

    void handleTransaction(ConnectionSapDB connection, Session session, boolean isDropParseID) throws SQLException {
        if (session.isHintRouted()) {
            return;
        }
        this._addSessionToTransaction(session);
        if (this._transactionState == TransactionState.None) {
            this._sessionPool.setPrimarySession(session);
        }
        if (this._transactionState == TransactionState.DistributedTransaction) {
            if (!isDropParseID && !session.isPartOfDistributedTransaction()) {
                this._joinDistributedTransaction(connection, session);
            }
        } else if (this._numberOfSessionsInvolved > 1) {
            switch (this._transactionState) {
                case None: 
                case ReadTransaction: {
                    break;
                }
                default: {
                    if (isDropParseID) break;
                    this._startDistributedTransaction(connection);
                    this._joinDistributedTransaction(connection, session);
                }
            }
        }
    }

    void clearTransaction(ConnectionSapDB connection) {
        this._transactionState = TransactionState.None;
        for (Session session : this._sessionPool.getSessions().values()) {
            session.leaveTransaction();
        }
        if (this._tracer.on() && this._transactionState != TransactionState.Unknown) {
            this._tracer.printDistributionState(connection, "Close Tx " + HexUtils.toDisplayHexString(this._transactionID));
        }
        this._numberOfSessionsInvolved = 0;
        this._transactionID = null;
    }

    private boolean _checkSession(Session session) {
        Session anchorSession = this._sessionPool.getAnchorSession();
        return anchorSession == null || anchorSession.getSiteVolumeID().getSiteID() == session.getSiteVolumeID().getSiteID() || !anchorSession.isPrimarySite();
    }

    private void _addSessionToTransaction(Session session) {
        if (session.isPartOfTransaction()) {
            return;
        }
        session.joinTransaction();
        ++this._numberOfSessionsInvolved;
    }

    private void _startDistributedTransaction(ConnectionSapDB connection) throws SQLException {
        if (this._transactionState == TransactionState.DistributedTransaction) {
            return;
        }
        Session session = this._sessionPool.getPrimarySession();
        HRequestPacket requestPacket = connection.getRequestPacket(session);
        requestPacket.initStartDistributedTransaction(connection, session);
        HReplyPacket replyPacket = connection.execute(this, session, requestPacket, new ConnectionSapDB.ExecuteFlag[0]);
        this._transactionID = replyPacket.findTransactionID(0, this._txIDBuffer);
        this._transactionState = TransactionState.DistributedTransaction;
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution("Start Distributed Tx " + HexUtils.toDisplayHexString(this._transactionID) + " on session " + session.getLocation().getAsShortString());
        }
    }

    private void _joinDistributedTransaction(ConnectionSapDB connection, Session session) throws SQLException {
        if (session.isPartOfDistributedTransaction()) {
            return;
        }
        HRequestPacket requestPacket = connection.getRequestPacket(session);
        requestPacket.initJoinDistributedTransaction(connection, session, this._transactionID);
        connection.execute(this, session, requestPacket, new ConnectionSapDB.ExecuteFlag[0]);
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution("Join Distributed Tx " + HexUtils.toDisplayHexString(this._transactionID) + " on session " + session.getLocation().getAsShortString());
        }
    }
}

