/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.ResultSetSapDBFinalize;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.HSegmentInfo;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.jdbcext.wrapper.Statement;
import com.sap.db.util.MessageTranslator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class StatementSapDB
extends WrapperDummy
implements java.sql.Statement {
    protected final Tracer _tracer;
    protected final ConnectionSapDB _connection;
    protected final int _resultSetType;
    protected final int _resultSetConcurrency;
    protected final int _resultSetHoldability;
    protected final AtomicBoolean _isClosed;
    private boolean _createInternalResultSets;
    private int _fetchDirection = 1000;
    private int _maxFieldSize;
    private int _maxRows;
    protected int _queryTimeout;
    protected boolean _isPoolable;
    protected int _fetchSize;
    protected String _cursorName;
    private final List<ResultSetSapDB> _resultSets = Collections.synchronizedList(new ArrayList());
    protected ResultSetSapDB _currentResultSet;
    protected int _currentResultSetIndex;
    protected int _rowsAffected = -1;
    protected boolean _hasRowCount;
    protected boolean _hasReturnedRowsAffected;
    protected Vector<Object> _batchItems;
    protected boolean _canceled = false;
    protected int _cursorUsage;
    protected String _commandInfoSource;
    protected int _commandInfoLine;
    protected Session _Session;
    protected long _serverProcessingTime = -1L;
    private boolean _isMetaDataStatement = false;
    static final int Cursor_not_used = 0;
    static final int Cursor_scrollable = 1;
    static final int Cursor_forward_only = 2;
    protected int _statementType;
    static final int Statement_User = 0;
    public static final long Statement_ServerProcessingTimeNotAvailable = -1L;
    protected static final int defaultHoldability_C = 1;
    public static final int BATCH_SUCCESS_NO_INFO_C = -2;

    public static StatementSapDB getStatementSapDB(java.sql.Statement statement) {
        java.sql.Statement s = statement;
        while (!(s instanceof StatementSapDB)) {
            if (s instanceof Statement) {
                s = ((Statement)s).getInner();
                continue;
            }
            if (s instanceof PreparedStatement) {
                s = ((PreparedStatement)s).getInner();
                continue;
            }
            if (s instanceof CallableStatement) {
                s = ((CallableStatement)s).getInner();
                continue;
            }
            return null;
        }
        return (StatementSapDB)s;
    }

    protected StatementSapDB(Tracer tracer, ConnectionSapDB connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean createInternalResultSets) throws SQLException {
        this._tracer = tracer;
        this._connection = connection;
        this._createInternalResultSets = createInternalResultSets;
        this._cursorName = connection._nextCursorName();
        switch (resultSetType) {
            case 1003: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetType", "TYPE_FORWARD_ONLY");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetConcurrency", "CONCUR_READ_ONLY");
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT");
            }
        }
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
        this._resultSetHoldability = resultSetHoldability;
        this._isClosed = new AtomicBoolean();
        this._statementType = 0;
        this.getSession(false);
        connection._addStatement(this);
    }

    protected void assertOpen() throws SQLException {
        if (this._isClosed.get() || this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected void checkLocks() {
        if (this instanceof InternalStatementSapDB) {
            return;
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        if (Thread.holdsLock(this._connection)) {
            // empty if block
        }
    }

    protected void addResultSet(ResultSetSapDB resultSet) {
        this._resultSets.add(resultSet);
    }

    protected void removeResultSet(ResultSetSapDB resultSet) {
        this._resultSets.remove(resultSet);
    }

    protected void closeResultSets() throws SQLException {
        this.closeResultSets(-1);
    }

    protected void closeResultSets(int lastIdx) throws SQLException {
        int n;
        for (int i = n = lastIdx == -1 ? this._resultSets.size() - 1 : lastIdx; i >= 0; --i) {
            ResultSetSapDB resultSet = this._resultSets.get(i);
            resultSet._close();
        }
        this._cursorUsage = 0;
        this._currentResultSet = null;
        this._currentResultSetIndex = 0;
    }

    protected boolean parseResult(Session session, HReplyPacket replyPacket, List<AbstractTranslator> translators, boolean resetrowcount) throws SQLException {
        boolean isQuery = false;
        boolean rowNotFound = false;
        CursorID cursorID = null;
        HDataPart dataPart = null;
        this._serverProcessingTime = -1L;
        if (resetrowcount) {
            this._rowsAffected = -1;
            this._hasRowCount = false;
            this._hasReturnedRowsAffected = false;
        }
        FunctionCode functionCode = replyPacket.getFunctionCode(0);
        switch (functionCode) {
            case Select: 
            case SelectForUpdate: 
            case DBProcedureCallWithResultSet: {
                isQuery = true;
                break;
            }
            case Commit: {
                this._connection._closeCursorsAtCommit();
                this._connection.clearTransaction();
                break;
            }
            case DDL: {
                this.handleDDLReply();
                break;
            }
            case Rollback: {
                this._connection.clearTransaction();
                this._connection._incrementRollbackCount();
                break;
            }
            case Connect: {
                this.handleDDLReply();
                this._connection._refreshMetaData();
            }
        }
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            PartKind partKind = partInfo.getPartKind();
            switch (partKind) {
                case ResultSetMetaData: {
                    if (isQuery && translators.size() > 0 && cursorID != null) {
                        if (dataPart == null) {
                            dataPart = HDataPart.createEmptyPart();
                        }
                        this.createResultSet(session, cursorID, translators, rowNotFound, dataPart);
                        cursorID = null;
                        translators = new ArrayList<AbstractTranslator>();
                        dataPart = null;
                        rowNotFound = false;
                    }
                    partInfo.getResultSetMetaData(this._connection, translators);
                    break;
                }
                case RowsAffected: {
                    this._rowsAffected = partInfo.getRowsAffected();
                    this._hasRowCount = true;
                    this._hasReturnedRowsAffected = false;
                    break;
                }
                case ResultSetID: {
                    if (isQuery && translators.size() > 0 && cursorID != null) {
                        if (dataPart == null) {
                            dataPart = HDataPart.createEmptyPart();
                        }
                        this.createResultSet(session, cursorID, translators, rowNotFound, dataPart);
                        translators = new ArrayList<AbstractTranslator>();
                        dataPart = null;
                        rowNotFound = false;
                    }
                    cursorID = new CursorID(partInfo.getCursorID());
                    break;
                }
                case ResultSet: {
                    dataPart = partInfo.getResultSetPart();
                    if (dataPart.isRowNotFound()) {
                        rowNotFound = true;
                    }
                    if (!isQuery || translators.size() <= 0 || cursorID == null) break;
                    if (dataPart == null) {
                        dataPart = HDataPart.createEmptyPart();
                    }
                    this.createResultSet(session, cursorID, translators, rowNotFound, dataPart);
                    cursorID = null;
                    translators = new ArrayList<AbstractTranslator>();
                    dataPart = null;
                    rowNotFound = false;
                    break;
                }
                case StatementContext: {
                    HOptionsPart statementContextPart = partInfo.getOptionsPart();
                    do {
                        switch (StatementContextOption.decode(statementContextPart.getOptionName())) {
                            case ServerProcessingTime: {
                                this._serverProcessingTime = statementContextPart.getOptionLongValue();
                            }
                        }
                    } while (statementContextPart.nextOption());
                }
            }
        }
        if (isQuery) {
            if (translators.size() > 0 && cursorID != null) {
                if (dataPart == null) {
                    dataPart = HDataPart.createEmptyPart();
                }
                this.createResultSet(session, cursorID, translators, rowNotFound, dataPart);
            }
            if (!this._resultSets.isEmpty()) {
                this._currentResultSet = this._resultSets.get(0);
            }
        }
        return isQuery;
    }

    private void handleDDLReply() throws SQLException {
        if (this._connection._isDDLCommitted()) {
            this._connection._closeCursorsAtCommit();
            this._connection.clearTransaction();
        }
    }

    protected int getCursorType() {
        return this._cursorUsage;
    }

    private ResultSetSapDB createResultSet(Session session, CursorID cursorID, List<AbstractTranslator> translators, boolean rowNotFound, HDataPart dataPart) throws SQLException {
        FetchInfo fetchInfo = new FetchInfo(cursorID, translators);
        dataPart.setDataFormatDescription(fetchInfo);
        int n = this._cursorUsage = this._resultSetType == 1003 ? 2 : 1;
        ResultSetSapDB result = this._createInternalResultSets ? new InternalResultSetSapDB(this._connection, session, this, fetchInfo, dataPart) : (this._connection._createFinalizerClass() ? new ResultSetSapDBFinalize(this._connection.getTracer(), this._connection, session, this, fetchInfo, dataPart) : new ResultSetSapDB(this._connection.getTracer(), this._connection, session, this, fetchInfo, dataPart));
        if (rowNotFound) {
            result._setEmpty(true);
        }
        result._setFromMetaData(this._isMetaDataStatement);
        return result;
    }

    HReplyPacket sendCommand(HRequestPacket requestPacket, String sql, boolean parseAgain, Session session) throws SQLException {
        requestPacket.initExecuteDirect(this._connection, session, this._resultSetHoldability, this._queryTimeout, sql, this._commandInfoSource, this._commandInfoLine);
        HReplyPacket replyPacket = this._connection.execute(this, session, requestPacket, ConnectionSapDB.ExecuteFlag.IS_STATEMENT, ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    protected HReplyPacket sendSQL(String sql, boolean parseAgain, Session session) throws SQLException {
        HRequestPacket requestPacket = this._connection.getRequestPacket(session);
        HReplyPacket replyPacket = this.sendCommand(requestPacket, sql, parseAgain, session);
        return replyPacket;
    }

    public String toString() {
        String s = super.toString();
        return this._isClosed.get() ? s + "[closed]" : s;
    }

    public void setCommandInfo(String source, int line) throws SQLException {
        this.assertOpen();
        this._commandInfoSource = source;
        this._commandInfoLine = line;
    }

    public final Session getSession(boolean handleTransaction) throws SQLException {
        this._Session = this._connection.getSessionPool().getPrimarySession();
        if (handleTransaction) {
            this._connection.handleTransaction(this._Session, false);
        }
        return this._Session;
    }

    public long getServerProcessingTime() throws SQLException {
        return this._serverProcessingTime;
    }

    protected void _setMetaDataStatement(boolean isMetaDataStatement) {
        this._isMetaDataStatement = isMetaDataStatement;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeQuery") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeQuery", sql);
            }
            ResultSet result = this._executeQuery(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql);
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            this._close();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMaxFieldSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxFieldSize", new Object[0]);
            }
            int result = this._maxFieldSize;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setMaxFieldSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setMaxFieldSize", maxFieldSize);
            }
            if (maxFieldSize < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.maxfieldsize", String.valueOf(maxFieldSize));
            }
            this.assertOpen();
            this._maxFieldSize = maxFieldSize;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRows() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMaxRows") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxRows", new Object[0]);
            }
            int result = this._getMaxRows();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setMaxRows") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setMaxRows", maxRows);
            }
            if (maxRows < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.maxrows", String.valueOf(maxRows));
            }
            this.assertOpen();
            this._maxRows = maxRows;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setEscapeProcessing") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setEscapeProcessing", enable);
            }
            this.assertOpen();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getQueryTimeout") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getQueryTimeout", new Object[0]);
            }
            int result = this._queryTimeout;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setQueryTimeout") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setQueryTimeout", queryTimeout);
            }
            if (queryTimeout < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.querytimeout", String.valueOf(queryTimeout));
            }
            this.assertOpen();
            this._queryTimeout = queryTimeout;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void cancel() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "cancel") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "cancel", new Object[0]);
            }
            this._cancel();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            SQLWarning result = null;
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setCursorName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCursorName", cursorName);
            }
            this.assertOpen();
            if (cursorName != null && !cursorName.isEmpty()) {
                this._cursorName = cursorName;
            }
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql);
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSet") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSet", new Object[0]);
            }
            this.assertOpen();
            ResultSetSapDB result = this._currentResultSet;
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetSapDB resultSetSapDB = result;
            return resultSetSapDB;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getUpdateCount") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getUpdateCount", new Object[0]);
            }
            int result = this._getUpdateCount();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMoreResults") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMoreResults", new Object[0]);
            }
            boolean result = this._getMoreResults(3);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFetchDirection", new Object[0]);
            }
            int result = this._fetchDirection;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchDirection", fetchDirection);
            }
            switch (fetchDirection) {
                case 1000: 
                case 1001: 
                case 1002: {
                    this._fetchDirection = fetchDirection;
                    return;
                }
                default: {
                    throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
                }
            }
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (!pon) throw e;
            r.setException(e);
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFetchSize", new Object[0]);
            }
            int result = this._getFetchSize();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchSize", fetchSize);
            }
            if (fetchSize < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.fetchsize", String.valueOf(fetchSize));
            }
            this._fetchSize = fetchSize;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetConcurrency() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetConcurrency") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetConcurrency", new Object[0]);
            }
            int result = this._resultSetConcurrency;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetType") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetType", new Object[0]);
            }
            int result = this._resultSetType;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "addBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "addBatch", sql);
            }
            if (this._batchItems == null) {
                this._batchItems = new Vector();
            }
            this._batchItems.add(sql);
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "clearBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearBatch", new Object[0]);
            }
            this._batchItems = null;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeBatch", new Object[0]);
            }
            int[] result = this._executeBatch();
            if (on) {
                this._tracer.printResult(result);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getConnection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getConnection", new Object[0]);
            }
            ConnectionSapDB result = this._connection;
            if (on) {
                this._tracer.printResult(result);
            }
            ConnectionSapDB connectionSapDB = result;
            return connectionSapDB;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMoreResults") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMoreResults", current);
            }
            boolean result = this._getMoreResults(current);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getGeneratedKeys") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getGeneratedKeys", new Object[0]);
                }
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, autoGeneratedKeys);
            }
            if (autoGeneratedKeys == 1) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, columnIndexes);
            }
            if (columnIndexes.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, columnNames);
            }
            if (columnNames.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql, autoGeneratedKeys);
            }
            if (autoGeneratedKeys == 1) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql, columnIndexes);
            }
            if (columnIndexes.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql, columnNames);
            }
            if (columnNames.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetHoldability", new Object[0]);
            }
            int result = this._getResultSetHoldability();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isClosed") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            boolean result = this._isClosed();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isPoolable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isPoolable", new Object[0]);
            }
            this.assertOpen();
            boolean result = this._isPoolable;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setPoolable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setPoolable", isPoolable);
            }
            this.assertOpen();
            this._isPoolable = isPoolable;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isCloseOnCompletion") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "isCloseOnCompletion", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("isCloseOnCompletion()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "closeOnCompletion") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "closeOnCompletion", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("closeOnCompletion()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getLargeUpdateCount") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getLargeUpdateCount", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("getLargeUpdateCount()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getLargeMaxRows") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getLargeMaxRows", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("getLargeMaxRows()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setLargeMaxRows") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setLargeMaxRows", max);
                }
                throw StatementSapDB._getUnsupportedMethodException("setLargeMaxRows( long )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeBatch") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeBatch", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeBatch()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnIndexes);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnNames);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    public ConnectionSapDB getConnectionSapDB() {
        return this._connection;
    }

    protected static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Statement");
    }

    protected static SQLException _getAutoGeneratedKeysNotSupportedException() {
        return SQLExceptionSapDB.newInstance("error.autogenkeys.retrieval.unsupported", new String[0]);
    }

    protected int _getMaxRows() {
        return this._maxRows;
    }

    protected int _getFetchSize() {
        return this._fetchSize;
    }

    protected int _getResultSetHoldability() {
        return this._resultSetHoldability;
    }

    protected ResultSet _executeQuery(String sql) throws SQLException {
        this.assertOpen();
        Session session = this.getSession(true);
        this._execute(sql, session);
        if (this._currentResultSet == null) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noresultset", new String[0]);
        }
        return this._currentResultSet;
    }

    protected int _executeUpdate(String sql) throws SQLException {
        this.assertOpen();
        Session session = this.getSession(true);
        boolean isQuery = this._execute(sql, session);
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        if (this._hasRowCount) {
            return this._rowsAffected;
        }
        return 0;
    }

    protected boolean _execute(String sql) throws SQLException {
        Session session = this.getSession(true);
        return this._execute(sql, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _execute(String sql, Session session) throws SQLException {
        this.assertOpen();
        try {
            boolean isQuery;
            this._canceled = false;
            if (sql == null || sql.isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.sqlstatement.null", new String[0]);
            }
            try {
                this.closeResultSets();
                HReplyPacket replyPacket = this.sendSQL(sql, false, session);
                isQuery = this.parseResult(session, replyPacket, new ArrayList<AbstractTranslator>(), true);
            }
            catch (InternalReconnectException e) {
                session = e.getNewSession();
                if (session == null || !session.isConnected()) {
                    throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
                }
                this._connection.handleTransaction(session, false);
                isQuery = this._execute(sql, session);
            }
            boolean bl = isQuery;
            return bl;
        }
        finally {
            this._canceled = false;
        }
    }

    protected boolean _getMoreResults(int current) throws SQLException {
        boolean ret;
        this.assertOpen();
        if (this._currentResultSet != null) {
            switch (current) {
                case 1: {
                    this._currentResultSet._close();
                    this._cursorUsage = 0;
                    break;
                }
                case 2: {
                    if (!this._resultSets.contains(this._currentResultSet)) break;
                    ++this._currentResultSetIndex;
                    break;
                }
                case 3: {
                    if (!this._resultSets.contains(this._currentResultSet)) break;
                    this.closeResultSets(this._currentResultSetIndex);
                    break;
                }
                default: {
                    throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "getMoreResults", "Statement.CLOSE_CURRENT_RESULT, Statement.KEEP_CURRENT_RESULT, or Statement.CLOSE_ALL_RESULTS");
                }
            }
            if (this._currentResultSetIndex < this._resultSets.size()) {
                this._currentResultSet = this._resultSets.get(this._currentResultSetIndex);
                this._cursorUsage = this._resultSetType == 1003 ? 2 : 1;
                ret = true;
            } else {
                this._currentResultSet = null;
                ret = false;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    protected int _getUpdateCount() throws SQLException {
        int ret;
        this.assertOpen();
        if (this._currentResultSet == null) {
            if (this._hasRowCount && !this._hasReturnedRowsAffected) {
                this._hasReturnedRowsAffected = true;
                ret = this._rowsAffected;
            } else {
                ret = -1;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] _executeBatch() throws SQLException {
        this.assertOpen();
        this._serverProcessingTime = 0L;
        if (this._batchItems == null) {
            return new int[0];
        }
        int count = this._batchItems.size();
        int[] result = new int[count];
        Vector<Object> items = this._batchItems;
        Session session = this.getSession(true);
        this._batchItems = null;
        try {
            this._canceled = false;
            int inputCursor = 0;
            int receiveCursor = 0;
            while (inputCursor < count) {
                HRequestPacket newRequestPacket = this._connection.getRequestPacket(session);
                newRequestPacket.initExecuteDirect(this._connection, session, this._resultSetHoldability, this._queryTimeout, (String)items.elementAt(inputCursor), null, -1, true, true);
                ++inputCursor;
                while (inputCursor < count && newRequestPacket.initExecuteDirect(this._connection, session, this._resultSetHoldability, this._queryTimeout, (String)items.elementAt(inputCursor), null, -1, false, true)) {
                    ++inputCursor;
                }
                newRequestPacket.close();
                HReplyPacket replyPacket = this._connection.execute(this, session, newRequestPacket, ConnectionSapDB.ExecuteFlag.IGNORE_ERRORS, ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
                for (HSegmentInfo segmentInfo : replyPacket.segments()) {
                    int rowsAffected;
                    SQLException sqlExceptionChain = segmentInfo.findSQLExceptionChain();
                    if (sqlExceptionChain != null) {
                        int[] resArr = new int[receiveCursor];
                        System.arraycopy(result, 0, resArr, 0, receiveCursor);
                        throw new BatchUpdateExceptionSapDB(resArr, sqlExceptionChain);
                    }
                    FunctionCode functionCode = segmentInfo.getFunctionCode();
                    if (functionCode == FunctionCode.Select || functionCode == FunctionCode.SelectForUpdate) {
                        int[] resArr = new int[receiveCursor + 1];
                        System.arraycopy(result, 0, resArr, 0, receiveCursor);
                        resArr[receiveCursor] = -3;
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset.withnumber", Integer.toString(receiveCursor + 1)), "2A000", resArr);
                    }
                    result[receiveCursor] = rowsAffected = segmentInfo.findRowsAffected();
                    if (result[receiveCursor] == -1) {
                        result[receiveCursor] = -2;
                    }
                    long serverExecutionTime = segmentInfo.findServerExecutionTime();
                    if (this._serverProcessingTime != -1L) {
                        this._serverProcessingTime = serverExecutionTime < 0L ? serverExecutionTime : (this._serverProcessingTime += serverExecutionTime);
                    }
                    ++receiveCursor;
                }
            }
            int[] nArray = result;
            return nArray;
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this._connection.handleTransaction(session, false);
            this._batchItems = items;
            int[] nArray = this._executeBatch();
            return nArray;
        }
        finally {
            this._canceled = false;
        }
    }

    protected void _cancel() throws SQLException {
        this.assertOpen();
        this._canceled = true;
        if (this._currentResultSet != null) {
            try {
                ResultSetSapDB rs = this._currentResultSet;
                this._connection._cancel(this, rs._getExecutingObject());
            }
            catch (ClassCastException e) {
                this._connection._cancel(this);
            }
        } else {
            this._connection._cancel(this);
        }
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _close() throws SQLException {
        if (this._isClosed()) {
            return;
        }
        this.closeResultSets();
        try {
            StatementSapDB statementSapDB = this;
            synchronized (statementSapDB) {
                ConnectionSapDB connectionSapDB = this._connection;
                synchronized (connectionSapDB) {
                    if (this._isClosed.get()) return;
                    if (this._connection._isClosed()) {
                        return;
                    }
                    this._dropParseIDs();
                    this._isClosed.set(true);
                    return;
                }
            }
        }
        finally {
            this._connection._removeStatement(this);
        }
    }

    protected void _dropParseIDs() throws SQLException {
    }

    protected TraceRecord _newTraceRecord(String className, String methodName) {
        return new TraceRecord(this._connection, this, null, className, methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }
}

