/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaSystem;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class SessionPool {
    private final Tracer _tracer;
    private final Map<SiteVolumeID, Session> _sessions;
    private final AtomicReference<Session> _anchorSession;
    private final AtomicReference<Session> _primarySession;
    private HanaSystem _system;

    public SessionPool(Tracer tracer) {
        this._tracer = tracer;
        this._sessions = new HashMap<SiteVolumeID, Session>();
        this._anchorSession = new AtomicReference();
        this._primarySession = new AtomicReference();
    }

    public Map<SiteVolumeID, Session> getSessions() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public Session getSession(SiteVolumeID siteVolumeID) {
        return this._sessions.get(siteVolumeID);
    }

    public HanaSystem getSystem() {
        return this._system;
    }

    public Session getAnchorSession() {
        return this._anchorSession.get();
    }

    public Session getPrimarySession() {
        return this._primarySession.get();
    }

    public void setPrimarySession(Session primarySession) {
        Session currentPrimarySession = this._primarySession.get();
        if (currentPrimarySession == null) {
            this._primarySession.set(primarySession);
        } else if (currentPrimarySession != primarySession && !primarySession.isHintRouted()) {
            this._primarySession.set(primarySession);
            this.setSendSessionContextFlag();
            if (this._tracer.on()) {
                this._tracer.printDistribution("Primary session changed to " + primarySession.toString());
            }
        }
    }

    public void addSession(Session session) throws SQLException {
        SiteVolumeID siteVolumeID = session.getSiteVolumeID();
        Session currentPrimarySession = this._primarySession.get();
        if (!session.isHintRouted()) {
            if (this._anchorSession.compareAndSet(null, session) && this._tracer.on()) {
                this._tracer.printDistribution("Anchor  session changed to " + session.toString());
            }
            if (currentPrimarySession == null) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution("Primary session changed to " + session.toString());
                }
            } else if (currentPrimarySession.getSiteVolumeID().equals(siteVolumeID)) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution("Primary session changed to " + session.toString());
                }
            }
        }
        this._sessions.put(siteVolumeID, session);
        if (this._system == null) {
            this._system = session.getSystem();
        }
    }

    public void setSendSessionContextFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionContextFlag();
        }
    }

    public void setSendSessionVariablesFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionVariablesFlag();
        }
    }

    public void setSendClientInfoFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendClientInfoFlag();
        }
    }

    public void releaseAll(ConnectionSapDB connection) {
        this._releaseSessions(connection, false);
        this._anchorSession.set(null);
    }

    public void releaseAllHintRouted(ConnectionSapDB connection) {
        this._releaseSessions(connection, true);
    }

    private void _releaseSessions(ConnectionSapDB connection, boolean hintRoutedOnly) {
        HashSet<SiteVolumeID> siteVolumeIDSet = new HashSet<SiteVolumeID>(this._sessions.keySet());
        for (SiteVolumeID siteVolumeID : siteVolumeIDSet) {
            Session session = this._sessions.get(siteVolumeID);
            if (session == null || hintRoutedOnly && !session.isHintRouted()) continue;
            if (session.isConnected()) {
                try {
                    HRequestPacket requestPacket = connection.getRequestPacket(session);
                    requestPacket.initDisconnect();
                    connection.execute(connection, session, requestPacket, new ConnectionSapDB.ExecuteFlag[0]);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            session.destroy();
            this._sessions.remove(siteVolumeID);
        }
    }

    public int getNumberOfLocations() {
        return this._system.getNumberOfLocations();
    }
}

