/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaSystem;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.LatencySession;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.RTETimeoutException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Session
extends DbgInstanceCount {
    private static final Set<Session> INSTANCES = Collections.newSetFromMap(new ConcurrentHashMap());
    private Properties _currentSessionVariablesAndClientInfoProperties = new Properties();
    protected final Tracer _tracer;
    private final AtomicInteger _connectionID;
    private Location _location;
    private Properties _info;
    private boolean _isHintRouted;
    private boolean _isPartOfTransaction;
    private boolean _isPartOfDistributedTransaction;
    private boolean _isSendSessionContextFlagSet;
    private boolean _isSendSessionVariablesFlagSet;
    private boolean _isSendClientInfoFlagSet;
    private long _sendTime;
    private long _receiveTime;
    private boolean _isDestroyed;
    protected static int DEFAULT_TIMEOUT = 0;
    protected long _sessionID = -1L;
    protected OutputStream _outstream;
    protected InputStream _instream;
    protected int _socketTimeOut;
    protected int _requestPacketSize;
    protected Socket _socket;
    protected int _messageID;
    public static final SessionFactory SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session open(Location location, Properties properties, Tracer tracer, boolean doConnectExchange) throws RTEException {
            Session sc = properties.containsKey("latency") ? new LatencySession(location, properties, tracer) : new Session(location, properties, tracer);
            sc.openSocket();
            Session session = sc.connectDB(SESSION_FACTORY, properties.getProperty("databaseName"), doConnectExchange);
            return session;
        }
    };

    public Session(Location location, Properties properties, Tracer tracer) throws RTEException {
        INSTANCES.add(this);
        this._location = location;
        this._tracer = tracer;
        this._info = properties;
        this._connectionID = new AtomicInteger();
        this._BasicSocketCommInit(properties);
    }

    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._closeSocket();
        INSTANCES.remove(this);
        this._isDestroyed = true;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return "Session@" + this.hashCode() + " ConnectionID:" + this._connectionID.get() + " SessionID:" + this.getSessionID() + " SiteID:" + this._location.getSiteVolumeID().getSiteID() + " VolumeID:" + this._location.getSiteVolumeID().getVolumeID() + " Host " + this._location.getHostName() + ":" + this._location.getPortNumber() + " on " + this._socket;
    }

    public Location getLocation() {
        return this._location;
    }

    public void setLocation(Location location) {
        this._location = location;
    }

    public HanaSystem getSystem() {
        return this._location.getSystem();
    }

    public SiteVolumeID getSiteVolumeID() {
        return this._location.getSiteVolumeID();
    }

    public boolean isPrimarySite() {
        return this._location.isPrimarySite();
    }

    public boolean isSecondarySite() {
        return this._location.isSecondarySite();
    }

    public boolean isHintRouted() {
        return this._isHintRouted;
    }

    public void setHintRouted(boolean isHintRouted) {
        if (isHintRouted && this.isSecondarySite() || !isHintRouted) {
            this._isHintRouted = isHintRouted;
        }
    }

    public int getConnectionID() {
        return this._connectionID.get();
    }

    public void setConnectionID(int connectionID) {
        this._connectionID.set(connectionID);
    }

    public boolean isPartOfTransaction() {
        return this._isPartOfTransaction;
    }

    public boolean isPartOfDistributedTransaction() {
        return this._isPartOfDistributedTransaction;
    }

    public void joinTransaction() {
        this._isPartOfTransaction = true;
    }

    public void joinDistributedTransaction() {
        this._isPartOfTransaction = true;
        this._isPartOfDistributedTransaction = true;
    }

    public void leaveTransaction() {
        this._isPartOfTransaction = false;
        this._isPartOfDistributedTransaction = false;
    }

    public boolean isSendSessionContextFlagSet() {
        return this._isSendSessionContextFlagSet;
    }

    public void setSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = true;
    }

    public void clearSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = false;
    }

    public boolean isSendSessionVariablesFlagSet() {
        return this._isSendSessionVariablesFlagSet;
    }

    public void setSendSessionVariablesFlag() {
        if (!this._isHintRouted) {
            return;
        }
        this._isSendSessionVariablesFlagSet = true;
    }

    public boolean isSendClientInfoFlagSet() {
        return this._isSendClientInfoFlagSet;
    }

    public void setSendClientInfoFlag() {
        this._isSendClientInfoFlagSet = true;
    }

    public void clearSendSessionVariablesAndClientInfoFlags(ConnectionSapDB connection) {
        Properties properties = new Properties();
        this._isSendSessionVariablesFlagSet = false;
        this._isSendClientInfoFlagSet = false;
        properties.putAll((Map<?, ?>)connection._getClientInfo());
        if (this._isHintRouted) {
            properties.putAll((Map<?, ?>)connection._getSessionVariables());
        }
        this._currentSessionVariablesAndClientInfoProperties = properties;
    }

    public Properties getCurrentSessionVariablesAndClientInfoProperties() {
        return this._currentSessionVariablesAndClientInfoProperties;
    }

    public long getSendTime() {
        return this._sendTime;
    }

    public long getReceiveTime() {
        return this._receiveTime;
    }

    public HReplyPacket execute(HRequestPacket requestPacket) throws RTEException {
        long beforeSend = Session._getMicroTime();
        this._send(requestPacket);
        long afterSend = Session._getMicroTime();
        this._sendTime = afterSend - beforeSend;
        HReplyPacket replyPacket = this._receive();
        long afterReceive = Session._getMicroTime();
        this._receiveTime = afterReceive - afterSend;
        return replyPacket;
    }

    protected void _send(HRequestPacket requestPacket) throws RTEException {
        byte[] packet = requestPacket.getRawPacketArray();
        int len = requestPacket.getLength();
        ByteUtils.putLong(this._sessionID, packet, 0);
        ByteUtils.putInt(this._messageID++, packet, 8);
        if (this._tracer.on()) {
            this._tracer.printPacket(packet);
        }
        this._sendRawData(packet, len);
    }

    protected HReplyPacket _receive() throws RTEException {
        byte[] header = new byte[32];
        byte[] packet = null;
        try {
            int n;
            if (this._instream.read(header, 0, 32) != 32) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            long sessionID = ByteUtils.getLong(header, 0);
            int varpartLength = ByteUtils.getInt(header, 12);
            if (this._sessionID == -1L && (sessionID != 0L || ByteUtils.getInt(header, 8) != 0)) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.REQUEST_UNKNOWN);
            }
            this._sessionID = sessionID;
            packet = new byte[varpartLength + 32];
            System.arraycopy(header, 0, packet, 0, 32);
            int off = 32;
            for (int len = varpartLength; len > 0; len -= n) {
                n = this._instream.read(packet, off, len);
                if (n == -1) {
                    this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                }
                off += n;
            }
        }
        catch (SocketTimeoutException e) {
            throw new RTETimeoutException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        if (this._tracer.on()) {
            this._tracer.printPacket(packet);
        }
        return HReplyPacket.newInstance(packet);
    }

    private static long _getMicroTime() {
        return System.nanoTime() / 1000L;
    }

    private void _closeSocket() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this._socket = null;
        }
    }

    public boolean isConnected() {
        return this._isConnected();
    }

    public long getSessionID() {
        return this._sessionID;
    }

    public byte[] getRequestPacket() {
        return new byte[this._requestPacketSize];
    }

    protected void _BasicSocketCommInit(Properties properties) {
        this._socketTimeOut = this.getIntProperty(properties, "communicationTimeout", DEFAULT_TIMEOUT);
        this._requestPacketSize = this.getIntProperty(properties, "packetSize", 130000);
    }

    protected int getIntProperty(Properties properties, String property, int defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String propertyValueString = properties.getProperty(property);
        if (propertyValueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValueString);
        }
        catch (NumberFormatException numberFormatEx) {
            return defaultValue;
        }
    }

    protected void openSocket() throws RTEException {
        this._openSocket();
    }

    private void doInfoExchange() throws RTEException {
        byte[] request = new byte[14];
        ByteUtils.putLongBigEndian(-1L, request, 0);
        ByteUtils.putByte(4, request, 4);
        ByteUtils.putShortBigEndian(20, request, 5);
        ByteUtils.putByte(4, request, 7);
        ByteUtils.putShortBigEndian(1, request, 8);
        ByteUtils.putByte(1, request, 11);
        ByteUtils.putByte(1, request, 12);
        ByteUtils.putByte(1, request, 13);
        this._sendRawData(request, 14);
        try {
            byte[] reply = new byte[8];
            int len = this._instream.read(reply, 0, 8);
            if (len < 8) {
                this._throwRTEException(MessageTranslator.translate("error.recv.connect", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.connect.receivefailed", e.getMessage()), RteReturnCode.SQLNOTOK);
        }
    }

    protected Session dbConnectExchange(SessionFactory factory, String dbname) throws RTEException {
        if (dbname == null || dbname.length() == 0) {
            return this;
        }
        HRequestPacket requestPacket = HRequestPacket.newInstance(this.getRequestPacket());
        requestPacket.initDBConnectInfo(dbname);
        HReplyPacket dbReply = this.execute(requestPacket);
        DBConnectInfo dbinfoParams = dbReply.findDBConnectInfo(0);
        if (dbinfoParams == null) {
            SQLException e = dbReply.findSQLExceptionChain(0);
            if (e == null) {
                e = SQLExceptionSapDB.newInstance("error.internal.unknownError", new String[0]);
            }
            this._throwRTEException(e.getMessage(), RteReturnCode.decode(e.getErrorCode()), -708);
        }
        if (dbinfoParams.isOnCorrectDatabase()) {
            return this;
        }
        if (dbinfoParams.getPort() <= 0 || dbinfoParams.getHost() == null || dbinfoParams.getHost().length() == 0) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", dbname), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        if (this._tracer.on()) {
            this._tracer.printMessage(dbinfoParams.toString());
        }
        this.destroy();
        String hostName = dbinfoParams.getHost();
        int portNumber = dbinfoParams.getPort();
        Host host = new Host(hostName, portNumber);
        Location location = new Location(host, null);
        Session newSession = factory.open(location, this._info, this._tracer, false);
        return newSession;
    }

    private void _throwRTEException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode);
    }

    private void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode) throws RTEException {
        this.destroy();
        throw new RTEException(this._tracer, message, rteReturnCode, detailErrorCode);
    }

    public Session connectDB(SessionFactory factory, String dbname, boolean doConnectExchange) throws RTEException {
        this.doInfoExchange();
        if (doConnectExchange && dbname != null && dbname.length() > 0) {
            return this.dbConnectExchange(factory, dbname);
        }
        return this;
    }

    public boolean _isConnected() {
        return this._socket != null;
    }

    protected void _sendRawData(byte[] bytes, int len) throws RTEException {
        OutputStream ostream = null;
        try {
            if (this._outstream == null) {
                this._outstream = this._socket.getOutputStream();
            }
            ostream = this._outstream;
        }
        catch (IOException ioExc1) {
            this._throwRTEException("sendData: getOutputStream failed", RteReturnCode.SQLSEND_LINE_DOWN);
        }
        try {
            ostream.write(bytes, 0, len);
        }
        catch (IOException ioExc2) {
            this._throwRTEException(MessageTranslator.translate("error.send.write", ioExc2.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
    }

    protected int lookupPort() {
        return this.getLocation().getPortNumber();
    }

    protected final void _openSocket() throws RTEException {
        RTEException exc;
        block11: {
            exc = null;
            String hostName = this.getLocation().getHostName();
            int port = this.lookupPort();
            if (this._tracer.on()) {
                this._tracer.printMessage("HOSTLIST: [" + hostName + ":" + port + "]");
            }
            if (Driver.getComputerName() != null && (Driver.getComputerName().equalsIgnoreCase(hostName) || Driver.getFullComputerName().equalsIgnoreCase(hostName))) {
                hostName = "localhost";
            }
            try {
                this._socket = new Socket(hostName, port);
                try {
                    this._socket.setSoTimeout(this._socketTimeOut);
                    this._socket.setTcpNoDelay(true);
                    this._socket.setSendBufferSize(36864);
                    this._socket.setKeepAlive(true);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                this._instream = this._socket.getInputStream();
                this._outstream = this._socket.getOutputStream();
                exc = null;
            }
            catch (UnknownHostException uhexc) {
                if (exc == null) {
                    exc = new RTEException(this._tracer, MessageTranslator.translate("error.unknown.host", hostName + ":" + this.lookupPort(), uhexc.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
                }
            }
            catch (IOException ioexc) {
                if (exc != null) break block11;
                exc = new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", hostName + ":" + this.lookupPort(), ioexc.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
            }
        }
        if (exc != null) {
            throw exc;
        }
        try {
            this._socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

