/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.SSLUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureSession
extends Session {
    public static final SessionFactory SECURE_SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session open(Location location, Properties properties, Tracer tracer, boolean doConnectExchange) throws RTEException {
            SecureSession sc = new SecureSession(location, properties, tracer);
            sc.openSocket();
            Session session = sc.connectDB(SECURE_SESSION_FACTORY, properties.getProperty("databaseName"), doConnectExchange);
            return session;
        }
    };
    private boolean _validateCertificate;
    private String _hostNameInCertificate;
    private String _keyStore;
    private String _keyStoreType;
    private String _keyStorePasswd;
    private String _trustStore;
    private String _trustStoreType;
    private String _trustStorePasswd;
    private String _sniHostname;

    private SecureSession(Location location, Properties properties, Tracer tracer) throws RTEException {
        super(location, properties, tracer);
        this._validateCertificate = ConnectionProperty.getBooleanProperty(properties, "validateCertificate", true);
        this._hostNameInCertificate = properties.getProperty("hostNameInCertificate");
        this._keyStore = properties.getProperty("keyStore");
        this._keyStoreType = properties.getProperty("keyStoreType");
        this._keyStorePasswd = properties.getProperty("keyStorePassword");
        this._trustStore = properties.getProperty("trustStore");
        this._trustStoreType = properties.getProperty("trustStoreType");
        this._trustStorePasswd = properties.getProperty("trustStorePassword");
        this._sniHostname = properties.getProperty("sniHostname");
    }

    private boolean isSystemDefaultUsed() {
        return this._keyStore == null && this._keyStoreType == null && this._keyStorePasswd == null && this._trustStore == null && this._trustStorePasswd == null && this._trustStoreType == null;
    }

    private String getKeyStoreType() {
        if (this._keyStoreType == null) {
            return "jks";
        }
        return this._keyStoreType;
    }

    private String getTrustStoreType() {
        if (this._trustStoreType == null) {
            return "jks";
        }
        return this._trustStoreType;
    }

    private String getKeyStoreFileName() {
        if (this._keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this._keyStore;
    }

    private String getTrustStoreFileName() {
        if (this._trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this._trustStore;
    }

    private String getKeyStorePasswd() {
        if (this._keyStorePasswd != null) {
            return this._keyStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String getTrustStorePasswd() {
        if (this._trustStorePasswd != null) {
            return this._trustStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.trustStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return null;
    }

    KeyManagerFactory getKeyManagerFactory(String host) throws RTEException {
        FileInputStream fis;
        KeyStore ks;
        KeyManagerFactory kmf;
        String keystorefilename = this.getKeyStoreFileName();
        if (keystorefilename == null) {
            return null;
        }
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsaex) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keymanagerfactorynodefault", nsaex.getMessage());
            sqlEx.initCause(nsaex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, nsaex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        try {
            ks = KeyStore.getInstance(this.getKeyStoreType());
        }
        catch (KeyStoreException kse) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keystore.create", kse.getMessage());
            sqlEx.initCause(kse);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, kse.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        try {
            fis = new FileInputStream(keystorefilename);
        }
        catch (FileNotFoundException fnf) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keystorefilenotfound", fnf.getMessage());
            sqlEx.initCause(fnf);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, fnf.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        try {
            ks.load(fis, this.getKeyStorePasswd().toCharArray());
        }
        catch (NoSuchAlgorithmException nsae) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keystoreloadfailed.nosuchalgorithm", nsae.getMessage());
            sqlEx.initCause(nsae);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, nsae.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        catch (CertificateException certe) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keystoreloadfailed.certificate", certe.getMessage());
            sqlEx.initCause(certe);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, certe.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        catch (IOException ioe) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keystoreloadfailed.ioexception", ioe.getMessage());
            sqlEx.initCause(ioe);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, ioe.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            kmf.init(ks, this.getKeyStorePasswd().toCharArray());
        }
        catch (UnrecoverableKeyException urke) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keymanagerfactory.unrecoverablekey", urke.getMessage());
            sqlEx.initCause(urke);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, urke.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        catch (KeyStoreException e) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        catch (NoSuchAlgorithmException nsae) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keymanagerfactory.nosuchalgorithm", nsae.getMessage());
            sqlEx.initCause(nsae);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, nsae.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return kmf;
    }

    TrustManagerFactory getTrustManagerFactory(String host) throws RTEException {
        FileInputStream fis;
        KeyStore ks;
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsaex) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.trustmanagerfactorynodefault", nsaex.getMessage());
            sqlEx.initCause(nsaex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, nsaex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        try {
            ks = KeyStore.getInstance(this.getTrustStoreType());
        }
        catch (KeyStoreException kse) {
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.keystore.create", kse.getMessage());
            sqlex.initCause(kse);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, kse.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        String keystorefilename = this.getTrustStoreFileName();
        if (keystorefilename == null) {
            return null;
        }
        try {
            fis = new FileInputStream(keystorefilename);
        }
        catch (FileNotFoundException fnf) {
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.keystorefilenotfound", fnf.getMessage());
            sqlex.initCause(fnf);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, fnf.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        try {
            String tspass = this.getTrustStorePasswd();
            ks.load(fis, tspass == null ? null : tspass.toCharArray());
        }
        catch (NoSuchAlgorithmException nsaex) {
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.keystoreloadfailed.nosuchalgorithm", nsaex.getMessage());
            sqlex.initCause(nsaex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, nsaex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (CertificateException cex) {
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.keystoreloadfailed.certificate", cex.getMessage());
            sqlex.initCause(cex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, cex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (IOException ioex) {
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.keystoreloadfailed.ioexception", ioex.getMessage());
            sqlex.initCause(ioex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, ioex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            tmf.init(ks);
        }
        catch (KeyStoreException kse) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)kse, "error.ssl.keymanagerfactory.keystore", new String[0]);
            sqlex.initCause(kse);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, kse.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tmf;
    }

    @Override
    protected final void openSocket() throws RTEException {
        RTEException exc = null;
        String hostName = this.getLocation().getHostName();
        try {
            this.openSocketIntern(hostName);
            return;
        }
        catch (RTEException e) {
            if (exc == null) {
                exc = e;
            }
            if (exc != null) {
                throw exc;
            }
            return;
        }
    }

    private void openSocketIntern(String host) throws RTEException {
        Socket sslsocket = null;
        boolean socketInUse = false;
        try {
            SSLSocketFactory factory;
            SSLContext sc;
            if (!this._validateCertificate) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                factory = sc.getSocketFactory();
            } else if (this.isSystemDefaultUsed()) {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                sc = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = this.getKeyManagerFactory(host);
                TrustManagerFactory tmf = this.getTrustManagerFactory(host);
                Object[] km = null;
                TrustManager[] tm = null;
                if (kmf != null) {
                    km = kmf.getKeyManagers();
                }
                if (tmf != null) {
                    tm = tmf.getTrustManagers();
                }
                sc.init((KeyManager[])km, tm, new SecureRandom());
                factory = sc.getSocketFactory();
            }
            this._socket = factory.createSocket(host, this.lookupPort());
            sslsocket = (SSLSocket)this._socket;
            ((SSLSocket)sslsocket).setUseClientMode(true);
            ArrayList<Object> protocols = new ArrayList<Object>();
            String[] supported_protocols = ((SSLSocket)sslsocket).getSupportedProtocols();
            for (String protocol : supported_protocols) {
                if (!protocol.startsWith("TLS")) continue;
                protocols.add(protocol);
            }
            String[] protocolArray = new String[protocols.size()];
            protocols.toArray(protocolArray);
            ((SSLSocket)sslsocket).setEnabledProtocols(protocolArray);
            if (Driver.getJavaVersion() >= 8) {
                SNIHostName serverName = new SNIHostName(this._sniHostname == null ? host : this._sniHostname);
                ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
                serverNames.add(serverName);
                SSLParameters params = ((SSLSocket)sslsocket).getSSLParameters();
                params.setServerNames(serverNames);
                ((SSLSocket)sslsocket).setSSLParameters(params);
            }
            ((SSLSocket)sslsocket).startHandshake();
            if (!"*".equals(this._hostNameInCertificate) && this._validateCertificate) {
                SQLException e;
                Certificate[] certs;
                try {
                    certs = ((SSLSocket)sslsocket).getSession().getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException e2) {
                    certs = new Certificate[]{};
                }
                if (certs.length == 0) {
                    try {
                        throw SQLExceptionSapDB.newInstance("error.ssl.nocertificatefound", new String[0]);
                    }
                    catch (SQLException sqlEx) {
                        throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, sqlEx.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
                    }
                }
                try {
                    X509Certificate x509cert = (X509Certificate)certs[0];
                    X500Principal principal = x509cert.getSubjectX500Principal();
                    String rfc2253name = principal.getName("RFC2253");
                    Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                    if (!SSLUtils.validateHostName(rfc2253name, alternativenames, this._hostNameInCertificate == null ? host : this._hostNameInCertificate)) {
                        try {
                            throw SQLExceptionSapDB.newInstance("error.ssl.hostnameverificationfailed", rfc2253name, this._hostNameInCertificate == null ? host : this._hostNameInCertificate);
                        }
                        catch (SQLException sqlEx) {
                            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, sqlEx.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
                        }
                    }
                }
                catch (ClassCastException classCastEx) {
                    try {
                        e = SQLExceptionSapDB.newInstance("error.ssl.nox509certificate", new String[0]);
                        e.initCause(classCastEx);
                        throw e;
                    }
                    catch (SQLException sqlEx) {
                        throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, sqlEx, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
                    }
                }
                catch (CertificateParsingException certParsingEx) {
                    try {
                        e = SQLExceptionSapDB.newInstance("error.ssl.nox509certificate", new String[0]);
                        e.initCause(certParsingEx);
                        throw e;
                    }
                    catch (SQLException sqlEx) {
                        throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, sqlEx, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
                    }
                }
            }
            try {
                sslsocket.setSoTimeout(this._socketTimeOut);
                sslsocket.setTcpNoDelay(true);
                sslsocket.setReceiveBufferSize(36864);
                sslsocket.setSendBufferSize(36864);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this._instream = this._socket.getInputStream();
            this._outstream = this._socket.getOutputStream();
            socketInUse = true;
        }
        catch (NoSuchAlgorithmException noSuchAlg) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.nosuchalgorithm", noSuchAlg.getMessage());
            sqlEx.initCause(noSuchAlg);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, noSuchAlg.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        catch (KeyManagementException keyManagementEx) {
            SQLException sqlEx = SQLExceptionSapDB.newInstance("error.ssl.keymanagementexception", keyManagementEx.getMessage());
            sqlEx.initCause(keyManagementEx);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host, keyManagementEx.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlEx);
        }
        catch (UnknownHostException uhexc) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.unknown.host", host, uhexc.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        catch (SSLHandshakeException sslhsex) {
            if (sslhsex.getMessage().contains("PKIX path building failed")) {
                SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.certificatepath", sslhsex.getMessage());
                sqlex.initCause(sslhsex);
                throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslhsex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
            }
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.handshake", sslhsex.getMessage());
            sqlex.initCause(sslhsex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslhsex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (SSLException sslex) {
            if (sslex.getMessage().contains("Received fatal alert: internal_error")) {
                SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.nosslsupport", sslex.getMessage());
                sqlex.initCause(sslex);
                throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
            }
            SQLException sqlex = SQLExceptionSapDB.newInstance("error.ssl.handshake", sslex.getMessage());
            sqlex.initCause(sslex);
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (IOException ioexc) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), ioexc.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode());
        }
        finally {
            if (sslsocket != null && !socketInUse) {
                try {
                    sslsocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

