/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.FetchChunk;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.ResultSetMetaDataSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResultSetSapDB
extends WrapperDummy
implements ResultSet,
SQLParamController {
    public static final int DEFAULT_FETCHSIZE = 32766;
    public static final int MAX_FETCHSIZE = 32766;
    private final Tracer _tracer;
    private final ConnectionSapDB _connection;
    private final Session _session;
    private final StatementSapDB _statement;
    private final FetchInfo _fetchInfo;
    private final int _rollbackCount;
    private final int _maxRows;
    private final AtomicBoolean _isClosed;
    private List<InputStream> _openInputStreams = new ArrayList<InputStream>();
    private List<Reader> _openReaders = new ArrayList<Reader>();
    private ResultSetMetaDataSapDB _metaData;
    private int _fetchSize;
    private int _cursorType;
    private Position _positionState;
    private Position _positionStateOfChunk;
    private boolean _isResultSetClosedOnServer;
    private boolean _isFromMetaData;
    private boolean _isEmpty;
    private DataFormatDescription.NullIndicator _nullIndicator;
    private FetchChunk _currentChunk;
    private long _serverProcessingTime;

    protected ResultSetSapDB(Tracer tracer, ConnectionSapDB connection, Session session, StatementSapDB statement, FetchInfo fetchInfo, HDataPart dataPart) throws SQLException {
        this._tracer = tracer;
        this._connection = connection;
        this._session = session;
        this._statement = statement;
        this._fetchInfo = fetchInfo;
        this._metaData = new ResultSetMetaDataSapDB(tracer, this._fetchInfo);
        this._rollbackCount = connection._getRollbackCount();
        this._maxRows = statement._getMaxRows();
        this._isClosed = new AtomicBoolean();
        int fetchSize = statement._getFetchSize();
        this._fetchSize = fetchSize >= 0 ? fetchSize : 32766;
        this._cursorType = statement.getCursorType();
        this._positionState = Position.BEFORE_FIRST;
        this._positionStateOfChunk = Position.NOT_AVAILABLE;
        if (dataPart != null) {
            this._setCurrentChunk(dataPart, 1);
            this._positionState = Position.BEFORE_FIRST;
        } else {
            this._isResultSetClosedOnServer = true;
        }
        this._statement.addResultSet(this);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("next") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "next", new Object[0]);
            }
            boolean result = this._next();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            this._close();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("wasNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "wasNull", new Object[0]);
            }
            boolean result = this._wasNull();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            SQLWarning result = null;
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getCursorName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCursorName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCursorName", new Object[0]);
            }
            String result = this._fetchInfo.getCursorID().toString();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            ResultSetMetaDataSapDB result = this._metaData;
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetMetaDataSapDB resultSetMetaDataSapDB = result;
            return resultSetMetaDataSapDB;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int findColumn(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("findColumn") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "findColumn", columnLabel);
            }
            int result = this._getTranslator(columnLabel).getIndex();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getObject", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Object result = translator.getObject(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Object object = result;
            return object;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getObject", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Object result = translator.getObject(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Object object = result;
            return object;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBoolean", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            boolean result = translator.getBoolean(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean getBoolean(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBoolean", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            boolean result = translator.getBoolean(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getByte", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            byte result = translator.getByte(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            byte by = result;
            return by;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte getByte(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getByte", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            byte result = translator.getByte(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            byte by = result;
            return by;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getShort", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            short result = translator.getShort(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            short s = result;
            return s;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized short getShort(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getShort", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            short result = translator.getShort(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            short s = result;
            return s;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getInt", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            int result = translator.getInt(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int getInt(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getInt", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            int result = translator.getInt(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getLong", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            long result = translator.getLong(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized long getLong(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getLong", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            long result = translator.getLong(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFloat", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            float result = translator.getFloat(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(Float.valueOf(result));
            }
            float f = result;
            return f;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized float getFloat(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFloat", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            float result = translator.getFloat(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(Float.valueOf(result));
            }
            float f = result;
            return f;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDouble", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            double result = translator.getDouble(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            double d = result;
            return d;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized double getDouble(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDouble", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            double result = translator.getDouble(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            double d = result;
            return d;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnIndex, scale);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnLabel, scale);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getString", columnIndex);
            }
            String result = this._getString(columnIndex);
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getString(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getString", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBytes", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            byte[] result = translator.getBytes(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(HexUtils.toDisplayHexString(result, 20));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte[] getBytes(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBytes", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            byte[] result = translator.getBytes(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(HexUtils.toDisplayHexString(result, 20));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getAsciiStream") : null;
        try {
            AbstractTranslator translator;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getAsciiStream", columnIndex);
            }
            if ((result = (translator = this._getTranslator(columnIndex)).getAsciiStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openInputStreams.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getAsciiStream") : null;
        try {
            AbstractTranslator translator;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getAsciiStream", columnLabel);
            }
            if ((result = (translator = this._getTranslator(columnLabel)).getAsciiStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openInputStreams.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getUnicodeStream") : null;
        try {
            AbstractTranslator translator;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getUnicodeStream", columnIndex);
            }
            if ((result = (translator = this._getTranslator(columnIndex)).getUnicodeStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openInputStreams.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getUnicodeStream") : null;
        try {
            AbstractTranslator translator;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getUnicodeStream", columnLabel);
            }
            if ((result = (translator = this._getTranslator(columnLabel)).getUnicodeStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openInputStreams.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBinaryStream") : null;
        try {
            AbstractTranslator translator;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", columnIndex);
            }
            if ((result = (translator = this._getTranslator(columnIndex)).getBinaryStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openInputStreams.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBinaryStream") : null;
        try {
            AbstractTranslator translator;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", columnLabel);
            }
            if ((result = (translator = this._getTranslator(columnLabel)).getBinaryStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openInputStreams.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isBeforeFirst") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isBeforeFirst", new Object[0]);
            }
            boolean result = this._isBeforeFirst();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isAfterLast") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isAfterLast", new Object[0]);
            }
            boolean result = this._isAfterLast();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isFirst") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isFirst", new Object[0]);
            }
            boolean result = this._isFirst();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isLast") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isLast", new Object[0]);
            }
            boolean result = this._isLast();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("beforeFirst") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "beforeFirst", new Object[0]);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("afterLast") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "afterLast", new Object[0]);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean first() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("first") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "first", new Object[0]);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean last() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("last") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "last", new Object[0]);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int getRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getRow") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getRow", new Object[0]);
            }
            int result = this._getRow();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("absolute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "absolute", row);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("relative") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "relative", rows);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("previous") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "previous", new Object[0]);
                }
                throw ResultSetSapDB._getForwardOnlyException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getFetchDirection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFetchDirection", new Object[0]);
            }
            int result = 1000;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchDirection", direction);
            }
            switch (direction) {
                case 1000: {
                    return;
                }
                case 1001: 
                case 1002: {
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                default: {
                    throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
                }
            }
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (!pon) throw e;
            r.setException(e);
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getFetchSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFetchSize", new Object[0]);
            }
            int result = this._fetchSize;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setFetchSize(int fetchSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchSize", fetchSize);
            }
            if (fetchSize < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.fetchsize", String.valueOf(fetchSize));
            }
            this._fetchSize = fetchSize;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getType") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getType", new Object[0]);
            }
            int result = 1003;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getConcurrency() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getConcurrency") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getConcurrency", new Object[0]);
            }
            int result = 1007;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean rowInserted() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rowInserted") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "rowInserted", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rowUpdated") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "rowUpdated", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rowDeleted") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "rowDeleted", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("insertRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "insertRow", new Object[0]);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRow", new Object[0]);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("deleteRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "deleteRow", new Object[0]);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refreshRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("refreshRow") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "refreshRow", new Object[0]);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("cancelRowUpdates") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "cancelRowUpdates", new Object[0]);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("moveToInsertRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "moveToInsertRow", new Object[0]);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("moveToCurrentRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "moveToCurrentRow", new Object[0]);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Statement getStatement() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getStatement") : null;
        try {
            StatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "getStatement", new Object[0]);
            }
            StatementSapDB statementSapDB = result = this._isFromMetaData ? null : this._statement;
            if (on) {
                this._tracer.printResult(result);
            }
            StatementSapDB statementSapDB2 = result;
            return statementSapDB2;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", columnIndex, map);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getObject( int, Map )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", columnLabel, map);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getObject( String, Map )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", columnIndex, cal);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(String columnLabel, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", columnLabel, cal);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", columnIndex, cal);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(String columnLabel, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", columnLabel, cal);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnIndex, cal);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnLabel, cal);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCharacterStream") : null;
        try {
            AbstractTranslator translator;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", columnIndex);
            }
            if ((result = (translator = this._getTranslator(columnIndex)).getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openReaders.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getCharacterStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCharacterStream") : null;
        try {
            AbstractTranslator translator;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", columnLabel);
            }
            if ((result = (translator = this._getTranslator(columnLabel)).getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openReaders.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Clob getClob(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClob", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Clob result = translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Clob clob = result;
            return clob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Clob getClob(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClob", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Clob result = translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Clob clob = result;
            return clob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBlob", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Blob result = translator.getBlob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Blob blob = result;
            return blob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Blob getBlob(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBlob", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Blob result = translator.getBlob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Blob blob = result;
            return blob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Array getArray(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getArray", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            Array result = translator.getArray(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Array array = result;
            return array;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Array getArray(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getArray", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            Array result = translator.getArray(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Array array = result;
            return array;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Ref getRef(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", columnIndex);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getRef( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Ref getRef(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", columnLabel);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getRef( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNull") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNull", columnIndex);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNull(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNull") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNull", columnLabel);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x, scale);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x, scale);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBoolean") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBoolean", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBoolean(String columnLabel, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBoolean") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBoolean", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateByte") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateByte", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateByte(String columnLabel, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateByte") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateByte", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateShort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateShort", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateShort(String columnLabel, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateShort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateShort", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateInt") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateInt", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateInt(String columnLabel, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateInt") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateInt", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateLong") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateLong", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateLong(String columnLabel, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateLong") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateLong", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateFloat") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateFloat", columnIndex, Float.valueOf(x));
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateFloat(String columnLabel, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateFloat") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateFloat", columnLabel, Float.valueOf(x));
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateDouble") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDouble", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateDouble(String columnLabel, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateDouble") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDouble", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBigDecimal") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBigDecimal", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBigDecimal") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBigDecimal", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateDate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDate", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateDate(String columnLabel, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateDate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDate", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateTime") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTime", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateTime(String columnLabel, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateTime") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTime", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateTimestamp") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTimestamp", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateTimestamp") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTimestamp", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateString", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateString(String columnLabel, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateString", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBytes") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBytes", columnIndex, HexUtils.toDisplayHexString(x, 20));
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBytes(String columnLabel, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBytes") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBytes", columnLabel, HexUtils.toDisplayHexString(x, 20));
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", columnIndex);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getURL( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized URL getURL(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", columnLabel);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getURL( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateClob(String columnLabel, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBlob(String columnLabel, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateArray", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateArray(String columnLabel, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateArray", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRef", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateRef(String columnLabel, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRef", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getHoldability", new Object[0]);
            }
            int result = this._statement._getResultSetHoldability();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isClosed") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            boolean result = this._isClosed();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getNString(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNString", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getNString(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNString", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getNCharacterStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNCharacterStream") : null;
        try {
            AbstractTranslator translator;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", columnIndex);
            }
            if ((result = (translator = this._getTranslator(columnIndex)).getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openReaders.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getNCharacterStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNCharacterStream") : null;
        try {
            AbstractTranslator translator;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", columnLabel);
            }
            if ((result = (translator = this._getTranslator(columnLabel)).getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()))) != null) {
                this._openReaders.add(result);
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized NClob getNClob(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNClob", columnIndex);
            }
            AbstractTranslator translator = this._getTranslator(columnIndex);
            NClob result = (NClob)translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            NClob nClob = result;
            return nClob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized NClob getNClob(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNClob", columnLabel);
            }
            AbstractTranslator translator = this._getTranslator(columnLabel);
            NClob result = (NClob)translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            NClob nClob = result;
            return nClob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized RowId getRowId(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", columnIndex);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getRowId( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized RowId getRowId(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", columnLabel);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getRowId( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SQLXML getSQLXML(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", columnIndex);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getSQLXML( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SQLXML getSQLXML(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", columnLabel);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getSQLXML( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNString(int columnIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNString", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNString(String columnLabel, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNString", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNClob(int columnIndex, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNClob(String columnLabel, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNClob(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBlob(String columnLabel, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnIndex, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnLabel, x, length);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateRowId(int columnIndex, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRowId", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateRowId(String columnLabel, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRowId", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateSQLXML", columnIndex, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateSQLXML", columnLabel, x);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", columnIndex, type);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getObject( int, Class )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", columnLabel, type);
                }
                throw ResultSetSapDB._getUnsupportedMethodException("getObject( String, Class )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x, targetSqlType);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x, targetSqlType);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x, targetSqlType, scaleOrLength);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x, targetSqlType, scaleOrLength);
                }
                throw ResultSetSapDB._getNotUpdatableException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ConnectionSapDB getConnectionSapDB() {
        return this._connection;
    }

    @Override
    public StatementSapDB getStatementSapDB() {
        return this._statement;
    }

    @Override
    public ResultSetSapDB getResultSetSapDB() {
        return this;
    }

    @Override
    public void assertControllerOpen() throws SQLException {
        if (this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    @Override
    public synchronized Session getSession(boolean avoidOpenSession, boolean handleTransaction) throws SQLException {
        if (handleTransaction) {
            this._connection.handleTransaction(this._session, false);
        }
        return this._session;
    }

    @Override
    public boolean wasNullOrSpecialNull() throws SQLException {
        return this._wasNull();
    }

    @Override
    public boolean wasSpecialNull() throws SQLException {
        return this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL;
    }

    @Override
    public void setNullIndicator(DataFormatDescription.NullIndicator nullIndicator) {
        this._nullIndicator = nullIndicator;
    }

    public String toString() {
        String s = super.toString();
        return this._isClosed.get() ? s + "[closed]" : s;
    }

    public synchronized long getServerProcessingTime() {
        return this._serverProcessingTime;
    }

    protected synchronized void _setFromMetaData(boolean isFromMetaData) {
        this._isFromMetaData = isFromMetaData;
    }

    protected synchronized void _setEmpty(boolean isEmpty) {
        this._isEmpty = isEmpty;
    }

    protected synchronized Object _getExecutingObject() {
        return this._isClosed() ? null : this._fetchInfo;
    }

    protected boolean _next() throws SQLException {
        boolean result;
        if (this._isEmpty) {
            this._positionState = Position.AFTER_LAST;
            return false;
        }
        this._closeOpenInputStreamsAndReaders();
        switch (this._positionState) {
            case BEFORE_FIRST: {
                if (this._positionStateOfChunk == Position.INSIDE && this._currentChunk.getChunkRowCount() > 0) {
                    this._positionState = Position.INSIDE;
                    result = true;
                    break;
                }
                result = this._fetchFirstChunk(this.getSession(false, true));
                break;
            }
            case INSIDE: {
                if (this._currentChunk.nextRow()) {
                    result = true;
                    break;
                }
                if (this._currentChunk.isLastChunk()) {
                    this._positionState = Position.AFTER_LAST;
                    result = false;
                    break;
                }
                result = this._fetchNextChunk(this.getSession(false, true));
                break;
            }
            case AFTER_LAST: 
            case NOT_AVAILABLE: {
                result = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected position state: " + (Object)((Object)this._positionState)));
            }
        }
        return result;
    }

    protected synchronized String _getString(int columnIndex) throws SQLException {
        AbstractTranslator translator = this._getTranslator(columnIndex);
        return translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _close() throws SQLException {
        if (this._isClosed()) {
            return;
        }
        try {
            ResultSetSapDB resultSetSapDB = this;
            synchronized (resultSetSapDB) {
                StatementSapDB statementSapDB = this._statement;
                synchronized (statementSapDB) {
                    ConnectionSapDB connectionSapDB = this._connection;
                    synchronized (connectionSapDB) {
                        if (this._isClosed.get()) return;
                        if (this._statement._isClosed()) return;
                        if (this._connection._isClosed()) {
                            return;
                        }
                        this._close(this.getSession(false, true));
                        this._isClosed.set(true);
                    }
                    if (!this._isFromMetaData) return;
                    this._statement._close();
                    return;
                }
            }
        }
        finally {
            this._statement.removeResultSet(this);
        }
    }

    private static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "ResultSet");
    }

    private static SQLException _getForwardOnlyException() {
        return SQLExceptionSapDB.newInstance("error.resultset.forwardonly", new String[0]);
    }

    private static SQLException _getNotUpdatableException() throws SQLException {
        return SQLExceptionSapDB.newInstance("error.resultset.notupdatable", new String[0]);
    }

    private void _checkLocks() {
        if (this._statement instanceof InternalStatementSapDB) {
            return;
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        if (Thread.holdsLock(this._statement)) {
            // empty if block
        }
        if (Thread.holdsLock(this._statement.getConnectionSapDB())) {
            // empty if block
        }
    }

    private boolean _wasNull() throws SQLException {
        return this._connection.emptyTimestampIsNull() ? this._nullIndicator == DataFormatDescription.NullIndicator.NULL || this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL : this._nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    private TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this._connection, this._statement, this, "ResultSet", methodName);
    }

    private void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    private void _assertOpen() throws SQLException {
        if (this._isClosed() || this._statement._isClosed() || this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
        if (this._rollbackCount < this._connection._getRollbackCount()) {
            this._cleanResult();
            throw SQLExceptionSapDB.newInstance("error.objectisclosedduetorollback", this.toString());
        }
    }

    private void _cleanResult() {
        this._closeOpenInputStreamsAndReaders();
        this._cursorType = 0;
        this._isClosed.set(true);
    }

    private void _closeOpenInputStreamsAndReaders() {
        for (InputStream inputStream : this._openInputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this._openInputStreams.clear();
        for (Reader reader : this._openReaders) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        this._openReaders.clear();
    }

    private AbstractTranslator _getTranslator(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._fetchInfo.getResultSetColumnCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalidcolumnindex", String.valueOf(columnIndex));
        }
        return this._fetchInfo.getResultSetTranslator(columnIndex);
    }

    private AbstractTranslator _getTranslator(String columnLabel) throws SQLException {
        AbstractTranslator translator = this._fetchInfo.getResultSetTranslator(columnLabel);
        if (translator == null) {
            throw SQLExceptionSapDB.newInstance("error.invalidcolumnindex", columnLabel);
        }
        return translator;
    }

    private HDataPart _getDataPart(int outputFieldPos) throws SQLException {
        if (this._positionState == Position.BEFORE_FIRST) {
            throw SQLExceptionSapDB.newInstance("error.resultset.beforefirst", new String[0]);
        }
        if (this._positionState == Position.AFTER_LAST) {
            throw SQLExceptionSapDB.newInstance("error.resultset.afterlast", new String[0]);
        }
        HDataPart dataPart = this._currentChunk.getDataPart();
        dataPart.moveToField(outputFieldPos);
        return dataPart;
    }

    private boolean _isBeforeFirst() throws SQLException {
        return !this._isEmpty && this._positionState == Position.BEFORE_FIRST;
    }

    private boolean _isAfterLast() throws SQLException {
        return !this._isEmpty && this._positionState == Position.AFTER_LAST;
    }

    private boolean _isFirst() throws SQLException {
        return this._currentChunk != null && !this._isEmpty && this._positionState == Position.INSIDE && this._currentChunk.isFirstChunk() && this._currentChunk.isCurrentRowFirstOfChunk();
    }

    private boolean _isLast() throws SQLException {
        return this._currentChunk != null && !this._isEmpty && this._positionState == Position.INSIDE && this._currentChunk.isLastChunk() && this._currentChunk.isCurrentRowLastOfChunk();
    }

    private int _getRow() throws SQLException {
        if (this._positionState != Position.INSIDE) {
            return 0;
        }
        return this._currentChunk != null ? this._currentChunk.getCurrentRowIndex() : 0;
    }

    private boolean _fetchFirstChunk(Session session) throws SQLException {
        HDataPart dataPart;
        int usedFetchSize = this._getUsedFetchSize();
        if (this._maxRows > 0) {
            usedFetchSize = Math.min(usedFetchSize, this._maxRows);
        }
        if ((dataPart = this._executeFetchNext(usedFetchSize, session)).getRecordCount() == 0) {
            this._isEmpty = true;
            this._positionState = Position.AFTER_LAST;
            this._positionStateOfChunk = Position.NOT_AVAILABLE;
            this._currentChunk = null;
            this._isResultSetClosedOnServer = dataPart.isResultSetClosedOnServer();
            return false;
        }
        this._setCurrentChunk(dataPart, 1);
        return true;
    }

    private boolean _fetchNextChunk(Session session) throws SQLException {
        HDataPart dataPart;
        int usedFetchSize = this._getUsedFetchSize();
        if (this._maxRows > 0) {
            usedFetchSize = Math.min(this._maxRows - this._currentChunk.getLastRowIndex() + 1, usedFetchSize);
        }
        if ((dataPart = this._executeFetchNext(usedFetchSize, session)).getRecordCount() == 0) {
            this._positionState = Position.AFTER_LAST;
            this._positionStateOfChunk = Position.NOT_AVAILABLE;
            this._currentChunk = null;
            this._isResultSetClosedOnServer = dataPart.isResultSetClosedOnServer();
            return false;
        }
        this._setCurrentChunk(dataPart, this._currentChunk.getLastRowIndex() + 1);
        return true;
    }

    private HDataPart _executeFetchNext(int fetchSize, Session session) throws SQLException {
        HDataPart resultSetPart;
        this._assertOpen();
        if (fetchSize < 1) {
            fetchSize = 1;
        }
        HRequestPacket requestPacket = this._connection.getRequestPacket(session);
        requestPacket.initFetchNext(this._connection, session, this._fetchInfo.getCursorID(), fetchSize);
        HReplyPacket replyPacket = this._connection.execute(this, session, requestPacket, new ConnectionSapDB.ExecuteFlag[0]);
        long processingTime = replyPacket.findServerExecutionTime(0);
        if (this._serverProcessingTime != -1L) {
            this._serverProcessingTime = processingTime < 0L ? processingTime : (this._serverProcessingTime += processingTime);
        }
        if ((resultSetPart = replyPacket.findResultSetPart(0)) == null) {
            throw SQLExceptionSapDB.newInstance("error.packet.fetchnodatapart", new String[0]);
        }
        resultSetPart.setDataFormatDescription(this._fetchInfo);
        return resultSetPart;
    }

    private void _setCurrentChunk(HDataPart dataPart, int firstRowIndex) throws SQLException {
        this._currentChunk = new FetchChunk(dataPart, firstRowIndex, this._maxRows);
        this._positionState = this._positionStateOfChunk = Position.INSIDE;
        this._isResultSetClosedOnServer = dataPart.isResultSetClosedOnServer();
    }

    private int _getUsedFetchSize() {
        if (this._fetchSize <= 0) {
            return 32766;
        }
        if (this._fetchSize > 32766) {
            return 32766;
        }
        return this._fetchSize;
    }

    private void _close(Session session) throws SQLException {
        if (this._cursorType != 0 && !this._isResultSetClosedOnServer) {
            this._connection._dropCursor(session, this._fetchInfo.getCursorID());
            this._isResultSetClosedOnServer = true;
        } else if (this._cursorType != 0 && (this._cursorType != 2 || this._currentChunk != null && !this._currentChunk.getDataPart().isLastPacket())) {
            this._connection._dropCursor(session, this._fetchInfo.getCursorID());
        }
        this._cleanResult();
    }

    private static enum Position {
        BEFORE_FIRST,
        INSIDE,
        AFTER_LAST,
        NOT_AVAILABLE;

    }
}

