/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class ParseInfo
implements DataFormatDescription {
    private final String _sql;
    private final FunctionCode _functionCode;
    private final boolean _isSelect;
    private final boolean _isProcedure;
    private Map<Session, ParseID> _parseIDs;
    private List<AbstractTranslator> _parameterTranslators;
    private Map<String, AbstractTranslator> _parameterTranslatorMap;
    private int _inputParameterCount;
    private List<DataType> _outputDataTypes;
    private boolean _hasLOBs;
    private List<AbstractTranslator> _resultSetTranslators;
    private HashPartitionInfo _hashPartitionInfo;
    private RangePartitionInfo _rangePartitionInfo;

    public ParseInfo(String sql, FunctionCode functionCode) throws SQLException {
        this._sql = sql;
        this._functionCode = functionCode;
        switch (functionCode) {
            case Select: 
            case SelectForUpdate: {
                this._isSelect = true;
                this._isProcedure = false;
                break;
            }
            case DBProcedureCall: {
                this._isSelect = false;
                this._isProcedure = true;
                break;
            }
            case DBProcedureCallWithResultSet: {
                this._isSelect = true;
                this._isProcedure = true;
                break;
            }
            default: {
                this._isSelect = false;
                this._isProcedure = false;
            }
        }
        this._parseIDs = new WeakHashMap<Session, ParseID>();
        this._parameterTranslators = new ArrayList<AbstractTranslator>();
        this._parameterTranslatorMap = new TreeMap<String, AbstractTranslator>(String.CASE_INSENSITIVE_ORDER);
        this._inputParameterCount = 0;
        this._outputDataTypes = new ArrayList<DataType>();
        this._hasLOBs = false;
        this._resultSetTranslators = new ArrayList<AbstractTranslator>();
    }

    @Override
    public int getOutputFieldCount() {
        return this._outputDataTypes.size();
    }

    @Override
    public DataType getOutputFieldDataType(int outputFieldPos) {
        return this._outputDataTypes.get(outputFieldPos - 1);
    }

    @Override
    public int getResultSetColumnCount() {
        return this._resultSetTranslators.size();
    }

    @Override
    public AbstractTranslator getResultSetTranslator(int index) {
        return this._resultSetTranslators.get(index - 1);
    }

    public String getSQL() {
        return this._sql;
    }

    public FunctionCode getFunctionCode() {
        return this._functionCode;
    }

    public boolean isSelect() {
        return this._isSelect;
    }

    public boolean isProcedure() {
        return this._isProcedure;
    }

    public Map<Session, ParseID> getParseIDs() {
        return Collections.unmodifiableMap(this._parseIDs);
    }

    public ParseID getParseID(Session session) {
        return this._parseIDs.get(session);
    }

    public void addParseID(Session session, ParseID parseID) {
        this._parseIDs.put(session, parseID);
    }

    public void removeParseID(Session session) {
        this._parseIDs.remove(session);
    }

    public List<AbstractTranslator> getParameterTranslators() {
        return Collections.unmodifiableList(this._parameterTranslators);
    }

    public AbstractTranslator getParameterTranslator(int index) {
        return this._parameterTranslators.get(index - 1);
    }

    public AbstractTranslator getParameterTranslator(String parameterName) {
        return this._parameterTranslatorMap.get(parameterName);
    }

    public int getParameterCount() {
        return this._parameterTranslators.size();
    }

    public int getInputParameterCount() {
        return this._inputParameterCount;
    }

    public boolean hasLOBs() {
        return this._hasLOBs;
    }

    public void setParameterInfo(List<AbstractTranslator> parameterTranslators, int inputParameterCount, List<DataType> outputDataTypes, boolean hasLOBs) {
        this._parameterTranslators = parameterTranslators;
        this._inputParameterCount = inputParameterCount;
        this._outputDataTypes = outputDataTypes;
        this._hasLOBs |= hasLOBs;
        this._parameterTranslatorMap.clear();
        for (AbstractTranslator translator : parameterTranslators) {
            String parameterName = translator.getColumnLabel();
            if (this._parameterTranslatorMap.containsKey(parameterName)) continue;
            this._parameterTranslatorMap.put(parameterName, translator);
        }
    }

    public List<AbstractTranslator> getResultSetTranslators() {
        return this._resultSetTranslators;
    }

    public void setResultSetTranslators(List<AbstractTranslator> resultSetTranslators) {
        this._resultSetTranslators = resultSetTranslators;
        for (AbstractTranslator translator : this._resultSetTranslators) {
            this._hasLOBs |= translator.isLOB();
        }
    }

    public boolean isHashPartitioned() {
        return this._hashPartitionInfo != null;
    }

    public HashPartitionInfo getHashPartitionInfo() {
        return this._hashPartitionInfo;
    }

    public void setHashPartitionInfo(HashPartitionInfo hashPartitionInfo) {
        this._hashPartitionInfo = hashPartitionInfo;
    }

    public boolean isRangePartitioned() {
        return this._rangePartitionInfo != null;
    }

    public RangePartitionInfo getRangePartitionInfo() {
        return this._rangePartitionInfo;
    }

    public void setRangePartitionInfo(RangePartitionInfo rangePartitionInfo) {
        this._rangePartitionInfo = rangePartitionInfo;
    }
}

