/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbc.translators.AbstractTranslator;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;

class ParameterMetaDataSapDB
extends WrapperDummy
implements ParameterMetaData {
    private final Tracer _tracer;
    private final List<AbstractTranslator> _translators;

    protected ParameterMetaDataSapDB(Tracer tracer, List<AbstractTranslator> translators) {
        this._tracer = tracer;
        this._translators = translators;
    }

    @Override
    public int getParameterCount() throws SQLException {
        boolean on = this._tracer.on();
        if (on) {
            this._tracer.printCall(this, "getParameterCount", new Object[0]);
        }
        int result = this._translators.size();
        if (on) {
            this._tracer.printResult(result);
        }
        return result;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isNullable", param);
            }
            int result = this._getTranslator(param).isNullable();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isSigned", param);
            }
            boolean result = this._getTranslator(param).isSigned();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getPrecision", param);
            }
            int result = this._getTranslator(param).getPrecision();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getScale(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getScale", param);
            }
            int result = this._getTranslator(param).getScale();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterType", param);
            }
            int result = this._getTranslator(param).getColumnType();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterTypeName", param);
            }
            String result = this._getTranslator(param).getColumnTypeName();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterClassName", param);
            }
            String result = this._getTranslator(param).getColumnClassName();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterMode", param);
            }
            int result = this._getTranslator(param).getParameterMode().getValue();
            if (on) {
                this._tracer.printResult(result);
            }
            return result;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    private AbstractTranslator _getTranslator(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this._translators.size()) {
            throw SQLExceptionSapDB.newInstance("error.invalidcolumnindex", String.valueOf(parameterIndex));
        }
        return this._translators.get(parameterIndex - 1);
    }
}

