/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.trace.Tracer;
import java.util.Properties;

public class LatencySession
extends Session {
    private static final int DEFAULT_LATENCY = 0;
    private final int _latency;

    protected LatencySession(Location location, Properties properties, Tracer tracer) throws RTEException {
        super(location, properties, tracer);
        this._latency = this.getIntProperty(properties, "latency", 0);
    }

    @Override
    public HReplyPacket _receive() throws RTEException {
        this._createLatency();
        return super._receive();
    }

    private synchronized void _createLatency() {
        try {
            Thread.sleep(this._latency);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

