/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.Iterator;

class InternalStatementSapDB
extends StatementSapDB {
    InternalStatementSapDB(ConnectionSapDB connection, boolean createInternalResultSets) throws SQLException {
        super(Tracer.DUMMY, connection, 1003, 1007, 1, createInternalResultSets);
    }

    @Override
    HReplyPacket sendCommand(HRequestPacket requestPacket, String sql, boolean parseAgain, Session session) throws SQLException {
        requestPacket.initExecuteDirect(this._connection, session, this._resultSetHoldability, this._queryTimeout, sql, null, -1);
        HReplyPacket replyPacket = this._connection.execute(this, session, requestPacket, ConnectionSapDB.ExecuteFlag.IS_STATEMENT, ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    protected int _executeUpdateOnAllSessions(String sql) throws SQLException {
        SessionPool sessionPool = this._connection.getSessionPool();
        Session primarySession = sessionPool.getPrimarySession();
        boolean isQuery = false;
        this._Session = primarySession;
        this._connection.handleTransaction(this._Session, false);
        if (!this._Session.isHintRouted()) {
            isQuery = this._execute(sql, this._Session);
        }
        Iterator<Session> iterator = sessionPool.getSessions().values().iterator();
        while (iterator.hasNext()) {
            Session session;
            this._Session = session = iterator.next();
            if (this._Session == primarySession || !this._Session._isConnected() || this._Session.isHintRouted()) continue;
            this._connection.handleTransaction(this._Session, false);
            isQuery = this._execute(sql, this._Session);
        }
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        return this._hasRowCount ? this._rowsAffected : 0;
    }
}

