/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.ServiceType;
import com.sap.db.jdbc.packet.TopologyInformationOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.UniqueID;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class HanaSystem {
    private final String _sidAndDatabaseName;
    private final String _sid;
    private final String _databaseName;
    private final Map<Host, Location> _locations;
    private final Map<Host, Host> _alternativeHostnames;
    private final UniqueID _nextlocation;

    static HanaSystem newInstance(String sidAndDatabaseName) {
        return new HanaSystem(sidAndDatabaseName);
    }

    private HanaSystem(String sidAndDatabaseName) {
        this._sidAndDatabaseName = sidAndDatabaseName;
        if (sidAndDatabaseName == null || sidAndDatabaseName.length() <= 3) {
            this._sid = sidAndDatabaseName;
            this._databaseName = "";
        } else {
            this._sid = sidAndDatabaseName.substring(0, 3);
            this._databaseName = sidAndDatabaseName.substring(3);
        }
        this._locations = new HashMap<Host, Location>();
        this._alternativeHostnames = new HashMap<Host, Host>();
        this._nextlocation = new UniqueID(0L);
    }

    String getSidAndDatabaseName() {
        return this._sidAndDatabaseName;
    }

    String getSid() {
        return this._sid;
    }

    String getDatabaseName() {
        return this._databaseName;
    }

    synchronized Map<Host, Location> getLocations() {
        return Collections.unmodifiableMap(this._locations);
    }

    synchronized int getNumberOfLocations() {
        return this._locations.size();
    }

    synchronized Location getLocation(SiteVolumeID siteVolumeID) {
        for (Location location : this._locations.values()) {
            if (!location.getSiteVolumeID().equals(siteVolumeID)) continue;
            return location;
        }
        return null;
    }

    synchronized Location getLocation(Host host, boolean considerAlternativeLocation) {
        Host alternativeHost;
        Location location = this._locations.get(host);
        if (location == null && considerAlternativeLocation && (alternativeHost = this._alternativeHostnames.get(host)) != null) {
            location = this._locations.get(alternativeHost);
        }
        return location;
    }

    synchronized Location getPrimaryLocation() {
        for (Location location : this._locations.values()) {
            if (!location.isPrimarySite()) continue;
            return location;
        }
        return null;
    }

    synchronized Location getSecondaryLocation() {
        for (Location location : this._locations.values()) {
            if (!location.isSecondarySite()) continue;
            return location;
        }
        return null;
    }

    synchronized Location updateLocations(HMultiLineOptionsPart multiLineOptionsPart) throws SQLException {
        int serviceType = ServiceType.IndexServer.getValue();
        Location ownLocation = null;
        this._locations.clear();
        do {
            String hostName = null;
            int portNumber = 0;
            String tenantName = null;
            double loadFactor = 0.0;
            byte siteID = 0;
            int volumeID = 0;
            boolean isMaster = false;
            boolean isStandby = false;
            boolean isOwn = false;
            int siteType = 0;
            do {
                switch (TopologyInformationOption.decode(multiLineOptionsPart.getOptionName())) {
                    case HostName: {
                        hostName = multiLineOptionsPart.getOptionStringValue();
                        break;
                    }
                    case HostPortNumber: {
                        portNumber = multiLineOptionsPart.getOptionIntValue();
                        break;
                    }
                    case TenantName: {
                        tenantName = multiLineOptionsPart.getOptionStringValue();
                        break;
                    }
                    case LoadFactor: {
                        loadFactor = multiLineOptionsPart.getOptionDoubleValue();
                        break;
                    }
                    case VolumeID: {
                        SiteVolumeID siteVolumeID = new SiteVolumeID(multiLineOptionsPart.getOptionIntValue());
                        siteID = siteVolumeID.getSiteID();
                        volumeID = siteVolumeID.getVolumeID();
                        break;
                    }
                    case IsMaster: {
                        isMaster = multiLineOptionsPart.getOptionBooleanValue();
                        break;
                    }
                    case IsStandby: {
                        isStandby = multiLineOptionsPart.getOptionBooleanValue();
                        break;
                    }
                    case IsCurrentSession: {
                        isOwn = multiLineOptionsPart.getOptionBooleanValue();
                        break;
                    }
                    case ServiceType: {
                        serviceType = multiLineOptionsPart.getOptionIntValue();
                        break;
                    }
                    case SiteType: {
                        siteType = multiLineOptionsPart.getOptionIntValue();
                        break;
                    }
                }
            } while (multiLineOptionsPart.nextOption());
            if (siteType < 0 || siteType > 3) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Site type");
            }
            if (siteID <= -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Site ID");
            }
            if (volumeID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Volume ID");
            }
            if (portNumber == 0) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Port number");
            }
            if (hostName == null) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Host name");
            }
            Host host = new Host(hostName, portNumber);
            Location location = this.addLocation(siteID, volumeID, host, tenantName, Location.SiteType.decode(siteType), isMaster, isStandby, serviceType, loadFactor);
            if (!isOwn) continue;
            ownLocation = location;
        } while (multiLineOptionsPart.nextLine());
        return ownLocation;
    }

    synchronized Location addLocation(byte siteID, int volumeID, Host host, String tenantName, Location.SiteType siteType, boolean isMaster, boolean isStandby, int serviceType, double Loadfactor) {
        Location location = new Location(siteID, volumeID, host, tenantName, siteType, isMaster, isStandby, serviceType, Loadfactor, this);
        this._locations.put(host, location);
        return location;
    }

    synchronized void clearLocations() {
        this._locations.clear();
        this._alternativeHostnames.clear();
    }

    synchronized void getLocationsList(List<Location> locationList, boolean connectionRoutingEnabled, Location.SiteType siteType) throws SQLException {
        boolean isStatisticServerConnect = false;
        ArrayList<Location> clearedLocation = new ArrayList<Location>();
        if (connectionRoutingEnabled) {
            clearedLocation.addAll(locationList);
            locationList.clear();
        }
        for (Location loc : this._locations.values()) {
            boolean isInList = false;
            for (int i = 0; i < locationList.size(); ++i) {
                Location location = locationList.get(i);
                if (!loc.getHost().equals(location.getHost()) && !loc.isSameTarget(location)) continue;
                locationList.set(i, loc);
                isInList = true;
                if (!loc.isStatisticServer()) break;
                isStatisticServerConnect = true;
                break;
            }
            if (isInList || !connectionRoutingEnabled && !loc.isMaster() && !loc.isStandby() || !loc.isIndexServer() && !loc.isNameServer() || siteType != Location.SiteType.NONE && siteType != loc.getSiteType()) continue;
            locationList.add(loc);
        }
        if (siteType != Location.SiteType.NONE) {
            ArrayList<Location> tempLocationList = new ArrayList<Location>(locationList);
            for (Location eachLocation : tempLocationList) {
                if (eachLocation.isInitial() || eachLocation.getSiteType() == siteType) continue;
                locationList.remove(eachLocation);
            }
        }
        if (connectionRoutingEnabled && clearedLocation.size() > 0 && locationList.size() == 0) {
            locationList.addAll(clearedLocation);
        }
        if (connectionRoutingEnabled && !isStatisticServerConnect && locationList.size() > 1) {
            long pos = this._nextlocation.getNextID() % (long)locationList.size();
            int var = 0;
            while ((long)var < pos) {
                locationList.add(locationList.remove(0));
                ++var;
            }
        }
    }

    synchronized void addAlternativeHostPort(Host hostPortFromURL, Host hostPortFromTopologyPart) {
        if (!hostPortFromURL.equals(hostPortFromTopologyPart)) {
            this._alternativeHostnames.put(hostPortFromURL, hostPortFromTopologyPart);
        }
    }

    Session getSession(SiteVolumeID siteVolumeID, Properties info, Tracer tracer) throws RTEException {
        Location location = this.getLocation(siteVolumeID);
        if (location == null) {
            return null;
        }
        try {
            return Driver.getCommunicationFactory(info, tracer).open(location, info, tracer, true);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.library.notloaded", "jniAuthentication", e.toString()), RteReturnCode.SQLNOTOK, -10899);
        }
    }

    void incrementNextLocationPointer() {
        this._nextlocation.getNextID();
    }
}

