/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FetchInfo
implements DataFormatDescription {
    private final CursorID _cursorID;
    private final List<AbstractTranslator> _translators;
    private final Map<String, AbstractTranslator> _translatorMap;

    public FetchInfo(CursorID cursorID, List<AbstractTranslator> translators) {
        this._cursorID = cursorID;
        this._translators = translators;
        this._translatorMap = new TreeMap<String, AbstractTranslator>(String.CASE_INSENSITIVE_ORDER);
        for (AbstractTranslator translator : this._translators) {
            String columnLabel = translator.getColumnLabel();
            if (columnLabel == null || this._translatorMap.containsKey(columnLabel)) continue;
            this._translatorMap.put(columnLabel, translator);
        }
        for (AbstractTranslator translator : this._translators) {
            String columnName = translator.getColumnName();
            if (columnName == null || this._translatorMap.containsKey(columnName)) continue;
            this._translatorMap.put(columnName, translator);
        }
    }

    @Override
    public int getOutputFieldCount() {
        return this._translators.size();
    }

    @Override
    public DataType getOutputFieldDataType(int outputFieldPos) {
        return this._translators.get(outputFieldPos - 1).getDataType();
    }

    @Override
    public int getResultSetColumnCount() {
        return this._translators.size();
    }

    @Override
    public AbstractTranslator getResultSetTranslator(int columnIndex) {
        return this._translators.get(columnIndex - 1);
    }

    public CursorID getCursorID() {
        return this._cursorID;
    }

    public final AbstractTranslator getResultSetTranslator(String columnLabelOrName) throws SQLException {
        return this._translatorMap.get(columnLabelOrName);
    }
}

