/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.packet.HDataPart;
import java.sql.SQLException;

class FetchChunk {
    private final HDataPart _dataPart;
    private final int _firstRowIndex;
    private final int _lastRowIndex;
    private final int _chunkRowCount;
    private final boolean _isFirstChunk;
    private final boolean _isLastChunk;
    private int _currentOffset;

    FetchChunk(HDataPart dataPart, int firstRowIndex, int maxRows) throws SQLException {
        this._dataPart = dataPart;
        this._firstRowIndex = firstRowIndex;
        this._isFirstChunk = firstRowIndex == 1;
        int chunkRowCount = this._dataPart.getRecordCount();
        int lastRowIndex = firstRowIndex + chunkRowCount - 1;
        if (maxRows > 0 && lastRowIndex >= maxRows) {
            this._lastRowIndex = maxRows;
            this._chunkRowCount = maxRows - firstRowIndex + 1;
            this._isLastChunk = true;
        } else {
            this._lastRowIndex = lastRowIndex;
            this._chunkRowCount = chunkRowCount;
            this._isLastChunk = this._dataPart.isLastPacket();
        }
    }

    HDataPart getDataPart() {
        return this._dataPart;
    }

    int getFirstRowIndex() {
        return this._firstRowIndex;
    }

    int getLastRowIndex() {
        return this._lastRowIndex;
    }

    public int getChunkRowCount() {
        return this._chunkRowCount;
    }

    boolean isFirstChunk() {
        return this._isFirstChunk;
    }

    boolean isLastChunk() {
        return this._isLastChunk;
    }

    int getCurrentRowIndex() {
        return this._firstRowIndex + this._currentOffset;
    }

    boolean isCurrentRowFirstOfChunk() {
        return this._currentOffset == 0;
    }

    boolean isCurrentRowLastOfChunk() {
        return this._currentOffset == this._chunkRowCount - 1;
    }

    boolean nextRow() throws SQLException {
        if (this._currentOffset == Integer.MAX_VALUE || this._currentOffset + 1 >= this._chunkRowCount) {
            return false;
        }
        ++this._currentOffset;
        this._dataPart.nextRecord();
        return true;
    }
}

