/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.CallableStatementSapDB;
import com.sap.db.jdbc.CallableStatementSapDBFinalize;
import com.sap.db.jdbc.ClientInfo;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.DatabaseMetaDataSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaSystem;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.SessionVariables;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.StatementSapDBFinalize;
import com.sap.db.jdbc.Topology;
import com.sap.db.jdbc.Transaction;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.ConnectionException;
import com.sap.db.jdbc.exceptions.InternalFallbackHintRoutedException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.packet.TransactionFlag;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.XAExceptionSAP;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.util.BackOffTimer;
import com.sap.db.util.StringUtils;
import com.sap.db.util.UniqueID;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AuthenticationManager;
import com.sap.db.util.security.NativeAuthenticationManagerImpl;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class ConnectionSapDB
extends WrapperDummy
implements java.sql.Connection {
    private static final String CURSOR_PREFIX = "JDBC_CURSOR_";
    private final TraceControl _traceControl;
    private final Tracer _tracer;
    private final SessionPool _sessionPool;
    private final Deque<HRequestPacket> _packetPool;
    private final SessionVariables _sessionVariables;
    private final ClientInfo _clientInfo;
    private final Transaction _transaction;
    private final UniqueID _uniqueID;
    private final Properties _connectProperties;
    private final Properties _connectPropertiesForCancel;
    private final List<Host> _preferredHosts;
    private final boolean _emptyTimestampIsNull;
    private final AtomicBoolean _isClosed;
    private final AtomicInteger _sentBytes;
    private final AtomicInteger _receivedBytes;
    private final String _defaultSchema;
    private DatabaseMetaDataSapDB _databaseMetaData;
    private SQLWarning _warnings;
    private Map<String, Class<?>> _typeMap;
    private int _resultSetHoldability;
    private boolean _isDDLCommitted;
    private DistributionMode _distributionMode;
    private boolean _isReadOnly;
    private int _isolationLevel;
    private String _currentSchema;
    private AbstractAuthenticationManager _authenticationManager;
    private EngineFeatures _engineFeatures;
    private byte[] _statementContext;
    private int _rollbackCount;
    private byte[] _cookie;
    private Subject _authenticatedSubject;
    private boolean _isInReconnect;
    private BackOffTimer _backOffTimer;
    private Object _executingObject;
    private final Object _lockExecutingObject = new Object();
    private final Set<StatementSapDB> _statements = Collections.newSetFromMap(new WeakHashMap());

    public static ConnectionSapDB getConnectionSapDB(java.sql.Connection connection) {
        java.sql.Connection c = connection;
        while (!(c instanceof ConnectionSapDB)) {
            if (c instanceof Connection) {
                c = ((Connection)c).getPhysicalConnection();
                continue;
            }
            return null;
        }
        return (ConnectionSapDB)c;
    }

    public static int getJdbcIsolationLevelForHanaIsolationLevel(int hanaIsolationLevel) throws SQLException {
        switch (hanaIsolationLevel) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", String.valueOf(hanaIsolationLevel));
    }

    public static String getSQLForJdbcIsolationLevel(int jdbcIsolationLevel) throws SQLException {
        switch (jdbcIsolationLevel) {
            case 0: 
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 2: {
                return "READ COMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", String.valueOf(jdbcIsolationLevel));
    }

    protected ConnectionSapDB(Session session, Properties info, List<Host> preferredHosts, TraceControl traceControl) throws SQLException {
        this._traceControl = traceControl;
        this._tracer = this._traceControl.getTracer();
        this._sessionPool = new SessionPool(this._tracer);
        this._packetPool = new ArrayDeque<HRequestPacket>();
        this._sessionVariables = new SessionVariables();
        this._clientInfo = new ClientInfo();
        this._transaction = new Transaction(this._sessionPool, this._tracer);
        this._uniqueID = new UniqueID();
        this._connectProperties = (Properties)info.clone();
        this._connectPropertiesForCancel = (Properties)info.clone();
        this._preferredHosts = preferredHosts != null && !preferredHosts.isEmpty() ? Collections.unmodifiableList(preferredHosts) : Collections.emptyList();
        this._emptyTimestampIsNull = this.getBooleanConnectProperty("emptyTimestampIsNull", true);
        this._isClosed = new AtomicBoolean();
        this._sentBytes = new AtomicInteger();
        this._receivedBytes = new AtomicInteger();
        this._typeMap = new TreeMap();
        this._resultSetHoldability = 1;
        this._isDDLCommitted = true;
        this._distributionMode = this.getConnectProperty("ignoreTopology", "false").trim().equals("1") ? DistributionMode.Off : DistributionMode.decode(this._connectProperties.getProperty("distribution", "STATEMENT"));
        this._transaction.setAutoCommit(this.getBooleanConnectProperty("autoCommit", true));
        this._isReadOnly = this.getBooleanConnectProperty("readOnly", false);
        this._isolationLevel = ConnectionSapDB._getJdbcIsolationLevelForConnectionPropertyValue(this.getConnectProperty("isolation"));
        this._currentSchema = this.getConnectProperty("currentSchema");
        try {
            this._getNewConnection(session, false);
        }
        catch (SQLException e) {
            if (this._tracer.on()) {
                this._tracer.printThrowable(e, null);
            }
            throw e;
        }
        this._defaultSchema = this._databaseMetaData._getUserName();
        if (this._currentSchema == null || this._currentSchema.isEmpty()) {
            this._currentSchema = this._defaultSchema;
        }
        this._packetPool.clear();
        Driver._addConnection(this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "createStatement", new Object[0]);
            }
            Statement result = this._createStatement(1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql);
            }
            PreparedStatement result = this._prepareStatement(sql, 1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql);
            }
            CallableStatement result = this._prepareCall(sql, 1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nativeSQL") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nativeSQL", sql);
            }
            String result = sql;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getAutoCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getAutoCommit", new Object[0]);
            }
            boolean result = this._getAutoCommit();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setAutoCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAutoCommit", autoCommit);
            }
            this._setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("commit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "commit", new Object[0]);
            }
            ConnectionSapDB connectionSapDB = this;
            synchronized (connectionSapDB) {
                this._commit();
            }
            this._closeCursorsAtCommit();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rollback") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "rollback", new Object[0]);
            }
            this._rollback();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isClosed") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            boolean result = this._isClosed();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            this._close();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            this._assertOpen();
            DatabaseMetaDataSapDB result = this._databaseMetaData;
            if (on) {
                this._tracer.printResult(result);
            }
            DatabaseMetaDataSapDB databaseMetaDataSapDB = result;
            return databaseMetaDataSapDB;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isReadOnly") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isReadOnly", new Object[0]);
            }
            this._assertOpen();
            boolean result = this._isReadOnly;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setReadOnly(boolean isReadOnly) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setReadOnly") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setReadOnly", isReadOnly);
            }
            this._setReadOnly(isReadOnly);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getCatalog() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCatalog") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCatalog", new Object[0]);
            }
            this._assertOpen();
            String result = null;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setCatalog") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCatalog", catalog);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTransactionIsolation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTransactionIsolation", new Object[0]);
            }
            int result = this._getTransactionIsolation();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setTransactionIsolation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTransactionIsolation", level);
            }
            this._setTransactionIsolation(level, true);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            SQLWarning result = this._warnings;
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
            this._warnings = null;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "createStatement", resultSetType, resultSetConcurrency);
            }
            Statement result = this._createStatement(resultSetType, resultSetConcurrency, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, resultSetType, resultSetConcurrency);
            }
            PreparedStatement result = this._prepareStatement(sql, resultSetType, resultSetConcurrency, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql, resultSetType, resultSetConcurrency);
            }
            CallableStatement result = this._prepareCall(sql, resultSetType, resultSetConcurrency, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTypeMap") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTypeMap", new Object[0]);
            }
            Map<String, Class<?>> result = Collections.unmodifiableMap(this._typeMap);
            if (on) {
                this._tracer.printResult(result);
            }
            Map<String, Class<?>> map = result;
            return map;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setTypeMap") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTypeMap", typeMap);
            }
            this._assertOpen();
            this._typeMap = typeMap != null ? new TreeMap(typeMap) : new TreeMap();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "createStatement", resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            Statement result = this._createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            if (on) {
                this._tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            PreparedStatement result = this._prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            CallableStatement result = this._prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, autoGeneratedKeys);
            }
            if (autoGeneratedKeys != 2) {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "autoGeneratedKeys", "NO_GENERATED_KEYS");
            }
            PreparedStatement result = this._prepareStatement(sql, 1003, 1007, this._getHoldability());
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "prepareStatement", sql, columnIndexes);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("prepareStatement( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "prepareStatement", sql, columnNames);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("prepareStatement( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getHoldability", new Object[0]);
            }
            int result = this._getHoldability();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setHoldability", holdability);
            }
            this._assertOpen();
            this._resultSetHoldability = holdability;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setSavepoint") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSavepoint", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("setSavepoint()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setSavepoint") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSavepoint", name);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("setSavepoint( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("rollback") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "rollback", savepoint);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("rollback( Savepoint )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("releaseSavepoint") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "releaseSavepoint", savepoint);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("releaseSavepoint( Savepoint )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Clob createClob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createClob", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createClob()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Blob createBlob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createBlob", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createBlob()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized NClob createNClob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createNClob", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createNClob()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SQLXML createSQLXML() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createSQLXML", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createSQLXML()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isValid") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isValid", timeout);
            }
            boolean result = this._isValid(timeout);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getClientInfo() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClientInfo", new Object[0]);
            }
            Properties result = this._getClientInfo();
            if (on) {
                this._tracer.printResult(result);
            }
            Properties properties = result;
            return properties;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getClientInfo(String key) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClientInfo", key);
            }
            String result = this._getClientInfo(key);
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClientInfo", properties);
            }
            this._setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClientInfo(String key, String value) throws SQLClientInfoException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClientInfo", key, value);
            }
            this._setClientInfo(key, value);
        }
        catch (SQLClientInfoException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createArrayOf") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createArrayOf", typeName, elements);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createArrayOf( String, Object[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("createStruct") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createStruct", typeName, attributes);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("createStruct( String, Object[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSchema") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSchema", new Object[0]);
            }
            String result = this._getCurrentSchema();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setSchema(String schema) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setSchema") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setSchema", schema);
            }
            this._setCurrentSchema(schema);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void abort(Executor executor) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("abort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "abort", executor);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("abort( Executor )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int getNetworkTimeout() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNetworkTimeout") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getNetworkTimeout", new Object[0]);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("getNetworkTimeout()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("setNetworkTimeout") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setNetworkTimeout", executor, milliseconds);
                }
                throw ConnectionSapDB._getUnsupportedMethodException("setNetworkTimeout( Executor, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    public String toString() {
        String s = super.toString();
        return this._isClosed.get() ? s + "[closed]" : s + "[ID " + this.getAnchorConnectionID() + "]";
    }

    public synchronized void reinitialize(boolean toFactorySettings, boolean factoryAutoCommitSetting) throws SQLException {
        if (toFactorySettings) {
            this._closeStatements();
            this._transaction.setAutoCommit(factoryAutoCommitSetting);
            this._setReadOnly(false);
            this._setTransactionIsolation(2, true);
            this._setCurrentSchema(this._defaultSchema);
            this._typeMap.clear();
            this._resultSetHoldability = 1;
            this._setClientInfo(null);
        }
    }

    public int getSentBytes() {
        return this._sentBytes.get();
    }

    public int getReceivedBytes() {
        return this._receivedBytes.get();
    }

    public Tracer getTracer() {
        return this._tracer;
    }

    public SessionPool getSessionPool() {
        return this._sessionPool;
    }

    public long getAnchorConnectionID() {
        return Driver.getAnchorConnectionID(this);
    }

    public long getPrimaryConnectionID() {
        return Driver.getPrimaryConnectionID(this);
    }

    public synchronized HRequestPacket getRequestPacket(Session session) throws SQLException {
        HRequestPacket requestPacket = this._packetPool.isEmpty() ? HRequestPacket.newInstance(session.getRequestPacket()) : this._packetPool.pop();
        return requestPacket;
    }

    public synchronized void freeRequestPacket(HRequestPacket requestPacket) {
        this._packetPool.push(requestPacket);
    }

    public boolean isAutoCommit() {
        return this._getAutoCommit();
    }

    public synchronized Map<String, String> generateClientInfoTransform(Session session) {
        String key;
        HashMap<String, String> map = new HashMap<String, String>();
        Properties connectionProperties = new Properties();
        connectionProperties.putAll((Map<?, ?>)this._clientInfo._getProperties());
        if (session.isHintRouted()) {
            connectionProperties.putAll((Map<?, ?>)this._sessionVariables._getProperties());
        }
        Properties sessionProperties = session.getCurrentSessionVariablesAndClientInfoProperties();
        for (Map.Entry<Object, Object> entry : connectionProperties.entrySet()) {
            key = (String)entry.getKey();
            String desiredValue = (String)entry.getValue();
            String currentValue = sessionProperties.getProperty(key);
            if (currentValue != null && currentValue.equals(desiredValue)) continue;
            map.put(key, desiredValue);
        }
        for (Object object : sessionProperties.keySet()) {
            key = (String)object;
            if (connectionProperties.containsKey(key)) continue;
            map.put(key, null);
        }
        return map;
    }

    public synchronized TransactionState getTransactionState() {
        return this._transaction.getTransactionState();
    }

    public synchronized void handleTransaction(Session session, boolean isDropParseID) throws SQLException {
        this._transaction.handleTransaction(this, session, isDropParseID);
    }

    public synchronized void clearTransaction() {
        this._transaction.clearTransaction(this);
    }

    public synchronized Properties getConnectProperties() {
        return this._connectProperties;
    }

    public synchronized String getConnectProperty(String key) {
        return this._connectProperties.getProperty(key, "");
    }

    public final synchronized String getConnectProperty(String key, String defaultValue) {
        return this._connectProperties.getProperty(key, defaultValue);
    }

    public final synchronized boolean getBooleanConnectProperty(String key, boolean defaultValue) {
        String value = this._connectProperties.getProperty(key);
        boolean result = value != null ? ConnectionProperty.isTrueString(value) : defaultValue;
        return result;
    }

    public synchronized void setConnectProperty(String key, String value) {
        this._connectProperties.setProperty(key, value);
    }

    public synchronized DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public synchronized EngineFeatures getEngineFeatures() {
        return this._engineFeatures;
    }

    public synchronized byte[] getStatementContext() {
        return this._statementContext;
    }

    public synchronized byte[] getCookie() {
        return this._cookie;
    }

    public synchronized void setCookie(byte[] cookie) {
        this._cookie = cookie;
    }

    public synchronized Subject getAuthenticatedSubject() {
        return this._authenticatedSubject;
    }

    public synchronized void setAuthenticatedSubject(Subject authenticatedSubject) {
        this._authenticatedSubject = authenticatedSubject;
    }

    public synchronized String getTermID() {
        StringBuilder builder = new StringBuilder(18);
        if (Driver.getProcessID() == 0) {
            builder.append("java@");
            builder.append(Integer.toHexString(this.hashCode()));
        } else {
            builder.append(Driver.getProcessID());
            builder.append('@');
            builder.append(Driver.getFullComputerName());
        }
        return builder.toString();
    }

    public boolean emptyTimestampIsNull() {
        return this._emptyTimestampIsNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<StatementSapDB> getStatements() {
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            return new HashSet<StatementSapDB>(this._statements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HReplyPacket execute(Object executingObject, Session session, HRequestPacket requestPacket, ExecuteFlag ... executeFlags) throws SQLException {
        EnumSet<ExecuteFlag> flags = executeFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(executeFlags)) : EnumSet.noneOf(ExecuteFlag.class);
        boolean isStatement = flags.contains((Object)ExecuteFlag.IS_STATEMENT);
        boolean isParse = flags.contains((Object)ExecuteFlag.IS_PARSE);
        boolean ignoreErrors = flags.contains((Object)ExecuteFlag.IGNORE_ERRORS);
        boolean allowReconnectOrFallback = flags.contains((Object)ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
        SQLException sqlExceptionChain = null;
        boolean fallBack = false;
        this._sentBytes.getAndAdd(requestPacket.getLength());
        try {
            Object object;
            HReplyPacket replyPacket = null;
            int localWeakReturnCode = 0;
            this._assertOpen();
            this._traceControl.checkTraceSettings();
            requestPacket.setStatementContextAndProfileTimes(this._statementContext, session.getSendTime(), session.getReceiveTime());
            try {
                FunctionCode functionCode;
                Location loc;
                object = this._lockExecutingObject;
                synchronized (object) {
                    this._executingObject = executingObject;
                }
                replyPacket = session.execute(requestPacket);
                localWeakReturnCode = replyPacket.findErrorCode(0);
                Object transFlags = null;
                HOptionsPart scpart = null;
                HMultiLineOptionsPart topoPart = null;
                for (HPartInfo partInfo : replyPacket.parts(0)) {
                    switch (partInfo.getPartKind()) {
                        case Error: {
                            sqlExceptionChain = partInfo.getSQLExceptionChain();
                            break;
                        }
                        case TransactionFlags: {
                            transFlags = partInfo.getOptionsPart();
                            break;
                        }
                        case StatementContext: {
                            scpart = partInfo.getOptionsPart();
                            break;
                        }
                        case TopologyInformation: {
                            if (this.getConnectProperty("ignoreTopology", "false").trim().equals("1")) break;
                            topoPart = partInfo.getMultiLineOptionsPart();
                            break;
                        }
                        case ConnectOptions: {
                            this._engineFeatures = new EngineFeatures(partInfo.getOptionsPart());
                            if (!this._connectProperties.getProperty("databaseName", "").isEmpty() || this._engineFeatures.getDatabaseName().isEmpty()) break;
                            this._connectProperties.put("databaseName", this._engineFeatures.getDatabaseName());
                            break;
                        }
                        case SessionVariable: {
                            if (!this._doCacheSessionVariables()) break;
                            this._cacheSessionVariables(partInfo.getSessionVariables());
                        }
                    }
                }
                HanaSystem sys = session.getSystem();
                if (this._engineFeatures != null && this._engineFeatures.getSystemID() != null && sys == null) {
                    StringBuilder sidAndDatabase = new StringBuilder();
                    sidAndDatabase.append(this._engineFeatures.getSystemID());
                    if (!this._engineFeatures.getDatabaseName().isEmpty()) {
                        sidAndDatabase.append(this._engineFeatures.getDatabaseName());
                    } else if (!this._connectProperties.getProperty("databaseName", "").isEmpty()) {
                        sidAndDatabase.append(this._connectProperties.getProperty("databaseName", ""));
                    }
                    String topologyHostName = "";
                    int topologyPort = 0;
                    if (topoPart != null) {
                        String[] topologyHostPort;
                        String topologyAddress = Topology.getOwnLocation(topoPart);
                        if (!topologyAddress.isEmpty() && topologyAddress.contains(":") && (topologyHostPort = topologyAddress.split(":")) != null && topologyHostPort.length == 2) {
                            topologyHostName = topologyHostPort[0];
                            topologyPort = Integer.parseInt(topologyHostPort[1]);
                        }
                        topoPart.rewind();
                    }
                    Host topologyHost = new Host(topologyHostName, topologyPort);
                    sys = session.getLocation().setSystemID(sidAndDatabase.toString(), session.getLocation().getHost(), topologyHost);
                }
                if (sys != null && topoPart != null && !this.getConnectProperty("ignoreTopology", "false").trim().equals("1") && (loc = sys.updateLocations(topoPart)) != null) {
                    sys.addAlternativeHostPort(session.getLocation().getHost(), loc.getHost());
                    if (loc.getPortNumber() != session.getLocation().getPortNumber() && !this.getConnectProperty("ignoreTopology", "false").trim().equals("0")) {
                        sys.clearLocations();
                    } else {
                        session.setLocation(loc);
                    }
                }
                if (scpart != null) {
                    block44: do {
                        switch (StatementContextOption.decode(scpart.getOptionName())) {
                            case StatementSequenceInfo: {
                                this._statementContext = scpart.getOptionBinaryValue(this._statementContext);
                                break;
                            }
                            case SchemaName: {
                                this._currentSchema = scpart.getOptionStringValue();
                                if (!this._doCacheSessionVariables()) break;
                                this._cacheSessionVariables(Collections.singletonMap("_SYS_DEFAULT_SCHEMA", this._currentSchema));
                                break;
                            }
                            case FlagSet: {
                                if (scpart.getOptionTinyIntValue() <= 0 || !session.isHintRouted()) continue block44;
                                fallBack = true;
                            }
                        }
                    } while (scpart.nextOption());
                }
                if (transFlags != null) {
                    do {
                        switch (TransactionFlag.decode(((HOptionsPart)transFlags).getOptionName())) {
                            case Committed: {
                                if (!((HOptionsPart)transFlags).getOptionBooleanValue()) break;
                                this.clearTransaction();
                                this._closeCursorsAtCommit();
                                break;
                            }
                            case RolledBack: {
                                if (!((HOptionsPart)transFlags).getOptionBooleanValue()) break;
                                ++this._rollbackCount;
                                this.clearTransaction();
                                break;
                            }
                            case NewIsolationLevel: {
                                int hanaIsolationLevel = ((HOptionsPart)transFlags).getOptionIntValue();
                                this._isolationLevel = ConnectionSapDB.getJdbcIsolationLevelForHanaIsolationLevel(hanaIsolationLevel);
                                break;
                            }
                            case DDLCommitModeChanged: {
                                this._isDDLCommitted = ((HOptionsPart)transFlags).getOptionBooleanValue();
                                break;
                            }
                            case WriteTransactionStarted: {
                                if (!((HOptionsPart)transFlags).getOptionBooleanValue()) break;
                                this._transaction.setTransactionState(TransactionState.WriteTransaction, session);
                                break;
                            }
                            case NoWriteTransactionStarted: {
                                if (!((HOptionsPart)transFlags).getOptionBooleanValue()) break;
                                this._transaction.setTransactionState(TransactionState.ReadTransaction, session);
                                break;
                            }
                            case SessionClosingTransactionError: {
                                this._close();
                                break;
                            }
                            case ReadOnlyMode: {
                                this._isReadOnly = ((HOptionsPart)transFlags).getOptionBooleanValue();
                                break;
                            }
                        }
                    } while (((HOptionsPart)transFlags).nextOption());
                } else if (!this._getAutoCommit() && !isParse && !this._transaction.isWriteTransaction() && this._transaction.setTransactionState(this, session, functionCode = replyPacket.getFunctionCode(0), this._isDDLCommitted)) {
                    this._closeCursorsAtCommit();
                }
                if (isStatement && this._getAutoCommit()) {
                    this.clearTransaction();
                    this._closeCursorsAtCommit();
                }
                if (replyPacket.getFunctionCode(0) == FunctionCode.Connect) {
                    this._releaseHintRoutedSession();
                }
            }
            catch (RTEException rteExc) {
                if (!this._isClosed() && !session.isConnected() && this.getSessionPool().getAnchorSession() != null) {
                    if (!session.isHintRouted() && session.getSiteVolumeID().getSiteID() == this.getSessionPool().getAnchorSession().getSiteVolumeID().getSiteID()) {
                        this._releaseSession();
                    } else {
                        this._releaseHintRoutedSession();
                    }
                }
                if (allowReconnectOrFallback && session.isHintRouted()) {
                    throw new InternalFallbackHintRoutedException(rteExc);
                }
                if (!allowReconnectOrFallback || !this.getBooleanConnectProperty("reconnect", true) || ConnectionProperty.getIntProperty(this._connectProperties, "communicationTimeout", 0) != 0 && rteExc.isCauseByTimeout() || this._isInReconnect || this._transaction.isWriteTransaction() || this._getTransactionIsolation() == 4 || this._getTransactionIsolation() == 8) {
                    throw ConnectionException.createException(rteExc);
                }
                this._tryReconnect(rteExc, session);
            }
            finally {
                object = this._lockExecutingObject;
                synchronized (object) {
                    this._executingObject = null;
                }
                if (sqlExceptionChain != null) {
                    if (sqlExceptionChain instanceof SQLWarning) {
                        this._addWarning((SQLWarning)sqlExceptionChain);
                    } else {
                        if (this._transaction.getAutoCommit()) {
                            ++this._rollbackCount;
                        }
                        if (!ignoreErrors && localWeakReturnCode != 0) {
                            throw sqlExceptionChain;
                        }
                    }
                }
            }
            this._receivedBytes.getAndAdd(replyPacket.getLength());
            if (fallBack) {
                throw new InternalFallbackHintRoutedException("FallbackFlag");
            }
            object = replyPacket;
            return object;
        }
        finally {
            if (requestPacket != null) {
                this.freeRequestPacket(requestPacket);
            }
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXAStart(this, session, xid, flags);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXAEnd(this, session, xid, flags);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        try {
            this._assertOpen();
            this._closeCursorsAtCommit();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXAPrepare(this, session, xid);
            HReplyPacket replyPacket = this.execute(this, session, requestPacket, new ExecuteFlag[0]);
            int returnCode = replyPacket.findXAReturnCode(0);
            this.clearTransaction();
            return returnCode;
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this._assertOpen();
            if (onePhase) {
                this._closeCursorsAtCommit();
            }
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXACommit(this, session, xid, onePhase);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
            if (onePhase) {
                this.clearTransaction();
            }
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXARollback(this, session, xid);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
            this.clearTransaction();
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXARecover(this, session, flag);
            HReplyPacket replyPacket = this.execute(this, session, requestPacket, new ExecuteFlag[0]);
            Xid[] xids = replyPacket.findXids(0);
            return xids;
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initXAForget(this, session, xid);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    protected void _assertOpen() throws SQLException {
        if (this._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected synchronized Session _openSession(SiteVolumeID siteVolumeID) throws SQLException {
        Session session = this._sessionPool.getSession(siteVolumeID);
        if (session == null) {
            HanaSystem sys = this._sessionPool.getSystem();
            if (this._tracer.on()) {
                this._tracer.printMessage("new session for site: '" + siteVolumeID.getSiteID() + "' and " + "volume: '" + siteVolumeID.getVolumeID() + "'");
            }
            try {
                session = sys.getSession(siteVolumeID, this._connectProperties, this._tracer);
                if (session == null) {
                    if (this._tracer.on()) {
                        this._tracer.printMessage("=> FAILED because of missing location information for siteID " + siteVolumeID.getSiteID() + " and volumeID " + siteVolumeID.getVolumeID() + ".");
                    }
                    return null;
                }
                this._getNewSession(session, true);
            }
            catch (RTEException rteExc) {
                if (this._tracer.on()) {
                    this._tracer.printMessage("using " + session + "\n=> FAILED");
                }
                throw SQLExceptionSapDB.newInstance("error.connect.rteexception", "", rteExc.getDetailErrorCode(), 0, rteExc.getRTEReturnCode(), SQLExceptionSapDB.NO_UPDATE_COUNTS, "SiteID=" + siteVolumeID.getSiteID(), "VolumeID=" + siteVolumeID.getVolumeID(), rteExc.getMessage());
            }
            catch (SQLException e) {
                if (this._tracer.on()) {
                    this._tracer.printThrowable(e, "using " + session + "\n=> FAILED");
                }
                throw e;
            }
            if (this._tracer.on()) {
                this._tracer.printMessage("=> " + session + " " + session.getLocation());
            }
        }
        if (this._tracer.on()) {
            this._tracer.printDistributionState(this, "new session added to");
        }
        return session;
    }

    protected boolean _getAutoCommit() {
        return this._transaction.getAutoCommit();
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close() throws SQLException {
        if (this._isClosed()) {
            return;
        }
        this._closeStatements();
        try {
            ConnectionSapDB connectionSapDB = this;
            synchronized (connectionSapDB) {
                block9: {
                    if (!this._isClosed.get()) break block9;
                    return;
                }
                this._sessionPool.releaseAll(this);
                this._packetPool.clear();
                this.clearTransaction();
                this._releaseSession();
                this._databaseMetaData = null;
                this._isClosed.set(true);
            }
        }
        finally {
            Driver._removeConnection(this);
        }
    }

    protected synchronized int _getTransactionIsolation() throws SQLException {
        this._assertOpen();
        return this._isolationLevel;
    }

    protected synchronized int _getHoldability() throws SQLException {
        this._assertOpen();
        return this._resultSetHoldability;
    }

    protected synchronized Properties _getSessionVariables() {
        return (Properties)this._sessionVariables._getProperties().clone();
    }

    protected synchronized Properties _getClientInfo() {
        return (Properties)this._clientInfo._getProperties().clone();
    }

    protected synchronized String _getClientInfo(String key) {
        return this._clientInfo._getProperty(key);
    }

    protected synchronized void _setClientInfo(Properties properties) throws SQLClientInfoException {
        this._clientInfo._setProperties(properties);
        this._sessionPool.setSendClientInfoFlag();
    }

    protected synchronized void _setClientInfo(String key, String value) throws SQLClientInfoException {
        this._clientInfo._setProperty(key, value);
        this._sessionPool.setSendClientInfoFlag();
    }

    protected synchronized void _handleFailedHintRouted() {
        if (this._backOffTimer == null) {
            this._backOffTimer = new BackOffTimer(this._connectProperties);
        }
        this._backOffTimer.backOff();
    }

    protected synchronized void _handleSuccessHintRouted() {
        if (this._backOffTimer == null) {
            return;
        }
        this._backOffTimer.reset();
    }

    protected synchronized boolean _isSecondaryReady() {
        if (this._backOffTimer == null) {
            return true;
        }
        return this._backOffTimer.isRetryOk();
    }

    protected synchronized UniqueID _getUniqueID() {
        return this._uniqueID;
    }

    protected boolean _createFinalizerClass() {
        return this.getBooleanConnectProperty("closeHandlesOnFinalize", true);
    }

    protected synchronized String _nextCursorName() {
        return CURSOR_PREFIX + this._uniqueID.getNextID();
    }

    protected synchronized void _refreshMetaData() throws SQLException {
        if (this._databaseMetaData == null) {
            this._databaseMetaData = new DatabaseMetaDataSapDB(this._tracer, this);
        } else {
            this._databaseMetaData._getDBInfo();
        }
    }

    protected synchronized boolean _isDDLCommitted() {
        return this._isDDLCommitted;
    }

    protected synchronized int _getRollbackCount() {
        return this._rollbackCount;
    }

    protected synchronized void _incrementRollbackCount() {
        ++this._rollbackCount;
    }

    protected synchronized void _commitInternal() throws SQLException {
        block2: {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initCommit(this, session);
            try {
                this.execute(this, session, requestPacket, ExecuteFlag.IS_STATEMENT);
            }
            catch (SQLException ignore) {
                if (ignore.getErrorCode() == 700) break block2;
                throw ignore;
            }
        }
        this.clearTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _rollbackInternal() throws SQLException {
        this._assertOpen();
        Session session = this._sessionPool.getPrimarySession();
        HRequestPacket requestPacket = this.getRequestPacket(session);
        requestPacket.initRollback(this, session);
        try {
            this.execute(this, session, requestPacket, ExecuteFlag.IS_STATEMENT);
        }
        catch (SQLException ignore) {
            if (ignore.getErrorCode() != 700) {
                throw ignore;
            }
        }
        finally {
            ++this._rollbackCount;
            this.clearTransaction();
        }
    }

    protected synchronized void _dropParseID(Session session, ParseID parseID) {
        if (parseID == null) {
            return;
        }
        try {
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initDropStatementID(this, session, parseID);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void _dropCursor(Session session, CursorID cursorID) {
        if (!session.isConnected() || cursorID == null) {
            return;
        }
        try {
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initCloseResultSet(this, session, cursorID);
            this.execute(this, session, requestPacket, new ExecuteFlag[0]);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _cancel(Object requestingObject) throws SQLException {
        Object object = this._lockExecutingObject;
        synchronized (object) {
            if (this._executingObject == requestingObject) {
                this._cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _cancel(Object r1, Object r2) throws SQLException {
        Object object = this._lockExecutingObject;
        synchronized (object) {
            if (this._executingObject == r1 && r1 != null || this._executingObject == r2 && r2 != null) {
                this._cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addStatement(StatementSapDB statement) {
        if (statement instanceof InternalStatementSapDB) {
            return;
        }
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            this._statements.add(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeStatement(StatementSapDB statement) {
        if (statement instanceof InternalStatementSapDB) {
            return;
        }
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            this._statements.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeStatements() throws SQLException {
        HashSet<StatementSapDB> temp;
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            temp = new HashSet<StatementSapDB>(this._statements);
        }
        for (StatementSapDB statement : temp) {
            statement._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeCursorsAtCommit() throws SQLException {
        HashSet<StatementSapDB> temp;
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            temp = new HashSet<StatementSapDB>(this._statements);
        }
        for (StatementSapDB statement : temp) {
            if (statement._getResultSetHoldability() != 2) continue;
            statement.closeResultSets();
        }
    }

    private static int _getJdbcIsolationLevelForConnectionPropertyValue(String value) throws SQLException {
        int jdbcIsolationLevel;
        block7: {
            if (value == null || value.isEmpty()) {
                return 2;
            }
            jdbcIsolationLevel = -1;
            try {
                jdbcIsolationLevel = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                if (value.equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
                    jdbcIsolationLevel = 1;
                }
                if (value.equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
                    jdbcIsolationLevel = 2;
                }
                if (value.equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
                    jdbcIsolationLevel = 4;
                }
                if (!value.equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) break block7;
                jdbcIsolationLevel = 8;
            }
        }
        if (jdbcIsolationLevel >= 1 && jdbcIsolationLevel <= 8) {
            return jdbcIsolationLevel;
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", value);
    }

    private static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Statement");
    }

    private TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this, null, null, "Connection", methodName);
    }

    private void _publish(TraceRecord r) {
        r.update(this);
        TraceRecordPublisher.getInstance().publish(r);
    }

    private void _getNewConnection(Session session, boolean isReconnect) throws SQLException {
        this._getNewSession(session, false);
        this._distributionMode = this._engineFeatures.getDistributionMode();
        if (this._authenticationManager != null && !this._authenticationManager.supportsReconnect()) {
            switch (this._distributionMode) {
                case Statement: {
                    this._distributionMode = DistributionMode.Off;
                    if (!this._tracer.on()) break;
                    this._tracer.printMessage("Disable distribution (mode statement) because it isn't supported with authentication mode " + this._authenticationManager.getMethodName() + ".");
                    break;
                }
                case All: {
                    this._distributionMode = DistributionMode.Connection;
                    if (!this._tracer.on()) break;
                    this._tracer.printMessage("Disable distribution (mode all) because it isn't supported with authentication mode " + this._authenticationManager.getMethodName() + ".");
                }
            }
        }
        if (isReconnect) {
            this._refreshMetaData();
        } else if (this._databaseMetaData == null) {
            this._databaseMetaData = new DatabaseMetaDataSapDB(this._tracer, this);
        } else {
            this._databaseMetaData._getDBInfo();
        }
        this._initClientInfoFromConnectionProperties();
        if (this._tracer.on()) {
            this._tracer.printDistributionState(this, "new session added to");
        }
    }

    private void _getNewSession(Session session, boolean forNewSession) throws SQLException {
        String passwd;
        String userName = this._connectProperties.getProperty("user");
        if (userName == null || userName.length() == 0) {
            userName = "";
        }
        if ((passwd = this._connectProperties.getProperty("password")) == null) {
            passwd = "";
        }
        String strippedPasswd = StringUtils.stripPasswd(passwd);
        try {
            if (this.getBooleanConnectProperty("nativeAuthentication", false)) {
                try {
                    this._authenticationManager = new NativeAuthenticationManagerImpl();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -11204) {
                        if (this._tracer.on()) {
                            this._tracer.printThrowable(e, "Cannot load native authentication library");
                        }
                        this._authenticationManager = new AuthenticationManager();
                    }
                    throw e;
                }
            } else {
                this._authenticationManager = new AuthenticationManager();
            }
            this._authenticationManager.authenticate(this, session, userName, strippedPasswd);
            if (this.getBooleanConnectProperty("authentication", false)) {
                throw SQLExceptionSapDB.newInstance("error.connection.challengeresponsenotsupported", new String[0]);
            }
            this._authenticationManager.connect(this, session, userName, strippedPasswd);
            session.setHintRouted(false);
            Session anchorSession = this._sessionPool.getAnchorSession();
            if (anchorSession != null && session != null) {
                if (anchorSession.isPrimarySite() && session.isSecondarySite()) {
                    session.setHintRouted(true);
                }
                if (anchorSession.isSecondarySite() && session.isPrimarySite()) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
                }
            }
            if (this._sessionVariables._hasProperties()) {
                session.setSendSessionVariablesFlag();
            }
            if (this._clientInfo._hasProperties()) {
                session.setSendClientInfoFlag();
            }
            this._sessionPool.addSession(session);
            session.setConnectionID(this._engineFeatures.getConnectionID());
            session.setSendSessionContextFlag();
            if (this._isReadOnly) {
                this._setReadOnly(true);
            }
            if (this._isolationLevel != 2) {
                this._setTransactionIsolation(this._isolationLevel, !forNewSession);
            }
            if (this._currentSchema != null && !this._currentSchema.isEmpty() && !this._currentSchema.equals(this._defaultSchema)) {
                boolean tempDDLCommittedStatus = this._isDDLCommitted;
                this._isDDLCommitted = false;
                this._setCurrentSchema(this._currentSchema);
                this._isDDLCommitted = tempDDLCommittedStatus;
            }
        }
        catch (SQLException e) {
            session.destroy();
            throw e;
        }
    }

    private void _tryReconnect(RTEException outerRteExc, Session session) throws SQLException {
        this._packetPool.clear();
        this._isInReconnect = true;
        Session newSession = null;
        boolean isDroppedSessionHintRouted = session.isHintRouted();
        try {
            if (this._authenticationManager == null || !this._authenticationManager.supportsReconnect()) {
                SQLException ex = SQLExceptionSapDB.newInstance("error.reconnect.notpossible", this._authenticationManager == null ? "NULL" : this._authenticationManager.getMethodName());
                ex.setNextException(ConnectionException.createException(outerRteExc));
                throw ex;
            }
            Location.SiteType siteType = Location.SiteType.NONE;
            if (this.getEngineFeatures().getActiveActiveProtocolVersion().getValue() >= ActiveActiveProtocolVersion.Level1.getValue() && session.getLocation().isHSR()) {
                for (Host host : this._preferredHosts) {
                    Location location = session.getSystem().getLocation(host, true);
                    if (location == null) continue;
                    siteType = location.getSiteType();
                    break;
                }
            }
            boolean isEngineConnectionRoutingEnabled = false;
            if (this._engineFeatures != null && this._engineFeatures.getDistributionMode() != null) {
                isEngineConnectionRoutingEnabled = this._engineFeatures.getDistributionMode().isConnectionRouting();
            }
            if (!isDroppedSessionHintRouted) {
                this.clearTransaction();
                this.reinitialize(false, false);
            }
            if (this._tracer.on()) {
                this._tracer.printProperties(Driver._getDisplayProperties(this._connectProperties), "try to reconnect");
            }
            boolean connectionRoutingEnabled = this._distributionMode.isConnectionRouting() && isEngineConnectionRoutingEnabled;
            newSession = Topology.getSession(this._preferredHosts, this._connectProperties, connectionRoutingEnabled, this._tracer, Driver.getCommunicationFactory(this._connectProperties, this._tracer), session.getSystem(), siteType);
            this._getNewConnection(newSession, true);
        }
        catch (RTEException rteExc) {
            throw ConnectionException.createException(outerRteExc);
        }
        finally {
            this._isInReconnect = false;
        }
        this._sessionPool.setPrimarySession(newSession);
        throw new InternalReconnectException(newSession);
    }

    private void _initClientInfoFromConnectionProperties() throws SQLException {
        this._setClientInfo("APPLICATION", System.getProperty("sun.java.command"));
        this._setClientInfo("APPLICATIONUSER", System.getProperty("user.name"));
        int len = "sessionVariable:".length();
        for (Map.Entry<Object, Object> o : this._connectProperties.entrySet()) {
            String sessionVariableValue;
            String sessionVariableName;
            Map.Entry<Object, Object> entry = o;
            Object key = entry.getKey();
            String keyString = key instanceof String ? (String)key : key.toString();
            if (!keyString.regionMatches(true, 0, "sessionVariable:", 0, len) || (sessionVariableName = keyString.substring(len)).isEmpty()) continue;
            Object value = entry.getValue();
            String string = sessionVariableValue = value instanceof String ? (String)value : value.toString();
            if (sessionVariableValue.isEmpty()) continue;
            this._setClientInfo(sessionVariableName, sessionVariableValue);
        }
    }

    private boolean _doCacheSessionVariables() {
        return !this.getConnectProperty("ignoreTopology", "false").trim().equals("1") && !this.getSessionPool().getAnchorSession().isSecondarySite();
    }

    private void _cacheSessionVariables(Map<String, String> map) {
        this._sessionVariables._updateProperties(map);
        this._sessionPool.setSendSessionVariablesFlag();
    }

    private void _releaseSession() {
        if (!this._isClosed.get()) {
            this._sessionPool.releaseAll(this);
        }
        this._databaseMetaData = null;
    }

    private void _releaseHintRoutedSession() {
        this._sessionPool.releaseAllHintRouted(this);
    }

    private Statement _createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._assertOpen();
        if (this._createFinalizerClass()) {
            return new StatementSapDBFinalize(this._tracer, this, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        }
        return new StatementSapDB(this._tracer, this, resultSetType, resultSetConcurrency, resultSetHoldability, false);
    }

    private PreparedStatement _prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._assertOpen();
        if (this._createFinalizerClass()) {
            return new CallableStatementSapDBFinalize(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        }
        return new CallableStatementSapDB(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
    }

    private CallableStatement _prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._assertOpen();
        if (this._createFinalizerClass()) {
            return new CallableStatementSapDBFinalize(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        }
        return new CallableStatementSapDB(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
    }

    private void _setAutoCommit(boolean autoCommit) throws SQLException {
        this._assertOpen();
        if (autoCommit && !this._transaction.getAutoCommit()) {
            this._commitInternal();
        }
        this._transaction.setAutoCommit(autoCommit);
    }

    private void _commit() throws SQLException {
        this._assertOpen();
        if (this._getAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        this._commitInternal();
    }

    private void _rollback() throws SQLException {
        if (this._getAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        this._rollbackInternal();
    }

    private void _setReadOnly(boolean isReadOnly) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION " + (isReadOnly ? "READ ONLY" : "READ WRITE"));
        this._isReadOnly = isReadOnly;
    }

    private void _setTransactionIsolation(int isolationLevel, boolean onAllSessions) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION ISOLATION LEVEL " + ConnectionSapDB.getSQLForJdbcIsolationLevel(isolationLevel), onAllSessions);
    }

    private String _getCurrentSchema() throws SQLException {
        this._assertOpen();
        return this._currentSchema;
    }

    private void _setCurrentSchema(String schema) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET SCHEMA " + schema);
    }

    private boolean _isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue", String.valueOf(timeout));
        }
        if (this._isClosed()) {
            return false;
        }
        try {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initExecuteDirect(this, session, 2, timeout, "SELECT 'PING' FROM SYS.DUMMY", null, -1);
            this.execute(this, session, requestPacket, ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
        }
        catch (InternalReconnectException e) {
            Session session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this.handleTransaction(session, false);
            return this._isValid(timeout);
        }
        catch (SQLException exc) {
            this._releaseSession();
            this._isClosed.set(true);
            this._databaseMetaData = null;
            return false;
        }
        return true;
    }

    private void _addWarning(SQLWarning warning) {
        if (this._warnings == null) {
            this._warnings = warning;
        } else {
            this._warnings.setNextWarning(warning);
        }
    }

    private void _executeInternalStatement(String sql) throws SQLException {
        this._executeInternalStatement(sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeInternalStatement(String sql, boolean onAllSessions) throws SQLException {
        InternalStatementSapDB is = new InternalStatementSapDB(this, true);
        try {
            if (onAllSessions) {
                is._executeUpdateOnAllSessions(sql);
            } else {
                is._executeUpdate(sql);
            }
        }
        finally {
            try {
                is._close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cancel() throws SQLException {
        ConnectionSapDB conn = null;
        StatementSapDB is = null;
        try {
            conn = ConnectionSapDB.getConnectionSapDB(Driver.getConnection(this._connectPropertiesForCancel.getProperty("dburl"), this._connectPropertiesForCancel));
            long connectionID = this.getAnchorConnectionID();
            is = new InternalStatementSapDB(conn, true);
            is._executeUpdate("ALTER SYSTEM CANCEL SESSION '" + connectionID + "'");
        }
        finally {
            if (is != null) {
                try {
                    is._close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static enum ExecuteFlag {
        NOP,
        IS_STATEMENT,
        IS_PARSE,
        IGNORE_ERRORS,
        ALLOW_RECONNECT_OR_FALLBACK;

    }
}

