/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class ConnectionProperty {
    public static final String user_C = "user";
    public static final String passwd_C = "password";
    public static final String key_C = "key";
    public static final String virtualHostName_C = "virtualHostName";
    public static final String databaseName_C = "databaseName";
    public static final String encrypt_C = "encrypt";
    public static final String locale_C = "locale";
    public static final String reconnect_C = "reconnect";
    public static final String distribution_C = "distribution";
    public static final String latency_C = "latency";
    public static final String communicationTimeout_C = "communicationTimeout";
    public static final String packetSize_C = "packetSize";
    public static final String closeHandlesOnFinalize_C = "closeHandlesOnFinalize";
    public static final String splitBatchCommands_C = "splitBatchCommands";
    public static final String emptyTimestampIsNull_C = "emptyTimestampIsNull";
    public static final String ignoreTopology_C = "ignoreTopology";
    public static final String validateCertificate_C = "validateCertificate";
    public static final String hostNameInCertificate_C = "hostNameInCertificate";
    public static final String keyStore_C = "keyStore";
    public static final String keyStoreType_C = "keyStoreType";
    public static final String keyStorePassword_C = "keyStorePassword";
    public static final String trustStore_C = "trustStore";
    public static final String trustStoreType_C = "trustStoreType";
    public static final String trustStorePassword_C = "trustStorePassword";
    public static final String sniHostname_C = "sniHostname";
    public static final String autoCommit_C = "autoCommit";
    public static final String readOnly_C = "readOnly";
    public static final String isolation_C = "isolation";
    public static final String currentSchema_C = "currentSchema";
    public static final String instanceNumber_C = "instanceNumber";
    public static final String dburl_C = "dburl";
    public static final String hostlist_C = "hostlist";
    public static final String authentication_C = "authentication";
    public static final String nativeAuthentication_C = "nativeAuthentication";
    public static final String transport_C = "transport";
    public static final String associatedConnectionID_C = "associatedConnectionID";
    public static final String trace_C = "trace";
    public static final String connectionTrace_C = "connectionTrace";
    public static final String traceSize_C = "traceSize";
    public static final String cache_C = "cache";
    public static final String cacheSize_C = "cacheSize";
    public static final String dataFormatSupport_C = "dataFormatSupport";
    public static final String systemReplicationProtocolVersion_C = "systemReplicationProtocolVersion";
    public static final String hintRoutingBackoffMin_C = "hintRoutingBackoffMin";
    public static final String hintRoutingBackoffMax_C = "hintRoutingBackoffMax";
    public static final String sessionVariable_C = "sessionVariable:";
    private static final Map<String, String> CANONICAL_PROP_NAMES;
    private static final String[] TRUE_STRINGS;
    public static final String jniAuthentication_C = "jniAuthentication";

    private ConnectionProperty() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String getCanonicalName(String name) {
        String canonicalName = CANONICAL_PROP_NAMES.get(name);
        return canonicalName != null ? canonicalName : name;
    }

    public static int getIntProperty(Properties info, String name, int defaultValue) {
        int result = defaultValue;
        String value = info.getProperty(name);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean getBooleanProperty(Properties info, String name, boolean defaultValue) {
        boolean result = defaultValue;
        String value = info.getProperty(name);
        if (value != null) {
            result = ConnectionProperty.isTrueString(value);
        }
        return result;
    }

    public static boolean isTrueString(String value) {
        if (value == null) {
            return false;
        }
        for (String s : TRUE_STRINGS) {
            if (!value.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    static {
        String[] names;
        CANONICAL_PROP_NAMES = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String name : names = new String[]{user_C, passwd_C, key_C, virtualHostName_C, databaseName_C, encrypt_C, locale_C, reconnect_C, distribution_C, latency_C, communicationTimeout_C, packetSize_C, closeHandlesOnFinalize_C, splitBatchCommands_C, emptyTimestampIsNull_C, ignoreTopology_C, validateCertificate_C, hostNameInCertificate_C, keyStore_C, keyStoreType_C, keyStorePassword_C, trustStore_C, trustStoreType_C, trustStorePassword_C, sniHostname_C, autoCommit_C, readOnly_C, isolation_C, currentSchema_C, instanceNumber_C, dburl_C, hostlist_C, authentication_C, nativeAuthentication_C, transport_C, associatedConnectionID_C, trace_C, connectionTrace_C, traceSize_C, cache_C, cacheSize_C, dataFormatSupport_C, systemReplicationProtocolVersion_C, hintRoutingBackoffMin_C, hintRoutingBackoffMax_C, sessionVariable_C}) {
            CANONICAL_PROP_NAMES.put(name, name);
        }
        TRUE_STRINGS = new String[]{"true", "yes", "on"};
    }
}

