/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Hash;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParameterMetaDataSapDB;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.ResultSetMetaDataSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.VolumeVoteCentre;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalFallbackHintRoutedException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.PartitionParameterFunction;
import com.sap.db.jdbc.packet.RangeComparisonFunction;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbc.translators.AbstractPutval;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.util.HexUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.UniqueID;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CallableStatementSapDB
extends StatementSapDB
implements java.sql.CallableStatement,
SQLParamController {
    public static final int UNLIMITED_STREAM_LENGTH = -1;
    private final String initialParamValue = "initParam";
    private List<Integer> _partitionParamIndexList = new ArrayList<Integer>();
    private ParseInfo _parseInfo;
    private DataFormatDescription.NullIndicator _nullIndicator;
    private HDataPart _dataPart;
    private Object[] _inputArgs;
    private Object[] _rawInputArgs;
    private Vector<AbstractPutval> _inputLongs;
    private int _batchSize;
    private short[] _outPutTypes;
    private byte[] _outPutScale;
    private int[] _tableLocations;
    private UniqueID _tableLocationCounter;
    public Map<SiteVolumeID, Vector<Object>> _batchVolumeMap = new HashMap<SiteVolumeID, Vector<Object>>();
    public int _computedVolumeID = -1;
    private static final PutvalComparator putvalComparator = new PutvalComparator();

    public static CallableStatementSapDB getCallableStatementSapDB(java.sql.PreparedStatement preparedStatement) {
        java.sql.PreparedStatement ps = preparedStatement;
        while (!(ps instanceof CallableStatementSapDB)) {
            if (ps instanceof PreparedStatement) {
                ps = ((PreparedStatement)ps).getInner();
                continue;
            }
            if (ps instanceof CallableStatement) {
                ps = ((CallableStatement)ps).getInner();
                continue;
            }
            return null;
        }
        return (CallableStatementSapDB)ps;
    }

    protected CallableStatementSapDB(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean createInternalResultSets) throws SQLException {
        super(tracer, connection, resultSetType, resultSetConcurrency, resultSetHoldability, createInternalResultSets);
        this.constructor(sql);
    }

    private void _clearPreparedBatch() throws SQLException {
        this._batchItems = null;
        this._batchVolumeMap.clear();
        this._batchSize = 0;
    }

    private void constructor(String sql) throws SQLException {
        this._tableLocationCounter = new UniqueID(this._connection._getUniqueID().getNextID());
        Session session = this.getSession(false, false);
        this._parseInfo = this.doParse(sql, false, session);
        this._isPoolable = false;
    }

    private ParseInfo doParse(String sql, boolean parseAgain, Session session) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.null", new String[0]);
        }
        ParseInfo result = null;
        if (parseAgain) {
            result = this._parseInfo;
        }
        if (result == null || parseAgain) {
            HReplyPacket replyPacket;
            try {
                replyPacket = this.sendSQL(sql, parseAgain, session);
            }
            catch (InternalReconnectException e) {
                session = e.getNewSession();
                if (session == null || !session.isConnected()) {
                    throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
                }
                this._connection.handleTransaction(session, false);
                replyPacket = this.sendSQL(sql, parseAgain, session);
            }
            catch (InternalFallbackHintRoutedException e1) {
                if (session.isHintRouted()) {
                    this._connection._handleFailedHintRouted();
                    SiteVolumeID siteVolumeID = this.getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                    try {
                        session = this._connection._openSession(siteVolumeID);
                    }
                    catch (SQLException e) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    this._Session = session;
                    ParseID parseID = this._parseInfo.getParseID(session);
                    if (parseID != null) {
                        return this._parseInfo;
                    }
                }
                replyPacket = this.sendSQL(sql, parseAgain, session);
            }
            if (!parseAgain) {
                result = new ParseInfo(sql, replyPacket.getFunctionCode(0));
            }
            ArrayList<AbstractTranslator> translators = new ArrayList<AbstractTranslator>();
            for (HPartInfo partInfo : replyPacket.parts(0)) {
                PartKind partKind = partInfo.getPartKind();
                switch (partKind) {
                    case StatementID: {
                        result.addParseID(session, new ParseID(partInfo.getStatementID()));
                        break;
                    }
                    case ParameterMetaData: {
                        partInfo.getParameterMetaData(this._connection, result);
                        break;
                    }
                    case ResultSetMetaData: {
                        partInfo.getResultSetMetaData(this._connection, translators);
                        result.setResultSetTranslators(translators);
                        break;
                    }
                    case TableLocation: {
                        this._tableLocations = partInfo.getTableLocations();
                        break;
                    }
                    case PartitionInformation: {
                        this.setPartitionInfo(partInfo, result, parseAgain);
                    }
                }
            }
            if (!parseAgain && result != null) {
                int parameterCount = result.getParameterCount();
                this._inputArgs = new Object[parameterCount];
                this._rawInputArgs = new Object[parameterCount];
            }
        }
        if (!parseAgain) {
            this._clearParameters();
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return result;
    }

    private void setPartitionInfo(HPartInfo partInfo, ParseInfo parseInfo, boolean parseAgain) throws SQLException {
        switch (partInfo.getPartitionMethod()) {
            case Hash: {
                HashPartitionInfo hashPartitionInfo = partInfo.getHashPartitionInfo();
                if (hashPartitionInfo == null) {
                    return;
                }
                parseInfo.setHashPartitionInfo(hashPartitionInfo);
                this.setPartitionParamIndexList(hashPartitionInfo.getPartitionParameterInfoList());
                break;
            }
            case Range: {
                RangePartitionInfo rangePartitionInfo;
                if (!parseAgain) {
                    this._computedVolumeID = -2;
                }
                if ((rangePartitionInfo = partInfo.getRangePartitionInfo()) == null) {
                    return;
                }
                parseInfo.setRangePartitionInfo(rangePartitionInfo);
                this.setPartitionParamIndexList(rangePartitionInfo.getPartitionParameterInfoList());
            }
        }
    }

    public HashPartitionInfo getHashPartitionInfo() {
        return this._parseInfo.getHashPartitionInfo();
    }

    public RangePartitionInfo getRangePartitionInfo() {
        return this._parseInfo.getRangePartitionInfo();
    }

    public boolean isClientRoutingByHash() {
        if (this._parseInfo != null && this._parseInfo.isHashPartitioned()) {
            if (this._batchSize > 0) {
                return this._parseInfo.getFunctionCode() == FunctionCode.Insert && this._connection.getBooleanConnectProperty("splitBatchCommands", false);
            }
            return true;
        }
        return false;
    }

    public boolean isClientRoutingByRange() {
        if (this._parseInfo != null && this._parseInfo.isRangePartitioned()) {
            return this._batchSize <= 0;
        }
        return false;
    }

    public boolean isClientRouting() {
        return this.isClientRoutingByRange() || this.isClientRoutingByHash();
    }

    private void setPartitionParamIndexList(List<PartitionParameterInfo> partitionParameterInfoList) {
        this._partitionParamIndexList = new ArrayList<Integer>();
        if (partitionParameterInfoList == null || partitionParameterInfoList.size() == 0) {
            return;
        }
        Iterator<PartitionParameterInfo> iterator = partitionParameterInfoList.iterator();
        while (iterator.hasNext()) {
            PartitionParameterInfo aPartitionParameterInfoList;
            PartitionParameterInfo paramInfo = aPartitionParameterInfoList = iterator.next();
            this._partitionParamIndexList.add(paramInfo.getParameterIndex());
        }
    }

    private Session getSessionForExecute() throws SQLException {
        Session session;
        boolean hintRouted;
        boolean bl = hintRouted = this.shouldHintBasedRoute() && this.isHintBasedRoutingRequired();
        if (this.isClientRouting() && (this._connection.getDistributionMode().isStatementRouting() || hintRouted)) {
            SiteVolumeID siteVolumeID = this.computeVolumeID(this._rawInputArgs);
            this._computedVolumeID = siteVolumeID.getVolumeID();
            if (siteVolumeID.isValid()) {
                session = this.getSession(siteVolumeID);
                if (this._parseInfo.getParseID(session) == null) {
                    this.reparse(session);
                }
            } else {
                session = this.getSession(false, true);
            }
        } else {
            session = this.getSession(false, true);
        }
        this._Session = session;
        return this._Session;
    }

    private Session getSession(SiteVolumeID siteVolumeID) throws SQLException {
        Session session = this._connection.getSessionPool().getSession(siteVolumeID);
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (this._Session.getLocation().isHSR() && this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID) && (!this.shouldHintBasedRoute() || !this._connection._isSecondaryReady())) {
            siteVolumeID = this.getPrimarySiblingSiteVolumeID(siteVolumeID.getVolumeID());
        }
        if (!this._connection.getDistributionMode().isStatementRouting() && !this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID)) {
            session = this._connection.getSessionPool().getPrimarySession();
        } else if (session == null) {
            try {
                session = this._connection._openSession(siteVolumeID);
            }
            catch (SQLException e) {
                if (anchor.isPrimarySite() && anchor.getSiteVolumeID().getSiteID() != siteVolumeID.getSiteID()) {
                    this._connection._handleFailedHintRouted();
                    siteVolumeID = this.getPrimarySiblingSiteVolumeID(siteVolumeID.getVolumeID());
                    try {
                        session = this._connection._openSession(siteVolumeID);
                    }
                    catch (SQLException e1) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                }
                throw e;
            }
            if (session == null) {
                session = this._connection.getSessionPool().getPrimarySession();
            }
        }
        this._connection.handleTransaction(session, false);
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        this._Session = session;
        return session;
    }

    private SiteVolumeID getPrimarySiblingSiteVolumeID(int volumeID) {
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (!this._connection.getDistributionMode().isStatementRouting() || anchor == null) {
            return this._connection.getSessionPool().getPrimarySession().getSiteVolumeID();
        }
        return new SiteVolumeID(anchor.getSiteVolumeID().getSiteID(), volumeID);
    }

    private void reparse(Session session) throws SQLException {
        ParseInfo tmpParseInfo = this.doParse(this._parseInfo.getSQL(), true, session);
        this._parseInfo.setResultSetTranslators(tmpParseInfo.getResultSetTranslators());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean _execute(Session session) throws SQLException {
        boolean isQuery;
        if (this._connection == null) {
            throw SQLExceptionSapDB.newInstance("error.internal.connectionnull", new String[0]);
        }
        this.closeResultSets();
        boolean doCommitInternal = false;
        CallableStatementSapDB callableStatementSapDB = this;
        synchronized (callableStatementSapDB) {
            ParseID parseID = this._parseInfo.getParseID(session);
            if (parseID == null) {
                this.reparse(session);
                parseID = this._parseInfo.getParseID(session);
                if (session.isHintRouted() && parseID == null) {
                    SiteVolumeID siteVolumeID = this.getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                    session = this._connection.getSessionPool().getSession(siteVolumeID);
                    if (session != null) {
                        parseID = this._parseInfo.getParseID(session);
                    }
                    if (parseID == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                        parseID = this._parseInfo.getParseID(session);
                    }
                    if (parseID == null) {
                        for (Map.Entry<Session, ParseID> entry : this._parseInfo.getParseIDs().entrySet()) {
                            Session aSession = entry.getKey();
                            ParseID aParseID = entry.getValue();
                            if (!aSession.isPrimarySite() || aParseID == null) continue;
                            parseID = aParseID;
                            break;
                        }
                        if (session == null || parseID == null) {
                            session = this._connection.getSessionPool().getPrimarySession();
                            this.reparse(session);
                        }
                    }
                }
            }
            try {
                boolean truncated = false;
                this._canceled = false;
                this._dataPart = null;
                HRequestPacket requestPacket = this._connection.getRequestPacket(session);
                boolean addParametersPart = this._parseInfo.getInputParameterCount() > 0;
                HDataPart dataPart = requestPacket.initExecute(this._connection, session, this._resultSetHoldability, this._queryTimeout, parseID, addParametersPart);
                if (addParametersPart) {
                    int n = this._parseInfo.getParameterCount();
                    for (int i = 1; i <= n; ++i) {
                        AbstractTranslator translator = this._parseInfo.getParameterTranslator(i);
                        if (!translator.getParameterMode().isInput() || "initParam" != this._inputArgs[i - 1]) continue;
                        throw new SQLException(MessageTranslator.translate("error.missinginout", Integer.toString(i)), "02000");
                    }
                    dataPart.putInputArgs(this._parseInfo.getParameterTranslators(), this._inputArgs);
                    if (this._parseInfo.hasLOBs()) {
                        truncated = this.handleStreamsForExecute(dataPart, this._inputArgs);
                    }
                    dataPart.close();
                }
                if (truncated && this._connection._getAutoCommit()) {
                    requestPacket.setAutoCommit(false);
                }
                requestPacket.close();
                ConnectionSapDB i = this._connection;
                synchronized (i) {
                    HReplyPacket replyPacket = this._connection.execute(this, session, requestPacket, ConnectionSapDB.ExecuteFlag.IS_STATEMENT, this._parseInfo.hasLOBs() ? ConnectionSapDB.ExecuteFlag.NOP : ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
                    for (HPartInfo partInfo : replyPacket.parts(0)) {
                        switch (partInfo.getPartKind()) {
                            case PartitionInformation: {
                                this.setPartitionInfo(partInfo, this._parseInfo, true);
                                break;
                            }
                            case TableLocation: {
                                this._tableLocations = partInfo.getTableLocations();
                            }
                        }
                    }
                    if (this._parseInfo.isSelect()) {
                        isQuery = this.parseResult(session, replyPacket, this._parseInfo.getResultSetTranslators(), true);
                    } else {
                        int returnCode = replyPacket.findErrorCode(0);
                        if (this._parseInfo.hasLOBs() && returnCode == 0) {
                            this._rowsAffected = -1;
                            this._hasRowCount = false;
                            replyPacket = this.handleStreamsForPutval(replyPacket, session);
                        }
                        isQuery = this.parseResult(session, replyPacket, this._parseInfo.getResultSetTranslators(), false);
                        HDataPart outputParametersPart = replyPacket.findOutputParametersPart(0);
                        if (outputParametersPart != null) {
                            this._dataPart = outputParametersPart;
                            this._dataPart.setDataFormatDescription(this._parseInfo);
                        }
                    }
                    if (truncated && this._connection._getAutoCommit()) {
                        doCommitInternal = true;
                    }
                }
            }
            catch (InternalReconnectException e) {
                session = e.getNewSession();
                if (session == null || !session.isConnected()) {
                    throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
                }
                this._connection.handleTransaction(session, false);
                this.closeResultSets();
                this._Session = session;
                boolean addParametersPart = this._execute(session);
                return addParametersPart;
            }
            catch (InternalFallbackHintRoutedException e1) {
                this.closeResultSets();
                if (session.isHintRouted()) {
                    if (e1.getMessage() == null || !e1.getMessage().equals("FallbackFlag")) {
                        this._connection._handleFailedHintRouted();
                    }
                    SiteVolumeID siteVolumeID = this.getPrimarySiblingSiteVolumeID(session.getSiteVolumeID().getVolumeID());
                    try {
                        session = this._connection._openSession(siteVolumeID);
                    }
                    catch (SQLException e) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    if (session == null) {
                        session = this._connection.getSessionPool().getPrimarySession();
                    }
                    this._Session = session;
                }
                boolean bl = this._execute(session);
                return bl;
            }
            finally {
                this._canceled = false;
            }
        }
        if (doCommitInternal) {
            this._connection._commitInternal();
            this._connection._closeCursorsAtCommit();
        }
        if (session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return isQuery;
    }

    private int[] _executePreparedBatch() throws SQLException {
        if (this.isClientRouting() && this._batchVolumeMap != null && this._batchVolumeMap.size() > 0 && this._parseInfo.getFunctionCode() == FunctionCode.Insert) {
            Set<SiteVolumeID> siteVolumeSet = this._batchVolumeMap.keySet();
            Iterator<SiteVolumeID> siteVolumeIter = siteVolumeSet.iterator();
            int[] res = new int[this._batchSize];
            int pos = 0;
            while (siteVolumeIter.hasNext()) {
                Session session;
                SiteVolumeID siteVolumeID = siteVolumeIter.next();
                this._batchItems = this._batchVolumeMap.get(siteVolumeID);
                if (this._batchItems.size() <= 0) continue;
                if (siteVolumeID.isValid()) {
                    session = this.getSession(siteVolumeID);
                    if (this._parseInfo.getParseID(session) == null) {
                        this.reparse(session);
                    }
                } else {
                    session = this.getSession(false, true);
                }
                this._Session = session;
                int[] ret = this._executePreparedBatch(session);
                System.arraycopy(ret, 0, res, pos, ret.length);
                pos += ret.length;
            }
            this._batchSize = 0;
            this._batchVolumeMap.clear();
            return res;
        }
        this._batchSize = 0;
        return this._executePreparedBatch(this.getSession(false, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] _executePreparedBatch(Session session) throws SQLException {
        doCommitInternal = false;
        var4_3 = this;
        synchronized (var4_3) {
            block30: {
                block28: {
                    block29: {
                        this.assertOpen();
                        this._serverProcessingTime = 0L;
                        parseID = this._parseInfo.getParseID(session);
                        if (this._parseInfo == null || parseID == null) {
                            this.reparse(session);
                            parseID = this._parseInfo.getParseID(session);
                        }
                        if (this._parseInfo.isSelect()) {
                            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset", new Object[0]), new int[0]);
                        }
                        if (this._parseInfo.getFunctionCode() == FunctionCode.DBProcedureCall || this._parseInfo.getFunctionCode() == FunctionCode.DBProcedureCallWithResultSet) {
                            for (AbstractTranslator translator : this._parseInfo.getParameterTranslators()) {
                                if (!translator.getParameterMode().isOutput()) continue;
                                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout", new Object[0]), new int[0]);
                            }
                        }
                        if (this._batchItems == null) {
                            return new int[0];
                        }
                        localBatchItems = this._batchItems;
                        this._batchItems = null;
                        this._canceled = false;
                        count = localBatchItems.size();
                        inputCursor = 0;
                        noError = true;
                        executeCount = -1;
                        result = new int[count];
                        this._rowsAffected = -1;
                        truncated = false;
lbl29:
                        // 3 sources

                        while (true) {
                            if (inputCursor < count && noError) {
                                streamVec = null;
                                firstRecordNo = inputCursor;
                                requestPacket = this._connection.getRequestPacket(session);
                                dataPart = requestPacket.initExecute(this._connection, session, this._resultSetHoldability, this._queryTimeout, parseID, true);
                                if (executeCount == -1) {
                                    requestPacket.addPartAttribute(PartAttribute.FirstPacket);
                                }
                                break block28;
                            }
                            if (truncated && this._connection._getAutoCommit()) {
                                doCommitInternal = true;
                            }
                            break block29;
                            break;
                        }
                        finally {
                            this._canceled = false;
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 4] lbl49 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (doCommitInternal) {
                        this._connection._commitInternal();
                        this._connection._closeCursorsAtCommit();
                    }
                    return result;
                }
                rowcnt = 0;
                do {
                    row = (Object[])localBatchItems.elementAt(inputCursor);
                    n = this._parseInfo.getParameterCount();
                    for (i = 1; i <= n; ++i) {
                        translator = this._parseInfo.getParameterTranslator(i);
                        if (!translator.getParameterMode().isInput() || "initParam" != row[i - 1]) continue;
                        this.makeBatchCountArray(result, new int[0], firstRecordNo, count - firstRecordNo, -3);
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", new Object[]{Integer.toString(inputCursor + 1), Integer.toString(i)}), "0200", result);
                    }
                    if (!dataPart.putInputArgs(this._parseInfo.getParameterTranslators(), row)) break;
                    ++rowcnt;
                    if (!this._parseInfo.hasLOBs()) continue;
                    looptruncated = this.handleStreamsForExecute(dataPart, row);
                    if (looptruncated) {
                        truncated = true;
                    }
                    if (truncated && this._connection._getAutoCommit()) {
                        requestPacket.setAutoCommit(false);
                    }
                    if (streamVec == null) {
                        streamVec = new Vector<AbstractPutval>(this._inputLongs.size());
                    }
                    streamVec.addAll(this._inputLongs);
                } while (++inputCursor < count);
                if (inputCursor == count) {
                    requestPacket.addPartAttribute(PartAttribute.LastPacket);
                }
                dataPart.close(inputCursor - firstRecordNo);
                if (rowcnt <= 0) ** GOTO lbl29
                try {
                    requestPacket.close();
                    replyPacket = this._connection.execute(this, session, requestPacket, new ConnectionSapDB.ExecuteFlag[]{this._parseInfo.hasLOBs() != false ? ConnectionSapDB.ExecuteFlag.NOP : ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK});
                }
                catch (InternalReconnectException e) {
                    session = e.getNewSession();
                    if (session != null && session.isConnected()) {
                        this._connection.handleTransaction(session, false);
                        this._batchItems = new Vector<E>(localBatchItems);
                        i = this._executePreparedBatch(session);
                        this._canceled = false;
                        return i;
                    }
                    throw SQLExceptionSapDB.newInstance("error.objectisclosed", new String[]{this.toString()});
                }
                catch (SQLException dbExc) {
                    specific = (SQLExceptionSapDBInterface)dbExc;
                    if (!this._connection._getAutoCommit()) {
                        this._rowsAffected = this._rowsAffected > 0 ? (this._rowsAffected += specific.getErrorPos() - 1) : specific.getErrorPos() - 1;
                    }
                    updateCounts = ((SQLExceptionSapDBInterface)dbExc).getUpdateCountsFromLastPacket();
                    this.makeBatchCountArray(result, updateCounts, firstRecordNo, count - firstRecordNo, -3);
                    throw new BatchUpdateExceptionSapDB(result, dbExc, (Integer)(inputCursor + 1));
                }
                executeCount = replyPacket.findRowsAffected(0);
                updateCounts = replyPacket.findBatchUpdateCounts(0);
                processingTime = replyPacket.findServerExecutionTime(0);
                if (this._serverProcessingTime != -1L) {
                    this._serverProcessingTime = processingTime < 0L ? processingTime : (this._serverProcessingTime += processingTime);
                }
                if (!this._parseInfo.hasLOBs()) break block30;
                this.handleStreamsForPutval(replyPacket, session);
            }
            this.makeBatchCountArray(result, updateCounts, firstRecordNo, inputCursor - firstRecordNo, -2);
            this._rowsAffected = executeCount;
            ** continue;
        }
    }

    private void makeBatchCountArray(int[] resultArr, int[] updateCounts, int chunkOffset, int chunkLen, int defaultValue) {
        if (updateCounts == null) {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = defaultValue;
            }
        } else {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = updateCounts.length > i ? updateCounts[i] : defaultValue;
            }
        }
    }

    private synchronized AbstractTranslator _getParameterTranslator(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this._parseInfo.getParameterCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalidcolumnindex", String.valueOf(parameterIndex));
        }
        return this._parseInfo.getParameterTranslator(parameterIndex);
    }

    private synchronized AbstractTranslator _getParameterTranslator(String parameterName) throws SQLException {
        if (!this._parseInfo.isProcedure()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noprocedure", new String[0]);
        }
        return this._parseInfo.getParameterTranslator(parameterName);
    }

    private HDataPart _getDataPart(int outputFieldPos) throws SQLException {
        if (this._dataPart == null) {
            throw SQLExceptionSapDB.newInstance("error.nooutparamdata", new String[0]);
        }
        this._dataPart.moveToField(outputFieldPos);
        return this._dataPart;
    }

    private synchronized boolean handleStreamsForExecute(HDataPart dataPart, Object[] arguments) throws SQLException {
        AbstractPutval putval;
        this._inputLongs = new Vector();
        int n = this._parseInfo.getParameterCount();
        for (int i = 1; i <= n; ++i) {
            AbstractTranslator translator = this._parseInfo.getParameterTranslator(i);
            Object inarg = arguments[i - 1];
            if (inarg == null || !translator.isLOB()) continue;
            try {
                putval = (AbstractPutval)inarg;
                this._inputLongs.addElement(putval);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this._inputLongs.size() > 1) {
            Collections.sort(this._inputLongs, putvalComparator);
        }
        boolean truncated = false;
        Enumeration<AbstractPutval> putvals = this._inputLongs.elements();
        while (putvals.hasMoreElements()) {
            putval = putvals.nextElement();
            if (putval.atEnd() && (putval = (AbstractPutval)putval.cloneForBatch()).atEnd()) {
                throw SQLExceptionSapDB.newInstance("error.stream.isatend", new String[0]);
            }
            putval.transferStream(dataPart);
            if (!putval.atEnd()) {
                truncated = true;
            }
            putval.setLocatorIDStale();
            putval.setState(AbstractPutval.State.WRITELOB);
        }
        return truncated;
    }

    private void getChangedPutvalDescriptors(HReplyPacket replyPacket) throws SQLException {
        byte[][] descriptorArray = replyPacket.findLOBLocators(0);
        int descIndex = 0;
        for (int i = 0; i < this._inputLongs.size(); ++i) {
            AbstractPutval putval = this._inputLongs.elementAt(i);
            if (putval.atEnd()) continue;
            if (descriptorArray.length > descIndex) {
                putval.setLocatorID(descriptorArray[descIndex++]);
                continue;
            }
            throw SQLExceptionSapDB.newInstance("error.internal.LOBDescriptorMissing", new String[0]);
        }
        if (descriptorArray.length > descIndex) {
            throw SQLExceptionSapDB.newInstance("error.internal.ToManyLOBDescriptors", new String[0]);
        }
    }

    private synchronized HReplyPacket handleStreamsForPutval(HReplyPacket replyPacket, Session session) throws SQLException {
        if (this._inputLongs == null || this._inputLongs.size() == 0) {
            return replyPacket;
        }
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            PartKind partKind = partInfo.getPartKind();
            if (partKind != PartKind.RowsAffected) continue;
            if (this._parseInfo.isSelect()) break;
            this._rowsAffected = partInfo.getRowsAffected();
            this._hasRowCount = true;
            break;
        }
        AbstractPutval lastStream = this._inputLongs.lastElement();
        int firstOpenStream = 0;
        int count = this._inputLongs.size();
        if (!lastStream.atEnd()) {
            this.getChangedPutvalDescriptors(replyPacket);
        }
        while (!lastStream.atEnd()) {
            int putvalshandled = 0;
            HRequestPacket requestPacket = this._connection.getRequestPacket(session);
            HDataPart dataPart = requestPacket.initWriteLOB(this._connection, session);
            for (int i = firstOpenStream; i < count && dataPart.canAddDescriptor(21); ++i) {
                AbstractPutval putval = this._inputLongs.elementAt(i);
                if (putval.atEnd() || putval.isLocatorIDStale()) {
                    ++firstOpenStream;
                    continue;
                }
                putval.addDescriptor(dataPart);
                ++putvalshandled;
                if (this._canceled) {
                    putval.closeStream();
                    ++firstOpenStream;
                    continue;
                }
                putval.transferStream(dataPart);
                if (!putval.atEnd()) continue;
                ++firstOpenStream;
            }
            if (putvalshandled == 0) {
                return replyPacket;
            }
            dataPart.close(putvalshandled);
            requestPacket.close();
            replyPacket = this._connection.execute(this, session, requestPacket, this._parseInfo.hasLOBs() ? ConnectionSapDB.ExecuteFlag.NOP : ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
        }
        if (this._canceled) {
            throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
        }
        return replyPacket;
    }

    protected synchronized void _registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this._outPutTypes == null) {
            int parameterCount = this._parseInfo.getParameterCount();
            this._outPutTypes = new short[parameterCount + 1];
            this._outPutScale = new byte[parameterCount + 1];
        }
        if (parameterIndex >= this._outPutTypes.length) {
            throw SQLExceptionSapDB.newInstance("error.internal.unexpectedoutput", String.valueOf(parameterIndex));
        }
        this._outPutTypes[parameterIndex] = (short)sqlType;
        this._outPutScale[parameterIndex] = (byte)scale;
    }

    @Override
    HReplyPacket sendCommand(HRequestPacket requestPacket, String sql, boolean parseAgain, Session session) throws SQLException {
        requestPacket.initPrepare(this._connection, session, this._resultSetHoldability, sql);
        HReplyPacket replyPacket = this._connection.execute(this, session, requestPacket, ConnectionSapDB.ExecuteFlag.IS_PARSE, ConnectionSapDB.ExecuteFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    private String translateDecimalForHashing(String decString, int parameterIndex) throws SQLException {
        if (decString == null || decString.trim().length() == 0) {
            return "initParam";
        }
        BigDecimal bd = new BigDecimal(decString);
        int scale = this._getParameterTranslator(parameterIndex).getScale();
        if (bd.scale() > scale) {
            return "initParam";
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(scale);
        decimalFormat.setMinimumFractionDigits(scale);
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setGroupingUsed(false);
        return decimalFormat.format(bd);
    }

    public boolean rangeGreaterThanEqualComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        int columnType = this._getParameterTranslator(paramIndex).getColumnType();
        byte multiValueRange = rangeInfo.getMultiValueRange();
        if (columnType == 4 || columnType == 5 || columnType == -6 || columnType == -5 || columnType == 93) {
            long val = (Long)value;
            if (multiValueRange == 1) {
                return rangeInfo.getLongCeil() > val;
            }
            return rangeInfo.getLongFloor() >= val;
        }
        if (columnType == 3) {
            BigDecimal bdVal = (BigDecimal)value;
            if (multiValueRange == 1) {
                return rangeInfo.getBdCeil().compareTo(bdVal) > 0;
            }
            return rangeInfo.getBdFloor().compareTo(bdVal) >= 0;
        }
        if (columnType == 12 || columnType == -9 || columnType == -15) {
            if (multiValueRange == 1) {
                return rangeInfo.getStringCeil().compareTo((String)value) > 0;
            }
            return rangeInfo.getStringFloor().compareTo((String)value) >= 0;
        }
        return false;
    }

    public boolean rangeGreaterThanComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        int columnType = this._getParameterTranslator(paramIndex).getColumnType();
        byte multiValueRange = rangeInfo.getMultiValueRange();
        if (columnType == 4 || columnType == 5 || columnType == -6 || columnType == -5 || columnType == 93) {
            long val = (Long)value;
            if (multiValueRange == 1) {
                return rangeInfo.getLongCeil() > val + 1L;
            }
            return rangeInfo.getLongFloor() > val;
        }
        if (columnType == 3) {
            BigDecimal bdVal = (BigDecimal)value;
            if (multiValueRange == 1) {
                int scale = this._getParameterTranslator(paramIndex).getScale();
                BigDecimal minValue = BigDecimal.valueOf(Math.pow(0.1, scale)).setScale(scale, RoundingMode.FLOOR);
                return rangeInfo.getBdCeil().compareTo(bdVal.add(minValue)) > 0;
            }
            return rangeInfo.getBdFloor().compareTo(bdVal) > 0;
        }
        if (columnType == 12 || columnType == -9 || columnType == -15) {
            if (multiValueRange == 1) {
                return rangeInfo.getStringCeil().compareTo((String)value) > 0;
            }
            return rangeInfo.getStringFloor().compareTo((String)value) > 0;
        }
        return false;
    }

    public boolean rangeLessThanComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        int columnType = this._getParameterTranslator(paramIndex).getColumnType();
        if (columnType == 4 || columnType == 5 || columnType == -6 || columnType == -5 || columnType == 93) {
            if (rangeInfo.getLongFloor() < (Long)value) {
                return true;
            }
        } else if (columnType == 3) {
            BigDecimal bdVal = (BigDecimal)value;
            if (rangeInfo.getBdFloor().compareTo(bdVal) < 0) {
                return true;
            }
        } else if ((columnType == 12 || columnType == -9 || columnType == -15) && rangeInfo.getStringFloor().compareTo((String)value) < 0) {
            return true;
        }
        return false;
    }

    public boolean rangeLessThanEqualComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        int columnType = this._getParameterTranslator(paramIndex).getColumnType();
        if (columnType == 4 || columnType == 5 || columnType == -6 || columnType == -5 || columnType == 93) {
            if (rangeInfo.getLongFloor() <= (Long)value) {
                return true;
            }
        } else if (columnType == 3) {
            BigDecimal bdVal = (BigDecimal)value;
            if (rangeInfo.getBdFloor().compareTo(bdVal) <= 0) {
                return true;
            }
        } else if ((columnType == 12 || columnType == -9 || columnType == -15) && rangeInfo.getStringFloor().compareTo((String)value) <= 0) {
            return true;
        }
        return false;
    }

    public boolean rangeEqualComparison(RangeInfo rangeInfo, Object value, int paramIndex) throws SQLException {
        if (rangeInfo.isRestRange()) {
            return true;
        }
        int columnType = this._getParameterTranslator(paramIndex).getColumnType();
        if (columnType == 4 || columnType == 5 || columnType == -6 || columnType == -5 || columnType == 93) {
            byte multiValueRange = rangeInfo.getMultiValueRange();
            long floor = rangeInfo.getLongFloor();
            long val = (Long)value;
            if (multiValueRange == 1) {
                return floor <= val && val < rangeInfo.getLongCeil();
            }
            return floor == val;
        }
        if (columnType == 3) {
            byte multiValueRange = rangeInfo.getMultiValueRange();
            BigDecimal bdVal = (BigDecimal)value;
            BigDecimal floor = rangeInfo.getBdFloor();
            if (multiValueRange == 1) {
                return floor.compareTo(bdVal) <= 0 && bdVal.compareTo(rangeInfo.getBdCeil()) < 0;
            }
            return floor.compareTo(bdVal) == 0;
        }
        if (columnType == 12 || columnType == -9 || columnType == -15) {
            byte multiValueRange = rangeInfo.getMultiValueRange();
            if (multiValueRange == 1) {
                return rangeInfo.getStringFloor().compareTo((String)value) <= 0 && ((String)value).compareTo(rangeInfo.getStringCeil()) < 0;
            }
            return rangeInfo.getStringFloor().compareTo((String)value) == 0;
        }
        return false;
    }

    public SiteVolumeID computeVolumeIDForRange(Object[] rawInputArgs) throws SQLException {
        RangePartitionInfo rangePartitionInfo = this._parseInfo.getRangePartitionInfo();
        if (rangePartitionInfo == null || rawInputArgs == null || rawInputArgs.length == 0) {
            return new SiteVolumeID(-1, -1);
        }
        int rangePartitionParams = rangePartitionInfo.getParameterCount();
        int noRanges = rangePartitionInfo.getRangeCount();
        List<PartitionParameterInfo> partitionParameterInfoList = rangePartitionInfo.getPartitionParameterInfoList();
        List<RangeInfo> rangeInfoList = rangePartitionInfo.getRangeInfoList();
        if (rangePartitionParams <= 0 || noRanges <= 0 || partitionParameterInfoList == null || partitionParameterInfoList.size() != rangePartitionParams || rangeInfoList.size() != noRanges) {
            return new SiteVolumeID(-1, -1);
        }
        VolumeVoteCentre voteCentre = new VolumeVoteCentre();
        block0: for (PartitionParameterInfo paramInfo : partitionParameterInfoList) {
            int paramIndex = paramInfo.getParameterIndex();
            Object value = rawInputArgs[paramIndex - 1];
            if (value == null) {
                RangeInfo rangeInfo = rangeInfoList.get(noRanges - 1);
                if (!rangeInfo.isRestRange()) continue;
                voteCentre.vote(rangeInfo.getVolumeID());
                continue;
            }
            if (value instanceof String && ((String)value).equalsIgnoreCase("initParam")) continue;
            RangeComparisonFunction rangeCmpFunction = paramInfo.getRangeComparisonFunction();
            int columnType = this._getParameterTranslator(paramIndex).getColumnType();
            if (columnType == 93) {
                PartitionParameterFunction partitionParamFunc = paramInfo.getPartitionParameterFunction();
                Timestamp paramValue = (Timestamp)value;
                String tStampString = this.convertTimestampForPartitioning(paramValue.toString(), partitionParamFunc, false);
                if (tStampString == null) continue;
                value = Long.valueOf(tStampString);
            } else if (columnType == -15 && paramInfo.getAttributeType() == 67) {
                String tempVal = ((String)value).replaceAll("\\s+$", "");
                value = tempVal;
            }
            boolean expressVoting = false;
            for (int j = 0; j < noRanges; ++j) {
                RangeInfo lastRangeInfo;
                RangeInfo rangeInfo = rangeInfoList.get(j);
                if (expressVoting) {
                    voteCentre.vote(rangeInfo.getVolumeID());
                    continue;
                }
                if (rangeCmpFunction == RangeComparisonFunction.EQ) {
                    if (!this.rangeEqualComparison(rangeInfo, value, paramIndex)) continue;
                    voteCentre.vote(rangeInfo.getVolumeID());
                    continue block0;
                }
                if (rangeCmpFunction == RangeComparisonFunction.LE) {
                    if (this.rangeLessThanEqualComparison(rangeInfo, value, paramIndex)) {
                        voteCentre.vote(rangeInfo.getVolumeID());
                        continue;
                    }
                    lastRangeInfo = rangeInfoList.get(noRanges - 1);
                    if (!lastRangeInfo.isRestRange()) continue block0;
                    voteCentre.vote(lastRangeInfo.getVolumeID());
                    continue block0;
                }
                if (rangeCmpFunction == RangeComparisonFunction.LT) {
                    if (this.rangeLessThanComparison(rangeInfo, value, paramIndex)) {
                        voteCentre.vote(rangeInfo.getVolumeID());
                        continue;
                    }
                    lastRangeInfo = rangeInfoList.get(noRanges - 1);
                    if (!lastRangeInfo.isRestRange()) continue block0;
                    voteCentre.vote(lastRangeInfo.getVolumeID());
                    continue block0;
                }
                if (rangeCmpFunction == RangeComparisonFunction.GE) {
                    if (!this.rangeGreaterThanEqualComparison(rangeInfo, value, paramIndex)) continue;
                    voteCentre.vote(rangeInfo.getVolumeID());
                    expressVoting = true;
                    continue;
                }
                if (rangeCmpFunction == RangeComparisonFunction.GT) {
                    if (!this.rangeGreaterThanComparison(rangeInfo, value, paramIndex)) continue;
                    voteCentre.vote(rangeInfo.getVolumeID());
                    expressVoting = true;
                    continue;
                }
                if (rangeCmpFunction != RangeComparisonFunction.NE) continue;
                if (this.rangeLessThanComparison(rangeInfo, value, paramIndex) || this.rangeGreaterThanComparison(rangeInfo, value, paramIndex)) {
                    voteCentre.vote(rangeInfo.getVolumeID());
                    if (!this.rangeEqualComparison(rangeInfo, value, paramIndex)) continue;
                    expressVoting = true;
                    continue;
                }
                expressVoting = true;
            }
        }
        return new SiteVolumeID(voteCentre.getTopVolumeID());
    }

    public SiteVolumeID computeVolumeID(Object[] rawInputArgs) {
        if (this.isClientRoutingByHash()) {
            try {
                return this.computeVolumeIDForHash(rawInputArgs);
            }
            catch (SQLException e) {
                return new SiteVolumeID(-1, -1);
            }
        }
        if (this.isClientRoutingByRange()) {
            try {
                return this.computeVolumeIDForRange(rawInputArgs);
            }
            catch (SQLException e) {
                return new SiteVolumeID(-1, -1);
            }
        }
        return new SiteVolumeID(-1, -1);
    }

    public SiteVolumeID computeVolumeIDForHash(Object[] rawInputArgs) throws SQLException {
        HashPartitionInfo hashPartitionInfo = this._parseInfo.getHashPartitionInfo();
        if (hashPartitionInfo == null || rawInputArgs == null || rawInputArgs.length == 0) {
            return new SiteVolumeID(-1, -1);
        }
        int noParameters = hashPartitionInfo.getParameterCount();
        int noPartitions = hashPartitionInfo.getPartitionCount();
        List<PartitionParameterInfo> partitionParameterInfoList = hashPartitionInfo.getPartitionParameterInfoList();
        if (noParameters <= 0 || noPartitions <= 0 || partitionParameterInfoList == null || partitionParameterInfoList.size() != noParameters) {
            return new SiteVolumeID(-1, -1);
        }
        int partindex = 0;
        int flag = -1;
        for (int i = 0; i < noParameters; ++i) {
            PartitionParameterFunction partitionParamFunc;
            PartitionParameterInfo paramInfo = partitionParameterInfoList.get(i);
            int parameterIndex = paramInfo.getParameterIndex();
            String paramValue = (String)rawInputArgs[parameterIndex - 1];
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (paramValue == null || paramValue.equalsIgnoreCase("initParam")) continue;
            if (columnType == 93 && (paramValue = this.convertTimestampForPartitioning(paramValue, partitionParamFunc = paramInfo.getPartitionParameterFunction(), true)) == null) {
                return new SiteVolumeID(-1, -1);
            }
            long hashVal = Hash.calculateHash(paramValue);
            flag = 0;
            if ((partindex += (int)(hashVal % (long)noPartitions)) < noPartitions) continue;
            partindex %= noPartitions;
        }
        if (flag == -1) {
            return new SiteVolumeID(-1, -1);
        }
        Integer siteVolumeID = this._parseInfo.getHashPartitionInfo().getPartitionAssignmentMap().get(partindex + 1);
        if (siteVolumeID == null) {
            return new SiteVolumeID(-1, -1);
        }
        return new SiteVolumeID(siteVolumeID);
    }

    private String convertTimestampForPartitioning(String timestampString, PartitionParameterFunction partitionParamFunc, boolean needDashes) {
        Timestamp timestamp;
        if (timestampString == null || timestampString.trim().length() == 0) {
            return null;
        }
        try {
            timestamp = Timestamp.valueOf(timestampString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (partitionParamFunc == PartitionParameterFunction.None) {
            buffer.append(this.getYear(timestamp));
            if (needDashes) {
                buffer.append("-");
            }
            buffer.append(this.getMonth(timestamp));
            if (needDashes) {
                buffer.append("-");
            }
            buffer.append(this.getDate(timestamp));
            return buffer.toString();
        }
        if (partitionParamFunc == PartitionParameterFunction.Year) {
            buffer.append(this.getYear(timestamp));
            return buffer.toString();
        }
        if (partitionParamFunc == PartitionParameterFunction.Month) {
            buffer.append(this.getYear(timestamp));
            if (needDashes) {
                buffer.append("-");
            }
            buffer.append(this.getMonth(timestamp));
            return buffer.toString();
        }
        return null;
    }

    private String getYear(Timestamp timestamp) {
        StringBuilder buffer = new StringBuilder();
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        for (int yearLenAppend = 4 - String.valueOf(cal.get(1)).length(); yearLenAppend > 0; --yearLenAppend) {
            buffer.append('0');
        }
        buffer.append(cal.get(1));
        return buffer.toString();
    }

    private String getMonth(Timestamp timestamp) {
        StringBuilder buffer = new StringBuilder();
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        if (cal.get(2) + 1 < 10) {
            buffer.append('0');
        }
        buffer.append(cal.get(2) + 1);
        return buffer.toString();
    }

    private String getDate(Timestamp timestamp) {
        StringBuilder buffer = new StringBuilder();
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        if (cal.get(5) < 10) {
            buffer.append('0');
        }
        buffer.append(cal.get(5));
        return buffer.toString();
    }

    private String translateBinaryForHashing(byte[] b) {
        try {
            String str = new String(b, "UTF-8");
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return "initParam";
        }
    }

    @Override
    public boolean wasSpecialNull() throws SQLException {
        return this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL;
    }

    @Override
    public void setNullIndicator(DataFormatDescription.NullIndicator indicator) {
        this._nullIndicator = indicator;
    }

    @Override
    public boolean wasNullOrSpecialNull() throws SQLException {
        if (this._connection.emptyTimestampIsNull()) {
            return this._nullIndicator == DataFormatDescription.NullIndicator.NULL || this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL;
        }
        return this._nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    @Override
    protected void _dropParseIDs() throws SQLException {
        if (this._parseInfo == null) {
            return;
        }
        for (Map.Entry<Session, ParseID> entry : new HashMap<Session, ParseID>(this._parseInfo.getParseIDs()).entrySet()) {
            Session session = entry.getKey();
            ParseID parseID = entry.getValue();
            if (session == null || !session._isConnected() || parseID == null) continue;
            this._connection.handleTransaction(session, true);
            this._connection._dropParseID(session, parseID);
            this._parseInfo.removeParseID(session);
        }
    }

    public synchronized ParseInfo getParseInfo() {
        return this._parseInfo;
    }

    private boolean shouldHintBasedRoute() throws SQLException {
        return this._connection.getEngineFeatures().getActiveActiveProtocolVersion().getValue() >= ActiveActiveProtocolVersion.Level1.getValue() && this._Session != null && this._Session.getLocation().isHSR() && this._parseInfo != null && this._parseInfo.getFunctionCode() == FunctionCode.Select && this._connection._getTransactionIsolation() == 2 && (this._connection.getTransactionState() == TransactionState.ReadTransaction || this._connection.getTransactionState() == TransactionState.None);
    }

    private boolean isRoutedFromSecondaryToPrimary(Session anchor, SiteVolumeID siteVolumeID) {
        return anchor.getSiteVolumeID().getSiteID() != siteVolumeID.getSiteID() && anchor.isSecondarySite();
    }

    private boolean isRoutedFromPrimaryToSecondary(Session anchor, SiteVolumeID siteVolumeID) {
        return anchor.getSiteVolumeID().getSiteID() != siteVolumeID.getSiteID() && anchor.isPrimarySite();
    }

    private boolean isHintBasedRoutingRequired() throws SQLException {
        Session anchor = this._connection.getSessionPool().getAnchorSession();
        if (anchor != null && this._tableLocations != null && this._tableLocations.length > 0) {
            SiteVolumeID siteVolumeID = new SiteVolumeID(this._tableLocations[0]);
            if (this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID)) {
                return true;
            }
            if (this.isRoutedFromSecondaryToPrimary(anchor, siteVolumeID)) {
                throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
            }
        } else if (anchor != null && this._parseInfo != null) {
            if (this._parseInfo.getHashPartitionInfo() != null) {
                Map<Integer, Integer> partitonMap = this._parseInfo.getHashPartitionInfo().getPartitionAssignmentMap();
                if (partitonMap.size() > 0) {
                    SiteVolumeID siteVolumeID = new SiteVolumeID(partitonMap.keySet().iterator().next());
                    if (this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID)) {
                        return true;
                    }
                    if (this.isRoutedFromSecondaryToPrimary(anchor, siteVolumeID)) {
                        throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
                    }
                }
            } else if (this._parseInfo.getRangePartitionInfo() != null) {
                RangeInfo rangeInfo = this._parseInfo.getRangePartitionInfo().getRangeInfoList().get(0);
                SiteVolumeID siteVolumeID = new SiteVolumeID(rangeInfo.getVolumeID());
                if (this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID)) {
                    return true;
                }
                if (this.isRoutedFromSecondaryToPrimary(anchor, siteVolumeID)) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.routing", new String[0]);
                }
            }
        }
        return false;
    }

    @Override
    public synchronized Session getSession(boolean avoidOpenSession, boolean handleTransaction) throws SQLException {
        boolean hintRouted;
        boolean bl = hintRouted = this.shouldHintBasedRoute() && this.isHintBasedRoutingRequired();
        if ((this._connection.getDistributionMode().isStatementRouting() || hintRouted) && this._tableLocations != null && this._tableLocations.length > 0) {
            SiteVolumeID siteVolumeID = new SiteVolumeID(this._tableLocations[(int)(this._tableLocationCounter.getNextID() % (long)this._tableLocations.length)]);
            if (siteVolumeID.isValid()) {
                Session anchor = this._connection.getSessionPool().getAnchorSession();
                if (this._Session.getLocation().isHSR() && this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID) && (!this.shouldHintBasedRoute() || !this._connection._isSecondaryReady())) {
                    siteVolumeID = this.getPrimarySiblingSiteVolumeID(siteVolumeID.getVolumeID());
                }
                if (!this._connection.getDistributionMode().isStatementRouting() && !this.isRoutedFromPrimaryToSecondary(anchor, siteVolumeID)) {
                    this._Session = this._connection.getSessionPool().getPrimarySession();
                } else {
                    Session session = this._connection.getSessionPool().getSession(siteVolumeID);
                    if (avoidOpenSession) {
                        if (session != null && session.isHintRouted()) {
                            this._connection._handleSuccessHintRouted();
                        }
                        return session != null ? session : this._Session;
                    }
                    if (session == null) {
                        try {
                            session = this._connection._openSession(siteVolumeID);
                        }
                        catch (SQLException e) {
                            if (anchor.isPrimarySite() && anchor.getSiteVolumeID().getSiteID() != siteVolumeID.getSiteID()) {
                                this._connection._handleFailedHintRouted();
                                siteVolumeID = this.getPrimarySiblingSiteVolumeID(siteVolumeID.getVolumeID());
                                try {
                                    session = this._connection._openSession(siteVolumeID);
                                }
                                catch (SQLException e1) {
                                    session = this._connection.getSessionPool().getPrimarySession();
                                }
                                if (session == null) {
                                    session = this._connection.getSessionPool().getPrimarySession();
                                }
                            }
                            throw e;
                        }
                        if (session == null) {
                            session = this._connection.getSessionPool().getPrimarySession();
                        }
                    }
                    this._Session = session;
                }
            }
        } else {
            this._Session = this._connection.getSessionPool().getPrimarySession();
        }
        if (handleTransaction) {
            this._connection.handleTransaction(this._Session, false);
        }
        if (this._Session.isHintRouted()) {
            this._connection._handleSuccessHintRouted();
        }
        return this._Session;
    }

    public SiteVolumeID getSiteVolumeID() {
        return this._Session.getSiteVolumeID();
    }

    @Override
    public StatementSapDB getStatementSapDB() {
        return this;
    }

    @Override
    public ResultSetSapDB getResultSetSapDB() {
        return this._currentResultSet;
    }

    public int[] getTableLocations() {
        return this._tableLocations;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeQuery") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeQuery", sql);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeQuery( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeUpdate( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("execute( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "addBatch") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "addBatch", sql);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("addBatch( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "clearBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearBatch", new Object[0]);
            }
            this._clearPreparedBatch();
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeBatch", new Object[0]);
            }
            int[] result = this._executePreparedBatch();
            if (on) {
                this._tracer.printResult(result);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, autoGeneratedKeys);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeUpdate( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, columnIndexes);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeUpdate( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeUpdate", sql, columnNames);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeUpdate( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, autoGeneratedKeys);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("execute( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, columnIndexes);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("execute( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "execute", sql, columnNames);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("execute( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnIndexes);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnNames);
                }
                throw CallableStatementSapDB._getNotCallableMethodException("executeLargeUpdate( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeQuery") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeQuery", new Object[0]);
            }
            ResultSet result = this._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", new Object[0]);
            }
            int result = this._executeUpdate();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", new Object[0]);
            }
            boolean result = this._execute();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterIndex, sqlType);
            }
            this._setNull(parameterIndex);
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, x);
            }
            this._setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType);
            }
            this._setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBoolean", parameterIndex, x);
            }
            this._setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setByte", parameterIndex, x);
            }
            this._setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setShort", parameterIndex, x);
            }
            this._setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setInt", parameterIndex, x);
            }
            this._setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setLong", parameterIndex, x);
            }
            this._setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFloat", parameterIndex, Float.valueOf(x));
            }
            this._setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDouble", parameterIndex, x);
            }
            this._setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBigDecimal", parameterIndex, x);
            }
            this._setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterIndex, x);
            }
            this._setDate(parameterIndex, x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterIndex, x);
            }
            this._setTime(parameterIndex, x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterIndex, x);
            }
            this._setTimestamp(parameterIndex, x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setString", parameterIndex, x);
            }
            this._setString(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBytes", parameterIndex, x);
            }
            this._setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, x, length);
            }
            this._setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setUnicodeStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setUnicodeStream", parameterIndex, x, length);
            }
            this._setUnicodeStream(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, x, length);
            }
            this._setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "clearParameters") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearParameters", new Object[0]);
            }
            this._clearParameters();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "addBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "addBatch", new Object[0]);
            }
            this._addBatch();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterIndex, sqlType, typeName);
            }
            this._setNull(parameterIndex);
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterIndex, x, cal);
            }
            this._setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterIndex, x, cal);
            }
            this._setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterIndex, x, cal);
            }
            this._setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, x, length);
            }
            this._setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, x);
            }
            this._setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, x);
            }
            this._setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setArray", parameterIndex, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setArray( int, Array )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRef", parameterIndex, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setRef( int, Ref )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "getMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            ResultSetMetaData result = this._getMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetMetaData resultSetMetaData = result;
            return resultSetMetaData;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setURL", parameterIndex, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setURL( int, URL )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "getParameterMetaData") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterMetaData", new Object[0]);
            }
            ParameterMetaData result = this._getParameterMetaData();
            if (on) {
                this._tracer.printResult(result);
            }
            ParameterMetaData parameterMetaData = result;
            return parameterMetaData;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType, scaleOrLength);
            }
            this._setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNString", parameterIndex, x);
            }
            this._setString(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, x);
            }
            this._setAsciiStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterIndex, x, length);
            }
            this._setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, x);
            }
            this._setCharacterStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterIndex, x, length);
            }
            this._setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterIndex, x);
            }
            this._setCharacterStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterIndex, x, length);
            }
            this._setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, x);
            }
            this._setBinaryStream(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterIndex, x, length);
            }
            this._setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, x);
            }
            this._setClob(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterIndex, x, length);
            }
            this._setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, x);
            }
            this._setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, x);
            }
            this._setClob(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterIndex, x, length);
            }
            this._setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, x);
            }
            this._setBlob(parameterIndex, x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterIndex, x, length);
            }
            this._setBlob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRowId", parameterIndex, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setRowId( int, RowId )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSQLXML", parameterIndex, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setSQLXML( int, SQLXML )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setObject( int, Object, SQLType )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterIndex, x, targetSqlType, scaleOrLength);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setObject( int, Object, SQLType, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("PreparedStatement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", new Object[0]);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("executeLargeUpdate()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "wasNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "wasNull", new Object[0]);
            }
            this.assertOpen();
            boolean result = this._wasNull();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getObject", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Object result = translator.getObject(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Object object = result;
            return object;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBoolean", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            boolean result = translator.getBoolean(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getByte", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            byte result = translator.getByte(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            byte by = result;
            return by;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getShort", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            short result = translator.getShort(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            short s = result;
            return s;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getInt", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            int result = translator.getInt(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getLong", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            long result = translator.getLong(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFloat", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            float result = translator.getFloat(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(Float.valueOf(result));
            }
            float f = result;
            return f;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDouble", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            double result = translator.getDouble(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            double d = result;
            return d;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterIndex, scale);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getString", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBytes", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            byte[] result = translator.getBytes(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(HexUtils.toDisplayHexString(result, 20));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType);
            }
            this._registerOutParameter(parameterIndex, sqlType, -1);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, scale);
            }
            this._registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterIndex, map);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, Map )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterIndex, cal);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterIndex, cal);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterIndex, cal);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClob", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Clob result = translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Clob clob = result;
            return clob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBlob", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Blob result = translator.getBlob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Blob blob = result;
            return blob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getArray( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRef( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, typeName);
            }
            this._registerOutParameter(parameterIndex, sqlType, -1);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getObject", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Object result = translator.getObject(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Object object = result;
            return object;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterName, map);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBoolean", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            boolean result = translator.getBoolean(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getByte", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            byte result = translator.getByte(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            byte by = result;
            return by;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getShort", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            short result = translator.getShort(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            short s = result;
            return s;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getInt", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            int result = translator.getInt(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getLong", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            long result = translator.getLong(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFloat", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            float result = translator.getFloat(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(Float.valueOf(result));
            }
            float f = result;
            return f;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDouble", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            double result = translator.getDouble(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            double d = result;
            return d;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            BigDecimal result = translator.getBigDecimal(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterName, cal);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Date result = translator.getDate(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterName, cal);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Time result = translator.getTime(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Time time = result;
            return time;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterName, cal);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Timestamp result = translator.getTimestamp(this, this._getDataPart(translator.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(result);
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getString", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBytes", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            byte[] result = translator.getBytes(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(HexUtils.toDisplayHexString(result, 20));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClob", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Clob result = translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Clob clob = result;
            return clob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBlob", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Blob result = translator.getBlob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Blob blob = result;
            return blob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getArray( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRef( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getURL( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getURL( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterName, sqlType);
            }
            this._setNull(this._getParameterTranslator(parameterName).getIndex());
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterName, sqlType, typeName);
            }
            this._setNull(this._getParameterTranslator(parameterName).getIndex());
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, x);
            }
            this._setObject(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, x, targetSqlType);
            }
            this._setObject(this._getParameterTranslator(parameterName).getIndex(), x, targetSqlType);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, x, targetSqlType, scale);
            }
            this._setObject(this._getParameterTranslator(parameterName).getIndex(), x, targetSqlType);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBoolean", parameterName, x);
            }
            this._setBoolean(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setByte", parameterName, x);
            }
            this._setByte(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setShort", parameterName, x);
            }
            this._setShort(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setInt", parameterName, x);
            }
            this._setInt(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setLong", parameterName, x);
            }
            this._setLong(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFloat", parameterName, Float.valueOf(x));
            }
            this._setFloat(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDouble", parameterName, x);
            }
            this._setDouble(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBigDecimal", parameterName, x);
            }
            this._setBigDecimal(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterName, x);
            }
            this._setDate(this._getParameterTranslator(parameterName).getIndex(), x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterName, x, cal);
            }
            this._setDate(this._getParameterTranslator(parameterName).getIndex(), x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterName, x);
            }
            this._setTime(this._getParameterTranslator(parameterName).getIndex(), x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterName, x, cal);
            }
            this._setTime(this._getParameterTranslator(parameterName).getIndex(), x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterName, x);
            }
            this._setTimestamp(this._getParameterTranslator(parameterName).getIndex(), x, null);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterName, x, cal);
            }
            this._setTimestamp(this._getParameterTranslator(parameterName).getIndex(), x, cal);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setString", parameterName, x);
            }
            this._setString(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBytes", parameterName, x);
            }
            this._setBytes(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, x, length);
            }
            this._setAsciiStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, x, length);
            }
            this._setCharacterStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, x, length);
            }
            this._setBinaryStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setURL(String parameterName, URL x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setURL", parameterName, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setURL( String, URL )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            this._registerOutParameter(this._getParameterTranslator(parameterName).getIndex(), sqlType, -1);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, scale);
            }
            this._registerOutParameter(this._getParameterTranslator(parameterName).getIndex(), sqlType, scale);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            this._registerOutParameter(this._getParameterTranslator(parameterName).getIndex(), sqlType, -1);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNString", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNString", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            String result = translator.getString(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Reader result = translator.getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Reader result = translator.getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            Reader result = translator.getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            Reader result = translator.getCharacterStream(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNClob", parameterIndex);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterIndex);
            NClob result = (NClob)translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            NClob nClob = result;
            return nClob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNClob", parameterName);
            }
            this.assertOpen();
            AbstractTranslator translator = this._getParameterTranslator(parameterName);
            NClob result = (NClob)translator.getClob(this, this._getDataPart(translator.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(result);
            }
            NClob nClob = result;
            return nClob;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRowId( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRowId( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getSQLXML( int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getSQLXML( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setNString(String parameterName, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNString", parameterName, x);
            }
            this._setString(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, x);
            }
            this._setAsciiStream(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, x, length);
            }
            this._setAsciiStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, x);
            }
            this._setCharacterStream(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, x, length);
            }
            this._setCharacterStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterName, x);
            }
            this._setCharacterStream(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterName, x, length);
            }
            this._setCharacterStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, x);
            }
            this._setBinaryStream(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, x, length);
            }
            this._setBinaryStream(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, x);
            }
            this._setClob(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setClob(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, x);
            }
            this._setClob(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setClob(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, x, length);
            }
            this._setClob(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNClob(String parameterName, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, x);
            }
            this._setClob(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNClob(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, x);
            }
            this._setClob(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setNClob(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, x, length);
            }
            this._setClob(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, x);
            }
            this._setBlob(this._getParameterTranslator(parameterName).getIndex(), x);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, x);
            }
            this._setBlob(this._getParameterTranslator(parameterName).getIndex(), x, -1L);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, x, length);
            }
            this._setBlob(this._getParameterTranslator(parameterName).getIndex(), x, length);
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRowId", parameterName, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setRowId( String, RowId )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSQLXML", parameterName, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setSQLXML( String, SQLXML )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterIndex, type);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, Class )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterName, type);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getObject( String, Class )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterName, x, targetSqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setObject( String, Object, SQLType )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterName, x, targetSqlType, scaleOrLength);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setObject( String, Object, SQLType, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( int, SQLType )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, scale);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( int, SQLType, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, typeName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( int, SQLType, String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( String, SQLType )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, scale);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( String, SQLType, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, typeName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( String, SQLType, String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public void assertControllerOpen() throws SQLException {
        if (this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected ResultSet _executeQuery() throws SQLException {
        this._execute();
        if (this._currentResultSet == null) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.noresultset", new String[0]);
        }
        return this._currentResultSet;
    }

    protected synchronized int _executeUpdate() throws SQLException {
        if (this._parseInfo != null && this._parseInfo.isSelect()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        this._execute();
        if (this._hasRowCount) {
            return this._rowsAffected;
        }
        return 0;
    }

    protected boolean _execute() throws SQLException {
        this.assertOpen();
        Session session = this.getSessionForExecute();
        return this._execute(session);
    }

    protected synchronized void _addBatch() throws SQLException {
        if (this._batchItems == null) {
            this._batchItems = new Vector();
        }
        ++this._batchSize;
        if (this.isClientRouting()) {
            Vector<Object> vect;
            SiteVolumeID siteVolumeID = this.computeVolumeID(this._rawInputArgs);
            if (this._batchVolumeMap.get(siteVolumeID) == null) {
                vect = new Vector<Object[]>();
                vect.add(this._inputArgs);
                this._batchVolumeMap.put(siteVolumeID, vect);
            } else {
                vect = this._batchVolumeMap.get(siteVolumeID);
                vect.add(this._inputArgs);
                this._batchVolumeMap.put(siteVolumeID, vect);
            }
        } else {
            this._batchItems.addElement(this._inputArgs);
        }
        Object[] nextRow = new Object[this._parseInfo.getParameterCount()];
        int n = this._parseInfo.getParameterCount();
        for (int i = 1; i <= n; ++i) {
            AbstractTranslator translator = this._parseInfo.getParameterTranslator(i);
            nextRow[i - 1] = translator.cloneObjectForBatch(this._inputArgs[i - 1]);
        }
        this._inputArgs = nextRow;
    }

    protected synchronized ResultSetMetaData _getMetaData() throws SQLException {
        if (this._parseInfo == null || !this._parseInfo.isSelect()) {
            return null;
        }
        List<AbstractTranslator> translators = this._parseInfo.getResultSetTranslators();
        if (translators == null) {
            return null;
        }
        return new ResultSetMetaDataSapDB(this._tracer, this._parseInfo);
    }

    protected synchronized ParameterMetaData _getParameterMetaData() throws SQLException {
        return new ParameterMetaDataSapDB(this._tracer, this._parseInfo.getParameterTranslators());
    }

    protected void _clearParameters() throws SQLException {
        for (int i = 0; i < this._inputArgs.length; ++i) {
            this._inputArgs[i] = "initParam";
            this._rawInputArgs[i] = "initParam";
        }
    }

    protected boolean _wasNull() throws SQLException {
        this.assertOpen();
        return this._connection.emptyTimestampIsNull() ? this._nullIndicator == DataFormatDescription.NullIndicator.NULL || this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL : this._nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    protected void _setNull(int parameterIndex) throws SQLException {
        this._inputArgs[parameterIndex - 1] = null;
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setObject(int parameterIndex, Object x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setObject(x);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case 4: {
                if (x instanceof Number) {
                    Number n = (Number)x;
                    this._setInt(parameterIndex, n.intValue());
                    return;
                }
            }
            case -5: {
                if (!(x instanceof Number)) break;
                Number n = (Number)x;
                this._setLong(parameterIndex, n.longValue());
                return;
            }
        }
        this._setObject(parameterIndex, x);
    }

    protected void _setBoolean(int parameterIndex, boolean x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setBoolean(x);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setByte(int parameterIndex, byte x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setByte(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = (long)x;
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? new BigDecimal(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam");
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 3) {
                this._rawInputArgs[parameterIndex - 1] = this.translateDecimalForHashing(String.valueOf(x), parameterIndex);
            } else if (columnType == 4 || columnType == -5 || columnType == 5) {
                this._rawInputArgs[parameterIndex - 1] = String.valueOf(x);
            } else if (columnType == -6) {
                if (x >= 0) {
                    this._rawInputArgs[parameterIndex - 1] = String.valueOf(x);
                } else {
                    int a = x + 256;
                    this._rawInputArgs[parameterIndex - 1] = String.valueOf(a);
                }
            } else if (columnType == -3 || columnType == -2) {
                byte[] b = new byte[1];
                if (x < 0) {
                    int a = x + 256;
                    String str = String.valueOf(a);
                    this._rawInputArgs[parameterIndex - 1] = str;
                } else {
                    b[0] = x;
                    this._rawInputArgs[parameterIndex - 1] = this.translateBinaryForHashing(b);
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam";
            }
        }
    }

    protected void _setShort(int parameterIndex, short x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setShort(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = (long)x;
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? new BigDecimal(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam");
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? this.translateDecimalForHashing(String.valueOf(x), parameterIndex) : (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6 ? String.valueOf(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam"));
        }
    }

    protected void _setInt(int parameterIndex, int x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setInt(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = (long)x;
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? new BigDecimal(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam");
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? this.translateDecimalForHashing(String.valueOf(x), parameterIndex) : (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6 ? String.valueOf(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam"));
        }
    }

    protected void _setLong(int parameterIndex, long x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setLong(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = x;
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? new BigDecimal(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam");
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = columnType == 3 ? this.translateDecimalForHashing(String.valueOf(x), parameterIndex) : (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6 ? String.valueOf(x) : (columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam"));
        }
    }

    protected void _setFloat(int parameterIndex, float x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setFloat(x);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setDouble(int parameterIndex, double x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setDouble(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    long lVal = (long)x;
                    this._rawInputArgs[parameterIndex - 1] = lVal;
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else if (columnType == 3) {
                int scale = this._getParameterTranslator(parameterIndex).getScale();
                if (scale == 0) {
                    long lVal = (long)x;
                    this._rawInputArgs[parameterIndex - 1] = new BigDecimal(lVal);
                } else {
                    String decString = this.translateDecimalForHashing(String.valueOf(x), parameterIndex);
                    this._rawInputArgs[parameterIndex - 1] = decString == null || decString.equalsIgnoreCase("initParam") ? "initParam" : new BigDecimal(decString);
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam";
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (columnType == 3) {
                int scale = this._getParameterTranslator(parameterIndex).getScale();
                this._rawInputArgs[parameterIndex - 1] = scale == 0 ? this.translateDecimalForHashing(String.valueOf((int)x), parameterIndex) : this.translateDecimalForHashing(String.valueOf(x), parameterIndex);
            } else if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                long iVal = (long)x;
                this._rawInputArgs[parameterIndex - 1] = String.valueOf(iVal);
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 12 || columnType == -9 || columnType == -15 ? String.valueOf(x) : "initParam";
            }
        }
    }

    protected void _setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setBigDecimal(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (x == null) {
                this._rawInputArgs[parameterIndex - 1] = null;
            } else if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = x.longValue();
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else if (columnType == 3) {
                int scale = this._getParameterTranslator(parameterIndex).getScale();
                this._rawInputArgs[parameterIndex - 1] = x.setScale(scale, RoundingMode.FLOOR);
            } else {
                this._rawInputArgs[parameterIndex - 1] = "initParam";
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = x == null ? "initParam" : (columnType == 3 ? this.translateDecimalForHashing(x.toString(), parameterIndex) : (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6 ? String.valueOf(x.longValue()) : "initParam"));
        }
    }

    protected void _setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setDate(x, cal);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setTime(x, cal);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setTimestamp(x, cal);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = x == null ? null : (columnType == 93 ? x : "initParam");
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = x == null ? "initParam" : (columnType == 93 ? x.toString() : "initParam");
        }
    }

    protected void _setString(int parameterIndex, String x) throws SQLException {
        Object arg;
        this.assertOpen();
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setString(x);
        if (this.isClientRoutingByRange() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (x == null) {
                this._rawInputArgs[parameterIndex - 1] = null;
            } else if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = Long.valueOf(x.trim());
                }
                catch (NumberFormatException e) {
                    x = x.replaceAll("[^0-9-.]", "");
                    try {
                        this._rawInputArgs[parameterIndex - 1] = Long.valueOf(x.trim());
                    }
                    catch (NumberFormatException e1) {
                        this._rawInputArgs[parameterIndex - 1] = "initParam";
                    }
                }
            } else if (columnType == 3) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = new BigDecimal(x);
                }
                catch (NumberFormatException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else if (columnType == 12 || columnType == -9 || columnType == -15) {
                this._rawInputArgs[parameterIndex - 1] = x;
            } else if (columnType == 93) {
                try {
                    this._rawInputArgs[parameterIndex - 1] = Timestamp.valueOf(x);
                }
                catch (IllegalArgumentException e) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = "initParam";
            }
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            if (x == null) {
                this._rawInputArgs[parameterIndex - 1] = "initParam";
            } else if (columnType == 3) {
                int scale = this._getParameterTranslator(parameterIndex).getScale();
                BigDecimal bd = new BigDecimal(x);
                if (bd.scale() > scale) {
                    this._rawInputArgs[parameterIndex - 1] = "initParam";
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat();
                    decimalFormat.setMinimumIntegerDigits(1);
                    decimalFormat.setMaximumFractionDigits(scale);
                    decimalFormat.setMinimumFractionDigits(scale);
                    decimalFormat.setDecimalSeparatorAlwaysShown(false);
                    decimalFormat.setGroupingUsed(false);
                    this._rawInputArgs[parameterIndex - 1] = decimalFormat.format(bd);
                }
            } else if (columnType == 93) {
                if ((x = x.trim()).contains(".")) {
                    int pos = x.indexOf(".");
                    this._rawInputArgs[parameterIndex - 1] = pos != 0 && x.charAt(pos - 1) == ' ' ? "initParam" : (pos < x.length() && x.charAt(pos + 1) == ' ' ? "initParam" : x);
                }
            } else if (columnType == 4 || columnType == -5 || columnType == 5 || columnType == -6) {
                if ((x = x.trim()).startsWith("-0") || x.startsWith("+0")) {
                    int pos;
                    StringBuilder buffer = new StringBuilder();
                    if (x.charAt(0) == '-') {
                        buffer.append('-');
                    }
                    for (pos = 1; pos < x.length() && x.charAt(pos) == '0'; ++pos) {
                    }
                    if (pos == x.length()) {
                        buffer.append('0');
                    } else {
                        buffer.append(x.substring(pos));
                    }
                    this._rawInputArgs[parameterIndex - 1] = buffer.toString();
                } else {
                    StringBuilder buffer = new StringBuilder();
                    int pos = 0;
                    if (x.length() > 0 && x.charAt(0) == '+') {
                        ++pos;
                    }
                    while (pos < x.length() && x.charAt(pos) == '0') {
                        ++pos;
                    }
                    if (pos == x.length()) {
                        buffer.append('0');
                    } else {
                        buffer.append(x.substring(pos));
                    }
                    this._rawInputArgs[parameterIndex - 1] = buffer.toString();
                }
            } else {
                this._rawInputArgs[parameterIndex - 1] = columnType == 12 || columnType == -9 || columnType == -15 ? x : "initParam";
            }
        }
    }

    protected void _setBytes(int parameterIndex, byte[] x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setBytes(x);
        if (this.isClientRoutingByRange()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        } else if (this.isClientRoutingByHash() && this._partitionParamIndexList.contains(parameterIndex)) {
            int columnType = this._getParameterTranslator(parameterIndex).getColumnType();
            this._rawInputArgs[parameterIndex - 1] = columnType == -3 || columnType == -2 ? this.translateBinaryForHashing(x) : "initParam";
        }
    }

    protected void _setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setAsciiStream(x, length);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setUnicodeStream(int parameterIndex, InputStream x) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setUnicodeStream(x);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setCharacterStream(x, length);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setBinaryStream(x, length);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setClob(int i, Clob x) throws SQLException {
        Object arg;
        this._inputArgs[i - 1] = arg = this._getParameterTranslator(i).setClob(x);
        if (this.isClientRouting()) {
            this._rawInputArgs[i - 1] = "initParam";
        }
    }

    protected void _setClob(int parameterIndex, Reader x, long length) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setCharacterStream(x, length);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    protected void _setBlob(int i, Blob x) throws SQLException {
        Object arg;
        this._inputArgs[i - 1] = arg = this._getParameterTranslator(i).setBlob(x);
        if (this.isClientRouting()) {
            this._rawInputArgs[i - 1] = "initParam";
        }
    }

    protected void _setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this._inputArgs[parameterIndex - 1] = arg = this._getParameterTranslator(parameterIndex).setBinaryStream(x, length);
        if (this.isClientRouting()) {
            this._rawInputArgs[parameterIndex - 1] = "initParam";
        }
    }

    private static SQLException _getNotCallableMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.notcallable", methodSignature, "Statement", "PreparedStatement");
    }

    private static class PutvalComparator
    implements Comparator<AbstractPutval> {
        private PutvalComparator() {
        }

        @Override
        public int compare(AbstractPutval p1, AbstractPutval p2) {
            int p1InputFieldPos = p1.getInputFieldPos();
            int p2InputFieldPos = p2.getInputFieldPos();
            return p1InputFieldPos - p2InputFieldPos;
        }
    }
}

