/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RollingAverages
extends MutableMetric
implements Closeable {
    private final MutableRatesWithAggregation innerMetrics = new MutableRatesWithAggregation();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RollingAverages-%d").build());
    private ScheduledFuture<?> scheduledTask = null;
    @Nullable
    private Map<String, MutableRate> currentSnapshot;
    private final int numWindows;
    private final String avgInfoNameTemplate;
    private final String avgInfoDescTemplate;
    private ConcurrentMap<String, LinkedBlockingDeque<SumAndCount>> averages = new ConcurrentHashMap<String, LinkedBlockingDeque<SumAndCount>>();

    public RollingAverages(long windowSizeMs, int numWindows, String valueName) {
        String uvName = StringUtils.capitalize(valueName);
        String lvName = StringUtils.uncapitalize(valueName);
        this.avgInfoNameTemplate = "[%s]RollingAvg" + uvName;
        this.avgInfoDescTemplate = "Rolling average " + lvName + " for " + "%s";
        this.numWindows = numWindows;
        this.scheduledTask = SCHEDULER.scheduleAtFixedRate(new RatesRoller(this), windowSizeMs, windowSizeMs, TimeUnit.MILLISECONDS);
    }

    public RollingAverages(long windowSizeMs, int numWindows) {
        this(windowSizeMs, numWindows, "Time");
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            for (Map.Entry entry : this.averages.entrySet()) {
                String name = (String)entry.getKey();
                MetricsInfo avgInfo = Interns.info(String.format(this.avgInfoNameTemplate, StringUtils.capitalize(name)), String.format(this.avgInfoDescTemplate, StringUtils.uncapitalize(name)));
                double totalSum = 0.0;
                long totalCount = 0L;
                for (SumAndCount sumAndCount : (LinkedBlockingDeque)entry.getValue()) {
                    totalCount += sumAndCount.getCount();
                    totalSum += sumAndCount.getSum();
                }
                if (totalCount == 0L) continue;
                builder.addGauge(avgInfo, totalSum / (double)totalCount);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    public void collectThreadLocalStates() {
        this.innerMetrics.collectThreadLocalStates();
    }

    public void add(String name, long value) {
        this.innerMetrics.add(name, value);
    }

    private synchronized void rollOverAvgs() {
        if (this.currentSnapshot == null) {
            return;
        }
        for (Map.Entry<String, MutableRate> entry : this.currentSnapshot.entrySet()) {
            SumAndCount sumAndCount;
            MutableRate rate = entry.getValue();
            LinkedBlockingDeque<SumAndCount> deque = (LinkedBlockingDeque<SumAndCount>)this.averages.get(entry.getKey());
            if (deque == null) {
                deque = new LinkedBlockingDeque<SumAndCount>(this.numWindows);
                this.averages.put(entry.getKey(), deque);
            }
            if (deque.offerLast(sumAndCount = new SumAndCount(rate.lastStat().total(), rate.lastStat().numSamples()))) continue;
            deque.pollFirst();
            deque.offerLast(sumAndCount);
        }
        this.setChanged();
    }

    @Override
    public void close() throws IOException {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        this.scheduledTask = null;
    }

    public synchronized Map<String, Double> getStats(long minSamples) {
        HashMap<String, Double> stats = new HashMap<String, Double>();
        for (Map.Entry entry : this.averages.entrySet()) {
            String name = (String)entry.getKey();
            double totalSum = 0.0;
            long totalCount = 0L;
            for (SumAndCount sumAndCount : (LinkedBlockingDeque)entry.getValue()) {
                totalCount += sumAndCount.getCount();
                totalSum += sumAndCount.getSum();
            }
            if (totalCount <= minSamples) continue;
            stats.put(name, totalSum / (double)totalCount);
        }
        return stats;
    }

    private static class RatesRoller
    implements Runnable {
        private final RollingAverages parent;

        public RatesRoller(RollingAverages parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RollingAverages rollingAverages = this.parent;
            synchronized (rollingAverages) {
                MetricsCollectorImpl mc = new MetricsCollectorImpl();
                MetricsRecordBuilderImpl rb = mc.addRecord("RatesRoller");
                this.parent.innerMetrics.snapshot(rb, true);
                Preconditions.checkState(mc.getRecords().size() == 1, "There must be only one record and it's named with 'RatesRoller'");
                this.parent.currentSnapshot = this.parent.innerMetrics.getGlobalMetrics();
                this.parent.rollOverAvgs();
            }
            this.parent.setChanged();
        }
    }

    private static class SumAndCount {
        private final double sum;
        private final long count;

        public SumAndCount(double sum, long count) {
            this.sum = sum;
            this.count = count;
        }

        public double getSum() {
            return this.sum;
        }

        public long getCount() {
            return this.count;
        }
    }
}

