/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EFTimePicker {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = EFTimePicker.generateDefaultOption();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String clazzName = EFTimePicker.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append(" <meta http-equiv='pragma' content='no-cache'>");
                sb.append(" <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append(" <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/layui/css/layui.css' media='all'>");
                sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/semantic/css/semantic.min.css' media='all'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/layui/layui.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/semantic/semantic.js'></script>");
                sb.append("<style>");
                sb.append("        html, body {");
                sb.append("    width: 100%;");
                sb.append("    border: 0px;");
                sb.append("    margin: 0px;");
                sb.append("    padding: 0px;");
                sb.append("     height: 100%;");
                sb.append(" }");
                sb.append("</style>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;width:100%;height:100%;'>");
                sb.append("<div style='margin:0px;padding:0px;width:100%;height:100%;display:flex;justify-content: center; align-items: center;'>");
                sb.append("<div class='ui icon input' style='width:100%;height:100%;'>\n            <input type='text' id='timePicker' name='operationType' class='ef-input' placeholder='\u8bf7\u8f93\u5165\u65f6\u95f4'>\n            <i class='calendar alternate outline icon'></i>\n        </div>");
                sb.append("</div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFTimePicker.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        String repaintRegions;
        JSONObject repaintRegionsObj;
        String formatF;
        String typeF;
        String fontSize;
        String textColor;
        String backColor;
        String borderColor;
        String format;
        String type;
        String inputHeight;
        StringBuffer sb = new StringBuffer();
        path = path.replace(".html", ".plugin");
        JSONObject optionJ = JSONObject.parseObject((String)option);
        JSONObject optionJson = optionJ.getJSONObject("saveJson");
        if (optionJson == null) {
            inputHeight = "30";
            type = "yyyyMMdd";
            format = "1";
            borderColor = "#22242626";
            backColor = "#ffffff";
            textColor = "#000000de";
            fontSize = "14";
        } else {
            inputHeight = optionJson.getString("height");
            type = optionJson.getString("type");
            format = optionJson.getString("format");
            borderColor = optionJson.getString("borderColor");
            backColor = optionJson.getString("backColor");
            textColor = optionJson.getString("textColor");
            fontSize = optionJson.getString("fontSize");
        }
        String css = "height:" + inputHeight + "px;";
        css = css + "font-size:" + fontSize + "px;";
        css = css + "border:1px solid " + borderColor + ";";
        css = css + "background-color:" + backColor + ";";
        css = css + "color:" + textColor + ";";
        if (type.equals("yyyyMM")) {
            typeF = "month";
            formatF = format.equals("1") ? "yyyyMM" : (format.equals("2") ? "yyyy-MM" : "yyyy/MM");
        } else if (type.equals("yyyyMMdd")) {
            typeF = "date";
            formatF = format.equals("1") ? "yyyyMMdd" : (format.equals("2") ? "yyyy-MM-dd" : "yyyy/MM/dd");
        } else {
            typeF = "datetime";
            formatF = format.equals("1") ? "yyyyMMdd HH:mm:ss" : (format.equals("2") ? "yyyy-MM-dd HH:mm:ss" : "yyyy/MM/dd HH:mm:ss");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        cssArray.add((Object)(jsResourcePath + "/layui/css/layui.css"));
        cssArray.add((Object)(jsResourcePath + "/semantic/css/semantic.min.css"));
        cssBuffer.append(cssArray.toString());
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/layui/layui.js"));
        jsArray.add((Object)(jsResourcePath + "/semantic/semantic.min.js"));
        jsBuffer.append(jsArray.toString());
        String uuid = String.valueOf(System.currentTimeMillis());
        domBuffer.append("<div style='margin:0px;padding:0px;width:100%;height:100%;display:flex;justify-content: center; align-items: flex-start;'>");
        domBuffer.append("<div class='ui icon input' style='width:100%;height:100%;'>");
        domBuffer.append("<input type='text' id='timePicker_" + uuid + "' style='" + css + "' class='ef-input' placeholder='\u8bf7\u8f93\u5165\u65f6\u95f4'>");
        domBuffer.append("</div>");
        domBuffer.append("</div>");
        scriptBuffer.append(" layui.use(['laydate'], function () {var $ = layui.jquery,form = layui.form,laydate = layui.laydate;laydate.render({elem: '#timePicker_" + uuid + "',type: '" + typeF + "',format: '" + formatF + "',value: new Date(),done:function(area,date,endDate){console.log('change');");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray = [];");
            scriptBuffer.append("var obj = {};");
            scriptBuffer.append("var paramExpression ;");
            JSONObject hyperLinkObj = hyperLinkArray.getJSONObject(0);
            Set keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray.push(obj);");
            scriptBuffer.append("var changeParam='';var hyperParam = paramExpression;var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + area + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + area + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + area + ';')  }else if(value == 'CONTROLVALUE'){  }  else if(value == 'XAXIS'){  }  else if(value == 'YAXIS'){  }  else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray)");
        }
        if ((repaintRegionsObj = JSONObject.parseObject((String)(repaintRegions = reportInfoObj.getString("repaintRegions")))) != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + area + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + area + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + area + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("CONTROLVALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + area+ ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("X-AXIS".equals(key) || "Y-AXIS".equals(key)) continue;
                String val = paramStrs[1].replaceAll("'", "");
                String echartParam2 = paramStrs[0] + "=" + val + ";";
                echartSb.append(echartParam2);
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,45,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')");
        }
        scriptBuffer.append("}});});");
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        JSONObject optionObj = JSONObject.parseObject((String)option);
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-4.1.0.min.js'></script>");
        sb.append("<style>");
        sb.append("        html, body {");
        sb.append("    width: 100%;");
        sb.append("    border: 0px;");
        sb.append("    margin: 0px;");
        sb.append("    padding: 0px;");
        sb.append("     height: 100%;");
        sb.append("     background-color: transparent;");
        sb.append(" }");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = tempPath + File.separator + fileName;
        String pngPath = tempPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (htmlPath.contains(":")) {
                htmlPath = htmlPath.substring(1, htmlPath.length());
                pngPath = pngPath.substring(1, pngPath.length());
            }
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            int result = engine.Er_ExportPluginImage(htmlPath = htmlPath.replaceAll("//", "/"), 0, 0, width, height, pngPath = pngPath.replaceAll("//", "/"));
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u65e5\u671f\u9009\u62e9\u63d2\u4ef6";
    }

    public static String getClassName() {
        return "EFTimePicker";
    }

    public static void main(String[] args) {
        System.out.println(EFTimePicker.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        return option;
    }
}

