/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;

public class DB2Socket {
    private Socket socket;
    protected DB2Connection connection;
    protected DataInputStream receiveStream;
    protected DataOutputStream sendStream;
    protected boolean closed = false;
    boolean pendingReadOnSocket = false;
    int firstByteReceived = -1;

    public DB2Socket(Socket socket, DB2Connection dB2Connection) throws IOException {
        this.connection = dB2Connection;
        this.socket = socket;
        this.receiveStream = new DataInputStream(this.socket.getInputStream());
        this.sendStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.sendStream.writeBytes("ValidDb2jdTokenFromTheClientSide");
    }

    public DB2Socket(Socket socket) throws IOException {
        this(socket, null);
    }

    protected synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.receiveStream != null) {
                    this.receiveStream.close();
                }
                if (this.sendStream != null) {
                    this.sendStream.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public DB2Socket(InputStream inputStream, OutputStream outputStream, DB2Connection dB2Connection) {
        this.receiveStream = new DataInputStream(inputStream);
        this.sendStream = new DataOutputStream(outputStream);
        this.connection = dB2Connection;
        this.socket = null;
    }

    public synchronized byte[] send(byte[] byArray) throws SQLException {
        int n = 0;
        this.sendToServer(byArray);
        if (!this.pendingReadOnSocket) {
            int n2;
            int n3;
            int n4;
            byte[] byArray2 = new byte[4];
            try {
                n4 = this.receiveStream.read();
                n3 = this.receiveStream.read();
                n2 = this.receiveStream.read();
                int n5 = this.receiveStream.read();
                if (-1 == n4 || -1 == n3 || -1 == n2 || -1 == n5) {
                    new SQLExceptionGenerator(this.connection).socketException("08S01b");
                }
                n = n4 << 24 | n3 << 16 | n2 << 8 | n5;
            }
            catch (IOException iOException) {
                new SQLExceptionGenerator(this.connection).socketException("08S01b");
            }
            byte[] byArray3 = new byte[n];
            n4 = 0;
            n3 = 0;
            n2 = 0;
            try {
                while (n4 < n) {
                    n2 = this.receiveStream.read(byArray3, n4, n - n4);
                    n4 += n2;
                }
            }
            catch (IOException iOException) {
                new SQLExceptionGenerator(this.connection).socketException("08S01");
            }
            return byArray3;
        }
        SQLExceptionGenerator.throwReceiveError();
        return null;
    }

    public synchronized void sendAsync(byte[] byArray) throws SQLException {
        this.sendToServer(byArray);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean isReceivingData(int var1_1) throws SQLException {
        block17: {
            var2_2 = false;
            this.firstByteReceived = -1;
            if (var1_1 >= 0) {
                try {
                    this.socket.setSoTimeout(var1_1);
                }
                catch (SocketException var3_3) {
                    // empty catch block
                }
            }
            try {
                this.firstByteReceived = this.receiveStream.read();
                var2_2 = true;
                var6_5 = null;
                ** if (var1_1 < 0) goto lbl-1000
            }
            catch (Throwable var5_14) {
                var6_8 = null;
                if (var1_1 >= 0) {
                    try {
                        this.socket.setSoTimeout(0);
                    }
                    catch (SocketException var7_12) {
                        var7_12.printStackTrace();
                    }
                }
                throw var5_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.socket.setSoTimeout(0);
                }
                catch (SocketException var7_9) {
                    var7_9.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (InterruptedIOException var3_4) {
                    var2_2 = false;
                    var6_6 = null;
                    if (var1_1 >= 0) {
                        try {
                            this.socket.setSoTimeout(0);
                        }
                        catch (SocketException var7_10) {
                            var7_10.printStackTrace();
                        }
                    }
                    break block17;
                }
                catch (IOException var4_13) {
                    new SQLExceptionGenerator(this.connection).socketException("08S01b");
                    var6_7 = null;
                    if (var1_1 >= 0) {
                        try {
                            this.socket.setSoTimeout(0);
                        }
                        catch (SocketException var7_11) {
                            var7_11.printStackTrace();
                        }
                    }
                }
            }
        }
        this.pendingReadOnSocket = var2_2 == false;
        return var2_2;
    }

    public synchronized byte[] receiveData() throws SQLException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        try {
            this.socket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        byte[] byArray = new byte[4];
        try {
            int n4 = this.firstByteReceived == -1 ? this.receiveStream.read() : this.firstByteReceived;
            int n5 = this.receiveStream.read();
            int n6 = this.receiveStream.read();
            int n7 = this.receiveStream.read();
            if (-1 == n4 || -1 == n5 || -1 == n6 || -1 == n7) {
                new SQLExceptionGenerator(this.connection).socketException("08S01b");
            }
            n3 = n4 << 24 | n5 << 16 | n6 << 8 | n7;
        }
        catch (IOException iOException) {
            new SQLExceptionGenerator(this.connection).socketException("08S01b");
        }
        byte[] byArray2 = new byte[n3];
        try {
            while (n < n3) {
                n2 = this.receiveStream.read(byArray2, n, n3 - n);
                n += n2;
            }
        }
        catch (IOException iOException) {
            new SQLExceptionGenerator(this.connection).socketException("08S01");
        }
        return byArray2;
    }

    protected void sendToServer(byte[] byArray) throws SQLException {
        try {
            DataOutputStream dataOutputStream = this.sendStream;
            synchronized (dataOutputStream) {
                this.sendStream.write(byArray, 0, byArray.length);
                this.sendStream.flush();
            }
        }
        catch (IOException iOException) {
            new SQLExceptionGenerator(this.connection).socketException("08S01a");
        }
    }

    public DB2Connection getConnection() {
        return this.connection;
    }
}

