/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2RequestOutputBuffer;
import COM.ibm.db2.jdbc.net.DB2Socket;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class DB2Request {
    protected DB2Socket db2socket;
    protected static boolean debug = false;
    protected static int inBufferSize = 32768;
    protected static int outBufferSize = 32764;
    protected byte[] inBuffer = new byte[inBufferSize];
    protected DataInputStream inMemory = new DataInputStream(new ByteArrayInputStream(this.inBuffer));
    protected int outTotalLength = 0;
    protected int outCurrentLength = 0;
    protected DB2RequestOutputBuffer outBuffer = new DB2RequestOutputBuffer();
    protected Vector outBufferChain = new Vector(5, 5);
    protected int outBufferChainPos = 0;
    protected int outBufferChainLen = 1;
    protected boolean closed = false;

    public DB2Request(DB2Socket dB2Socket) {
        this.db2socket = dB2Socket;
        this.outBufferChain.addElement(this.outBuffer);
    }

    public DB2Request(DB2Request dB2Request) {
        this.db2socket = dB2Request.db2socket;
        this.outBufferChain.addElement(this.outBuffer);
    }

    public DB2Request(DB2Connection dB2Connection) {
        this.db2socket = dB2Connection.db2socket;
        this.outBufferChain.addElement(this.outBuffer);
    }

    protected void nextOutputBuffer() {
        this.outTotalLength += this.outBuffer.outBuf.size();
        ++this.outBufferChainPos;
        if (debug) {
            System.err.println("nextOutputBuffer: outTotalLength = " + this.outTotalLength + " position = " + this.outBufferChainPos);
        }
        if (this.outBufferChainPos < this.outBufferChainLen) {
            if (debug) {
                System.err.println("nextOutputBuffer: Re-using element # " + this.outBufferChainPos);
            }
            this.outBuffer = (DB2RequestOutputBuffer)this.outBufferChain.elementAt(this.outBufferChainPos);
        } else {
            this.outBuffer = new DB2RequestOutputBuffer();
            this.outBufferChain.addElement(this.outBuffer);
            ++this.outBufferChainLen;
            if (debug) {
                System.err.println("nextOutputBuffer: created new element length =  " + this.outBufferChainLen);
            }
        }
    }

    public void write(short s) throws IOException {
        this.outCurrentLength += 2;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 2;
        }
        if (debug) {
            System.err.println("write( short = " + s + ")");
        }
        this.outBuffer.outMemory.writeShort(s);
    }

    public void write(int n) throws IOException {
        this.outCurrentLength += 4;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 4;
        }
        if (debug) {
            System.err.println("write( int = " + n + ")");
        }
        this.outBuffer.outMemory.writeInt(n);
    }

    public void write(long l) throws IOException {
        this.outCurrentLength += 8;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 8;
        }
        if (debug) {
            System.err.println("write( long = " + l + ")");
        }
        this.outBuffer.outMemory.writeLong(l);
    }

    public void write(float f) throws IOException {
        if (debug) {
            System.err.println("write( float = " + f + ")");
        }
        this.outCurrentLength += 4;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 4;
        }
        this.outBuffer.outMemory.writeFloat(f);
    }

    public void write(double d) throws IOException {
        if (debug) {
            System.err.println("write( double = " + d + ")");
        }
        this.outCurrentLength += 8;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 8;
        }
        this.outBuffer.outMemory.writeDouble(d);
    }

    public void write(boolean bl) throws IOException {
        if (debug) {
            System.err.println("write( boolean = " + bl + ")");
        }
        if (bl) {
            this.write((short)1);
        } else {
            this.write((short)0);
        }
    }

    public void write(char c) throws IOException {
        this.outCurrentLength += 2;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 2;
        }
        if (debug) {
            System.err.println("write( char = " + c + ")");
        }
        this.outBuffer.outMemory.writeChar(c);
    }

    public void write(String string) throws IOException {
        if (string == null) {
            this.write(-1);
            return;
        }
        int n = string.length();
        this.write(n);
        int n2 = 2 * n;
        this.outCurrentLength += n2;
        if (this.outCurrentLength <= outBufferSize) {
            if (debug) {
                System.err.println("write( String = \"" + string + "\", len = " + n + ")");
            }
            this.outBuffer.outMemory.writeChars(string);
        } else {
            this.outCurrentLength -= n2;
            int n3 = (outBufferSize - this.outCurrentLength) / 2;
            int n4 = 0;
            String string2 = null;
            while (n > 0) {
                if (n3 < 1) {
                    this.nextOutputBuffer();
                    this.outCurrentLength = 0;
                    n3 = outBufferSize / 2;
                }
                if (n3 >= n) {
                    if (debug) {
                        System.err.println("Filling last chars length = " + n);
                    }
                    string2 = 0 == n4 ? string : string.substring(n4, n4 + n);
                    this.outCurrentLength += n * 2;
                    n = 0;
                } else {
                    if (debug) {
                        System.err.println("Filling entire buffer length = " + n3 * 2);
                    }
                    string2 = string.substring(n4, n4 + n3);
                    n -= n3;
                    n4 += n3;
                    n3 = 0;
                }
                this.outBuffer.outMemory.writeChars(string2);
                if (!debug) continue;
                System.err.println("No. of chars written to the buffer = " + string2.length() + " char position = " + n4);
            }
        }
    }

    public void writeASCII(String string) throws IOException {
        int n = string.length();
        if (debug) {
            System.err.println("writeASCII( String = \"" + string + "\", len = " + n + ")");
        }
        char[] cArray = new char[n];
        byte[] byArray = new byte[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(cArray[n2] & 0xFF);
            ++n2;
        }
        this.write(byArray, n);
    }

    public void write(byte by) throws IOException {
        ++this.outCurrentLength;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 1;
        }
        if (debug) {
            System.err.println("write( byte = " + by + ")");
        }
        this.outBuffer.outMemory.write(by);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n = byArray.length;
        this.write(byArray, n);
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.outCurrentLength += 4 + n;
        if (this.outCurrentLength <= outBufferSize) {
            if (debug) {
                System.err.print("write( byte len = " + n + " bytes = ->");
                int n2 = 0;
                while (n2 < n) {
                    System.err.print(byArray[n2]);
                    ++n2;
                }
                System.err.println("<-");
            }
            this.outBuffer.outMemory.writeInt(n);
            this.outBuffer.outMemory.write(byArray, 0, n);
        } else {
            if (debug) {
                System.err.println("write byte[] spanning MULTIPLE buffers!!");
            }
            this.outCurrentLength -= 4 + n;
            this.write(n);
            int n3 = outBufferSize - this.outCurrentLength;
            this.outBuffer.outMemory.write(byArray, 0, n3);
            int n4 = n3;
            while ((n -= n3) > 0) {
                if (debug) {
                    System.err.println("Remaining length in buffer = " + n3 + " buffer position = " + n4);
                }
                this.nextOutputBuffer();
                if (outBufferSize > n) {
                    if (debug) {
                        System.err.println("Filling last bits length = " + n);
                    }
                    this.outBuffer.outMemory.write(byArray, n4, n);
                    this.outCurrentLength = n;
                    n3 = n;
                    continue;
                }
                if (debug) {
                    System.err.println("Filling entire buffer length = " + outBufferSize);
                }
                n3 = outBufferSize;
                this.outBuffer.outMemory.write(byArray, n4, n3);
                n4 += n3;
            }
        }
    }

    public short readShort() throws IOException {
        short s = this.inMemory.readShort();
        if (debug) {
            System.err.println("readShort - rValue = " + s);
        }
        return s;
    }

    public int readInt() throws IOException {
        int n = this.inMemory.readInt();
        if (debug) {
            System.err.println("readInt - rValue = " + n);
        }
        return n;
    }

    public long readLong() throws IOException {
        long l = this.inMemory.readLong();
        if (debug) {
            System.err.println("readLong - rValue = " + l);
        }
        return l;
    }

    public float readFloat() throws IOException {
        float f = this.inMemory.readFloat();
        return f;
    }

    public double readDouble() throws IOException {
        double d = this.inMemory.readDouble();
        return d;
    }

    public boolean readBoolean() throws IOException {
        boolean bl = true;
        short s = this.readShort();
        if (s == 0) {
            bl = false;
        }
        if (debug) {
            System.err.println("readBoolean - rValue = " + bl);
        }
        return bl;
    }

    public byte readByte() throws IOException {
        byte by = this.inMemory.readByte();
        if (debug) {
            System.err.println("readByte - rValue = " + by);
        }
        return by;
    }

    public char readChar() throws IOException {
        char c = this.inMemory.readChar();
        if (debug) {
            System.err.println("readChar - rValue = " + c);
        }
        return c;
    }

    public String readString() throws IOException {
        int n = this.inMemory.readInt();
        int n2 = n / 2;
        if (debug) {
            System.err.println("readString - byte length = " + n + " char length = " + n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = this.inMemory.readChar();
            ++n3;
        }
        String string = new String(cArray);
        if (debug) {
            System.err.println("readString - rValue = " + string);
        }
        return string;
    }

    public String readASCIIString() throws IOException {
        int n = this.inMemory.readInt();
        if (debug) {
            System.err.println("readASCIIString - length = " + n);
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)this.inMemory.readByte();
            if (debug) {
                System.err.println("readASCIIString - reading byte " + n2 + " value = " + cArray[n2]);
            }
            ++n2;
        }
        String string = new String(cArray);
        if (debug) {
            System.err.println("readASCIIString - rValue = " + string);
        }
        return string;
    }

    public byte[] readBytes() throws IOException {
        int n = this.inMemory.readInt();
        if (debug) {
            System.err.println("readBytes - length = " + n);
        }
        byte[] byArray = new byte[n];
        this.inMemory.readFully(byArray, 0, n);
        if (debug) {
            System.err.print("bytes = ->");
            int n2 = 0;
            while (n2 < n) {
                System.err.print(byArray[n2]);
                ++n2;
            }
            System.err.println("<-");
        }
        return byArray;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.inMemory.close();
                this.outBuffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inMemory = null;
            this.outBuffer = null;
            this.outBufferChain.removeAllElements();
            this.outBufferChain = null;
            this.db2socket = null;
        }
    }

    public void sendAndRecv() throws SQLException {
        DB2Socket dB2Socket = this.db2socket;
        synchronized (dB2Socket) {
            this.send();
            this.receive();
        }
    }

    protected void send() throws SQLException {
        DB2Socket dB2Socket = this.db2socket;
        synchronized (dB2Socket) {
            if (this.db2socket == null || this.db2socket.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            try {
                this.outTotalLength += this.outBuffer.outBuf.size();
                if (debug) {
                    System.err.println("send - writing " + this.outTotalLength + " bytes to socket");
                }
                if (debug) {
                    System.err.println("outTotalLength <= outBufferSize --> " + this.outTotalLength + " <= " + outBufferSize);
                }
                if (this.outTotalLength <= outBufferSize) {
                    if (debug) {
                        System.err.println("Sending 1 buffer of size = " + this.outBuffer.outBuf.size());
                    }
                    this.db2socket.sendStream.writeShort(1);
                    this.db2socket.sendStream.writeInt(this.outBuffer.outBuf.size());
                    this.outBuffer.outBuf.writeTo(this.db2socket.sendStream);
                    this.db2socket.sendStream.flush();
                    this.outBuffer.outBuf.reset();
                } else {
                    if (debug) {
                        System.err.println("Sending MULTIPLE buffers of total size = " + this.outTotalLength + " number of buffers = " + (this.outBufferChainPos + 1) + "total length of chain = " + this.outBufferChainLen);
                    }
                    this.db2socket.sendStream.writeShort((short)(this.outBufferChainPos + 1));
                    this.db2socket.sendStream.writeInt(this.outTotalLength);
                    DB2RequestOutputBuffer dB2RequestOutputBuffer = null;
                    int n = 0;
                    while (n <= this.outBufferChainPos) {
                        if (debug) {
                            System.err.println("Getting output buffer number = " + n);
                        }
                        dB2RequestOutputBuffer = (DB2RequestOutputBuffer)this.outBufferChain.elementAt(n);
                        if (debug) {
                            System.err.println("Sending length of buffer = " + dB2RequestOutputBuffer.outBuf.size());
                        }
                        this.db2socket.sendStream.writeInt(dB2RequestOutputBuffer.outBuf.size());
                        if (debug) {
                            System.err.println("Sending  buffer");
                        }
                        dB2RequestOutputBuffer.outBuf.writeTo(this.db2socket.sendStream);
                        if (debug) {
                            System.err.println("Flushing stream");
                        }
                        this.db2socket.sendStream.flush();
                        if (debug) {
                            System.err.println("Resetting the buffer");
                        }
                        dB2RequestOutputBuffer.outBuf.reset();
                        ++n;
                    }
                    if (debug) {
                        System.err.println("Resetting outBuffer.");
                    }
                    this.outBuffer = (DB2RequestOutputBuffer)this.outBufferChain.elementAt(0);
                }
            }
            catch (IOException iOException) {
                SQLExceptionGenerator.throwSendError();
            }
        }
        this.outBufferChainPos = 0;
        this.outTotalLength = 0;
        this.outCurrentLength = 0;
    }

    protected void receive() throws SQLException {
        try {
            int n = this.db2socket.receiveStream.readInt();
            if (debug) {
                System.err.println("receive - reading " + n + " bytes from socket");
            }
            if (debug) {
                System.err.println("available bytes = " + this.db2socket.receiveStream.available());
            }
            if (this.inBuffer == null || this.inBuffer.length < n) {
                if (debug) {
                    System.err.println("creating inBuffer of size " + n);
                }
                this.inBuffer = new byte[n];
                this.inMemory = new DataInputStream(new ByteArrayInputStream(this.inBuffer));
            }
            if (n <= inBufferSize - 4) {
                this.db2socket.receiveStream.readFully(this.inBuffer, 0, n);
                if (debug) {
                    System.err.println("data has been read from the socket length = " + n);
                }
            } else {
                int n2 = 0;
                int n3 = inBufferSize - 4;
                if (debug) {
                    System.err.println("Getting mulitple buffers: inLen = " + n3 + " totalLen = " + n + " inPos = " + n2);
                }
                int n4 = n - n3;
                this.db2socket.receiveStream.readFully(this.inBuffer, n2, n3);
                n2 += n3;
                while (n4 > 0) {
                    n3 = this.db2socket.receiveStream.readInt();
                    if (debug) {
                        System.err.println("Getting mulitple buffers: inLen = " + n3 + " totalLen = " + n4 + " inPos = " + n2);
                    }
                    this.db2socket.receiveStream.readFully(this.inBuffer, n2, n3);
                    n2 += n3;
                    n4 -= n3;
                }
                if (debug) {
                    System.err.println("Getting mulitple buffers: inLen = " + n3 + " totalLen = " + n4 + " inPos = " + n2);
                }
                if (debug) {
                    System.err.println("data has been read from the socket");
                }
            }
            this.inMemory.reset();
        }
        catch (IOException iOException) {
            SQLExceptionGenerator.throwReceiveError();
        }
    }
}

