/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2OutputParameters;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJSection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DB2CallableStatement
extends DB2PreparedStatement
implements CallableStatement,
SQLJCallableStatement {
    private DB2OutputParameters outParams = null;
    protected boolean wasNull = false;

    public DB2CallableStatement(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n, SQLJSection sQLJSection, SQLJColumnMetaData sQLJColumnMetaData, SQLJColumnMetaData sQLJColumnMetaData2, boolean bl, boolean bl2, int n2, int n3) throws SQLException {
        super(string, dB2Connection, n, sQLJSection, sQLJColumnMetaData, sQLJColumnMetaData2, bl, bl2, n2, n3);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n4 = n - 1;
        n2 = this.convert2SQLType(n2);
        switch (this.direction[n4]) {
            case 0: {
                this.direction[n4] = 4;
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.direction[n4] = 2;
            }
        }
        this.sqltypes[n4] = n2;
        if (this.ctypes[n4] == 0) {
            this.ctypes[n4] = this.sqlType2cType(n2);
        }
        if ((n2 == 3 || n2 == 2) && n3 < this.scales[n4]) {
            n3 = this.scales[n4];
        }
        this.scales[n4] = (short)n3;
        this.executed = false;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private int validateParameter(int n) throws SQLException {
        return this.validateParameter(n, 0, false);
    }

    private int validateParameter(int n, int n2) throws SQLException {
        return this.validateParameter(n, n2, true);
    }

    private int validateParameter(int n, int n2, boolean bl) throws SQLException {
        int n3;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (!this.executed) {
            this.sqlExcptGen.throwNotExecutedError();
        }
        if (this.direction[n3 = n - 1] != 4 && this.direction[n3] != 2) {
            this.sqlExcptGen.throwNotOutputParameterError();
        }
        if (bl && this.sqltypes[n3] != n2) {
            this.sqlExcptGen.throwTypeError();
        }
        return n3;
    }

    public String getString(int n) throws SQLException {
        int n2 = this.validateParameter(n);
        int n3 = this.sqltypes[n2];
        if (n3 != 1 && n3 != 12 && n3 != -1 && n3 != -99) {
            this.sqlExcptGen.throwTypeError();
        }
        n2 = this.outParams.mapOutputParameter(n2);
        return this.outParams.getString(n2);
    }

    public boolean getBoolean(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 5));
        return this.outParams.getBoolean(n2);
    }

    public byte getByte(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 5));
        return this.outParams.getByte(n2);
    }

    public short getShort(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 5));
        return this.outParams.getShort(n2);
    }

    public int getInt(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 4));
        return this.outParams.getInt(n2);
    }

    public long getLong(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, -5));
        return this.outParams.getLong(n2);
    }

    public float getFloat(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 7));
        return this.outParams.getFloat(n2);
    }

    public double getDouble(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 8));
        return this.outParams.getDouble(n2);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n, 2));
        BigDecimal bigDecimal = this.outParams.getBigDecimal(n3);
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n2, 4);
    }

    public byte[] getBytes(int n) throws SQLException {
        int n2 = this.validateParameter(n);
        int n3 = this.sqltypes[n2];
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "type", n3);
        }
        if (n3 != -2 && n3 != -3 && n3 != -4 && n3 != -98) {
            this.sqlExcptGen.throwTypeError();
        }
        n2 = this.outParams.mapOutputParameter(n2);
        return this.outParams.getBytes(n2);
    }

    public Date getDate(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 91));
        return this.outParams.getDate(n2, Calendar.getInstance());
    }

    public Time getTime(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 92));
        return this.outParams.getTime(n2, Calendar.getInstance());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 93));
        return this.outParams.getTimestamp(n2, Calendar.getInstance());
    }

    public Object getObject(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n));
        return this.outParams.getObject(n2);
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet;
        DB2Request dB2Request = this.db2req;
        synchronized (dB2Request) {
            resultSet = super.executeQuery();
            this.createOutputParamObj();
        }
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n;
        DB2Request dB2Request = this.db2req;
        synchronized (dB2Request) {
            n = super.executeUpdate();
            this.createOutputParamObj();
        }
        return n;
    }

    public boolean execute() throws SQLException {
        boolean bl;
        DB2Request dB2Request = this.db2req;
        synchronized (dB2Request) {
            bl = super.execute();
            this.createOutputParamObj();
        }
        return bl;
    }

    private void createOutputParamObj() throws SQLException {
        this.outParams = new DB2OutputParameters(this, this.maxNumParams, this.direction, this.sqltypes);
    }

    protected synchronized int execute2() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n = 0;
        this.warnings = null;
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        if (this.resultSet != null) {
            this.resultSet.realClose();
        }
        try {
            this.db2req.write((short)80);
            this.db2req.write(this.statementHandle);
            this.paramToServer();
            this.db2req.sendAndRecv();
            n = this.db2req.readInt();
            this.executed = true;
            if (n == this.SQL_SUCCESS) {
                this.rowCount = this.db2req.readInt();
                this.colCount = this.db2req.readShort();
                this.CLIBlockSize = this.db2req.readInt();
                if (this.resultSet != null) {
                    this.resultSet.reset(this.colCount);
                }
            } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                n = this.db2req.readInt();
                if (n == this.SQL_SUCCESS) {
                    String string = this.db2req.readString();
                    String string2 = this.db2req.readString();
                    int n2 = this.db2req.readInt();
                    this.addWarning(new SQLWarning(string, string2, n2));
                }
                this.rowCount = this.db2req.readInt();
                this.colCount = this.db2req.readShort();
                this.CLIBlockSize = this.db2req.readInt();
                if (this.resultSet != null) {
                    this.resultSet.reset(this.colCount);
                }
                this.checkForCursorDowngrade();
                n = this.SQL_SUCCESS;
            }
            if (n == 99) {
                n = this.loadParameters();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    protected int loadParameters() throws SQLException {
        int n = -1;
        int n2 = 99;
        try {
            while (n2 == 99) {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)81);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n2 = this.db2req.readInt();
                    if (n2 != this.SQL_SUCCESS && n2 != this.SQL_SUCCESS_WITH_INFO && n2 != 99) {
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                    if (n2 == 99) {
                        int n3;
                        n = this.db2req.readInt();
                        int n4 = n - 1;
                        int n5 = this.paramRow[n4].getLength();
                        if (!this.paramRow[n4].doConversion()) {
                            InputStream inputStream = (InputStream)this.paramRow[n4].getValue();
                            byte[] byArray = new byte[Math.min(32699, n5)];
                            while ((n3 = inputStream.read(byArray, 0, Math.min(32699, n5))) != -1 && n5 != 0) {
                                n5 -= n3;
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                if (this.sqltypes[n4] == -99) {
                                    this.db2req.write((short)1);
                                } else {
                                    this.db2req.write((short)0);
                                }
                                this.db2req.write(byArray, n3);
                                this.db2req.sendAndRecv();
                                int n6 = this.db2req.readInt();
                                if (n6 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n6);
                            }
                        } else {
                            int n7;
                            BufferedReader bufferedReader = new BufferedReader((Reader)this.paramRow[n4].getValue());
                            int n8 = this.paramRow[n4].getLength();
                            n3 = Math.min(16349, n8);
                            char[] cArray = new char[n3];
                            while ((n7 = bufferedReader.read(cArray, 0, n3)) != -1 && n8 != 0) {
                                n3 = Math.min(16349, n8 -= n7);
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                this.db2req.write((short)1);
                                this.db2req.write(new String(cArray, 0, n7));
                                this.db2req.sendAndRecv();
                                int n9 = this.db2req.readInt();
                                if (n9 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n9);
                            }
                        }
                    } else if (n2 == this.SQL_SUCCESS) {
                        int n10;
                        int n11 = this.db2req.readInt();
                        if (n11 != this.SQL_SUCCESS) {
                            this.sqlExcptGen.check_return_code(this, n11);
                        }
                        this.rowCount = this.db2req.readInt();
                        this.colCount = this.db2req.readShort();
                        if (this.colCount > 0 && (n10 = this.db2req.readInt()) != this.SQL_SUCCESS) {
                            this.sqlExcptGen.check_return_code(this, n10);
                        }
                        this.CLIBlockSize = this.db2req.readInt();
                        if (this.resultSet != null) {
                            this.resultSet.reset(this.colCount);
                        }
                    } else if (n2 == this.SQL_SUCCESS_WITH_INFO) {
                        n2 = this.db2req.readInt();
                        if (n2 == this.SQL_SUCCESS) {
                            String string = this.db2req.readString();
                            String string2 = this.db2req.readString();
                            int n12 = this.db2req.readInt();
                            this.addWarning(new SQLWarning(string, string2, n12));
                        }
                        this.rowCount = this.db2req.readInt();
                        this.colCount = this.db2req.readShort();
                        this.CLIBlockSize = this.db2req.readInt();
                        if (this.resultSet != null) {
                            this.resultSet.reset(this.colCount);
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        super(string, dB2Connection, n, n2);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 2));
        return this.outParams.getBigDecimal(n2);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Ref type");
        return null;
    }

    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (null == byArray) {
            return null;
        }
        return new DB2Blob(byArray);
    }

    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        if (null == string) {
            return null;
        }
        return new DB2Clob(string);
    }

    public Array getArray(int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 91));
        return this.outParams.getDate(n2, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 92));
        return this.outParams.getTime(n2, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        int n2 = this.outParams.mapOutputParameter(this.validateParameter(n, 93));
        return this.outParams.getTimestamp(n2, calendar);
    }
}

