/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.sql.SQLException;

public class DB2UnicodeStream
extends DB2InputStream {
    protected int bytesRetrieved = 0;

    protected native String SQLReadString(int var1, Integer var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public DB2UnicodeStream(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        super(dB2Statement, n, n2);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2UnicodeStream( stmt, " + n + ", " + n2 + " )");
        }
        if (n2 == -351) {
            this.docLength /= 2;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "docLength", this.docLength);
            DB2Trace.methodExit(this, "DB2UnicodeStream()");
        }
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        return this.bufferEnd - this.bufferPos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n2 = 0;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            int n4 = byArray.length;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "bytesToRead", n4);
            }
            if (this.buffer != null) {
                n3 = this.bufferEnd - this.bufferPos;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "bytesAvailable", n3);
                }
                if (n3 != 0) {
                    if (n4 <= n3) {
                        System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n4);
                        this.bufferPos += n4;
                        n2 = n4;
                        n4 = 0;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n3);
                        this.bufferPos += n3;
                        n2 = n3;
                        n4 -= n3;
                    }
                }
            }
            if (n4 != 0 && this.currentPosition <= this.docLength) {
                String string;
                n3 = 0;
                n = Math.max(32000, n4);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "currentPosition", this.currentPosition);
                    DB2Trace.data(30, "bytesToRead", n4);
                    DB2Trace.data(30, "len", n);
                }
                Integer n5 = new Integer(0);
                try {
                    this.numBytesRead = 0;
                    DB2Statement dB2Statement = this.statement;
                    synchronized (dB2Statement) {
                        string = this.SQLReadString(n, n5, this.lobType, this.locator, this.currentPosition, this.docLength, this.statement.statementHandle, this.connection.connectionHandle);
                        int n6 = n5;
                        if (n6 != 0) {
                            this.connection.sqlExcptGen.check_return_code(this.statement, n6);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.toString());
                }
                if (string != null) {
                    int n7 = string.length();
                    this.buffer = string.getBytes("UTF8");
                    n3 = this.buffer.length;
                    this.currentPosition = this.lobType == 41 ? (this.currentPosition += this.numBytesRead) : (this.currentPosition += n7);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "numBytesRead", this.numBytesRead);
                    DB2Trace.data(40, "bytesAvailable", n3);
                }
                this.bufferPos = 0;
                this.bufferEnd = n3;
                if (n3 != 0) {
                    if (n4 <= n3) {
                        System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n4);
                        this.bufferPos += n4;
                        n2 += n4;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n3);
                        this.bufferPos += n3;
                        n2 += n3;
                    }
                }
            }
            this.bytesRetrieved += n2;
            if (n2 == 0) {
                n2 = -1;
            }
            n = n2;
            Object var12_13 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n2);
        return n;
    }

    public synchronized long skip(long l) {
        return 0L;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() {
    }

    public boolean markSupported() {
        return false;
    }
}

