/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DB2ResultSetMetaData
implements ResultSetMetaData {
    protected DB2Statement statement;
    protected DB2Connection connection;
    protected DB2ResultSet resultset;
    protected int numberOfColumns;
    protected boolean mappedRS;
    protected int[] colBaseTypesNotAdjusted = null;

    protected native String SQLColAttributes(int var1, int var2, Integer var3, Integer var4, int var5, int var6);

    public DB2ResultSetMetaData(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n, boolean bl) {
        this.statement = dB2Statement;
        this.connection = dB2Statement.getDB2Connection();
        this.resultset = dB2ResultSet;
        this.numberOfColumns = n;
        this.mappedRS = bl;
    }

    public DB2ResultSetMetaData(DB2PreparedStatement dB2PreparedStatement) {
        this.statement = dB2PreparedStatement;
        this.connection = dB2PreparedStatement.getDB2Connection();
        this.resultset = null;
        this.numberOfColumns = 0;
        this.mappedRS = false;
    }

    public int getColumnCount() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (null == this.resultset || this.resultset.numCols <= 0) {
            Integer n = new Integer(0);
            Integer n2 = new Integer(0);
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                String string = this.SQLColAttributes(1, 0, n2, n, this.statement.statementHandle, this.connection.connectionHandle);
            }
            int n3 = n2;
            if (n3 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n3);
            }
            this.numberOfColumns = n;
            if (this.resultset != null) {
                this.resultset.numCols = this.numberOfColumns;
            }
        } else {
            this.numberOfColumns = this.resultset.numCols;
        }
        return this.numberOfColumns;
    }

    protected int getMappedColumn(int n) throws SQLException {
        if (this.mappedRS) {
            int n2 = this.resultset.getMappedColumn(n);
            return n2;
        }
        return n;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 11, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return 1 == n2;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 12, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return 1 == n2;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 13, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return 0 != n2;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 9, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return 1 == n2;
    }

    public int isNullable(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 7, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        if (1 == (n2 = n3.intValue())) {
            return 1;
        }
        if (0 == n2) {
            return 0;
        }
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 8, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return 1 != n2;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 6, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 18, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (null != this.resultset && null != this.resultset.mappedColumnNames && this.resultset.mappedColumnNames.length >= n && null != this.resultset.mappedColumnNames[n - 1]) {
            return this.resultset.mappedColumnNames[n - 1];
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 1, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 16, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 4, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 5, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2;
    }

    public String getTableName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 15, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public String getCatalogName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 17, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public int getColumnType(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n6, 2, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n7 = n3;
        if (n7 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n7);
        }
        if ((n5 = n2.intValue()) == -450) {
            DB2Connection dB2Connection2 = this.connection;
            synchronized (dB2Connection2) {
                string = this.SQLColAttributes(n6, 1098, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
            }
            n7 = n3;
            if (n7 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n7);
            }
            if ((n4 = n2.intValue()) == 1) {
                n4 = 2001;
            } else if (n4 == 2) {
                n4 = 2002;
            } else if (n4 == 3) {
                n4 = 2006;
            }
            DB2Connection dB2Connection3 = this.connection;
            synchronized (dB2Connection3) {
                string = this.SQLColAttributes(n6, 1254, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
            }
            n7 = n3;
            if (n7 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n7);
            }
            n5 = n2;
        } else {
            n4 = this.connection.adjust(n5);
        }
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted.length < n) {
            int n8 = this.getColumnCount();
            this.colBaseTypesNotAdjusted = new int[n8];
            int n9 = 0;
            while (n9 < n8) {
                this.colBaseTypesNotAdjusted[n9] = -99999;
                ++n9;
            }
        }
        this.colBaseTypesNotAdjusted[n - 1] = n5;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(30, "DB2ColType", n4);
            DB2Trace.data(30, "DB2ColBaseTypeNotAdjusted", n5);
        }
        return n4;
    }

    public String getColumnTypeName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 14, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return string;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 10, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return 0 == n2;
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getColumnClassName( " + n + " )");
        }
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        String string = null;
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted[n - 1] == -99999) {
            this.getColumnType(n);
        }
        int n2 = this.connection.adjust(this.colBaseTypesNotAdjusted[n - 1]);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "[B";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 70: {
                string = "java.net.URL";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2001: {
                string = "java.sql.Distinct";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                this.connection.sqlExcptGen.rsException("S1004");
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getColumnClassName()", string);
        }
        return string;
    }
}

