/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2BaseConstants;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2ParameterMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2Statement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJPackage;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import com.ibm.db2.jcc.SQLJSection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement,
SQLJPreparedStatement {
    protected short maxNumParams = 0;
    protected byte[] SQLJPID = null;
    protected long[] parameters = null;
    protected int[] direction = null;
    protected int[] sqltypes = null;
    protected long[] precisions = null;
    protected boolean[] sqltypeGuessed = null;
    protected int[] ctypes = null;
    protected int[] maxWholeDigits = null;
    protected int[] scales = null;
    protected boolean[] wasBound = null;
    protected short[] described = null;
    protected ParamElement[] paramRow = null;
    protected Vector paramSet = new Vector();
    protected static final int BUFLEN = 32699;
    protected boolean executed = false;
    private boolean resetParamSetSize = false;
    protected short statementType;
    private boolean[] SQLJParmIsGraphic = null;
    private String sqljDescribeInfo = null;
    private boolean sqljPSCloned = false;
    SQLJSection section = null;
    SQLJColumnMetaData parameterMetaData = null;
    SQLJColumnMetaData resultSetMetaData = null;
    boolean isSQLJSingletonQuery = false;
    short CLIStatementType = 0;
    Vector SQLJBatchStatements = null;
    long queryInstanceIdentifier;

    protected native int SQLPrepare(String var1, int var2, int var3, byte[] var4);

    protected native int SQLJPrepare(String var1, int var2, short var3, short var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9);

    protected native int SQLExecute(int var1, boolean var2);

    protected native int SQLBindNull(int var1, int var2, int var3, long var4, int var6, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindNull2(long var1);

    protected native int SQLBindSmallInt(int var1, int var2, int var3, int var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindSmallInt2(int var1, long var2);

    protected native int SQLBindInteger(int var1, int var2, int var3, int var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindInteger2(int var1, long var2);

    protected native int SQLBindBigInt(int var1, int var2, long var3, int var5, long var6, int var8, long var9, long[] var11, int var12);

    protected native int SQLBindBigInt2(long var1, long var3);

    protected native int SQLBindReal(int var1, int var2, long var3, int var5, int var6, float var7, long var8, long[] var10, int var11);

    protected native int SQLBindReal2(float var1, long var2);

    protected native int SQLBindDouble(int var1, int var2, double var3, int var5, long var6, int var8, long var9, long[] var11, int var12);

    protected native int SQLBindDouble2(double var1, long var3);

    protected native int SQLBindChar(int var1, int var2, long var3, int var5, String var6, int var7, int var8, long var9, long[] var11, int var12, int var13, boolean var14);

    protected native int SQLBindBinary(int var1, int var2, long var3, int var5, int var6, byte[] var7, long var8, long[] var10, int var11, boolean var12);

    protected native int SQLBindDate(int var1, int var2, int var3, int var4, int var5, int var6, long var7, int var9, long var10, long[] var12, int var13);

    protected native int SQLBindDate2(int var1, int var2, int var3, long var4);

    protected native int SQLBindTime(int var1, int var2, int var3, int var4, int var5, int var6, long var7, int var9, long var10, long[] var12, int var13);

    protected native int SQLBindTime2(int var1, int var2, int var3, long var4);

    protected native int SQLBindTimestamp(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13, long var14, long[] var16, int var17);

    protected native int SQLBindTimestamp2(int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, int var10);

    protected native int SQLBindStream(int var1, int var2, long var3, int var5, int var6, int var7, int var8, boolean var9, long var10, long[] var12, int var13);

    protected native int SQLPutByteData(byte[] var1, int var2, int var3);

    protected native int SQLPutStringData(char[] var1, int var2, int var3, int var4);

    protected native int SQLGetNumParams(int var1);

    protected native int SQLParamData(int var1);

    protected native int SQLParamDataBatch(int var1, long[] var2, int var3, int var4);

    protected native int SQLBindLob(int var1, int var2, int var3, int var4, long var5, long[] var7, int var8);

    protected native int SQLBindLobArray(int var1, int var2, int var3, int[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindIntArray(int var1, int var2, int var3, int[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindShortArray(int var1, int var2, int var3, short[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindFloatArray(int var1, int var2, int var3, float[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindDoubleArray(int var1, int var2, int var3, double[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindDateArray(int var1, int var2, int var3, int[][] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindTimeArray(int var1, int var2, int var3, int[][] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindTimestampArray(int var1, int var2, int var3, int[][] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindByteArrayArray(int var1, int var2, long var3, int var5, byte[][] var6, int[] var7, long var8, long[] var10, int var11);

    protected native int SQLBindStringArray(int var1, int var2, int var3, long var4, int var6, int var7, int var8, String[] var9, int[] var10, long var11, long[] var13, int var14);

    protected native int SQLBindLongArray(int var1, int var2, int var3, long[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLExecBatchData(int var1, int[] var2, int var3);

    protected native int SQLDescribeParam(int var1, int var2, int[] var3, long[] var4, int[] var5);

    protected native int SQLFreeStmtClearParameters(int var1);

    protected native void freeArrays(int var1, long[] var2);

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2PreparedStatement \r\n" + string + "{");
        stringBuffer.append(super.toString(string + "    ", bl));
        stringBuffer.append("\r\n");
        stringBuffer.append(string + "    statementType = " + this.statementType + "\r\n");
        stringBuffer.append(string + "    executed = " + this.executed + "\r\n");
        stringBuffer.append(string + "    maxNumParams = " + this.maxNumParams + "\r\n");
        int n = 0;
        while (n < this.maxNumParams) {
            stringBuffer.append(string + "    parameters[" + n + "] = " + this.parameters[n] + "\r\n");
            stringBuffer.append(string + "    direction[" + n + "] = " + this.direction[n] + "\r\n");
            stringBuffer.append(string + "    sqltypes[" + n + "] = " + this.sqltypes[n] + "\r\n");
            stringBuffer.append(string + "    sqltypeGuessed[" + n + "] = " + this.sqltypeGuessed[n] + "\r\n");
            stringBuffer.append(string + "    precisions[" + n + "] = " + this.precisions[n] + "\r\n");
            stringBuffer.append(string + "    ctypes[" + n + "] = " + this.ctypes[n] + "\r\n");
            stringBuffer.append(string + "    scales[" + n + "] = " + this.scales[n] + "\r\n");
            stringBuffer.append(string + "    described[" + n + "] = " + this.described[n] + "\r\n");
            ++n;
        }
        stringBuffer.append(string + "}\r\n");
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        super(dB2Connection, n, n2);
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + string + "\", con, " + n + ", " + n2 + " )");
            }
            if (null == string || 0 == string.trim().length()) {
                this.sqlExcptGen.throwNullError();
            }
            this.statementType = this.getStatementType(string);
            this.sql = 27 == this.statementType ? this.parseSQLJ(string) : string;
            this.returnCode = 0;
            DB2Connection dB2Connection2 = this.connection;
            synchronized (dB2Connection2) {
                this.maxNumParams = (short)this.SQLPrepare(this.sql, this.statementHandle, dB2Connection.connectionHandle, this.SQLJPID);
            }
            if (this.returnCode != 0) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                    this.maxNumParams = (short)this.SQLGetNumParams(this.statementHandle);
                }
                catch (SQLException sQLException) {
                    this.close();
                    throw sQLException;
                }
            }
            this.initParameterVariables();
            if (27 == this.statementType && this.sqljDescribeInfo != null) {
                this.processSQLJDescribeInfo();
            }
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "maxNumParam", this.maxNumParams);
            DB2Trace.methodExit(this, "DB2PreparedStatement()");
            throw throwable;
        }
        DB2Trace.data(10, "maxNumParam", this.maxNumParams);
        DB2Trace.methodExit(this, "DB2PreparedStatement()");
    }

    private void initParameterVariables() {
        this.parameters = new long[this.maxNumParams];
        this.direction = new int[this.maxNumParams];
        this.sqltypes = new int[this.maxNumParams];
        this.precisions = new long[this.maxNumParams];
        this.sqltypeGuessed = new boolean[this.maxNumParams];
        this.ctypes = new int[this.maxNumParams];
        this.maxWholeDigits = new int[this.maxNumParams];
        this.scales = new int[this.maxNumParams];
        this.wasBound = new boolean[this.maxNumParams];
        this.described = new short[this.maxNumParams];
        this.paramRow = new ParamElement[this.maxNumParams];
        int n = 0;
        while (n < this.maxNumParams) {
            this.parameters[n] = 0L;
            this.direction[n] = 0;
            this.sqltypes[n] = 0;
            this.precisions[n] = 0L;
            this.sqltypeGuessed[n] = false;
            this.ctypes[n] = 0;
            this.scales[n] = 0;
            this.wasBound[n] = false;
            this.described[n] = 0;
            this.paramRow[n] = new ParamElement();
            ++n;
        }
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection) throws SQLException {
        this(string, dB2Connection, 1003, 1007);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseSQLJ(String var1_1) throws SQLException {
        block27: {
            block26: {
                var2_2 = null;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "parseSQLJ( " + var1_1 + " )");
                    }
                    var2_2 = var1_1.substring(var1_1.indexOf("{"));
                    var3_3 = var2_2.indexOf("db2jrt");
                    var4_4 = 6;
                    var5_5 = var1_1.indexOf(",");
                    var6_6 = Integer.parseInt(var1_1.substring(1, var5_5));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "numOfTokens", var6_6);
                    }
                    if (var6_6 > 0) {
                        var7_7 = new int[var6_6];
                        var8_9 = 0;
                        ++var5_5;
                        var9_10 = 0;
                        while (var9_10 < var6_6) {
                            var8_9 = var1_1.indexOf(",", var5_5);
                            var7_7[var9_10] = Integer.parseInt(var1_1.substring(var5_5, var8_9));
                            var5_5 = var8_9 + 1;
                            ++var9_10;
                        }
                        this.colCount4JSQL = var6_6;
                        this.colNames4JSQL = new String[var6_6];
                        var10_12 = 0;
                        while (var10_12 < var6_6) {
                            var8_9 = var5_5 + var7_7[var10_12];
                            this.colNames4JSQL[var10_12] = new String(var1_1.substring(var5_5, var8_9));
                            var5_5 = var8_9;
                            ++var10_12;
                        }
                    }
                    var7_8 = var1_1.indexOf(",", ++var5_5);
                    var8_9 = Integer.parseInt(var1_1.substring(var5_5, var7_8));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "cursorName_len", var8_9);
                    }
                    if (var8_9 > 0) {
                        var5_5 = var7_8 + 1;
                        var7_8 = var1_1.indexOf(",", var5_5);
                        var9_10 = Integer.parseInt(var1_1.substring(var5_5, var7_8));
                        var5_5 = var7_8 + 1;
                        var7_8 = var1_1.indexOf(",", var5_5);
                        var10_12 = Integer.parseInt(var1_1.substring(var5_5, var7_8));
                        var11_13 = var2_2.substring(var9_10, var10_12);
                        var5_5 = var7_8 + 1;
                        var7_8 = var5_5 + var8_9;
                        var12_14 = new String(var1_1.substring(var5_5, var7_8)) + "," + var11_13;
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "cursor_pid_ep", var10_12);
                            DB2Trace.data(20, "cursorName", var12_14);
                        }
                        this.setCursorName(var12_14);
                    } else {
                        var10_12 = var2_2.lastIndexOf(125);
                        var10_12 = var2_2.lastIndexOf(41, var10_12 - 1);
                        var10_12 = var2_2.lastIndexOf(39, var10_12 - 1);
                        var9_10 = var2_2.lastIndexOf("','", var10_12 - 1);
                        var11_13 = var2_2.substring(var9_10 + 3, var10_12);
                        var10_12 = var9_10;
                        var12_14 = var2_2.substring((var9_10 = var2_2.lastIndexOf("','", var10_12 - 1)) + 3, var10_12);
                        if (var12_14.length() > 0 || var11_13.length() > 0) {
                            var9_10 = var3_3 + var4_4;
                            var9_10 = var2_2.indexOf("'", var9_10) + 1;
                            var10_12 = var2_2.indexOf(44, var9_10);
                            var13_15 = var2_2.indexOf("',", var10_12);
                            var14_16 = var2_2.substring(var9_10, var10_12);
                            var15_17 = var2_2.substring(var10_12 + 1, var13_15);
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(20, "CursorName", var14_16);
                                DB2Trace.data(20, "PIDString", var15_17);
                            }
                            var2_2 = var12_14 + var14_16 + var11_13;
                            var16_18 = new ByteArrayOutputStream(162);
                            var17_19 = 0;
                            var18_20 = var15_17.length();
                            var20_21 = 0;
                            while (var20_21 < var18_20) {
                                var19_22 = var15_17.charAt(var20_21);
                                if (',' == var19_22) {
                                    var16_18.write(var17_19);
                                    var17_19 = 0;
                                } else if (' ' != var19_22) {
                                    var17_19 = var17_19 * 10 + Character.digit(var19_22, 10);
                                }
                                ++var20_21;
                            }
                            this.SQLJPID = var16_18.toByteArray();
                        }
                    }
                    if (var2_2.indexOf("db2jrt") != -1) {
                        var5_5 = var2_2.indexOf("db2jrt");
                        var9_10 = 0;
                        while (var9_10 < 5) {
                            var5_5 = var2_2.indexOf("'", var5_5 + 1);
                            ++var9_10;
                        }
                        var7_8 = var2_2.indexOf("'", var5_5 + 1);
                        if (var2_2.substring(var5_5, var7_8 + 1).indexOf(",") != -1) {
                            this.sqljDescribeInfo = var2_2.substring(var5_5 + 1, var7_8);
                        }
                    }
                    if (this.sqljDescribeInfo == null) {
                        var5_5 = var2_2.indexOf(39, var3_3 + var4_4 + 1);
                        var5_5 = var2_2.indexOf(39, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var7_8 = var2_2.indexOf(39, (var5_5 = var2_2.indexOf(39, var5_5 + 1)) + 1);
                        if (var7_8 - var5_5 > 1) {
                            this.SQLJParmIsGraphic = new boolean[var7_8 - var5_5 - 1];
                            ++var5_5;
                            var9_10 = 0;
                            while (var9_10 < this.SQLJParmIsGraphic.length) {
                                if (var2_2.charAt(var5_5) == '1') {
                                    this.SQLJParmIsGraphic[var9_10] = true;
                                }
                                ++var9_10;
                                ++var5_5;
                            }
                        }
                    }
                    var9_11 = var2_2;
                    var22_23 = null;
                    if (DB2Trace.TraceOn == false) return var9_11;
                    if (this.SQLJParmIsGraphic == null) break block26;
                    var23_25 = 0;
                    ** while (var23_25 < this.SQLJParmIsGraphic.length)
                }
                catch (Throwable var21_27) {
                    var22_24 = null;
                    if (!DB2Trace.TraceOn) throw var21_27;
                    if (this.SQLJParmIsGraphic == null) break block27;
                    var23_26 = 0;
                    ** while (var23_26 < this.SQLJParmIsGraphic.length)
                }
lbl-1000:
                // 1 sources

                {
                    DB2Trace.data(100, "SQLJParmIsGraphic[" + var23_25 + "]", String.valueOf(this.SQLJParmIsGraphic[var23_25]));
                    ++var23_25;
                    continue;
                }
            }
            DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
            return var9_11;
lbl-1000:
            // 1 sources

            {
                DB2Trace.data(100, "SQLJParmIsGraphic[" + var23_26 + "]", String.valueOf(this.SQLJParmIsGraphic[var23_26]));
                ++var23_26;
                continue;
            }
        }
        DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
        throw var21_27;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForSQLJGraphic(int n) {
        int n2 = n - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkForSQLJGraphic( " + n + " )");
                DB2Trace.data(10, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
            }
            if (27 == this.statementType && this.SQLJParmIsGraphic != null && this.SQLJParmIsGraphic.length > n2 && this.SQLJParmIsGraphic[n2]) {
                int n3 = this.sqltypes[n2];
                switch (this.sqltypes[n2]) {
                    case 1: {
                        this.sqltypes[n2] = -95;
                        break;
                    }
                    case 12: {
                        this.sqltypes[n2] = -96;
                        break;
                    }
                    case -1: {
                        this.sqltypes[n2] = -97;
                        break;
                    }
                    case -99: {
                        this.sqltypes[n2] = -350;
                    }
                }
                if (this.sqltypes[n2] != n3) {
                    this.wasBound[n2] = false;
                }
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
            DB2Trace.methodExit(this, "checkForSQLJGraphic()");
            throw throwable;
        }
        DB2Trace.data(100, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
        DB2Trace.methodExit(this, "checkForSQLJGraphic()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSQLJDescribeInfo() {
        try {
            StringTokenizer stringTokenizer;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "processSQLJDescribeInfo()");
            }
            if ((stringTokenizer = new StringTokenizer(this.sqljDescribeInfo, ",", false)).countTokens() > 0) {
                int n = stringTokenizer.countTokens() - 1;
                String string = "";
                stringTokenizer.nextToken();
                int n2 = 0;
                while (n2 < n) {
                    string = stringTokenizer.nextToken();
                    int n3 = 0;
                    int n4 = 0;
                    if (string.indexOf(" ") != -1) {
                        n4 = string.indexOf("(");
                        this.sqltypes[n2] = new Integer(string.substring(n3, n4));
                        n3 = n4 + 1;
                        n4 = string.indexOf(" ");
                        this.precisions[n2] = new Integer(string.substring(n3, n4)).intValue();
                        string.substring(n3, n4);
                        n3 = n4 + 1;
                        n4 = string.indexOf(")");
                        this.scales[n2] = new Integer(string.substring(n3, n4));
                    } else if (string.indexOf("(") != -1) {
                        n4 = string.indexOf("(");
                        this.sqltypes[n2] = new Integer(string.substring(n3, n4));
                        n3 = n4 + 1;
                        n4 = string.indexOf(")");
                        this.precisions[n2] = new Integer(string.substring(n3, n4)).intValue();
                    } else {
                        this.sqltypes[n2] = new Integer(string);
                    }
                    this.described[n2] = this.sqltypes[n2] == 0 ? (short)0 : 1;
                    ++n2;
                }
            }
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void close2(boolean bl) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close2( " + bl + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "Closed (Entry)", String.valueOf(this.closed));
                DB2Trace.data(10, "sqljPSCloned", String.valueOf(this.sqljPSCloned));
            }
            if (!this.closed) {
                super.close2(bl);
                if (this.parameters != null && this.maxNumParams != 0 && !this.sqljPSCloned) {
                    this.freeArrays(this.maxNumParams, this.parameters);
                }
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "Closed (Exit)", String.valueOf(this.closed));
            DB2Trace.methodExit(this, "close2()");
            throw throwable;
        }
        DB2Trace.data(20, "Closed (Exit)", String.valueOf(this.closed));
        DB2Trace.methodExit(this, "close2()");
    }

    protected void setDirection(int n, int n2, int n3) throws SQLException {
        this.setDirection(n, n2, n3, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setDirection(int n, int n2, int n3, int n4) throws SQLException {
        int n5 = n - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDirection( " + n + ", " + n2 + ", " + n3 + ", " + n4 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.direction[n5] == 4) {
                this.direction[n5] = 2;
                this.wasBound[n5] = false;
            } else if (this.direction[n5] == 0) {
                this.direction[n5] = 1;
                this.wasBound[n5] = false;
            }
            if (this.described[n5] != 1 && n2 != 0) {
                if (this.sqltypes[n5] != n2) {
                    this.sqltypes[n5] = n2;
                    this.wasBound[n5] = false;
                }
                this.sqltypeGuessed[n5] = false;
            }
            if ((this.sqltypes[n5] == 3 || this.sqltypes[n5] == 2 && this.sqljDescribeInfo == null) && n4 != -1 && n4 != this.scales[n5]) {
                this.scales[n5] = n4;
                this.wasBound[n5] = false;
            }
            if (this.ctypes[n5] != n3) {
                if (this.batchSize > 0 && this.ctypes[n5] != 0) {
                    this.sqlExcptGen.throwBatchCTypeChanged(n);
                }
                this.ctypes[n5] = n3;
                this.wasBound[n5] = false;
            }
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "direction[" + n5 + "]", this.direction[n5]);
            DB2Trace.data(20, "wasBound[" + n5 + "]", String.valueOf(this.wasBound[n5]));
            DB2Trace.data(20, "sqltypes[" + n5 + "]", this.sqltypes[n5]);
            DB2Trace.data(20, "ctypes[" + n5 + "]", this.ctypes[n5]);
            DB2Trace.data(20, "scales[" + n5 + "]", this.scales[n5]);
            DB2Trace.methodExit(this, "setDirection()");
            throw throwable;
        }
        DB2Trace.data(20, "direction[" + n5 + "]", this.direction[n5]);
        DB2Trace.data(20, "wasBound[" + n5 + "]", String.valueOf(this.wasBound[n5]));
        DB2Trace.data(20, "sqltypes[" + n5 + "]", this.sqltypes[n5]);
        DB2Trace.data(20, "ctypes[" + n5 + "]", this.ctypes[n5]);
        DB2Trace.data(20, "scales[" + n5 + "]", this.scales[n5]);
        DB2Trace.methodExit(this, "setDirection()");
    }

    protected void checkParameters() throws SQLException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int loadBatchParameters() throws SQLException {
        this.returnCode = 0;
        int n = -99999;
        int n2 = -99999;
        int n3 = -99999;
        try {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "loadBatchParameters()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                Vector[] vectorArray = new Vector[this.maxNumParams];
                int n4 = 0;
                while (n4 < this.maxNumParams) {
                    vectorArray[n4] = new Vector();
                    ++n4;
                }
                int n5 = 0;
                while (n5 < this.maxNumParams) {
                    int n6 = 0;
                    while (n6 < this.batchSize) {
                        this.paramRow = (ParamElement[])this.paramSet.elementAt(n6);
                        if (this.paramRow[n5].isStream()) {
                            vectorArray[n5].addElement(new Integer(n6));
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Stream param 0-based (param,set)", n5 + "," + n6);
                            }
                        }
                        ++n6;
                    }
                    ++n5;
                }
                n = this.SQLParamDataBatch(this.statementHandle, this.parameters, this.batchSize, this.maxNumParams);
                if (this.returnCode != 99 && this.returnCode != 0) {
                    this.sqlExcptGen.check_batch_return_code(this, this.returnCode);
                }
                while (this.returnCode == 99) {
                    n2 = n - 1;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "SQLParamDataBatch specifier (1-based)", n);
                    }
                    if (vectorArray[n2].isEmpty()) {
                        if (!DB2Trace.TraceOn) throw new SQLException("Error encountered loading stream parameter" + n2);
                        DB2Trace.data(10, "Error: No more sets contains streams for param", n2);
                        throw new SQLException("Error encountered loading stream parameter" + n2);
                    }
                    n3 = (Integer)vectorArray[n2].remove(0);
                    this.loadParameters2(n3, n2);
                    n = this.SQLParamDataBatch(this.statementHandle, this.parameters, this.batchSize, this.maxNumParams);
                    if (this.returnCode == 99 || this.returnCode == 0) continue;
                    this.sqlExcptGen.check_batch_return_code(this, this.returnCode);
                }
            }
            catch (SQLException sQLException) {
                if (!DB2Trace.TraceOn) throw sQLException;
                DB2Trace.data(20, "SQLException thrown. paramNum, setNum", "" + n2 + "," + n3);
                throw sQLException;
            }
            catch (Exception exception) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Exception thrown. paramNum, setNum, specifier", n2 + "," + n3 + "," + n);
                    DB2Trace.data(20, "Error", exception.getMessage());
                }
                Object var9_11 = null;
                if (!DB2Trace.TraceOn) return this.returnCode;
                DB2Trace.methodExit((Object)this, "loadBatchParameters()", this.returnCode);
                return this.returnCode;
            }
            Object var9_10 = null;
            if (!DB2Trace.TraceOn) return this.returnCode;
            DB2Trace.methodExit((Object)this, "loadBatchParameters()", this.returnCode);
            return this.returnCode;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "loadBatchParameters()", this.returnCode);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int loadParameters() throws SQLException {
        int n;
        block7: {
            int n2;
            this.returnCode = 0;
            int n3 = -99999;
            int n4 = -1;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "loadParameters()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                n4 = this.SQLParamData(this.statementHandle);
                if (this.returnCode != 99 && this.returnCode != 0) {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                while (true) {
                    if (this.returnCode != 99) {
                        n = this.returnCode;
                        break block7;
                    }
                    this.loadParameters2(-1, n4 - 1);
                    n4 = this.SQLParamData(this.statementHandle);
                    if (this.returnCode == 100) {
                        n2 = this.returnCode;
                        Object var5_5 = null;
                        if (!DB2Trace.TraceOn) return n2;
                        break;
                    }
                    if (this.returnCode == 99 || this.returnCode == 0) continue;
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!DB2Trace.TraceOn) throw throwable;
                DB2Trace.methodExit((Object)this, "loadParameters()", this.returnCode);
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "loadParameters()", this.returnCode);
            return n2;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return n;
        DB2Trace.methodExit((Object)this, "loadParameters()", this.returnCode);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadParameters2(int n, int n2) throws SQLException {
        this.returnCode = 0;
        int n3 = -99999;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "loadParameters2(setNum=" + n + ",paramNum=" + n2 + ")");
            }
            if (n >= 0) {
                try {
                    this.paramRow = (ParamElement[])this.paramSet.elementAt(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!DB2Trace.TraceOn) throw arrayIndexOutOfBoundsException;
                    DB2Trace.data(10, "(ArrayIndexOutOfBoundException) batchSize", this.batchSize);
                    throw arrayIndexOutOfBoundsException;
                }
            }
            try {
                boolean bl = false;
                int n4 = -99999;
                int n5 = this.paramRow[n2].getLength();
                if (this.paramRow[n2].doConversion()) {
                    BufferedReader bufferedReader = new BufferedReader((Reader)this.paramRow[n2].getValue());
                    char[] cArray = new char[Math.min(16349, n5)];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "paramRow[" + n2 + "].doConversion", "True");
                        DB2Trace.data(20, "chars toRead", n5);
                    }
                    while (n5 != 0 && (n3 = bufferedReader.read(cArray, 0, Math.min(cArray.length, n5))) != -1) {
                        n5 -= n3;
                        if (0 == n3) break;
                        DB2Connection dB2Connection = this.connection;
                        synchronized (dB2Connection) {
                            n4 = this.SQLPutStringData(cArray, n3, this.statementHandle, this.connection.connectionHandle);
                        }
                        if (n4 != 0) {
                            this.sqlExcptGen.check_return_code(this, n4);
                        }
                        bl = true;
                    }
                    n3 = bufferedReader.read();
                } else {
                    InputStream inputStream = (InputStream)this.paramRow[n2].getValue();
                    byte[] byArray = new byte[Math.min(32699, n5)];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "paramRow[" + n2 + "].doConversion", "False");
                        DB2Trace.data(20, "bytes toRead", n5);
                    }
                    while (n5 != 0 && (n3 = inputStream.read(byArray, 0, Math.min(32699, n5))) != -1) {
                        n5 -= n3;
                        if (0 == n3) break;
                        n4 = this.SQLPutByteData(byArray, n3, this.statementHandle);
                        if (n4 != 0) {
                            this.sqlExcptGen.check_return_code(this, n4);
                        }
                        bl = true;
                    }
                    n3 = inputStream.read();
                }
                if (!Boolean.getBoolean("DB2.ignore.stream.length") && (-1 == n3 && n5 != 0 || -1 != n3 && n5 == 0)) {
                    this.cancel();
                    DB2Trace.data(30, "Data length provided to stream did not match the stream length sent to server. Throwing an SQLException");
                    throw new SQLException("The stream contains more or less data than was specified");
                }
                if (!bl) {
                    DB2Trace.data(30, "No data read from InputStream. Throwing IOException");
                    throw new IOException("No data available from InputStream");
                }
            }
            catch (IOException iOException) {
                this.sqlExcptGen.throw_IOException(iOException);
            }
            Object var12_15 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "loadParameters2()", this.returnCode);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "loadParameters2()", this.returnCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery() throws SQLException {
        DB2ResultSet dB2ResultSet;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeQuery()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "statementType", this.statementType);
            }
            if (24 != this.statementType && 25 != this.statementType && 27 != this.statementType) {
                this.sqlExcptGen.throwInvalidQueryError();
            }
            this.execute2();
            this.getResultSet();
            dB2ResultSet = this.resultSet;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2ResultSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "executeQuery()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "executeQuery()");
        return dB2ResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate() throws SQLException {
        int n;
        int n2 = -2;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeUpdate()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "statementType", this.statementType);
            }
            if (24 == this.statementType) {
                this.sqlExcptGen.throwInvalidUpdateError();
            }
            this.execute2();
            n = n2 = this.getUpdateCount();
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "executeUpdate()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "executeUpdate()", n2);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute2() throws SQLException {
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "execute2()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.warnings = null;
            this.batchReturn = null;
            int n = 0;
            while (n < this.maxNumParams) {
                if (this.paramRow[n].isSet()) {
                    int n2;
                    Object object = this.paramRow[n].getValue();
                    if (this.paramRow[n].isStream() && this.direction[n] == 2) {
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    if (this.sqltypes[n] == 0 || this.sqltypeGuessed[n]) {
                        this.guessSQLType(n + 1, this.paramRow[n].getLength());
                    }
                    if (27 == this.statementType && this.sqljDescribeInfo == null) {
                        this.checkForSQLJGraphic(n + 1);
                    }
                    if (!this.wasBound[n]) {
                        this.setPrecision(n + 1);
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "wasBound[" + n + "] = " + this.wasBound[n]);
                        DB2Trace.data(10, "sqltypes[" + n + "] = " + this.sqltypes[n]);
                        DB2Trace.data(10, "sqltypeGuessed[" + n + "] = " + this.sqltypeGuessed[n]);
                        DB2Trace.data(10, "precisions[" + n + "] = " + this.precisions[n]);
                        DB2Trace.data(10, "scales[" + n + "] = " + this.scales[n]);
                        DB2Trace.data(10, "ctypes[" + n + "] = " + this.ctypes[n]);
                        DB2Trace.data(10, "described[" + n + "] = " + this.described[n]);
                        DB2Trace.data(10, "direction[" + n + "] = " + this.direction[n]);
                        DB2Trace.data(10, "About to BIND...");
                    }
                    if (object == null) {
                        n2 = !this.wasBound[n] ? this.SQLBindNull(this.direction[n], n + 1, this.sqltypes[n], this.precisions[n], this.scales[n], this.ctypes[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindNull2(this.parameters[n]);
                        this.sqlExcptGen.check_return_code(this, n2);
                    } else {
                        switch (this.ctypes[n]) {
                            case -25: {
                                n2 = !this.wasBound[n] ? this.SQLBindBigInt(this.direction[n], n + 1, ((PrimitiveData)object).longValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindBigInt2(((PrimitiveData)object).longValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 4: {
                                n2 = !this.wasBound[n] ? this.SQLBindInteger(this.direction[n], n + 1, ((PrimitiveData)object).intValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindInteger2(((PrimitiveData)object).intValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -7: 
                            case -6: 
                            case 5: {
                                n2 = !this.wasBound[n] ? this.SQLBindSmallInt(this.direction[n], n + 1, ((PrimitiveData)object).shortValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindSmallInt2(((PrimitiveData)object).shortValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 7: {
                                n2 = !this.wasBound[n] ? this.SQLBindReal(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], n + 1, ((PrimitiveData)object).floatValue(), this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindReal2(((PrimitiveData)object).floatValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 8: {
                                n2 = !this.wasBound[n] ? this.SQLBindDouble(this.direction[n], n + 1, ((PrimitiveData)object).doubleValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindDouble2(((PrimitiveData)object).doubleValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -8: 
                            case 1: {
                                if (this.paramRow[n].isStream()) {
                                    n2 = this.SQLBindStream(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], this.ctypes[n], n + 1, this.paramRow[n].getLength() * 2, this.paramRow[n].doConversion(), this.parameters[n], this.parameters, this.statementHandle);
                                } else {
                                    DB2Connection dB2Connection = this.connection;
                                    synchronized (dB2Connection) {
                                        n2 = this.SQLBindChar(this.direction[n], this.sqltypes[n], this.precisions[n], n + 1, (String)object, this.scales[n], this.ctypes[n], this.parameters[n], this.parameters, this.statementHandle, this.connection.connectionHandle, !this.wasBound[n]);
                                    }
                                }
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -2: {
                                n2 = this.paramRow[n].isStream() ? this.SQLBindStream(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], this.ctypes[n], n + 1, this.paramRow[n].getLength(), this.paramRow[n].doConversion(), this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindBinary(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], n + 1, (byte[])object, this.parameters[n], this.parameters, this.statementHandle, !this.wasBound[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 31: {
                                int n3 = ((DB2Blob)object).getLocator();
                                n2 = this.SQLBindLob(this.direction[n], n + 1, n3, this.ctypes[n], this.parameters[n], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -351: 
                            case 41: {
                                int n4 = ((DB2Clob)object).getLocator();
                                n2 = this.SQLBindLob(this.direction[n], n + 1, n4, this.ctypes[n], this.parameters[n], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 9: {
                                n2 = !this.wasBound[n] ? this.SQLBindDate(this.direction[n], n + 1, ((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindDate2(((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 10: {
                                n2 = !this.wasBound[n] ? this.SQLBindTime(this.direction[n], n + 1, ((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindTime2(((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 11: {
                                n2 = !this.wasBound[n] ? this.SQLBindTimestamp(this.direction[n], n + 1, ((int[])object)[0], ((int[])object)[1], ((int[])object)[2], ((int[])object)[3], ((int[])object)[4], ((int[])object)[5], ((int[])object)[6], this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindTimestamp2(((int[])object)[0], ((int[])object)[1], ((int[])object)[2], ((int[])object)[3], ((int[])object)[4], ((int[])object)[5], ((int[])object)[6], this.parameters[n], this.sqltypes[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            default: {
                                this.sqlExcptGen.pstmtException("S1003");
                            }
                        }
                    }
                    this.wasBound[n] = true;
                } else {
                    if (27 == this.statementType && this.sqljDescribeInfo == null) {
                        this.checkForSQLJGraphic(n + 1);
                    }
                    if (DB2Trace.TraceOn && this.direction[n] != 4) {
                        DB2Trace.data(20, "Error: param[" + n + "].isSet()", "false");
                    }
                }
                ++n;
            }
            if (this.resultSet != null) {
                this.resultSet.realClose();
            }
            this.rowCount = 0;
            this.colCount = 0;
            this.checkParameters();
            this.returnCode = 0;
            this.returnCode = this.SQLExecute(this.statementHandle, this.resetParamSetSize);
            if (0 == this.returnCode || 1 == this.returnCode) {
                this.resetParamSetSize = false;
            }
            if (DB2Trace.TraceOn) {
                switch (this.returnCode) {
                    case 0: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_SUCCESS");
                        break;
                    }
                    case 99: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_NEED_DATA");
                        break;
                    }
                    case 100: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_NO_DATA_FOUND");
                        break;
                    }
                    default: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", this.returnCode);
                    }
                }
            }
            if (this.returnCode == 99) {
                this.returnCode = this.loadParameters();
            }
            if (this.returnCode == 100) {
                this.rowCount = 0;
                Object var7_7 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
                DB2Trace.methodExit(this, "execute2()");
                return;
            }
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            this.executed = true;
            Object var7_8 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
            DB2Trace.methodExit(this, "execute2()");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNull(int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setNull( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (n2 == 0) {
                this.sqlExcptGen.pstmtException("S1003");
            }
            if (n2 == 2001 || n2 == 2002 || n2 == 2006) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "parameterIndex", n);
                    DB2Trace.data(10, "inType", n2);
                }
                this.describeParam(n, true);
                n2 = this.sqltypes[n - 1];
            }
            int n3 = this.convert2SQLType(n2);
            int n4 = this.ctypes[n - 1];
            if (n4 == 0) {
                n4 = this.sqlType2cType(n3);
            }
            this.setDirection(n, n3, n4);
            this.paramRow[n - 1].set(-1, null);
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setNull()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setNull()");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBoolean(n, bl, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setBoolean(int n, boolean bl, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBoolean( " + n + ", " + bl + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (bl) {
                this.setShort(n, (short)1, n2);
            } else {
                this.setShort(n, (short)0, n2);
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setBoolean()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setBoolean()");
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setByte(n, by, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setByte(int n, byte by, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setByte( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.setShort(n, by, n2);
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setByte()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setByte()");
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setShort(n, s, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setShort(int n, short s, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setShort( " + n + ", " + s + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(n, n2, 5);
            this.paramRow[n - 1].set(0, s);
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setShort()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setShort()");
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setInt(n, n2, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setInt(int n, int n2, int n3) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setInt( " + n + ", " + n2 + ", " + n3 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(n, n3, 4);
            this.paramRow[n - 1].set(0, n2);
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setInt()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setInt()");
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setLong(n, l, -5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setLong(int n, long l, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setLong( " + n + ", " + l + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            int n3 = this.convert2SQLType(-5);
            this.setDirection(n, n3, -25);
            if (-5 == n3) {
                this.paramRow[n - 1].set(0, l);
            } else {
                this.paramRow[n - 1].set(0, (int)l);
            }
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setLong()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setLong()");
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setFloat(n, f, 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setFloat(int n, float f, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFloat( " + n + ", " + f + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            n2 = this.convert2SQLType(n2);
            this.setDirection(n, n2, 7);
            this.paramRow[n - 1].set(0, f);
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setFloat()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setFloat()");
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setDouble(n, d, 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setDouble(int n, double d, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDouble( " + n + ", " + d + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(n, n2, 8);
            this.paramRow[n - 1].set(0, d);
            Object var6_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setDouble()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setDouble()");
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBigDecimal(n, bigDecimal, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBigDecimal(int n, BigDecimal bigDecimal, int n2) throws SQLException {
        block6: {
            block5: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setBigDecimal( " + n + ", " + bigDecimal + ", " + n2 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (bigDecimal == null) {
                        this.setNull(n, n2);
                        Object var6_4 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block5;
                    }
                    this.setDirection(n, n2, -8);
                    int n3 = n - 1;
                    this.setPrecisionAndScale(n3, bigDecimal);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setBigDecimal()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setBigDecimal()");
            return;
        }
        Object var6_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setBigDecimal()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPrecisionAndScale(int n, BigDecimal bigDecimal) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setPrecisionAndScale( " + n + ", " + bigDecimal + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (27 == this.statementType && this.sqljDescribeInfo != null) {
                this.paramRow[n].set((int)this.precisions[n], bigDecimal.toString());
            } else {
                int n2 = this.scales[n];
                String string = bigDecimal.abs().toString();
                int n3 = 0;
                int n4 = string.length();
                if (string.indexOf(46) != -1) {
                    n3 = 1;
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (!string.startsWith("0", n5)) break;
                    ++n3;
                    ++n5;
                }
                int n6 = bigDecimal.scale();
                int n7 = n4 - n3;
                n7 = Math.max(n7, 1);
                if (n6 > this.scales[n]) {
                    this.scales[n] = n6;
                } else {
                    n7 += this.scales[n] - n6;
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "scale", n6);
                    DB2Trace.data(10, "precision", n7);
                }
                if (n2 != this.scales[n]) {
                    this.wasBound[n] = false;
                }
                this.paramRow[n].set(n7, bigDecimal.toString());
            }
            Object var11_10 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setPrecisionAndScale()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setPrecisionAndScale()");
    }

    public void setString(int n, String string) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (string == null) {
            int n2 = n - 1;
            if (this.ctypes[n2] == 0) {
                this.ctypes[n2] = -8;
                this.wasBound[n2] = false;
            }
            this.setDirection(n, 0, this.ctypes[n2]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setString(n, string, 0, -1);
    }

    protected void setString(int n, String string, int n2) throws SQLException {
        this.setString(n, string, n2, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setString(int n, String string, int n2, int n3) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setString( " + n + ", " + string + ", " + n2 + ", " + n3 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.setDirection(n, n2, -8, n3);
            int n4 = string.length();
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "String length", n4);
            }
            this.paramRow[n - 1].set(n4, string);
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setString()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setString()");
    }

    protected byte[] toByteArray(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            byArray[n * 2] = (byte)((cArray[n] & 0xFF00) >> 8);
            byArray[n * 2 + 1] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        return byArray;
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (byArray == null) {
            int n2 = n - 1;
            if (this.ctypes[n2] == 0) {
                this.ctypes[n2] = -2;
                this.wasBound[n2] = false;
            }
            this.setDirection(n, 0, this.ctypes[n2]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setBytes(n, byArray, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setBytes(int n, byte[] byArray, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBytes( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (n2) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 91: 
                case 92: 
                case 93: {
                    this.sqlExcptGen.pstmtException("22003");
                }
            }
            this.setDirection(n, n2, -2);
            this.paramRow[n - 1].set(byArray.length, byArray);
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setBytes()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setBytes()");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, 91, Calendar.getInstance());
    }

    protected void setDate(int n, Date date, int n2) throws SQLException {
        this.setDate(n, date, n2, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setDate(int n, Date date, int n2, Calendar calendar) throws SQLException {
        block9: {
            block8: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setDate( " + n + ", sqlType=" + n2 + ", Date=" + date + ",calTimeZone=" + calendar.getTimeZone().getID() + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (null == date) {
                        this.setNull(n, n2);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block8;
                    }
                    this.setDirection(n, n2, 9);
                    calendar = (Calendar)calendar.clone();
                    calendar.setTime(date);
                    int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)};
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year", nArray[0]);
                        DB2Trace.data(10, "Month", nArray[1]);
                        DB2Trace.data(10, "Day", nArray[2]);
                    }
                    this.paramRow[n - 1].set(0, nArray);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setDate()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setDate()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setDate()");
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, 92, Calendar.getInstance());
    }

    protected void setTime(int n, Time time, int n2) throws SQLException {
        this.setTime(n, time, n2, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setTime(int n, Time time, int n2, Calendar calendar) throws SQLException {
        block9: {
            block8: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setTime( " + n + ",sqlType=" + n2 + ", Time=" + time + ", calTimeZone=" + calendar.getTimeZone().getID() + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (time == null) {
                        this.setNull(n, n2);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block8;
                    }
                    this.setDirection(n, n2, 10);
                    calendar = (Calendar)calendar.clone();
                    calendar.setTime(time);
                    int[] nArray = new int[]{calendar.get(11), calendar.get(12), calendar.get(13)};
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Hour", nArray[0]);
                        DB2Trace.data(10, "Minute", nArray[1]);
                        DB2Trace.data(10, "Second", nArray[2]);
                    }
                    this.paramRow[n - 1].set(0, nArray);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setTime()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setTime()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setTime()");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, 93, Calendar.getInstance());
    }

    protected void setTimestamp(int n, Timestamp timestamp, int n2) throws SQLException {
        this.setTimestamp(n, timestamp, n2, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setTimestamp(int n, Timestamp timestamp, int n2, Calendar calendar) throws SQLException {
        block9: {
            block8: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setTimestamp( " + n + ", sqlType=" + n2 + ",TimeStamp=" + timestamp + ", calTimeZone=" + calendar.getTimeZone().getID() + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (timestamp == null) {
                        this.setNull(n, n2);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block8;
                    }
                    this.setDirection(n, n2, 11);
                    calendar = (Calendar)calendar.clone();
                    calendar.setTime(timestamp);
                    int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos()};
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year", nArray[0]);
                        DB2Trace.data(10, "Month", nArray[1]);
                        DB2Trace.data(10, "Day", nArray[2]);
                        DB2Trace.data(10, "Hour_of_Day", nArray[3]);
                        DB2Trace.data(10, "Minute", nArray[4]);
                        DB2Trace.data(10, "Second", nArray[5]);
                        DB2Trace.data(10, "Nano", nArray[6]);
                    }
                    this.paramRow[n - 1].set(0, nArray);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setTimestamp()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setTimestamp()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setTimestamp()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        block11: {
            block10: {
                block9: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setAsciiStream(" + n + ", " + inputStream + ", " + n2 + " )");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (n < 1 || n > this.maxNumParams) {
                            this.sqlExcptGen.throwParamIndexError();
                        }
                        if (null == inputStream) {
                            int n3 = n - 1;
                            if (this.ctypes[n3] == 0) {
                                this.ctypes[n3] = 1;
                                this.wasBound[n3] = false;
                            }
                            this.setDirection(n, 0, this.ctypes[n3]);
                            this.paramRow[n - 1].set(-1, null);
                            Object var6_6 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block9;
                        }
                        if (0 == n2) {
                            String string = new String();
                            this.setString(n, string);
                            break block10;
                        }
                        this.setDirection(n, 0, 1);
                        this.paramRow[n - 1].set(n2, inputStream, true, false);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setAsciiStream()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setAsciiStream()");
                return;
            }
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setAsciiStream()");
            return;
        }
        Object var6_8 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setAsciiStream()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        block13: {
            block12: {
                block11: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setUnicodeStream(" + n + ", " + n2 + " )");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (n < 1 || n > this.maxNumParams) {
                            this.sqlExcptGen.throwParamIndexError();
                        }
                        if (null == inputStream) {
                            int n3 = n - 1;
                            if (this.ctypes[n3] == 0) {
                                this.ctypes[n3] = -8;
                                this.wasBound[n3] = false;
                            }
                            this.setDirection(n, 0, this.ctypes[n3]);
                            this.paramRow[n - 1].set(-1, null);
                            Object var7_7 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block11;
                        }
                        if (0 == n2) {
                            String string = new String();
                            this.setString(n, string);
                            break block12;
                        }
                        this.setDirection(n, 0, -8);
                        InputStreamReader inputStreamReader = null;
                        try {
                            inputStreamReader = new InputStreamReader(inputStream, "UnicodeBig");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            unsupportedEncodingException.printStackTrace();
                        }
                        this.paramRow[n - 1].set(n2 / 2, inputStreamReader, true, true);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setUnicodeStream()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setUnicodeStream()");
                return;
            }
            Object var7_8 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setUnicodeStream()");
            return;
        }
        Object var7_9 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setUnicodeStream()");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (inputStream == null) {
            int n3 = n - 1;
            if (this.ctypes[n3] == 0) {
                this.ctypes[n3] = -2;
                this.wasBound[n3] = false;
            }
            this.setDirection(n, 0, this.ctypes[n3]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setBinaryStream(n, inputStream, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBinaryStream(int n, InputStream inputStream, int n2, int n3) throws SQLException {
        block5: {
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setBinaryStream( " + n + " , " + inputStream + ", " + n2 + " , " + n3 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (0 == n2) {
                        this.setBytes(n, new byte[0], n3);
                        Object var6_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block4;
                    }
                    this.setDirection(n, n3, -2);
                    this.paramRow[n - 1].set(n2, inputStream, true, false);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setBinaryStream()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setBinaryStream()");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setBinaryStream()");
    }

    public void clearParameters() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearParameters()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "sqljPSCloned", String.valueOf(this.sqljPSCloned));
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.parameters != null && this.maxNumParams != 0 && !this.sqljPSCloned) {
                this.freeArrays(this.maxNumParams, this.parameters);
            }
            int n = 0;
            while (n < this.maxNumParams) {
                if (!this.sqljPSCloned) {
                    this.parameters[n] = 0L;
                    this.paramRow[n].unset();
                    this.direction[n] = 0;
                }
                this.wasBound[n] = false;
                ++n;
            }
            if (!this.sqljPSCloned) {
                this.SQLFreeStmtClearParameters(this.statementHandle);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            DB2Trace.methodExit(this, "clearParameters()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "clearParameters()");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, 0, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block55: {
            block54: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setObject( " + n + ", " + object + ", " + n2 + ", " + n3 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (object == null) {
                        this.setNull(n, n2);
                        Object var7_5 = null;
                        break block54;
                    }
                    if (n2 == 2001 || n2 == 2002 || n2 == 2006) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "parameterIndex", n);
                            DB2Trace.data(10, "targetType", n2);
                        }
                        this.describeParam(n, true);
                        n2 = this.sqltypes[n - 1];
                    }
                    if (n2 == 0) {
                        try {
                            if (object instanceof String) {
                                this.setString(n, (String)object);
                                break block55;
                            }
                            if (object instanceof Character) {
                                this.setString(n, ((Character)object).toString());
                                break block55;
                            }
                            if (object instanceof BigDecimal) {
                                BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                                this.setBigDecimal(n, bigDecimal);
                                break block55;
                            }
                            if (object instanceof Boolean) {
                                this.setBoolean(n, (Boolean)object);
                                break block55;
                            }
                            if (object instanceof Short) {
                                this.setShort(n, (Short)object);
                                break block55;
                            }
                            if (object instanceof Integer) {
                                this.setInt(n, (Integer)object);
                                break block55;
                            }
                            if (object instanceof Long) {
                                this.setLong(n, (Long)object);
                                break block55;
                            }
                            if (object instanceof Float) {
                                this.setFloat(n, ((Float)object).floatValue());
                                break block55;
                            }
                            if (object instanceof Double) {
                                this.setDouble(n, (Double)object);
                                break block55;
                            }
                            if (object instanceof byte[]) {
                                this.setBytes(n, (byte[])object);
                                break block55;
                            }
                            if (object instanceof Date) {
                                this.setDate(n, (Date)object);
                                break block55;
                            }
                            if (object instanceof Time) {
                                this.setTime(n, (Time)object);
                                break block55;
                            }
                            if (object instanceof Timestamp) {
                                this.setTimestamp(n, (Timestamp)object);
                                break block55;
                            }
                            if (object instanceof Blob) {
                                this.setBlob(n, (Blob)object);
                                break block55;
                            }
                            if (object instanceof Clob) {
                                this.setClob(n, (Clob)object);
                                break block55;
                            }
                            if (object instanceof URL) {
                                this.setURL(n, (URL)object);
                                break block55;
                            }
                            this.sqlExcptGen.pstmtException("S1003");
                        }
                        catch (ClassCastException classCastException) {
                            this.sqlExcptGen.pstmtException("S1003");
                        }
                        break block55;
                    }
                    n2 = this.convert2SQLType(n2);
                    try {
                        if (object instanceof String) {
                            if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                                this.setString(n, DB2PreparedStatement.translateFloat((String)object), n2, n3);
                                break block55;
                            }
                            if (n2 == 70 || n2 == -400) {
                                try {
                                    URL uRL = new URL((String)object);
                                    this.setURL(n, uRL, n2);
                                    break block55;
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new SQLException(malformedURLException.getMessage());
                                }
                            }
                            this.setString(n, (String)object, n2);
                            break block55;
                        }
                        if (object instanceof Character) {
                            if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                                this.setString(n, DB2PreparedStatement.translateFloat(((Character)object).toString()), n2, n3);
                                break block55;
                            } else {
                                this.setString(n, ((Character)object).toString(), n2);
                            }
                            break block55;
                        }
                        if (object instanceof BigDecimal) {
                            BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                            this.setBigDecimal(n, bigDecimal, n2);
                            break block55;
                        }
                        if (object instanceof Boolean) {
                            if (n2 == 1 || n2 == 12 || n2 == -1 || n2 == -99) {
                                this.setString(n, ((Boolean)object).toString(), n2);
                                break block55;
                            } else {
                                this.setBoolean(n, (Boolean)object, n2);
                            }
                            break block55;
                        }
                        if (object instanceof Short) {
                            this.setShort(n, (Short)object, n2);
                            break block55;
                        }
                        if (object instanceof Integer) {
                            this.setInt(n, (Integer)object, n2);
                            break block55;
                        }
                        if (object instanceof Long) {
                            this.setLong(n, (Long)object, n2);
                            break block55;
                        }
                        if (object instanceof Float) {
                            this.setFloat(n, ((Float)object).floatValue(), n2);
                            break block55;
                        }
                        if (object instanceof Double) {
                            this.setDouble(n, (Double)object, n2);
                            break block55;
                        }
                        if (object instanceof byte[]) {
                            this.setBytes(n, (byte[])object, n2);
                            break block55;
                        }
                        if (object instanceof Date) {
                            this.setDate(n, (Date)object, n2);
                            break block55;
                        }
                        if (object instanceof Time) {
                            this.setTime(n, (Time)object, n2);
                            break block55;
                        }
                        if (object instanceof Timestamp) {
                            this.setTimestamp(n, (Timestamp)object, n2);
                            break block55;
                        }
                        if (object instanceof Blob) {
                            this.setBlob(n, (Blob)object, n2);
                            break block55;
                        }
                        if (object instanceof Clob) {
                            this.setClob(n, (Clob)object, n2);
                            break block55;
                        }
                        if (object instanceof URL) {
                            this.setURL(n, (URL)object, n2);
                            break block55;
                        }
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    catch (ClassCastException classCastException) {
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    break block55;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    DB2Trace.methodExit(this, "setObject()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setObject()");
            return;
        }
        Object var7_6 = null;
        DB2Trace.methodExit(this, "setObject()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        boolean bl;
        boolean bl2;
        block5: {
            boolean bl3;
            block4: {
                bl2 = false;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    this.execute2();
                    this.getResultSet();
                    if (this.resultSet.numCols > 0) {
                        bl2 = true;
                        bl3 = true;
                        Object var4_4 = null;
                        if (!DB2Trace.TraceOn) return bl3;
                        break block4;
                    }
                    bl2 = false;
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "execute()", bl2);
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "execute()", bl2);
            return bl3;
        }
        Object var4_5 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "execute()", bl2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2ParameterMetaData getParameterMetaData() throws SQLException {
        DB2ParameterMetaData dB2ParameterMetaData;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getParameterMetaData()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            dB2ParameterMetaData = new DB2ParameterMetaData(this);
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2ParameterMetaData;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getParameterMetaData()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getParameterMetaData()");
        return dB2ParameterMetaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2ResultSetMetaData getResultSetMetaData() throws SQLException {
        DB2ResultSetMetaData dB2ResultSetMetaData;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetMetaData()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            dB2ResultSetMetaData = new DB2ResultSetMetaData(this);
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2ResultSetMetaData;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getParameterMetaData()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getParameterMetaData()");
        return dB2ResultSetMetaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int convert2SQLType(int n) throws SQLException {
        int n2;
        int n3 = n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "convert2SQLType( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (n3) {
                case -7: 
                case -6: {
                    n3 = 5;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                case 6: {
                    n3 = 8;
                    break;
                }
                case -5: {
                    n3 = -5;
                    break;
                }
                case 7: {
                    n3 = this.connection.getRealSqlType();
                    break;
                }
                case 2004: {
                    n3 = -98;
                    break;
                }
                case 2005: {
                    n3 = -99;
                    break;
                }
                case 70: {
                    n3 = -400;
                }
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "convert2SQLType()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "convert2SQLType()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int sqlType2cType(int n) {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "sqlType2cType( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (n) {
                case -5: {
                    n3 = -25;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = -8;
                    break;
                }
                case -98: 
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    n3 = -2;
                    break;
                }
                case -400: 
                case -99: 
                case -1: 
                case 1: 
                case 12: 
                case 70: 
                case 2005: {
                    n3 = -8;
                    break;
                }
                case 91: {
                    n3 = 9;
                    break;
                }
                case 92: {
                    n3 = 10;
                    break;
                }
                case 93: {
                    n3 = 11;
                    break;
                }
                default: {
                    n3 = n;
                }
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "sqlType2cType()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "sqlType2cType()", n3);
        return n2;
    }

    protected static String translateFloat(String string) {
        char c = new DecimalFormatSymbols().getDecimalSeparator();
        if (c != '.') {
            return string.replace(c, '.');
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setPrecision(int n) throws SQLException {
        int n2;
        block17: {
            block16: {
                n2 = n - 1;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setPrecision( " + n + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (1 == this.described[n2]) {
                        Object var7_3 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block16;
                    }
                    boolean bl = false;
                    long l = this.precisions[n2];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "precisions[" + n2 + "]", this.precisions[n2]);
                        DB2Trace.data(20, "direction[" + n2 + "]", this.direction[n2]);
                        DB2Trace.data(20, "ctypes[" + n2 + "]", this.ctypes[n2]);
                        DB2Trace.data(20, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                    }
                    if (2 == this.sqltypes[n2] || 3 == this.sqltypes[n2]) {
                        this.precisions[n2] = this.connection.getTypeMaxLength(this.sqltypes[n2]);
                    } else if (1 != this.direction[n2]) {
                        if (this.ctypes[n2] != 1 && this.ctypes[n2] != -8 && this.ctypes[n2] != -2) {
                            this.precisions[n2] = this.connection.getTypeMaxLength(this.sqltypes[n2]);
                        } else if (this.sqltypes[n2] == 1 || this.sqltypes[n2] == 12 || this.sqltypes[n2] == -1 || this.sqltypes[n2] == -2 || this.sqltypes[n2] == -3 || this.sqltypes[n2] == -4 || this.sqltypes[n2] == -95 || this.sqltypes[n2] == -96 || this.sqltypes[n2] == -97) {
                            if (2 != this.described[n2] && this.connection.isDescribeParamSupported()) {
                                this.describeParam(n, false);
                            }
                            if (1 != this.described[n2]) {
                                this.precisions[n2] = this.connection.getTypeMaxLength(this.sqltypes[n2]);
                            }
                        } else if (this.sqltypes[n2] == -98 || this.sqltypes[n2] == -99 || this.sqltypes[n2] == -350) {
                            this.describeParam(n, true);
                        }
                    }
                    if (this.precisions[n2] != l) {
                        this.wasBound[n2] = false;
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "wasBound[" + n2 + "]", String.valueOf(this.wasBound[n2]));
                    DB2Trace.data(10, "precisions[" + n2 + "]", this.precisions[n2]);
                    DB2Trace.methodExit(this, "setPrecision()");
                    throw throwable;
                }
            }
            DB2Trace.data(10, "wasBound[" + n2 + "]", String.valueOf(this.wasBound[n2]));
            DB2Trace.data(10, "precisions[" + n2 + "]", this.precisions[n2]);
            DB2Trace.methodExit(this, "setPrecision()");
            return;
        }
        Object var7_4 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "wasBound[" + n2 + "]", String.valueOf(this.wasBound[n2]));
        DB2Trace.data(10, "precisions[" + n2 + "]", this.precisions[n2]);
        DB2Trace.methodExit(this, "setPrecision()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void describeParam(int n, boolean bl) throws SQLException {
        int n2;
        int n3;
        block11: {
            block10: {
                n3 = 0;
                n2 = n - 1;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "describeParam( parameterIndex=" + n + "," + "throwExcept=" + String.valueOf(bl) + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (1 == this.described[n2]) {
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block10;
                    }
                    if (DB2Trace.TraceOn && !this.connection.isDescribeParamSupported()) {
                        DB2Trace.data(10, "Describe not supported");
                    }
                    if (0 == (n3 = this.SQLDescribeParam(this.statementHandle, n, this.sqltypes, this.precisions, this.scales))) {
                        this.described[n2] = 1;
                        this.sqltypeGuessed[n2] = false;
                        break block11;
                    }
                    this.described[n2] = 2;
                    try {
                        this.sqlExcptGen.check_return_code(this, n3);
                    }
                    catch (SQLException sQLException) {
                        if (bl) {
                            throw sQLException;
                        }
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "Describe failed but JDBC not propagating error to application.");
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "described[" + n2 + "]", this.described[n2]);
                    DB2Trace.data(10, "sqltypeGuessed[" + n2 + "]", String.valueOf(this.sqltypeGuessed[n2]));
                    DB2Trace.methodExit((Object)this, "describeParam()", n3);
                    throw throwable;
                }
            }
            DB2Trace.data(10, "described[" + n2 + "]", this.described[n2]);
            DB2Trace.data(10, "sqltypeGuessed[" + n2 + "]", String.valueOf(this.sqltypeGuessed[n2]));
            DB2Trace.methodExit((Object)this, "describeParam()", n3);
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "described[" + n2 + "]", this.described[n2]);
        DB2Trace.data(10, "sqltypeGuessed[" + n2 + "]", String.valueOf(this.sqltypeGuessed[n2]));
        DB2Trace.methodExit((Object)this, "describeParam()", n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void guessSQLType(int n, int n2) throws SQLException {
        int n3;
        block15: {
            block14: {
                block13: {
                    n3 = n - 1;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "guessSQLType( " + n + "," + n2 + ")");
                        }
                        if (this.sqltypes[n3] != 0 && !this.sqltypeGuessed[n3]) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Cannot override user provided sqlType");
                            }
                            Object var6_4 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block13;
                        }
                        this.sqltypeGuessed[n3] = true;
                        if (this.sqltypes[n3] == -99 || this.sqltypes[n3] == -350 || this.sqltypes[n3] == -98) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "sqlType already at maximum type (LOB)");
                            }
                            break block14;
                        }
                        int n4 = this.sqltypes[n3];
                        if (n2 == -1) {
                            n2 = 0;
                        }
                        if (!(n2 > this.connection.getTypeMaxLength(12) || this.paramRow[n3].isStream() || this.ctypes[n3] == 1 && this.sqltypes[n3] == -1 || this.ctypes[n3] == -8 && this.sqltypes[n3] == -1 || this.ctypes[n3] == -2 && this.sqltypes[n3] == -4)) {
                            this.sqltypes[n3] = this.ctypes[n3] == -2 ? -3 : 12;
                        } else if (n2 <= this.connection.getTypeMaxLength(-1) || !this.connection.isLOBSupported()) {
                            this.sqltypes[n3] = this.ctypes[n3] == -2 ? -4 : -1;
                        } else {
                            int n5 = this.sqltypes[n3] = this.ctypes[n3] == -2 ? -98 : -99;
                        }
                        if (this.sqltypes[n3] != n4) {
                            this.wasBound[n3] = false;
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
                        DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
                        DB2Trace.data(20, "length", n2);
                        DB2Trace.methodExit(this, "guessSQLType");
                        throw throwable;
                    }
                }
                DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
                DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
                DB2Trace.data(20, "length", n2);
                DB2Trace.methodExit(this, "guessSQLType");
                return;
            }
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
            DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
            DB2Trace.data(20, "length", n2);
            DB2Trace.methodExit(this, "guessSQLType");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
        DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
        DB2Trace.data(20, "length", n2);
        DB2Trace.methodExit(this, "guessSQLType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.paramSet.addElement(this.paramRow);
            this.paramRow = new ParamElement[this.maxNumParams];
            int n = 0;
            while (n < this.maxNumParams) {
                this.paramRow[n] = new ParamElement();
                ++n;
            }
            ++this.batchSize;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "addBatch()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "addBatch()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearBatch()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchSize = 0;
            this.paramSet.removeAllElements();
            int n = 0;
            while (n < this.maxNumParams) {
                this.paramRow[n].unset();
                this.wasBound[n] = false;
                ++n;
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "clearBatch()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "clearBatch()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        try {
            int n;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeBatch()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchReturn = new int[this.batchSize];
            if (this.resultSet != null) {
                this.resultSet.realClose();
            }
            if (0 == this.batchSize) {
                int[] nArray = this.batchReturn;
                Object var42_2 = null;
                this.clearBatch();
                if (!DB2Trace.TraceOn) return nArray;
                DB2Trace.methodExit(this, "executeBatch()");
                return nArray;
            }
            int n2 = 0;
            while (n2 < this.batchSize) {
                this.batchReturn[n2] = -3;
                ++n2;
            }
            if (24 == this.statementType) {
                throw new BatchUpdateException(this.sqlExcptGen.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn);
            }
            ParamElement[][] paramElementArray = null;
            ParamElement[] paramElementArray2 = null;
            ParamElement[][] paramElementArray3 = new ParamElement[this.batchSize][this.maxNumParams];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            BatchUpdateException batchUpdateException = null;
            SQLException sQLException = null;
            Enumeration enumeration = this.paramSet.elements();
            while (enumeration.hasMoreElements()) {
                paramElementArray3[n3] = (ParamElement[])enumeration.nextElement();
                n = 0;
                int n7 = 0;
                while (n7 < this.maxNumParams) {
                    block100: {
                        boolean bl = false;
                        if (!paramElementArray3[n3][n7].isSet()) {
                            if (paramElementArray2 == null || !paramElementArray2[n7].isSet()) {
                                n = 1;
                                try {
                                    this.sqlExcptGen.throwNotSet(n3, n7, this.batchReturn);
                                }
                                catch (BatchUpdateException batchUpdateException2) {
                                    if (batchUpdateException == null) {
                                        batchUpdateException = batchUpdateException2;
                                        sQLException = batchUpdateException2;
                                        break block100;
                                    }
                                    sQLException.setNextException(batchUpdateException2);
                                    sQLException = batchUpdateException2;
                                }
                            } else {
                                paramElementArray3[n3][n7] = paramElementArray2[n7];
                            }
                        }
                    }
                    ++n7;
                }
                if (n == 0) {
                    if (paramElementArray == null) {
                        n6 = this.batchSize - n4;
                        paramElementArray = new ParamElement[n6][this.maxNumParams];
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "First row with all params (zero-based)", n3);
                        }
                    }
                    paramElementArray[n5] = paramElementArray3[n3];
                    ++n5;
                } else {
                    ++n4;
                }
                paramElementArray2 = paramElementArray3[n3];
                ++n3;
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "batchSize", this.batchSize);
                DB2Trace.data(20, "batchSizeAdjusted", n6);
                DB2Trace.data(20, "Number of bad rows (badRowCnt)", n4);
                DB2Trace.data(20, "Number of good rows (goodRowCnt)", n5);
            }
            if (n6 < 1) {
                if (batchUpdateException != null) {
                    throw batchUpdateException;
                }
                int[] nArray = this.batchReturn;
                Object var42_3 = null;
                this.clearBatch();
                if (!DB2Trace.TraceOn) return nArray;
                DB2Trace.methodExit(this, "executeBatch()");
                return nArray;
            }
            int[] nArray = new int[n6];
            n = 0;
            while (n < n6) {
                nArray[n] = -3;
                ++n;
            }
            Object object = null;
            int[] nArray2 = new int[n6];
            int n8 = 0;
            int n9 = 0;
            while (n9 < this.maxNumParams) {
                block3 : switch (this.ctypes[n9]) {
                    case -25: {
                        long[] lArray = new long[n6];
                        int n10 = 0;
                        while (true) {
                            if (n10 >= n6) {
                                n8 = this.SQLBindLongArray(n9 + 1, this.sqltypes[n9], n6, lArray, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n10][n9].getValue();
                            nArray2[n10] = paramElementArray[n10][n9].getLength();
                            if (null != object) {
                                lArray[n10] = ((PrimitiveData)object).longValue();
                            }
                            ++n10;
                        }
                    }
                    case 4: {
                        int[] nArray3 = new int[n6];
                        int n11 = 0;
                        while (true) {
                            if (n11 >= n6) {
                                n8 = this.SQLBindIntArray(n9 + 1, this.sqltypes[n9], n6, nArray3, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n11][n9].getValue();
                            nArray2[n11] = paramElementArray[n11][n9].getLength();
                            if (null != object) {
                                nArray3[n11] = ((PrimitiveData)object).intValue();
                            }
                            ++n11;
                        }
                    }
                    case -7: 
                    case -6: 
                    case 5: {
                        short[] sArray = new short[n6];
                        int n12 = 0;
                        while (true) {
                            if (n12 >= n6) {
                                n8 = this.SQLBindShortArray(n9 + 1, this.sqltypes[n9], n6, sArray, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n12][n9].getValue();
                            nArray2[n12] = paramElementArray[n12][n9].getLength();
                            if (null != object) {
                                sArray[n12] = ((PrimitiveData)object).shortValue();
                            }
                            ++n12;
                        }
                    }
                    case 7: {
                        float[] fArray = new float[n6];
                        int n13 = 0;
                        while (true) {
                            if (n13 >= n6) {
                                n8 = this.SQLBindFloatArray(n9 + 1, this.sqltypes[n9], n6, fArray, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n13][n9].getValue();
                            nArray2[n13] = paramElementArray[n13][n9].getLength();
                            if (null != object) {
                                fArray[n13] = ((PrimitiveData)object).floatValue();
                            }
                            ++n13;
                        }
                    }
                    case 8: {
                        double[] dArray = new double[n6];
                        int n14 = 0;
                        while (true) {
                            if (n14 >= n6) {
                                n8 = this.SQLBindDoubleArray(n9 + 1, this.sqltypes[n9], n6, dArray, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n14][n9].getValue();
                            nArray2[n14] = paramElementArray[n14][n9].getLength();
                            if (null != object) {
                                dArray[n14] = ((PrimitiveData)object).doubleValue();
                            }
                            ++n14;
                        }
                    }
                    case -8: 
                    case 1: {
                        String[] stringArray = new String[n6];
                        int n15 = 0;
                        this.paramRow = paramElementArray[0];
                        int n16 = 0;
                        while (true) {
                            if (n16 >= n6) {
                                if (this.sqltypes[n9] == 0 || this.sqltypeGuessed[n9]) {
                                    this.guessSQLType(n9 + 1, n15);
                                }
                                if (!this.wasBound[n9]) {
                                    this.setPrecision(n9 + 1);
                                }
                                n8 = this.SQLBindStringArray(n9 + 1, this.sqltypes[n9], this.ctypes[n9], this.precisions[n9], this.scales[n9], this.direction[n9], n6, stringArray, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n16][n9].getValue();
                            nArray2[n16] = paramElementArray[n16][n9].getLength();
                            if (nArray2[n16] > n15) {
                                n15 = nArray2[n16];
                            }
                            if (null != object) {
                                if (paramElementArray[n16][n9].isStream()) {
                                    nArray2[n16] = -2;
                                    this.paramRow = paramElementArray[n16];
                                } else {
                                    stringArray[n16] = (String)object;
                                }
                            }
                            ++n16;
                        }
                    }
                    case -2: {
                        byte[][] byArrayArray = new byte[n6][];
                        int n16 = 0;
                        this.paramRow = paramElementArray[0];
                        int n17 = 0;
                        while (true) {
                            if (n17 >= n6) {
                                if (this.sqltypes[n9] == 0 || this.sqltypeGuessed[n9]) {
                                    this.guessSQLType(n9 + 1, n16);
                                }
                                if (!this.wasBound[n9]) {
                                    this.setPrecision(n9 + 1);
                                }
                                n8 = this.SQLBindByteArrayArray(n9 + 1, this.sqltypes[n9], this.precisions[n9], n6, byArrayArray, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n17][n9].getValue();
                            nArray2[n17] = paramElementArray[n17][n9].getLength();
                            if (nArray2[n17] > n16) {
                                n16 = nArray2[n17];
                            }
                            if (null != object) {
                                if (paramElementArray[n17][n9].isStream()) {
                                    nArray2[n17] = -2;
                                    this.paramRow = paramElementArray[n17];
                                } else {
                                    byArrayArray[n17] = new byte[nArray2[n17]];
                                    System.arraycopy((byte[])object, 0, byArrayArray[n17], 0, nArray2[n17]);
                                }
                            }
                            ++n17;
                        }
                    }
                    case 9: {
                        int[][] nArray4 = new int[n6][3];
                        int n18 = 0;
                        while (true) {
                            if (n18 >= n6) {
                                n8 = this.SQLBindDateArray(n9 + 1, this.sqltypes[n9], n6, nArray4, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n18][n9].getValue();
                            nArray2[n18] = paramElementArray[n18][n9].getLength();
                            if (null != object) {
                                int[] nArray5 = (int[])object;
                                System.arraycopy(nArray5, 0, nArray4[n18], 0, 3);
                            }
                            ++n18;
                        }
                    }
                    case 10: {
                        int[][] nArray6 = new int[n6][3];
                        int n19 = 0;
                        while (true) {
                            if (n19 >= n6) {
                                n8 = this.SQLBindTimeArray(n9 + 1, this.sqltypes[n9], n6, nArray6, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n19][n9].getValue();
                            nArray2[n19] = paramElementArray[n19][n9].getLength();
                            if (null != object) {
                                int[] nArray7 = (int[])object;
                                System.arraycopy(nArray7, 0, nArray6[n19], 0, 3);
                            }
                            ++n19;
                        }
                    }
                    case 11: {
                        int[] nArray8;
                        int[][] nArray9 = new int[n6][7];
                        int n20 = 0;
                        while (true) {
                            if (n20 >= n6) {
                                n8 = this.SQLBindTimestampArray(n9 + 1, this.sqltypes[n9], n6, nArray9, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n20][n9].getValue();
                            nArray2[n20] = paramElementArray[n20][n9].getLength();
                            if (null != object) {
                                nArray8 = (int[])object;
                                System.arraycopy(nArray8, 0, nArray9[n20], 0, 7);
                            }
                            ++n20;
                        }
                    }
                    case -351: 
                    case 31: 
                    case 41: {
                        int[] nArray8 = new int[n6];
                        int n21 = 0;
                        while (true) {
                            if (n21 >= n6) {
                                n8 = this.SQLBindLobArray(n9 + 1, this.ctypes[n9], n6, nArray8, nArray2, this.parameters[n9], this.parameters, this.statementHandle);
                                this.sqlExcptGen.check_return_code(this, n8);
                                break block3;
                            }
                            object = paramElementArray[n21][n9].getValue();
                            nArray2[n21] = paramElementArray[n21][n9].getLength();
                            if (object != null) {
                                nArray8[n21] = 31 == this.ctypes[n9] ? ((DB2Blob)object).getLocator() : ((DB2Clob)object).getLocator();
                            }
                            ++n21;
                        }
                    }
                    default: {
                        this.sqlExcptGen.throwNotSet(0, n9, this.batchReturn);
                    }
                }
                ++n9;
            }
            n8 = this.SQLExecBatchData(n6, nArray, this.statementHandle);
            this.resetParamSetSize = true;
            if (DB2Trace.TraceOn) {
                int n22 = 0;
                while (n22 < nArray.length) {
                    switch (nArray[n22]) {
                        case 0: {
                            DB2Trace.data(100, "returnCode[" + n22 + "]", "SQL_PARAM_SUCCESS");
                            break;
                        }
                        case 6: {
                            DB2Trace.data(100, "returnCode[" + n22 + "]", "SQL_PARAM_SUCCESS_WITH_INFO");
                            break;
                        }
                        case 5: {
                            DB2Trace.data(100, "returnCode[" + n22 + "]", "SQL_PARAM_ERROR");
                            break;
                        }
                        case 7: {
                            DB2Trace.data(100, "returnCode[" + n22 + "]", "SQL_PARAM_UNUSED");
                            break;
                        }
                    }
                    ++n22;
                }
            }
            int n23 = 0;
            while (n23 < nArray.length) {
                switch (nArray[n23]) {
                    case 0: 
                    case 6: {
                        this.batchReturn[n23 + n4] = -2;
                        break;
                    }
                    case 5: {
                        this.batchReturn[n23 + n4] = -3;
                        break;
                    }
                    case 7: {
                        this.batchReturn[n23 + n4] = 0;
                        break;
                    }
                }
                ++n23;
            }
            try {
                this.sqlExcptGen.check_batch_return_code(this, n8);
            }
            catch (BatchUpdateException batchUpdateException3) {
                if (batchUpdateException != null) {
                    sQLException.setNextException(batchUpdateException3);
                }
                batchUpdateException = batchUpdateException3;
            }
            if (batchUpdateException != null) {
                throw batchUpdateException;
            }
            int[] nArray10 = this.batchReturn;
            Object var42_4 = null;
            this.clearBatch();
            if (!DB2Trace.TraceOn) return nArray10;
            DB2Trace.methodExit(this, "executeBatch()");
            return nArray10;
        }
        catch (Throwable throwable) {
            Object var42_5 = null;
            this.clearBatch();
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "executeBatch()");
            throw throwable;
        }
    }

    protected final boolean isElementNull(ParamElement paramElement, int n, int n2) throws SQLException {
        if (!paramElement.isSet()) {
            this.sqlExcptGen.throwNotSet(n, n2, this.batchReturn);
        }
        return false;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (reader == null) {
            int n3 = n - 1;
            if (this.ctypes[n3] == 0) {
                this.ctypes[n3] = -8;
                this.wasBound[n3] = false;
            }
            this.setDirection(n, 0, this.ctypes[n3]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setCharacterStream(n, reader, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setCharacterStream(int n, Reader reader, int n2, int n3) throws SQLException {
        block5: {
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setCharacterStream( " + n + ", " + reader + ", " + n2 + ", " + n3 + " )");
                    }
                    if (0 == n2) {
                        this.setString(n, new String(), n3);
                        Object var6_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block4;
                    }
                    this.setDirection(n, n3, -8);
                    this.paramRow[n - 1].set(n2, reader, true, true);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setCharacterStream()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setCharacterStream()");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setCharacterStream()");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setRef()");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == blob) {
            this.setNull(n, -98);
            return;
        }
        this.setBlob(n, blob, -98);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBlob(int n, Blob blob, int n2) throws SQLException {
        block8: {
            block7: {
                try {
                    int n3;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setBlob( " + n + ", " + blob + ", " + n2 + " )");
                    }
                    if (0 == (n3 = (int)blob.length())) {
                        this.setBytes(n, new byte[0], n2);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block7;
                    }
                    if (blob instanceof DB2Blob && ((DB2Blob)blob).data == null && 25 != this.statementType) {
                        DB2Blob dB2Blob = (DB2Blob)blob;
                        this.setDirection(n, n2, 31);
                        this.paramRow[n - 1].set(n3, dB2Blob, false, false);
                        break block8;
                    }
                    if (25 == this.statementType) {
                        this.setBytes(n, blob.getBytes(1L, (int)blob.length()), n2);
                        break block8;
                    } else {
                        this.setBinaryStream(n, blob.getBinaryStream(), n3, n2);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setBlob()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setBlob()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setBlob()");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == clob) {
            this.setNull(n, -99);
            return;
        }
        this.setClob(n, clob, -99);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setClob(int n, Clob clob, int n2) throws SQLException {
        block8: {
            block7: {
                try {
                    int n3;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setClob( " + n + ", " + clob + ", " + n2 + " )");
                    }
                    if (0 == (n3 = (int)clob.length())) {
                        this.setString(n, new String(), n2);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block7;
                    }
                    if (clob instanceof DB2Clob && ((DB2Clob)clob).data == null & 25 != this.statementType) {
                        DB2Clob dB2Clob = (DB2Clob)clob;
                        n2 = dB2Clob.lobType == 41 ? -99 : -350;
                        this.setDirection(n, n2, dB2Clob.lobType);
                        this.paramRow[n - 1].set(n3, dB2Clob, false, true);
                        break block8;
                    }
                    if (25 == this.statementType) {
                        this.setString(n, clob.getSubString(1L, (int)clob.length()), n2);
                        break block8;
                    } else {
                        this.setCharacterStream(n, clob.getCharacterStream(), n3, n2);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setClob()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setClob()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setClob()");
    }

    public void setArray(int n, Array array) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setArray()");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSetMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date, 91, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time, 92, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp, 93, calendar);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == uRL) {
            this.setNull(n, 70);
            return;
        }
        this.setURL(n, uRL, -400);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setURL(int n, URL uRL, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setURL( " + n + ", " + uRL + ", " + n2 + " )");
            }
            this.setDirection(n, n2, 1);
            this.paramRow[n - 1].set(uRL.toExternalForm().length(), uRL.toExternalForm());
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setURL()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setURL()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n, SQLJSection sQLJSection, SQLJColumnMetaData sQLJColumnMetaData, SQLJColumnMetaData sQLJColumnMetaData2, boolean bl, boolean bl2, int n2, int n3) throws SQLException {
        super(dB2Connection, n2, n3);
        try {
            String string2;
            int n4;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + string + "\", " + dB2Connection.connectionHandle + ", " + n + ", " + (sQLJSection != null ? "section number=" + sQLJSection.getSectionNumber() : "null") + ", " + (sQLJColumnMetaData != null ? "num parameters=" + sQLJColumnMetaData.getColumns() : "null") + ", " + (sQLJColumnMetaData2 != null ? "num columns=" + sQLJColumnMetaData2.getColumns() : "null") + ", " + bl + ", " + bl2 + ", " + n2 + ", " + n3 + ", " + " )");
            }
            this.sql = string;
            this.section = sQLJSection;
            SQLJPackage sQLJPackage = sQLJSection.getPackage();
            this.statementType = (short)27;
            this.CLIStatementType = DB2BaseConstants.mapSQLJRoleToStmtType(n, bl);
            this.parameterMetaData = sQLJColumnMetaData;
            this.resultSetMetaData = sQLJColumnMetaData2;
            int[] nArray = null;
            int[] nArray2 = null;
            int[] nArray3 = null;
            if (sQLJColumnMetaData != null) {
                this.maxNumParams = (short)sQLJColumnMetaData.getColumns();
                nArray = sQLJColumnMetaData.getSqlTypes();
                nArray2 = sQLJColumnMetaData.getPrecisions();
                nArray3 = sQLJColumnMetaData.getScales();
            }
            if ((n4 = this.SQLJPrepare(string, string == null ? 0 : string.length(), this.CLIStatementType, this.maxNumParams, this.statementHandle, sQLJSection.getSectionNumber(), sQLJPackage.getPackageName().getBytes(), sQLJPackage.getConsistencyToken(), sQLJPackage.getCollectionName().getBytes())) != 0) {
                this.sqlExcptGen.check_return_code(this, n4);
            }
            if ((string2 = sQLJSection.getServerCursorName()) != null && string2.length() > 0) {
                this.setCursorName(string2);
            }
            this.initParameterVariables();
            if (!bl2) {
                int n5 = 0;
                while (n5 < this.maxNumParams) {
                    this.sqltypes[n5] = DB2BaseConstants.mapSQLDATypeToCLISQLType(nArray[n5]);
                    this.precisions[n5] = nArray2[n5];
                    this.scales[n5] = nArray3[n5];
                    if (this.sqltypes[n5] != 0) {
                        this.described[n5] = 1;
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "sqltype[" + n5 + "]", this.sqltypes[n5]);
                        DB2Trace.data(10, "precisions[" + n5 + "]", this.precisions[n5]);
                        DB2Trace.data(10, "scales[" + n5 + "]", this.scales[n5]);
                    }
                    ++n5;
                }
            }
            Object var19_18 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2PreparedStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2PreparedStatement()");
    }

    public void setInputs(Object[] objectArray) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setInputs()");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)objectArray[0];
        this.maxNumParams = dB2PreparedStatement.maxNumParams;
        this.parameters = dB2PreparedStatement.parameters;
        this.direction = dB2PreparedStatement.direction;
        this.sqltypes = dB2PreparedStatement.sqltypes;
        this.precisions = dB2PreparedStatement.precisions;
        this.sqltypeGuessed = dB2PreparedStatement.sqltypeGuessed;
        this.ctypes = dB2PreparedStatement.ctypes;
        this.maxWholeDigits = dB2PreparedStatement.maxWholeDigits;
        this.scales = dB2PreparedStatement.scales;
        this.wasBound = dB2PreparedStatement.wasBound;
        this.described = dB2PreparedStatement.described;
        this.paramRow = dB2PreparedStatement.paramRow;
        this.paramSet = dB2PreparedStatement.paramSet;
        int n = 0;
        while (n < this.maxNumParams) {
            this.wasBound[n] = false;
            ++n;
        }
        this.sqljPSCloned = true;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setInputs()");
        }
    }

    public Object[] getInputs() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getInputs()");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        Object[] objectArray = new Object[]{this};
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getInputs()");
        }
        return objectArray;
    }

    public SQLJColumnMetaData getParameterColumnMetaData() {
        return this.parameterMetaData;
    }

    public SQLJColumnMetaData getResultSetColumnMetaData() {
        return this.resultSetMetaData;
    }

    public SQLJSection getSection() {
        return this.section;
    }

    public void setSection(SQLJSection sQLJSection) {
        int n = 0;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setSection( " + (sQLJSection != null ? "section number=" + sQLJSection.getSectionNumber() : "null") + " )");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        this.section = sQLJSection;
        SQLJPackage sQLJPackage = sQLJSection.getPackage();
        n = this.SQLJPrepare(this.sql, this.sql == null ? 0 : this.sql.length(), this.CLIStatementType, this.maxNumParams, this.statementHandle, sQLJSection.getSectionNumber(), sQLJPackage.getPackageName().getBytes(), sQLJPackage.getConsistencyToken(), sQLJPackage.getCollectionName().getBytes());
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setSection()", n);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] executeBatch(boolean var1_1) throws SQLException {
        block17: {
            block16: {
                var2_2 = null;
                var3_3 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "executeBatch( " + var1_1 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.maxNumParams > 0) {
                        var2_2 = this.executeBatch();
                    } else {
                        var3_3 = this.SQLJBatchStatements.size();
                        var2_2 = new int[var3_3];
                        var4_4 = null;
                        var5_5 = 0;
                        while (var5_5 < var3_3) {
                            try {
                                var2_2[var5_5] = ((PreparedStatement)this.SQLJBatchStatements.elementAt(var5_5)).executeUpdate();
                            }
                            catch (SQLException var6_6) {
                                var2_2[var5_5] = -3;
                                if (null == var4_4) {
                                    var4_4 = new BatchUpdateException(var6_6.getMessage(), var6_6.getSQLState(), var6_6.getErrorCode(), var2_2);
                                    if (var6_6.getNextException() != null) {
                                        var4_4.setNextException(var4_4.getNextException());
                                    }
                                }
                                var4_4.setNextException(var6_6);
                            }
                            ++var5_5;
                        }
                    }
                    var4_4 = var2_2;
                    var8_7 = null;
                    if (this.SQLJBatchStatements != null) {
                        this.SQLJBatchStatements.removeAllElements();
                    }
                    if (!DB2Trace.TraceOn) return var4_4;
                    var9_9 = new StringBuffer();
                    if (var2_2 == null) break block16;
                    var9_9.append('[');
                }
                catch (Throwable var7_13) {
                    var8_8 = null;
                    if (this.SQLJBatchStatements != null) {
                        this.SQLJBatchStatements.removeAllElements();
                    }
                    if (!DB2Trace.TraceOn) throw var7_13;
                    var9_10 = new StringBuffer();
                    if (var2_2 == null) break block17;
                    var9_10.append('[');
                    var10_12 = 0;
                    ** while (var10_12 < var2_2.length)
                }
                var10_11 = 0;
                while (var10_11 < var2_2.length) {
                    if (var10_11 > 0) {
                        var9_9.append(',');
                    }
                    var9_9.append(var2_2[var10_11]);
                    ++var10_11;
                }
                var9_9.append(']');
            }
            DB2Trace.methodExit((Object)this, "executeBatch()", var9_9.toString());
            return var4_4;
lbl-1000:
            // 1 sources

            {
                if (var10_12 > 0) {
                    var9_10.append(',');
                }
                var9_10.append(var2_2[var10_12]);
                ++var10_12;
                continue;
            }
lbl71:
            // 1 sources

            var9_10.append(']');
        }
        DB2Trace.methodExit((Object)this, "executeBatch()", var9_10.toString());
        throw var7_13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addBatch(SQLJPreparedStatement sQLJPreparedStatement) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch( Statement Handle=" + ((DB2PreparedStatement)sQLJPreparedStatement).getTraceHandle() + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.maxNumParams > 0) {
                this.addBatch();
            } else {
                if (null == this.SQLJBatchStatements) {
                    this.SQLJBatchStatements = new Vector();
                }
                this.SQLJBatchStatements.add(sQLJPreparedStatement);
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "addBatch()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "addBatch()");
    }

    public SQLJResultSet getSingletonResultSet() {
        SQLJResultSet sQLJResultSet = null;
        try {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getSingletonResultSet()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                sQLJResultSet = (SQLJResultSet)this.getResultSet();
            }
            catch (SQLException sQLException) {
                sQLJResultSet = null;
                Object var4_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == sQLJResultSet ? "ResultSet is null" : "ResultSet is not null");
                }
            }
            Object var4_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == sQLJResultSet ? "ResultSet is null" : "ResultSet is not null");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == sQLJResultSet ? "ResultSet is null" : "ResultSet is not null");
            }
            throw throwable;
        }
        return sQLJResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeSetCurrentPackageset() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeSetCurrentPackageset()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "Collection", (String)this.paramRow[0].getValue());
            }
            this.section.getPackage().changeCollectionName((String)this.paramRow[0].getValue());
            n = n2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "executeSetCurrentPackageset()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "executeSetCurrentPackageset()", n2);
        return n;
    }

    public void setSQLJSingletonQuery(boolean bl) {
        this.isSQLJSingletonQuery = bl;
    }

    public boolean getSQLJSingletonQuery() {
        return this.isSQLJSingletonQuery;
    }

    public void setQueryInstanceIdentifier(long l) {
        this.queryInstanceIdentifier = l;
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
        }

        public ParamElement(int n, Object object) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int n, Object object, boolean bl, boolean bl2) {
            this(n, object);
            this.isStream = bl;
            this.doConversion = bl2;
        }

        public void set(int n, double d) {
            this.primitiveData.set(d);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, int n2) {
            this.primitiveData.set(n2);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, float f) {
            this.primitiveData.set(f);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, long l) {
            this.primitiveData.set(l);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, short s) {
            this.primitiveData.set(s);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, Object object) {
            this.set(n, object, false, false);
        }

        public void set(int n, Object object, boolean bl, boolean bl2) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = bl;
            this.doConversion = bl2;
            this.fSet = true;
        }

        public void unset() {
            this.fSet = false;
            this.value = null;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public double doubleValue() {
            return this.doubleVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public short shortValue() {
            return this.shortVal;
        }

        public void set(double d) {
            this.doubleVal = d;
        }

        public void set(int n) {
            this.intVal = n;
        }

        public void set(float f) {
            this.floatVal = f;
        }

        public void set(long l) {
            this.longVal = l;
        }

        public void set(short s) {
            this.shortVal = s;
        }
    }
}

