/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected long cachedLength = -1L;
    protected int[] retCode = new int[1];
    protected byte[] data = null;

    protected native int SQLGetBAPosition(int var1, int var2, int var3, byte[] var4, int var5, int var6, int[] var7);

    protected native int SQLGetBlobPosition(int var1, int var2, int var3, int var4, int var5, int[] var6);

    protected native long SQLGetLength(int var1, int var2, int var3, int[] var4);

    protected native int SQLGetByteArray(byte[] var1, int var2, int var3, int var4, long var5, int var7, int[] var8);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2Blob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Blob( stmt, " + n + ", " + n2 + " )");
            }
            DB2Connection dB2Connection = this.connection = (DB2Connection)dB2Statement.getConnection();
            synchronized (dB2Connection) {
                this.locator = n;
                this.lobType = n2;
                this.statement = this.connection.getInputStreamStmt();
                this.closed = false;
            }
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2Blob()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2Blob()");
    }

    public DB2Blob(byte[] byArray) {
        this.data = null == byArray ? new byte[0] : byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            this.closed = true;
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "close()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "close()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        long l;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            if (this.cachedLength < 0L) {
                if (this.data != null) {
                    this.cachedLength = this.data.length;
                } else {
                    this.cachedLength = this.SQLGetLength(this.statement.statementHandle, this.locator, this.lobType, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            l = this.cachedLength;
            Object var4_2 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "length()", this.cachedLength);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "length()", this.cachedLength);
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBytes( " + l + ", " + n + " )");
            }
            byte[] byArray2 = null;
            if (this.data != null) {
                if (l > (long)this.data.length || 0 == n) {
                    byArray2 = new byte[]{};
                } else {
                    n = (int)Math.min((long)this.data.length - l + 1L, (long)n);
                    byArray2 = new byte[n];
                    System.arraycopy(this.data, (int)l - 1, byArray2, 0, n);
                }
            } else {
                byArray2 = new byte[n];
                int n2 = this.SQLGetByteArray(byArray2, this.statement.statementHandle, this.lobType, this.locator, l, n, this.retCode);
                if (this.retCode[0] != 0) {
                    this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                } else if (n2 < n) {
                    byte[] byArray3 = byArray2;
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray3, 0, byArray2, 0, n2);
                }
            }
            byArray = byArray2;
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getBytes()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getBytes()");
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        DB2InputStream dB2InputStream;
        block5: {
            ByteArrayInputStream byteArrayInputStream;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getBinaryStream()");
                    }
                    if (this.data != null) {
                        byteArrayInputStream = new ByteArrayInputStream(this.data);
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return byteArrayInputStream;
                        break block4;
                    }
                    dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            return byteArrayInputStream;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2InputStream;
        DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
        return dB2InputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(byte[] byArray, long l) throws SQLException {
        long l2;
        long l3 = -1L;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern[], " + l + " )");
            }
            if (null == byArray || byArray.length == 0) {
                l3 = -1L;
            } else if (this.data != null) {
                while (l + (long)byArray.length - 1L < (long)this.data.length) {
                    int n = (int)l - 1;
                    int n2 = 0;
                    while (n2 < byArray.length && this.data[n] == byArray[n2]) {
                        ++n;
                        ++n2;
                    }
                    if (byArray.length == n2) {
                        l3 = l;
                    }
                    ++l;
                }
            } else {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    l3 = this.SQLGetBAPosition(this.statement.statementHandle, this.lobType, this.locator, byArray, byArray.length, (int)l, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            l2 = l3;
            Object var10_10 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", l3);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(Blob blob, long l) throws SQLException {
        long l2;
        long l3 = -1L;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern, " + l + " )");
            }
            if (blob instanceof DB2Blob && ((DB2Blob)blob).data == null && this.data == null) {
                Integer n = new Integer(0);
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    l3 = this.SQLGetBlobPosition(this.statement.statementHandle, this.lobType, this.locator, ((DB2Blob)blob).getLocator(), (int)l, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            } else {
                long l4 = blob.length();
                byte[] byArray = blob.getBytes(0L, (int)l4);
                l3 = this.position(byArray, l);
            }
            l2 = l3;
            Object var10_10 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", l3);
        return l2;
    }

    final int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }
}

