/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Driver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Locale;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class DB2BaseDataSource
implements Referenceable,
Serializable {
    static final long serialVersionUID = -3058333050951489179L;
    static final String logSource = "DB2 - ";
    private transient PrintWriter log = null;
    private int timeout = 0;
    protected String databaseName = null;
    protected String serverName = null;
    protected int portNumber = 0;
    protected String description = null;
    protected transient String password = null;
    protected transient String user = null;
    protected boolean fullyMaterializeLobData = false;
    protected String connectionAttribute = null;
    protected String language = null;

    public DB2BaseDataSource() {
        Locale locale = Locale.getDefault();
        String string = locale.getCountry();
        String string2 = locale.getLanguage();
        this.language = string2.substring(0, 1).toUpperCase() + string2.substring(1, 2) + "_" + string;
    }

    public void setDatabaseName(String string) {
        this.printToLog("setDatabaseName(): " + string);
        this.databaseName = string;
    }

    public String getDatabaseName() {
        this.printToLog("getDatabaseName(): " + this.databaseName);
        return this.databaseName;
    }

    public void setServerName(String string) {
        this.printToLog("setServerName(): " + string);
        this.serverName = string;
    }

    public String getServerName() {
        this.printToLog("getServerName(): " + this.serverName);
        return this.serverName;
    }

    public void setPortNumber(int n) {
        this.printToLog("setPortNumber(): " + n);
        this.portNumber = n;
    }

    public int getPortNumber() {
        this.printToLog("getPortNumber(): " + this.portNumber);
        return this.portNumber;
    }

    public void setDescription(String string) {
        this.printToLog("setDescription(): " + string);
        this.description = string;
    }

    public String getDescription() {
        this.printToLog("getDescription(): " + this.description);
        return this.description;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return "";
    }

    public void setUser(String string) {
        this.printToLog("setUser(): " + string);
        this.user = string;
    }

    public String getUser() {
        this.printToLog("getUser(): " + this.user);
        return this.user;
    }

    public void setConnectionAttribute(String string) {
        this.printToLog("setConnectionAttribute(): " + string);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setConnectionAttribute( " + string + " )");
        }
        this.connectionAttribute = string;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setConnectionAttribute()");
        }
    }

    public String getConnectionAttribute() {
        this.printToLog("getConnectionAttribute(): " + this.connectionAttribute);
        return this.connectionAttribute;
    }

    public void setLanguage(String string) {
        this.printToLog("setLanguage(): " + string);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setLanguage( " + string + " )");
        }
        this.language = string;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLanguage()");
        }
    }

    public String getLanguage() {
        this.printToLog("getLanguage(): " + this.language);
        return this.language;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.log = printWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.printToLog("setLoginTimeout(): " + n);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setLoginTimeout( " + n + " )");
        }
        this.timeout = n;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLoginTimeout()");
        }
    }

    public int getLoginTimeout() throws SQLException {
        this.printToLog("getLoginTimeout(): " + this.timeout);
        return this.timeout;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName() + "Factory", null);
        reference.add(new StringRefAddr("databaseName", this.databaseName));
        reference.add(new StringRefAddr("serverName", this.serverName));
        reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        return reference;
    }

    public void setFullyMaterializeLobData(boolean bl) {
        this.printToLog("setFullyMaterializeLobData(): " + bl);
        this.fullyMaterializeLobData = bl;
    }

    public boolean getFullyMaterializeLobData() {
        this.printToLog("getFullyMaterializeLobData(): " + this.fullyMaterializeLobData);
        return this.fullyMaterializeLobData;
    }

    public String toString() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
        String string2 = "class               = " + this.getClass().getName();
        string2 = string2 + string + "serverName          =";
        if (this.serverName != null) {
            string2 = string2 + " " + this.serverName;
        }
        string2 = string2 + string + "portNumber          = " + this.portNumber;
        string2 = string2 + "\ndatabaseName        =";
        if (this.databaseName != null) {
            string2 = string2 + " " + this.databaseName;
        }
        string2 = string2 + string + "user                =";
        if (this.user != null) {
            string2 = string2 + " " + this.user;
        }
        string2 = string2 + string + "password            =";
        if (this.password != null) {
            string2 = string2 + "XXXXXXX";
        }
        string2 = string2 + string + "connectionAttribute =";
        if (this.connectionAttribute != null) {
            string2 = string2 + " " + this.connectionAttribute;
        }
        string2 = string2 + string + "language            =";
        if (this.language != null) {
            string2 = string2 + " " + this.language;
        }
        return string2;
    }

    protected void loadDLL() throws SQLException {
        if (this.isLoaded()) {
            DB2Driver dB2Driver = new DB2Driver();
        }
    }

    protected boolean isLoaded() {
        return DB2Driver.loaded;
    }

    void printToLog(String string) {
        if (this.log != null) {
            this.log.println(logSource + string);
        }
    }
}

