/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassLoaderTracer;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.DirClassProvider;
import COM.ibm.db2.app.classloader.JarFileClassProvider;
import COM.ibm.db2.app.classloader.JarFilenameFilter;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.util.Vector;

public class JarDirClassProvider
implements ClassProvider,
Validatable {
    private Vector providers = new Vector();
    private File jarDirectory;
    private ClassLoaderTracer tracer = ClassLoaderTracer.instance();

    public JarDirClassProvider(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory");
        }
        this.jarDirectory = file;
        this.addProvider(new DirClassProvider(this.jarDirectory));
        this.addNewJars();
    }

    public String getClassPath() {
        String string = null;
        try {
            string = this.getProvider(0).getClassPath();
            int n = 1;
            while (true) {
                String string2 = this.getProvider(n).getClassPath();
                string = string + File.pathSeparator + string2;
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
    }

    public byte[] getClassBytes(String string) {
        try {
            byte[] byArray = null;
            int n = 0;
            while (true) {
                if ((byArray = this.getProvider(n).getClassBytes(string)) != null) {
                    return byArray;
                }
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public ClassLoaderResource getResource(String string) {
        try {
            ClassLoaderResource classLoaderResource = null;
            int n = 0;
            while (true) {
                if ((classLoaderResource = this.getProvider(n).getResource(string)) != null) {
                    return classLoaderResource;
                }
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getAbsoluteResourcePath(String string) {
        try {
            String string2 = null;
            int n = 0;
            while (true) {
                if ((string2 = this.getProvider(n).getAbsoluteResourcePath(string)) != null) {
                    return string2;
                }
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public boolean hasResource(String string) {
        try {
            int n = 0;
            while (true) {
                if (this.getProvider(n).hasResource(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public void validate() throws InvalidationException {
        try {
            Object var1_1 = null;
            int n = 0;
            while (true) {
                this.getProvider(n).validate();
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.addNewJars();
            return;
        }
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    private ClassProvider getProvider(int n) {
        return (ClassProvider)this.providers.elementAt(n);
    }

    private void addNewJars() {
        String string = this.getClassPath();
        String[] stringArray = this.jarDirectory.list(JarFilenameFilter.instance());
        if (null != stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = this.jarDirectory.getPath() + File.separator + stringArray[n];
                if (string.indexOf(string2) == -1) {
                    File file = new File(string2);
                    if (this.tracer.isTracing) {
                        this.tracer.trace("JarDirClassProvider:addNewJars. add new class provider for jar: " + file.getAbsolutePath(), 2);
                    }
                    this.addProvider(new JarFileClassProvider(file));
                }
                ++n;
            }
        }
    }

    private void addProvider(ClassProvider classProvider) {
        this.providers.addElement(classProvider);
    }
}

