/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobWithIO;
import java.io.IOException;
import java.io.Reader;

class ClobReader
extends Reader {
    private ClobWithIO clob;
    private int pointer;
    private int mark;

    ClobReader(ClobWithIO clobWithIO) {
        this.clob = clobWithIO;
        this.pointer = 0;
        this.mark = -1;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray);
        if (n != 1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        if (n < 0 || n >= cArray.length || n2 <= 0 || n + n2 > cArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            int n3 = (int)this.clob.size();
            if (n3 <= this.pointer) {
                return -1;
            }
            int n4 = Math.min(n2, n3 - this.pointer);
            int n5 = this.clob.substr(this.pointer, cArray, n, n4);
            if (n5 < 0) {
                return -1;
            }
            this.pointer += n5;
            return n5;
        }
        catch (Exception exception) {
            throw new IOException("I/O error during Clob read(): " + exception);
        }
    }

    public long skip(long l) throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        try {
            int n = (int)this.clob.size();
            int n2 = (long)this.pointer + l >= (long)n ? n : ((long)this.pointer + l <= 0L ? 0 : this.pointer + (int)l);
            int n3 = n2 - this.pointer;
            this.pointer = n2;
            return n3;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Clob skip(): " + exception);
        }
    }

    public int available() throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        try {
            return (int)this.clob.size() - this.pointer;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Clob available(): " + exception);
        }
    }

    public synchronized void mark(int n) throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        this.mark = this.pointer;
    }

    public synchronized void reset() throws IOException {
        if (this.clob == null) {
            throw new IOException("Reader is closed");
        }
        this.pointer = this.mark < 0 ? 0 : this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
        this.clob = null;
    }
}

