/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobInputStream;
import COM.ibm.db2.app.BlobOutputStream;
import COM.ibm.db2.app.BlobWithIO;
import COM.ibm.db2.app.Lob;
import java.io.InputStream;
import java.io.OutputStream;

class BlobWithDB2Buffer
extends Lob
implements BlobWithIO {
    long bufferPtr;
    int bufferSize;
    int bufferUsedType;
    long bufferUsedPtr;

    BlobWithDB2Buffer(long l, int n, int n2, long l2) throws Exception {
        this.bufferPtr = l;
        this.bufferSize = n;
        this.bufferUsedType = n2;
        this.bufferUsedPtr = l2;
    }

    public void close() {
        this.bufferPtr = 0L;
    }

    void assertOpen() throws Exception {
        if (this.bufferPtr == 0L) {
            throw new Exception("Blob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return BlobWithDB2Buffer.getSize(this.bufferUsedType, this.bufferUsedPtr);
    }

    public InputStream getInputStream() throws Exception {
        return new BlobInputStream(this);
    }

    public OutputStream getOutputStream() throws Exception {
        return new BlobOutputStream(this);
    }

    public synchronized void append(byte[] byArray, int n, int n2) throws Exception {
        this.assertOpen();
        if (this.size() + (long)n2 > (long)this.bufferSize) {
            throw new Exception("cannot exceed maximum length: " + this.bufferSize);
        }
        BlobWithDB2Buffer.doAppend(byArray, n, n2, this.bufferPtr, this.bufferUsedType, this.bufferUsedPtr);
    }

    public synchronized int substr(int n, byte[] byArray, int n2, int n3) throws Exception {
        this.assertOpen();
        int n4 = Math.min((int)this.size() - n, n3);
        BlobWithDB2Buffer.doSubstr(n, byArray, n2, n3, this.bufferPtr);
        return n4;
    }

    static native int getSize(int var0, long var1) throws Exception;

    static native void doAppend(byte[] var0, int var1, int var2, long var3, int var5, long var6) throws Exception;

    static native void doSubstr(int var0, byte[] var1, int var2, int var3, long var4) throws Exception;
}

