/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobInputStream;
import COM.ibm.db2.app.BlobOutputStream;
import COM.ibm.db2.app.BlobWithIO;
import COM.ibm.db2.app.Lob;
import java.io.InputStream;
import java.io.OutputStream;

class BlobWithByteBuffer
extends Lob
implements BlobWithIO {
    byte[] buffer;
    int capacity;
    int count;

    BlobWithByteBuffer(byte[] byArray) throws Exception {
        this.buffer = byArray;
        this.capacity = byArray.length;
        this.count = byArray.length;
    }

    BlobWithByteBuffer() throws Exception {
        this.capacity = 32;
        this.count = 0;
        this.buffer = new byte[this.capacity];
    }

    void close() {
        this.buffer = null;
        this.count = 0;
        this.capacity = 0;
    }

    void assertOpen() throws Exception {
        if (this.buffer == null) {
            throw new Exception("Blob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return this.count;
    }

    public InputStream getInputStream() throws Exception {
        return new BlobInputStream(this);
    }

    public OutputStream getOutputStream() throws Exception {
        return new BlobOutputStream(this);
    }

    public synchronized void append(byte[] byArray, int n, int n2) throws Exception {
        this.assertOpen();
        if (this.count + n2 <= this.capacity) {
            System.arraycopy(byArray, n, this.buffer, this.count, n2);
            this.count += n2;
        } else {
            int n3 = this.capacity + (int)((double)n2 * 1.2);
            byte[] byArray2 = new byte[n3];
            int n4 = this.count + n2;
            System.arraycopy(this.buffer, 0, byArray2, 0, this.count);
            System.arraycopy(byArray, n, byArray2, this.count, n2);
            this.capacity = n3;
            this.buffer = byArray2;
            this.count = n4;
        }
    }

    public synchronized int substr(int n, byte[] byArray, int n2, int n3) throws Exception {
        this.assertOpen();
        int n4 = n3;
        if (n >= this.count) {
            n4 = 0;
        } else if (n + n3 > this.count) {
            n4 = this.count - (n + n3);
        }
        System.arraycopy(this.buffer, n, byArray, n2, n4);
        return n4;
    }
}

