/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.validation.CRLValidator;
import com.itextpdf.signatures.validation.CertificateChainValidator;
import com.itextpdf.signatures.validation.DocumentRevisionsValidator;
import com.itextpdf.signatures.validation.OCSPValidator;
import com.itextpdf.signatures.validation.RevocationDataValidator;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.SignatureValidator;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

public class ValidatorChainBuilder {
    private SignatureValidationProperties properties;
    private Supplier<IssuingCertificateRetriever> certificateRetrieverFactory;
    private Supplier<CertificateChainValidator> certificateChainValidatorFactory;
    private Supplier<RevocationDataValidator> revocationDataValidatorFactory;
    private Supplier<OCSPValidator> ocspValidatorFactory;
    private Supplier<CRLValidator> crlValidatorFactory;
    private Supplier<DocumentRevisionsValidator> documentRevisionsValidatorFactory;
    private Collection<Certificate> trustedCertificates;
    private Collection<Certificate> knownCertificates;

    public SignatureValidator buildSignatureValidator(PdfDocument document) {
        return new SignatureValidator(document, this);
    }

    public DocumentRevisionsValidator buildDocumentRevisionsValidator() {
        return new DocumentRevisionsValidator(this);
    }

    public CertificateChainValidator buildCertificateChainValidator() {
        return new CertificateChainValidator(this);
    }

    public RevocationDataValidator buildRevocationDataValidator() {
        return new RevocationDataValidator(this);
    }

    public OCSPValidator buildOCSPValidator() {
        return new OCSPValidator(this);
    }

    public CRLValidator buildCRLValidator() {
        return new CRLValidator(this);
    }

    public ValidatorChainBuilder withDocumentRevisionsValidatorFactory(Supplier<DocumentRevisionsValidator> documentRevisionsValidatorFactory) {
        this.documentRevisionsValidatorFactory = documentRevisionsValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withCRLValidatorFactory(Supplier<CRLValidator> crlValidatorFactory) {
        this.crlValidatorFactory = crlValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withOCSPValidatorFactory(Supplier<OCSPValidator> ocspValidatorFactory) {
        this.ocspValidatorFactory = ocspValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withRevocationDataValidatorFactory(Supplier<RevocationDataValidator> revocationDataValidatorFactory) {
        this.revocationDataValidatorFactory = revocationDataValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withCertificateChainValidatorFactory(Supplier<CertificateChainValidator> certificateChainValidatorFactory) {
        this.certificateChainValidatorFactory = certificateChainValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withSignatureValidationProperties(SignatureValidationProperties properties) {
        this.properties = properties;
        return this;
    }

    public ValidatorChainBuilder withIssuingCertificateRetrieverFactory(Supplier<IssuingCertificateRetriever> certificateRetrieverFactory) {
        this.certificateRetrieverFactory = certificateRetrieverFactory;
        return this;
    }

    public ValidatorChainBuilder withKnownCertificates(Collection<Certificate> knownCertificates) {
        this.knownCertificates = new ArrayList<Certificate>(knownCertificates);
        return this;
    }

    public ValidatorChainBuilder withTrustedCertificates(Collection<Certificate> trustedCertificates) {
        this.trustedCertificates = new ArrayList<Certificate>(trustedCertificates);
        return this;
    }

    public IssuingCertificateRetriever getCertificateRetriever() {
        if (this.certificateRetrieverFactory == null) {
            return this.buildIssuingCertificateRetriever();
        }
        return this.certificateRetrieverFactory.get();
    }

    public SignatureValidationProperties getProperties() {
        if (this.properties == null) {
            this.properties = new SignatureValidationProperties();
        }
        return this.properties;
    }

    DocumentRevisionsValidator getDocumentRevisionsValidator() {
        if (this.documentRevisionsValidatorFactory == null) {
            return this.buildDocumentRevisionsValidator();
        }
        return this.documentRevisionsValidatorFactory.get();
    }

    CertificateChainValidator getCertificateChainValidator() {
        if (this.certificateChainValidatorFactory == null) {
            return this.buildCertificateChainValidator();
        }
        return this.certificateChainValidatorFactory.get();
    }

    RevocationDataValidator getRevocationDataValidator() {
        if (this.revocationDataValidatorFactory == null) {
            return this.buildRevocationDataValidator();
        }
        return this.revocationDataValidatorFactory.get();
    }

    CRLValidator getCRLValidator() {
        if (this.crlValidatorFactory == null) {
            return this.buildCRLValidator();
        }
        return this.crlValidatorFactory.get();
    }

    OCSPValidator getOCSPValidator() {
        if (this.ocspValidatorFactory == null) {
            return this.buildOCSPValidator();
        }
        return this.ocspValidatorFactory.get();
    }

    private IssuingCertificateRetriever buildIssuingCertificateRetriever() {
        IssuingCertificateRetriever result = new IssuingCertificateRetriever();
        if (this.trustedCertificates != null) {
            result.setTrustedCertificates(this.trustedCertificates);
        }
        if (this.knownCertificates != null) {
            result.addKnownCertificates(this.knownCertificates);
        }
        return result;
    }
}

