/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateID;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPReq;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.bouncycastle.operator.AbstractOperatorCreationException;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.SignUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcspClientBouncyCastle
implements IOcspClient {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(OcspClientBouncyCastle.class);

    public IBasicOCSPResp getBasicOCSPResp(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            IOCSPResp ocspResponse = this.getOcspResponse(checkCert, rootCert, url);
            if (ocspResponse == null) {
                return null;
            }
            if (ocspResponse.getStatus() != BOUNCY_CASTLE_FACTORY.createOCSPResponseStatus().getSuccessful()) {
                return null;
            }
            return BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(ocspResponse.getResponseObject());
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
            return null;
        }
    }

    @Override
    public byte[] getEncoded(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            ISingleResp[] responses;
            IBasicOCSPResp basicResponse = this.getBasicOCSPResp(checkCert, rootCert, url);
            if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                ISingleResp resp = responses[0];
                ICertificateStatus status = resp.getCertStatus();
                if (!BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood().equals(status)) {
                    if (BOUNCY_CASTLE_FACTORY.createRevokedStatus(status) == null) {
                        LOGGER.info("OCSP status is unknown.");
                    } else {
                        LOGGER.info("OCSP status is revoked.");
                    }
                }
                return basicResponse.getEncoded();
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
        }
        return null;
    }

    protected static IOCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws AbstractOCSPException, IOException, CertificateEncodingException, AbstractOperatorCreationException {
        ICertificateID id = SignUtils.generateCertificateId(issuerCert, serialNumber, BOUNCY_CASTLE_FACTORY.createCertificateID().getHashSha1());
        return SignUtils.generateOcspRequestWithNonce(id);
    }

    protected static ICertificateStatus getCertificateStatus(byte[] basicOcspRespBytes) {
        try {
            ISingleResp[] responses;
            IBasicOCSPResp basicResponse = BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(BOUNCY_CASTLE_FACTORY.createBasicOCSPResponse(BOUNCY_CASTLE_FACTORY.createASN1Primitive(basicOcspRespBytes)));
            if (basicResponse != null && (responses = basicResponse.getResponses()).length >= 1) {
                return responses[0].getCertStatus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    IOCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, AbstractOCSPException, IOException, AbstractOperatorCreationException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            url = CertificateUtil.getOCSPURL(checkCert);
        }
        if (url == null) {
            return null;
        }
        InputStream in = this.createRequestAndResponse(checkCert, rootCert, url);
        return in == null ? null : BOUNCY_CASTLE_FACTORY.createOCSPResp(StreamUtil.inputStreamToArray((InputStream)in));
    }

    protected InputStream createRequestAndResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws IOException, AbstractOperatorCreationException, AbstractOCSPException, CertificateEncodingException {
        LOGGER.info("Getting OCSP from " + url);
        IOCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL urlt = new URL(url);
        return SignUtils.getHttpResponseForOcspRequest(array, urlt);
    }
}

