/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IRevokedStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.bouncycastle.operator.AbstractOperatorCreationException;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CRLVerifier;
import com.itextpdf.signatures.CertificateVerifier;
import com.itextpdf.signatures.CrlClientOnline;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.RootStoreVerifier;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.VerificationException;
import com.itextpdf.signatures.VerificationOK;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OCSPVerifier
extends RootStoreVerifier {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    protected static final Logger LOGGER = LoggerFactory.getLogger(OCSPVerifier.class);
    protected static final String id_kp_OCSPSigning = "1.3.6.1.5.5.7.3.9";
    protected List<IBasicOCSPResp> ocsps;
    private IOcspClient ocspClient;
    private ICrlClient crlClient;

    public OCSPVerifier(CertificateVerifier verifier, List<IBasicOCSPResp> ocsps) {
        super(verifier);
        this.ocsps = ocsps;
    }

    public void setOcspClient(IOcspClient ocspClient) {
        this.ocspClient = ocspClient;
    }

    public void setCrlClient(ICrlClient crlClient) {
        this.crlClient = crlClient;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
        int validOCSPsFound = 0;
        if (this.ocsps != null) {
            for (IBasicOCSPResp ocspResp : this.ocsps) {
                if (!this.verify(ocspResp, signCert, issuerCert, signDate)) continue;
                ++validOCSPsFound;
            }
        }
        boolean online = false;
        int validOCSPsFoundOnline = 0;
        if (this.onlineCheckingAllowed && this.verify(this.getOcspResponse(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validOCSPsFound;
            ++validOCSPsFoundOnline;
            online = true;
        }
        LOGGER.info("Valid OCSPs found: " + validOCSPsFound);
        if (validOCSPsFound > 0) {
            result.add(new VerificationOK(signCert, this.getClass(), "Valid OCSPs Found: " + validOCSPsFound + (online ? " (" + validOCSPsFoundOnline + " online)" : "")));
        }
        if (this.verifier != null) {
            result.addAll(this.verifier.verify(signCert, issuerCert, signDate));
        }
        return result;
    }

    public boolean verify(IBasicOCSPResp ocspResp, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        ISingleResp[] resp;
        if (ocspResp == null) {
            return false;
        }
        for (ISingleResp iSingleResp : resp = ocspResp.getResponses()) {
            if (!signCert.getSerialNumber().equals(iSingleResp.getCertID().getSerialNumber())) continue;
            try {
                if (issuerCert == null) {
                    issuerCert = signCert;
                }
                if (!SignUtils.checkIfIssuersMatch(iSingleResp.getCertID(), issuerCert)) {
                    LOGGER.info("OCSP: Issuers doesn't match.");
                    continue;
                }
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
            catch (AbstractOCSPException | AbstractOperatorCreationException e) {
                continue;
            }
            if (iSingleResp.getNextUpdate() != null && signDate.after(iSingleResp.getNextUpdate())) {
                LOGGER.info(MessageFormatUtil.format((String)"OCSP is no longer valid: {0} after {1}", (Object[])new Object[]{signDate, iSingleResp.getNextUpdate()}));
                continue;
            }
            ICertificateStatus status = iSingleResp.getCertStatus();
            IRevokedStatus revokedStatus = BOUNCY_CASTLE_FACTORY.createRevokedStatus(status);
            boolean isStatusGood = BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood().equals(status);
            if (!isStatusGood && (revokedStatus == null || !signDate.before(revokedStatus.getRevocationTime()))) continue;
            this.isValidResponse(ocspResp, issuerCert, signDate);
            if (!isStatusGood) {
                LOGGER.warn(MessageFormatUtil.format((String)"The certificate was valid on the verification date, but has been revoked since {0}.", (Object[])new Object[]{revokedStatus.getRevocationTime()}));
            }
            return true;
        }
        return false;
    }

    public void isValidResponse(IBasicOCSPResp ocspResp, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        X509Certificate responderCert = null;
        if (this.isSignatureValid(ocspResp, issuerCert)) {
            responderCert = issuerCert;
        }
        if (responderCert == null) {
            if (ocspResp.getCerts().length > 0) {
                IBasicOCSPResp responderOcspResp;
                Iterable<X509Certificate> certs = SignUtils.getCertsFromOcspResponse(ocspResp);
                for (X509Certificate cert : certs) {
                    try {
                        List<String> keyPurposes = cert.getExtendedKeyUsage();
                        if (keyPurposes == null || !keyPurposes.contains(id_kp_OCSPSigning) || !this.isSignatureValid(ocspResp, cert)) continue;
                        responderCert = cert;
                        break;
                    }
                    catch (CertificateParsingException certificateParsingException) {
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified");
                }
                responderCert.verify(issuerCert.getPublicKey());
                responderCert.checkValidity(ocspResp.getProducedAt());
                if (SignUtils.getExtensionValueByOid(responderCert, BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspNoCheck().getId()) != null) {
                    return;
                }
                if (this.ocspClient != null) {
                    responderOcspResp = null;
                    byte[] basicOcspRespBytes = this.ocspClient.getEncoded(responderCert, issuerCert, null);
                    if (basicOcspRespBytes != null) {
                        try {
                            responderOcspResp = BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(BOUNCY_CASTLE_FACTORY.createBasicOCSPResponse(BOUNCY_CASTLE_FACTORY.createASN1Primitive(basicOcspRespBytes)));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.verifyOcsp(responderOcspResp, responderCert, issuerCert, ocspResp.getProducedAt())) {
                        return;
                    }
                }
                if (this.crlClient != null && this.checkCrlResponses(this.crlClient, responderCert, issuerCert, ocspResp.getProducedAt())) {
                    return;
                }
                responderOcspResp = new OcspClientBouncyCastle().getBasicOCSPResp(responderCert, issuerCert, null);
                if (this.verifyOcsp(responderOcspResp, responderCert, issuerCert, ocspResp.getProducedAt())) {
                    return;
                }
                if (this.checkCrlResponses(new CrlClientOnline(), responderCert, issuerCert, ocspResp.getProducedAt())) {
                    return;
                }
                throw new VerificationException(responderCert, "Authorized OCSP responder certificate revocation status cannot be checked");
            }
            if (this.rootStore != null) {
                try {
                    for (X509Certificate anchor : SignUtils.getCertificates(this.rootStore)) {
                        if (!this.isSignatureValid(ocspResp, anchor)) continue;
                        responderCert = anchor;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (responderCert == null) {
                throw new VerificationException(issuerCert, "OCSP response could not be verified: it does not contain certificate chain and response is not signed by issuer certificate or any from the root store.");
            }
        }
        responderCert.checkValidity(ocspResp.getProducedAt());
    }

    public boolean isSignatureValid(IBasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            return SignUtils.isSignatureValid(ocspResp, responderCert, BOUNCY_CASTLE_FACTORY.getProviderName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public IBasicOCSPResp getOcspResponse(X509Certificate signCert, X509Certificate issuerCert) {
        if (signCert == null && issuerCert == null) {
            return null;
        }
        OcspClientBouncyCastle ocsp = new OcspClientBouncyCastle();
        return ocsp.getBasicOCSPResp(signCert, issuerCert, null);
    }

    private boolean verifyOcsp(IBasicOCSPResp ocspResp, X509Certificate certificate, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        if (ocspResp == null) {
            return false;
        }
        return this.verify(ocspResp, certificate, issuerCert, signDate);
    }

    private boolean checkCrlResponses(ICrlClient client, X509Certificate responderCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        Collection<byte[]> crlBytesCollection = client.getEncoded(responderCert, null);
        for (byte[] crlBytes : crlBytesCollection) {
            CRL crl = SignUtils.parseCrlFromStream(new ByteArrayInputStream(crlBytes));
            if (!this.verifyCrl(crl, responderCert, issuerCert, signDate)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyCrl(CRL crl, X509Certificate certificate, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        if (crl instanceof X509CRL) {
            CRLVerifier crlVerifier = new CRLVerifier(null, null);
            crlVerifier.setRootStore(this.rootStore);
            crlVerifier.setOnlineCheckingAllowed(this.onlineCheckingAllowed);
            return crlVerifier.verify((X509CRL)crl, certificate, issuerCert, signDate);
        }
        return false;
    }
}

