/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol.flt;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.protocol.flt.ObObj;
import com.oceanbase.jdbc.internal.protocol.flt.OceanBaseProtocolV20;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class FullLinkTrace {
    private static final int TYPE_LENGTH = 2;
    private static final int LEN_LENGTH = 4;
    private static final int TYPE_LEN_LENGTH = 6;
    private static final int FLT_SIZE = 4;
    private static final int DBL_SIZE = 8;
    private static final int MAX_TRACE_LOG_SIZE = 8192;
    private boolean traceEnable;
    private boolean forcePrint;
    public TraceInfo traceInfo;
    private UUID traceId;
    private UUID rootSpanId;
    private ConcurrentHashMap<UUID, SpanContext> activeSpanMap = new ConcurrentHashMap();
    private SpanContext lastActiveSpan;
    private byte level;
    private boolean autoFlush;
    private byte[] logBuf = new byte[8192];
    private int logBufOffset;

    public FullLinkTrace(boolean useNewExtraInfo) {
        this.traceInfo = new TraceInfo(useNewExtraInfo);
        this.traceId = new UUID(0L, 0L);
        this.rootSpanId = new UUID(0L, 0L);
    }

    public void beginTrace() {
        this.traceEnable = false;
        this.forcePrint = false;
        if (this.traceInfo.controlInfo.isValid()) {
            boolean bl = this.traceEnable = FullLinkTrace.getPercentage() < this.traceInfo.controlInfo.samplePercentage;
        }
        if (this.traceEnable) {
            switch (this.traceInfo.controlInfo.recordPolicy) {
                case RP_ALL: {
                    this.forcePrint = true;
                    break;
                }
                case RP_SAMPLE_AND_SLOW_QUERY: {
                    this.forcePrint = FullLinkTrace.getPercentage() < this.traceInfo.controlInfo.printSamplePercentage;
                    break;
                }
                default: {
                    this.forcePrint = false;
                }
            }
            this.traceId = UUID.randomUUID();
            this.level = this.traceInfo.controlInfo.level;
            this.autoFlush = this.forcePrint;
        } else {
            this.traceId = new UUID(0L, 0L);
            this.level = 0;
            this.autoFlush = false;
        }
    }

    public void endTrace() {
        if (this.isInitedUUID(this.traceId)) {
            for (SpanContext span : this.activeSpanMap.values()) {
                if (0L != span.endTimestamp) continue;
                span.endNano = System.nanoTime();
                span.endTimestamp = System.currentTimeMillis();
            }
            this.activeSpanMap.clear();
            this.lastActiveSpan = null;
        }
    }

    private void flushTransaction() throws IOException {
        for (SpanContext span : this.activeSpanMap.values()) {
            this.flushQuery(span);
            if (0L == span.endTimestamp) continue;
            this.activeSpanMap.remove(span.spanId);
        }
    }

    private void flushQuery(SpanContext span) throws IOException {
        this.writeLogIntoTrace(span.getJsonString());
        span.tagList.clear();
    }

    public UUID beginSpan(int spanType) {
        return this.beginChildSpan(spanType);
    }

    private UUID beginChildSpan(int spanType) {
        return this.beginSpanInternal(spanType, (byte)1, false);
    }

    private UUID beginFollowSpan(int spanType) {
        return this.beginSpanInternal(spanType, (byte)1, true);
    }

    private UUID beginSpanInternal(int spanType, byte level, boolean isFollow) {
        UUID spanId = null;
        if (this.isInitedUUID(this.traceId) && level <= this.level) {
            SpanContext newSpan = new SpanContext(spanType, isFollow);
            SpanContext parent = this.getCurrentSpan();
            if (parent != null) {
                newSpan.sourceSpanId = parent.spanId;
            } else {
                this.rootSpanId = newSpan.spanId;
            }
            this.activeSpanMap.put(newSpan.spanId, newSpan);
            this.lastActiveSpan = newSpan;
            spanId = newSpan.spanId;
        }
        return spanId;
    }

    public void endSpan(UUID spanId) throws IOException {
        if (!this.isInitedUUID(this.traceId) || !this.isInitedUUID(spanId)) {
            return;
        }
        boolean slowQueryFound = false;
        SpanContext span = this.activeSpanMap.get(spanId);
        if (span != null) {
            span.endNano = System.nanoTime();
            span.endTimestamp = System.currentTimeMillis();
            if ((this.traceInfo.controlInfo.recordPolicy == RecordPolicy.RP_ONLY_SLOW_QUERY || this.traceInfo.controlInfo.recordPolicy == RecordPolicy.RP_SAMPLE_AND_SLOW_QUERY) && this.traceInfo.controlInfo.slowQueryThreshold > 0L && (span.endNano - span.startNano) / 1000L >= this.traceInfo.controlInfo.slowQueryThreshold) {
                slowQueryFound = true;
            }
        }
        if (this.forcePrint || slowQueryFound) {
            this.flushQuery(span);
            this.activeSpanMap.remove(span.spanId);
        }
    }

    private SpanContext getCurrentSpan() {
        if (null == this.lastActiveSpan || 0L != this.lastActiveSpan.endTimestamp) {
            this.lastActiveSpan = null;
            for (SpanContext span : this.activeSpanMap.values()) {
                if (0L != span.endTimestamp) continue;
                this.lastActiveSpan = span;
                break;
            }
        }
        return this.lastActiveSpan;
    }

    public void setTag(int tagType, String tagKey, String tagValue) {
        SpanContext span = this.getCurrentSpan();
        if (span != null && tagKey != null) {
            TagContext tag = new TagContext(tagType, tagKey, tagValue);
            span.tagList.addFirst(tag);
        }
    }

    public void buildRequest(OceanBaseProtocolV20 ob20) throws IOException {
        int spanInfoSize;
        int driverLogSize;
        SpanContext span = this.getCurrentSpan();
        if (span != null & this.traceEnable) {
            this.traceInfo.traceId = this.traceId;
            this.traceInfo.spanId = span.spanId;
            this.traceInfo.spanInfo.traceId = this.traceId;
            this.traceInfo.spanInfo.spanId = span.spanId;
            this.traceInfo.spanInfo.traceEnable = this.traceEnable;
            this.traceInfo.spanInfo.forcePrint = this.forcePrint;
            if (this.forcePrint) {
                this.flushQuery(span);
            }
        }
        if (this.logBufOffset > 0) {
            this.traceInfo.driverLog.log = new String(this.logBuf, 0, this.logBufOffset) + '\u0000';
            this.logBufOffset = 0;
        }
        int totalSize = 0;
        int appInfoSize = this.traceInfo.appInfo.getSerializeSize();
        if ((totalSize += appInfoSize + (driverLogSize = this.traceInfo.driverLog.getSerializeSize()) + (spanInfoSize = this.traceInfo.spanInfo.getSerializeSize())) > 0) {
            TraceInfo.access$4402(this.traceInfo, new byte[totalSize + 1]);
            Buffer buf = new Buffer(this.traceInfo.valueData, totalSize);
            if (appInfoSize != 0) {
                this.traceInfo.appInfo.serialize(buf);
                this.traceInfo.appInfo.reset();
                if (buf.getPosition() != appInfoSize) {
                    throw new IOException("Full link trace: serialize extra info failed.");
                }
            }
            if (driverLogSize != 0) {
                this.traceInfo.driverLog.serialize(buf);
                this.traceInfo.driverLog.reset();
                if (buf.getPosition() != appInfoSize + driverLogSize) {
                    throw new IOException("Full link trace: serialize extra info failed.");
                }
            }
            if (spanInfoSize != 0) {
                this.traceInfo.spanInfo.serialize(buf);
                this.traceInfo.spanInfo.reset();
                if (buf.getPosition() != totalSize) {
                    throw new IOException("Full link trace: serialize extra info failed.");
                }
            }
            if (!this.traceInfo.useNewExtraInfo) {
                ((TraceInfo)this.traceInfo).valueData[totalSize] = 0;
                this.traceInfo.value.setVarchar(this.traceInfo.valueData, totalSize);
                ob20.setExtraInfo(this.traceInfo.key, this.traceInfo.value);
            } else {
                ob20.setExtraInfo(OceanBaseProtocolV20.ExtraInfoKey.FULL_TRC, Arrays.copyOfRange(this.traceInfo.valueData, 0, totalSize));
            }
        }
    }

    private void writeLogIntoTrace(String log) throws IOException {
        String format = "{\"trace_id\":\"" + FullLinkTrace.toStringUUID(this.traceId) + "\"," + log + "}";
        long length = Math.min(8192 - this.logBufOffset, format.length());
        System.arraycopy(format.getBytes(StandardCharsets.UTF_8), 0, this.logBuf, this.logBufOffset, (int)length);
        if ((long)this.logBufOffset + length >= 8192L) {
            throw new IOException("Buffer will overflow: need " + length + " bytes, but remain " + (8192 - this.logBufOffset) + " bytes.");
        }
        this.logBufOffset = (int)((long)this.logBufOffset + length);
    }

    private static String toStringUUID(UUID uuid) {
        long high = uuid.getLeastSignificantBits();
        long low = uuid.getMostSignificantBits();
        byte[] bytes = new byte[16];
        Buffer buf = new Buffer(bytes);
        buf.writeLongFromHighToLow(high);
        buf.writeLongFromHighToLow(low);
        return FullLinkTrace.printHexBinary(bytes);
    }

    private static String printHexBinary(byte[] data) {
        char[] hexCode = "0123456789abcdef".toCharArray();
        StringBuilder builder = new StringBuilder(data.length * 2 + 4);
        for (int i = 0; i < data.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                builder.append("-");
            }
            byte b = data[i];
            builder.append(hexCode[b >> 4 & 0xF]);
            builder.append(hexCode[b & 0xF]);
        }
        return builder.toString();
    }

    private static String printHexBinary2(byte[] data) {
        char[] hexCode = "0123456789abcdef".toCharArray();
        StringBuilder builder = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            builder.append(hexCode[b >> 4 & 0xF]);
            builder.append(hexCode[b & 0xF]);
            builder.append(' ');
        }
        return builder.toString();
    }

    private boolean isInitedUUID(UUID uuid) {
        return uuid != null && (uuid.getLeastSignificantBits() != 0L || uuid.getMostSignificantBits() != 0L);
    }

    private static double getPercentage() {
        return Math.random();
    }

    private static int getStoreInt1Size() {
        return 7;
    }

    private static int getStoreInt2Size() {
        return 8;
    }

    private static int getStoreInt3Size() {
        return 9;
    }

    private static int getStoreInt4Size() {
        return 10;
    }

    private static int getStoreInt5Size() {
        return 11;
    }

    private static int getStoreInt6Size() {
        return 12;
    }

    private static int getStoreInt8Size() {
        return 14;
    }

    private static int getStoreDoubleSize() {
        return 14;
    }

    private static int getStoreFloatSize() {
        return 10;
    }

    private static int getStoreUuidSize() {
        return 22;
    }

    private static int getStoreStringSize(int strLen) {
        return 6 + strLen;
    }

    private static void storeInt(Buffer buf, long value, short type, long valueLen) throws IOException {
        buf.checkRemainder(6L + valueLen);
        buf.writeShort(type);
        buf.writeInt((int)valueLen);
        if (1L == valueLen) {
            buf.writeByte((byte)value);
        } else if (2L == valueLen) {
            buf.writeShort((short)value);
        } else if (3L == valueLen) {
            buf.writeLongInt((int)value);
        } else if (4L == valueLen) {
            buf.writeInt((int)value);
        } else if (5L == valueLen) {
            buf.writeNBytes(value, 5);
        } else if (6L == valueLen) {
            buf.writeNBytes(value, 6);
        } else if (8L == valueLen) {
            buf.writeLongFromLowToHigh(value);
        }
    }

    private static void storeInt1(Buffer buf, byte value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 1L);
    }

    private static void storeInt2(Buffer buf, short value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 2L);
    }

    private static void storeInt3(Buffer buf, int value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 3L);
    }

    private static void storeInt4(Buffer buf, int value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 4L);
    }

    private static void storeInt5(Buffer buf, long value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 5L);
    }

    private static void storeInt6(Buffer buf, long value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 6L);
    }

    private static void storeInt8(Buffer buf, long value, short type) throws IOException {
        FullLinkTrace.storeInt(buf, value, type, 8L);
    }

    private static void storeDouble(Buffer buf, double value, short type) throws IOException {
        buf.checkRemainder(14L);
        buf.writeShort(type);
        buf.writeInt(8);
        buf.writeLongFromLowToHigh(Double.doubleToLongBits(value));
    }

    private static void storeFloat(Buffer buf, float value, short type) throws IOException {
        buf.checkRemainder(10L);
        buf.writeShort(type);
        buf.writeInt(4);
        buf.writeInt(Float.floatToIntBits(value));
    }

    private static void storeUUID(Buffer buf, UUID uuid, short type) throws IOException {
        buf.checkRemainder(22L);
        buf.writeShort(type);
        buf.writeInt(16);
        buf.writeLongFromHighToLow(uuid.getLeastSignificantBits());
        buf.writeLongFromHighToLow(uuid.getMostSignificantBits());
    }

    private static void storeString(Buffer buf, String str, int strLen, short type) throws IOException {
        buf.checkRemainder(6 + strLen);
        buf.writeShort(type);
        buf.writeInt(strLen);
        buf.writeString(str);
    }

    private static void storeTypeAndLen(Buffer buf, short type, int valLen) throws IOException {
        buf.checkRemainder(6L);
        buf.writeShort(type);
        buf.writeInt(valLen);
    }

    private static byte getInt1(Buffer buf, long valLen) throws IOException {
        if (1L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readByte();
    }

    private static short getInt2(Buffer buf, long valLen) throws IOException {
        if (2L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readShort();
    }

    private static int getInt3(Buffer buf, long valLen) throws IOException {
        if (3L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readInt3();
    }

    private static int getInt4(Buffer buf, long valLen) throws IOException {
        if (4L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readInt4();
    }

    private static long getInt8(Buffer buf, long valLen) throws IOException {
        if (8L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return buf.readLong8();
    }

    private static double getDouble(Buffer buf, long valLen) throws IOException {
        if (8L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return Double.longBitsToDouble(buf.readLong8());
    }

    private static float getFloat(Buffer buf, long valLen) throws IOException {
        if (4L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        return Float.intBitsToFloat(buf.readInt4());
    }

    private static UUID getUUID(Buffer buf, long valLen) throws IOException {
        if (16L != valLen) {
            throw new IOException("Wrong length to decode: " + valLen);
        }
        buf.checkRemainder(valLen);
        long high = buf.readLong8();
        long low = buf.readLong8();
        return new UUID(low, high);
    }

    private static String getString(Buffer buf, long strLen) throws IOException {
        buf.checkRemainder(strLen);
        return buf.readString((int)strLen);
    }

    static short resolveType(Buffer buf) throws IOException {
        buf.checkRemainder(2L);
        return buf.readShort();
    }

    static int resolveLength(Buffer buf) throws IOException {
        buf.checkRemainder(4L);
        return buf.readInt4();
    }

    private class SpanContext {
        private int spanType;
        private UUID spanId;
        private UUID sourceSpanId;
        private boolean isFollow;
        private long startTimestamp;
        private long startNano;
        private long endTimestamp;
        private long endNano;
        private LinkedList<TagContext> tagList;
        private String moduleName = "oceanbase_jdbc";

        public SpanContext(int spanType, boolean isFollow) {
            this.spanType = spanType;
            this.spanId = UUID.randomUUID();
            this.sourceSpanId = new UUID(0L, 0L);
            this.isFollow = isFollow;
            this.startNano = System.nanoTime();
            this.startTimestamp = System.currentTimeMillis();
            this.endNano = 0L;
            this.endTimestamp = 0L;
            this.tagList = new LinkedList();
        }

        private String getJsonString() {
            String spanStr = "\"name\":\"" + this.moduleName + "\",\"id\":\"" + FullLinkTrace.toStringUUID(this.spanId) + "\",\"parent_id\":\"" + FullLinkTrace.toStringUUID(this.sourceSpanId) + "\",\"start_ts\":" + this.startTimestamp * 1000L + ",\"end_ts\":" + this.endTimestamp * 1000L + ",\"is_follow\":" + (this.isFollow ? "true" : "false");
            StringBuilder sb = new StringBuilder();
            boolean firstOne = true;
            for (TagContext tag : this.tagList) {
                if (!firstOne) {
                    sb.append(",");
                } else {
                    firstOne = false;
                }
                sb.append(tag.getJsonString());
            }
            String tagsStr = sb.toString();
            if (tagsStr.length() > 0) {
                spanStr = spanStr + ",\"tags\":[" + tagsStr + "]";
            }
            return spanStr;
        }
    }

    private class TagContext {
        private int tagType;
        private String tagKey;
        private String tagValue;

        private TagContext(int tagType, String tagKey, String tagValue) {
            this.tagType = tagType;
            this.tagKey = tagKey;
            this.tagValue = tagValue;
        }

        private String getJsonString() {
            return "{\"" + this.tagKey + "\":\"" + this.tagValue + "\"}";
        }
    }

    public class TraceInfo {
        private DriveLog driverLog;
        public ControlInfo controlInfo;
        public AppInfo appInfo;
        QueryInfo queryInfo;
        SpanInfo spanInfo;
        private boolean useNewExtraInfo;
        private ObObj key;
        private ObObj value;
        private byte[] valueData;
        private UUID traceId;
        private UUID spanId;

        private TraceInfo(boolean useNewExtraInfo) {
            this.driverLog = new DriveLog();
            this.controlInfo = new ControlInfo();
            this.appInfo = new AppInfo();
            this.queryInfo = new QueryInfo();
            this.spanInfo = new SpanInfo();
            this.useNewExtraInfo = useNewExtraInfo;
            this.controlInfo.recordPolicy = RecordPolicy.RP_ONLY_SLOW_QUERY;
            if (!this.useNewExtraInfo) {
                this.key = new ObObj();
                this.value = new ObObj();
                String extraKey = OceanBaseProtocolV20.ExtraInfoKey.FULL_TRC.name().toLowerCase(Locale.ROOT);
                this.key.setVarchar(extraKey.getBytes(), extraKey.length());
            }
        }

        static /* synthetic */ byte[] access$4402(TraceInfo x0, byte[] x1) {
            x0.valueData = x1;
            return x1;
        }
    }

    class SpanInfo
    extends FullLinkTraceInfoBase {
        private boolean traceEnable;
        private boolean forcePrint;
        private byte refType;
        private UUID traceId;
        private UUID spanId;

        private SpanInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_SPAN_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.traceEnable) {
                localize += 6;
                localize += FullLinkTrace.getStoreInt1Size();
                localize += FullLinkTrace.getStoreInt1Size();
                localize += FullLinkTrace.getStoreUuidSize();
                localize += FullLinkTrace.getStoreInt1Size();
                localize += FullLinkTrace.getStoreUuidSize();
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            if (this.traceEnable) {
                int originalPos = buf.getPosition();
                buf.checkRemainder(6L);
                buf.setPosition(originalPos + 6);
                FullLinkTrace.storeInt1(buf, this.traceEnable ? (byte)1 : 0, FullLinkTraceExtraInfoId.FLT_TRACE_ENABLE.getValue());
                FullLinkTrace.storeInt1(buf, this.forcePrint ? (byte)1 : 0, FullLinkTraceExtraInfoId.FLT_FORCE_PRINT.getValue());
                FullLinkTrace.storeUUID(buf, this.traceId, FullLinkTraceExtraInfoId.FLT_TRACE_ID.getValue());
                FullLinkTrace.storeInt1(buf, this.refType, FullLinkTraceExtraInfoId.FLT_REF_TYPE.getValue());
                FullLinkTrace.storeUUID(buf, this.spanId, FullLinkTraceExtraInfoId.FLT_SPAN_ID.getValue());
                int totalLen = buf.getPosition() - originalPos - 6;
                buf.setPosition(originalPos);
                FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
                buf.setPosition(buf.getPosition() + totalLen);
            }
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_TRACE_ENABLE.value) {
                    this.traceEnable = FullLinkTrace.getInt1(buf, valLen) == 1;
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_FORCE_PRINT.value) {
                    this.forcePrint = FullLinkTrace.getInt1(buf, valLen) == 1;
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_TRACE_ID.value) {
                    this.traceId = FullLinkTrace.getUUID(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_REF_TYPE.value) {
                    this.refType = FullLinkTrace.getInt1(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SPAN_ID.value) {
                    this.spanId = FullLinkTrace.getUUID(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.traceEnable = false;
            this.forcePrint = false;
            this.refType = 0;
            this.traceId = null;
            this.spanId = null;
        }
    }

    class QueryInfo
    extends FullLinkTraceInfoBase {
        long queryStartTimestamp;
        long queryEndTimestamp;

        private QueryInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_QUERY_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            localize += 6;
            localize += FullLinkTrace.getStoreInt8Size();
            return localize += FullLinkTrace.getStoreInt8Size();
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeInt8(buf, this.queryStartTimestamp, FullLinkTraceExtraInfoId.FLT_QUERY_START_TIMESTAMP.getValue());
            FullLinkTrace.storeInt8(buf, this.queryEndTimestamp, FullLinkTraceExtraInfoId.FLT_QUERY_END_TIMESTAMP.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_QUERY_START_TIMESTAMP.value) {
                    this.queryStartTimestamp = FullLinkTrace.getInt8(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_QUERY_END_TIMESTAMP.value) {
                    this.queryEndTimestamp = FullLinkTrace.getInt8(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }
    }

    public class AppInfo
    extends FullLinkTraceInfoBase {
        private String clientIdentifier;
        private String module;
        private String action;
        private String clientInfo;
        private boolean isSet;

        private AppInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_APP_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.isSet) {
                if (null != this.clientIdentifier) {
                    localize += FullLinkTrace.getStoreStringSize(this.clientIdentifier.length());
                }
                if (null != this.module) {
                    localize += FullLinkTrace.getStoreStringSize(this.module.length());
                }
                if (null != this.action) {
                    localize += FullLinkTrace.getStoreStringSize(this.action.length());
                }
                if (null != this.clientInfo) {
                    localize += FullLinkTrace.getStoreStringSize(this.clientInfo.length());
                }
                if (0 != localize) {
                    localize += 6;
                }
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            if (null != this.clientIdentifier) {
                FullLinkTrace.storeString(buf, this.clientIdentifier, this.clientIdentifier.length(), FullLinkTraceExtraInfoId.FLT_CLIENT_IDENTIFIER.getValue());
            }
            if (null != this.module) {
                FullLinkTrace.storeString(buf, this.module, this.module.length(), FullLinkTraceExtraInfoId.FLT_MODULE.getValue());
            }
            if (null != this.action) {
                FullLinkTrace.storeString(buf, this.action, this.action.length(), FullLinkTraceExtraInfoId.FLT_ACTION.getValue());
            }
            if (null != this.clientInfo) {
                FullLinkTrace.storeString(buf, this.clientInfo, this.clientInfo.length(), FullLinkTraceExtraInfoId.FLT_CLIENT_INFO.getValue());
            }
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_CLIENT_IDENTIFIER.value) {
                    this.clientIdentifier = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_MODULE.value) {
                    this.module = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_ACTION.value) {
                    this.action = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_CLIENT_INFO.value) {
                    this.clientInfo = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.isSet = false;
            this.clientIdentifier = null;
            this.module = null;
            this.action = null;
            this.clientInfo = null;
        }

        public void setModule(String module, String action) {
            this.isSet = true;
            this.module = module;
            this.action = action;
        }

        public String getModule() {
            return this.module;
        }

        public void setAction(String action) {
            this.isSet = true;
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }

        public void setClientInfo(String clientInfo) {
            this.isSet = true;
            this.clientInfo = clientInfo;
        }

        public String getClientInfo() {
            return this.clientInfo;
        }

        public void setClientIdentifier(String clientIdentifier) {
            this.isSet = true;
            this.clientIdentifier = clientIdentifier;
        }

        public String getClientIdentifier() {
            return this.clientIdentifier;
        }
    }

    public class ControlInfo
    extends FullLinkTraceInfoBase {
        byte level;
        double samplePercentage;
        RecordPolicy recordPolicy;
        double printSamplePercentage;
        long slowQueryThreshold;

        private ControlInfo() {
            this.type = FullLinkTraceExtraInfoType.FLT_CONTROL_INFO;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            localize += 6;
            localize += FullLinkTrace.getStoreInt1Size();
            localize += FullLinkTrace.getStoreDoubleSize();
            localize += FullLinkTrace.getStoreInt1Size();
            localize += FullLinkTrace.getStoreDoubleSize();
            return localize += FullLinkTrace.getStoreInt8Size();
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeInt1(buf, this.level, FullLinkTraceExtraInfoId.FLT_LEVEL.getValue());
            FullLinkTrace.storeDouble(buf, this.samplePercentage, FullLinkTraceExtraInfoId.FLT_SAMPLE_PERCENTAGE.getValue());
            FullLinkTrace.storeInt1(buf, (byte)this.recordPolicy.ordinal(), FullLinkTraceExtraInfoId.FLT_RECORD_POLICY.getValue());
            FullLinkTrace.storeDouble(buf, this.printSamplePercentage, FullLinkTraceExtraInfoId.FLT_PRINT_SAMPLE_PCT.getValue());
            FullLinkTrace.storeInt8(buf, this.slowQueryThreshold, FullLinkTraceExtraInfoId.FLT_SLOW_QUERY_THRES.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_LEVEL.value) {
                    this.level = FullLinkTrace.getInt1(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SAMPLE_PERCENTAGE.value) {
                    this.samplePercentage = FullLinkTrace.getDouble(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_RECORD_POLICY.value) {
                    byte v = FullLinkTrace.getInt1(buf, valLen);
                    this.recordPolicy = RecordPolicy.valueOf(v);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_PRINT_SAMPLE_PCT.value) {
                    this.printSamplePercentage = FullLinkTrace.getDouble(buf, valLen);
                    continue;
                }
                if (extraId == FullLinkTraceExtraInfoId.FLT_SLOW_QUERY_THRES.value) {
                    this.slowQueryThreshold = FullLinkTrace.getInt8(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        public byte getLevel() {
            return this.level;
        }

        public double getSamplePercentage() {
            return this.samplePercentage;
        }

        public byte getRecordPolicy() {
            return (byte)(this.recordPolicy.ordinal() + 1);
        }

        public double getPrintSamplePercentage() {
            return this.printSamplePercentage;
        }

        public long getSlowQueryThreshold() {
            return this.slowQueryThreshold;
        }

        private boolean isValid() {
            return this.level > 0 && this.recordPolicy != RecordPolicy.MAX_RECORD_POLICY && this.samplePercentage >= 0.0 && this.samplePercentage <= 1.0 && this.printSamplePercentage >= 0.0 && this.printSamplePercentage <= 1.0;
        }
    }

    private class DriveLog
    extends FullLinkTraceInfoBase {
        private String log;

        private DriveLog() {
            this.type = FullLinkTraceExtraInfoType.FLT_DRV_LOG;
        }

        @Override
        protected int getSerializeSize() {
            int localize = 0;
            if (this.log != null && this.log.length() != 0) {
                localize += 6;
                localize += FullLinkTrace.getStoreStringSize(this.log.length());
            }
            return localize;
        }

        @Override
        protected void serialize(Buffer buf) throws IOException {
            int originalPos = buf.getPosition();
            buf.checkRemainder(6L);
            buf.setPosition(originalPos + 6);
            FullLinkTrace.storeString(buf, this.log, this.log.length(), FullLinkTraceExtraInfoId.FLT_DRIVER_SPAN.getValue());
            int totalLen = buf.getPosition() - originalPos - 6;
            buf.setPosition(originalPos);
            FullLinkTrace.storeTypeAndLen(buf, this.type.getValue(), totalLen);
            buf.setPosition(buf.getPosition() + totalLen);
        }

        @Override
        protected void deserialize(Buffer buf, int infoEndPos) throws IOException {
            while (buf.getPosition() < infoEndPos) {
                short extraId = FullLinkTrace.resolveType(buf);
                int valLen = FullLinkTrace.resolveLength(buf);
                if (extraId == FullLinkTraceExtraInfoId.FLT_DRIVER_SPAN.value) {
                    this.log = FullLinkTrace.getString(buf, valLen);
                    continue;
                }
                buf.skipBytes(valLen);
            }
        }

        private void reset() {
            this.log = null;
        }
    }

    abstract class FullLinkTraceInfoBase {
        FullLinkTraceExtraInfoType type;

        FullLinkTraceInfoBase() {
        }

        protected abstract int getSerializeSize();

        protected abstract void serialize(Buffer var1) throws IOException;

        protected abstract void deserialize(Buffer var1, int var2) throws IOException;
    }

    public static enum TagKey {
        COMMAND_NAME("command_name"),
        CLIENT_HOST("client_host");

        private final String keyStr;

        private TagKey(String str) {
            this.keyStr = str;
        }

        public String getString() {
            return this.keyStr;
        }
    }

    private static enum RecordPolicy {
        RP_ALL,
        RP_ONLY_SLOW_QUERY,
        RP_SAMPLE_AND_SLOW_QUERY,
        MAX_RECORD_POLICY;


        private static RecordPolicy valueOf(byte v) throws UnsupportedEncodingException {
            switch (v) {
                case 1: {
                    return RP_ALL;
                }
                case 2: {
                    return RP_ONLY_SLOW_QUERY;
                }
                case 3: {
                    return RP_SAMPLE_AND_SLOW_QUERY;
                }
                case 4: {
                    return MAX_RECORD_POLICY;
                }
            }
            throw new UnsupportedEncodingException("Unknown RecordPolicy: " + v);
        }
    }

    static enum FullLinkTraceExtraInfoType {
        FLT_DRV_LOG(1),
        FLT_EXTRA_INFO_DRIVE_END(1000),
        FLT_APP_INFO(2001),
        FLT_QUERY_INFO(2002),
        FLT_CONTROL_INFO(2003),
        FLT_SPAN_INFO(2004),
        FLT_EXTRA_INFO_TYPE_END(65535);

        private final short value;

        private FullLinkTraceExtraInfoType(int v) {
            this.value = (short)v;
        }

        short getValue() {
            return this.value;
        }
    }

    private static enum FullLinkTraceExtraInfoId {
        FLT_DRIVER_SPAN(1),
        FLT_DRIVER_END(1000),
        FLT_PROXY_END(2000),
        FLT_CLIENT_IDENTIFIER(2001),
        FLT_MODULE(2002),
        FLT_ACTION(2003),
        FLT_CLIENT_INFO(2004),
        FLT_APPINFO_TYPE(2005),
        FLT_QUERY_START_TIMESTAMP(2010),
        FLT_QUERY_END_TIMESTAMP(2011),
        FLT_LEVEL(2020),
        FLT_SAMPLE_PERCENTAGE(2021),
        FLT_RECORD_POLICY(2022),
        FLT_PRINT_SAMPLE_PCT(2023),
        FLT_SLOW_QUERY_THRES(2024),
        FLT_TRACE_ENABLE(2030),
        FLT_FORCE_PRINT(2031),
        FLT_TRACE_ID(2032),
        FLT_REF_TYPE(2033),
        FLT_SPAN_ID(2034),
        FLT_EXTRA_INFO_ID_END(65535);

        private final short value;

        private FullLinkTraceExtraInfoId(int v) {
            this.value = (short)v;
        }

        private short getValue() {
            return this.value;
        }
    }
}

