/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.impl;

import com.oceanbase.jdbc.internal.failover.BlackList.BlackListConfig;
import com.oceanbase.jdbc.internal.failover.BlackList.append.AppendStrategy;
import com.oceanbase.jdbc.internal.failover.BlackList.append.NormalAppend;
import com.oceanbase.jdbc.internal.failover.BlackList.append.RetryDuration;
import com.oceanbase.jdbc.internal.failover.BlackList.recover.TimeoutRecover;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.BalanceStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.GroupRotationStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.RandomStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.RotationStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.ServerAffinityStrategy;
import com.oceanbase.jdbc.internal.failover.impl.Builder;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceAddressList;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceDriver;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceInfo;
import com.oceanbase.jdbc.internal.failover.impl.checkers.BalanceStrategyChecker;
import com.oceanbase.jdbc.internal.failover.impl.checkers.BlackListStrategyAppendChecker;
import com.oceanbase.jdbc.internal.failover.impl.checkers.BlackListStrategyRemoveChecker;
import com.oceanbase.jdbc.internal.failover.impl.checkers.ConfigChecker;
import com.oceanbase.jdbc.internal.failover.impl.checkers.GroupStrategyConfigChecker;
import java.sql.SQLException;
import java.util.HashMap;

public class LoadBlanceDriverBuilder
implements Builder {
    private LoadBalanceDriver loadBalanceDriver = null;
    ConfigChecker checker = null;
    LoadBalanceInfo loadBalanceInfo = null;

    public LoadBlanceDriverBuilder(LoadBalanceInfo loadBalanceInfo) {
        this.loadBalanceInfo = loadBalanceInfo;
        this.reset();
    }

    public LoadBlanceDriverBuilder(LoadBalanceDriver loadBalanceDriver) {
        this.loadBalanceDriver = loadBalanceDriver;
        this.reset();
    }

    public LoadBlanceDriverBuilder() {
        this.reset();
    }

    @Override
    public void reset() {
        this.loadBalanceDriver = new LoadBalanceDriver();
    }

    @Override
    public void buildGlobalConfigs() {
        this.loadBalanceDriver.setLoadBalanceInfo(this.loadBalanceInfo);
    }

    @Override
    public void buildGroupStrategy() throws SQLException {
        HashMap<String, String> map = this.loadBalanceInfo.getGroupBalanceStrategyConfigs();
        GroupRotationStrategy groupBalanceStrategy = null;
        String name = map.get("NAME");
        this.checker = new GroupStrategyConfigChecker();
        if (!this.checker.isValid(map)) {
            throw new SQLException("groupBalanceStrategy config incorrect\uff1a" + map);
        }
        switch (name.toUpperCase()) {
            default: 
        }
        groupBalanceStrategy = new GroupRotationStrategy();
        this.loadBalanceInfo.setGroupBalanceStrategy(groupBalanceStrategy);
    }

    @Override
    public void buildBlackListStrategy() throws SQLException {
        BlackListConfig blackListConfig = this.loadBalanceInfo.getBlackListConfig();
        String name = blackListConfig.getRemoveStrategyConfigs().get("NAME");
        TimeoutRecover removeStrategy = null;
        this.checker = new BlackListStrategyRemoveChecker();
        if (!this.checker.isValid(blackListConfig.getRemoveStrategyConfigs())) {
            throw new SQLException("groupBalanceStrategy config incorrect\uff1a" + blackListConfig.getRemoveStrategyConfigs());
        }
        switch (name.toUpperCase()) {
            default: 
        }
        removeStrategy = new TimeoutRecover();
        int timeout = Integer.parseInt(blackListConfig.getRemoveStrategyConfigs().get("TIMEOUT"));
        removeStrategy.setTimeout(timeout);
        blackListConfig.setRemoveStrategy(removeStrategy);
        name = blackListConfig.getAppendStrategyConfigs().get("NAME");
        this.checker = new BlackListStrategyAppendChecker();
        if (!this.checker.isValid(blackListConfig.getAppendStrategyConfigs())) {
            throw new SQLException("groupBalanceStrategy config incorrect\uff1a" + blackListConfig.getAppendStrategyConfigs());
        }
        AppendStrategy appendStrategy = null;
        switch (name.toUpperCase()) {
            case "RETRYDURATION": {
                String retryTimes = blackListConfig.getAppendStrategyConfigs().get("RETRYTIMES");
                String duration = blackListConfig.getAppendStrategyConfigs().get("DURATION");
                appendStrategy = new RetryDuration(Long.parseLong(duration), Integer.parseInt(retryTimes));
                break;
            }
            default: {
                appendStrategy = new NormalAppend();
            }
        }
        blackListConfig.setAppendStrategy(appendStrategy);
    }

    @Override
    public void buildBalanceStrategy() throws SQLException {
        HashMap<String, String> map = this.loadBalanceInfo.getBalanceStrategyConfigs();
        BalanceStrategy balanceStrategy = null;
        String name = map.get("NAME");
        this.checker = new BalanceStrategyChecker();
        if (!this.checker.isValid(map)) {
            throw new SQLException("Global balanceStrategy config incorrect\uff1a" + map);
        }
        switch (name.toUpperCase()) {
            case "SERVERAFFINITY": {
                balanceStrategy = new ServerAffinityStrategy();
                break;
            }
            case "ROTATION": {
                balanceStrategy = new RotationStrategy();
                break;
            }
            default: {
                balanceStrategy = new RandomStrategy();
            }
        }
        this.loadBalanceInfo.setBalanceStrategy(balanceStrategy);
    }

    @Override
    public void buildHostListBalanceStrategies() throws SQLException {
        this.checker = new BalanceStrategyChecker();
        for (LoadBalanceAddressList loadBalanceAddressList : this.loadBalanceInfo.groups) {
            String name = loadBalanceAddressList.getBalanceStrategyConfigs().get("NAME");
            HashMap<String, String> map = loadBalanceAddressList.getBalanceStrategyConfigs();
            if (!this.checker.isValid(map)) {
                throw new SQLException("Host list  balanceStrategy config incorrect\uff1a" + map);
            }
            BalanceStrategy hostListBalanceStrategy = null;
            switch (name.toUpperCase()) {
                case "SERVERAFFINITY": {
                    hostListBalanceStrategy = new ServerAffinityStrategy();
                    break;
                }
                case "ROTATION": {
                    hostListBalanceStrategy = new RotationStrategy();
                    break;
                }
                default: {
                    hostListBalanceStrategy = new RandomStrategy();
                }
            }
            loadBalanceAddressList.setBalanceStrategy(hostListBalanceStrategy);
        }
    }

    @Override
    public LoadBalanceDriver getResult() {
        return this.loadBalanceDriver;
    }
}

