/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public class OBTIMESTAMPTZParameter
implements Cloneable,
ParameterHolder {
    private final TIMESTAMPTZ ts;
    private static final byte[] LITERALS_TIMESTAMP = "timestamp ".getBytes();
    private static final int ORACLE_TIME_SCALE = 9;
    private boolean isTZTablesImported = false;

    public OBTIMESTAMPTZParameter(TIMESTAMPTZ ts) {
        this.ts = ts;
    }

    public OBTIMESTAMPTZParameter(TIMESTAMPTZ ts, boolean isTZTablesImported) {
        this.ts = ts;
        this.isTZTablesImported = isTZTablesImported;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        try {
            pos.write(LITERALS_TIMESTAMP);
            pos.write(39);
            String tmString = this.ts.toResultSetString(null);
            pos.write(tmString.getBytes());
            pos.write(39);
        }
        catch (SQLException e) {
            throw new IOException("get String value error");
        }
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 27;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        byte[] data = this.ts.getBytes();
        int length = data.length;
        data[11] = 9;
        pos.write((byte)length);
        pos.write(data, 0, data.length);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TIMESTAMP_TZ;
    }

    @Override
    public String toString() {
        return "'" + this.ts.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

