/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.authentication;

import com.oceanbase.jdbc.authentication.AuthenticationPlugin;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

public class SendPamAuthPacket
implements AuthenticationPlugin {
    private String authenticationData;
    private String passwordCharacterEncoding;
    private Options options;
    private int counter = 0;

    @Override
    public String name() {
        return "PAM client authentication";
    }

    @Override
    public String type() {
        return "dialog";
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.authenticationData = authenticationData;
        this.passwordCharacterEncoding = options.passwordCharacterEncoding;
        this.options = options;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        Buffer buffer;
        int type;
        do {
            String password;
            ++this.counter;
            if (this.counter == 1) {
                password = this.authenticationData;
            } else {
                if (!this.options.nonMappedOptions.containsKey("password" + this.counter)) {
                    throw new SQLException("PAM authentication request multiple passwords, but 'password" + this.counter + "' is not set");
                }
                password = (String)this.options.nonMappedOptions.get("password" + this.counter);
            }
            out.startPacket(sequence.incrementAndGet());
            byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? password.getBytes(this.passwordCharacterEncoding) : password.getBytes();
            out.write(bytePwd, 0, bytePwd.length);
            out.write(0);
            out.flush();
            buffer = in.getPacket(true);
            sequence.set(in.getLastPacketSeq());
        } while ((type = buffer.getByteAt(0) & 0xFF) != 254 && type != 0 && type != 255);
        return buffer;
    }
}

