/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Map_GuangDong_Three {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Map_GuangDong_Three.generateDefaultOption();
            String clazzName = Map_GuangDong_Three.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String resourceDataPath = websiteName + File.separator + "pluginResource";
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", new JSONObject().toString());
                return results;
            }
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            String htmlString = option.replaceAll("##plugin", jsResourceHttp);
            htmlString = htmlString.replaceAll("##pluginResource", resourceDataPath);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(htmlString);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
            if (result == 0) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", new JSONObject().toString());
            } else {
                results.put("state", "failed");
            }
            if (!htmlFile.exists()) return results;
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Map_GuangDong_Three.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=utf-8>\n    <title>\u5730\u56fe\u7279\u6548</title>\n    <style>\n        body {\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            font-family: Arial, sans-serif;\n        }\n\n        .label-div {\n            width: 250px;\n            height: 50px;\n            background-color: #0C0C0C21;\n            border-radius: 20px;\n            display: flex;\n            /* position: absolute; */\n        }\n\n        .count-div {\n            flex: 2;\n            display: flex;\n            justify-content: center;\n            align-items: center;\n        }\n\n        .count-left {\n            font-size: 9px;\n            color: #fff;\n        }\n\n        .count-right {\n            font-size: 11px;\n            color: lightgray;\n        }\n\n        .city-div {\n            flex: 3;\n            display: flex;\n            flex-direction: column;\n        }\n\n        /* \u57ce\u5e02\u540d */\n        .city-name {\n            flex: 1;\n            font-size: 13px;\n            display: flex;\n            justify-content: flex-start;\n            align-items: flex-end;\n            color: #fff;\n            font-weight: bolder;\n            /*position: absolute;*/\n        }\n\n        .city-py {\n            flex: 1;\n            font-size: 12px;\n            display: flex;\n            justify-content: flex-start;\n            align-items: flex-start;\n            color: #fff;\n        }\n\n        .number-div {\n            flex: 2;\n            display: flex;\n            justify-content: center;\n            align-items: center;\n        }\n\n        .fluorescent-number {\n            font-size: 30px;\n            font-weight: bold;\n            color: yellowgreen; /* Bright green for fluorescence */\n            text-align: center;\n            text-shadow: 0 0 5px #00FF00, /* Main shadow */ 0 0 10px #00FF00,\n            0 0 20px #00FF00,\n            0 0 30px #00FF00,\n            0 0 40px #00FF00,\n            0 0 50px #00FF00,\n            0 0 60px #00FF00,\n            0 0 70px #00FF00;\n        }\n\n\n        @keyframes glow {\n            0% {\n                text-shadow: 0 0 5px #00FF00,\n                0 0 10px #00FF00,\n                0 0 20px #00FF00,\n                0 0 30px #00FF00,\n                0 0 40px #00FF00,\n                0 0 50px #00FF00,\n                0 0 60px #00FF00,\n                0 0 70px #00FF00;\n\n            }\n\n            100% {\n                text-shadow: 0 0 10px #00FFFF, /* Slightly blue-green */ 0 0 20px #00FFFF,\n                0 0 30px #00FFFF,\n                0 0 40px #00FFFF,\n                0 0 50px #00FFFF,\n                0 0 60px #00FFFF,\n                0 0 70px #00FFFF,\n                0 0 80px #00FFFF;\n            }\n\n        }\n\n        canvas {\n            width: 100%;\n            height: 100%;\n            display: block;\n        }\n    </style>\n</head>\n\n<body>\n<script src='##plugin/build/three.js'></script>\n<script src='##plugin/three/js/controls/OrbitControls.js'></script>\n<script src='##plugin/three/js/loaders/OBJLoader.js'></script>\n<script src='##plugin/three/js/loaders/MTLLoader.js'></script>\n<script src='##plugin/three/js/utils/BufferGeometryUtils.js'></script>\n<script src='##plugin/three/js/postprocessing/EffectComposer.js'></script>\n<script src='##plugin/three/js/postprocessing/RenderPass.js'></script>\n<!-- \u5f15\u5165\u53ef\u4ee5\u5b9e\u73b0Bloom\u6cdb\u5149\u6548\u679c\u7684\u540e\u671f\u5904\u7406\u901a\u9053UnrealBloomPass -->\n<script src='##plugin/three/js/postprocessing/UnrealBloomPass.js'></script>\n<script src='##plugin/three/js/postprocessing/ShaderPass.js'></script>\n<script src='##plugin/three/js/shaders/LuminosityHighPassShader.js'></script>\n<script src='##plugin/three/js/shaders/CopyShader.js'></script>\n<script src='##plugin/three/js/objects/Reflector.js'></script>\n<script src='##plugin/three/js/shaders/WaterRefractionShader.js'></script>\n<script src='##plugin/three/comm.js'></script>\n<script type='module'>\n    import { CSS2DRenderer, CSS2DObject } from '##plugin/three/jsm/renderers/CSS2DRenderer.js';\n    import { CSS3DRenderer, CSS3DObject } from '##plugin/three/jsm/renderers/CSS3DRenderer.js';\n    import wall_output_fragment from '##plugin/three/js/wall_output_fragment.glsl.js'\n    import flyLine_output_fragment from '##plugin/three/js/flyLine_output_fragment.glsl.js'\n    import flyLine_output_vertex from '##plugin/three/js/flyLine_output_vertex.glsl.js'\n    import aniGroundCirclePlane_output_fragment from '##plugin/three/js/aniGroundCirclePlane_output_fragment.glsl.js'\n\n    var scene = new THREE.Scene();\n    var isFinishLoadJson1 = false;  // \u5e7f\u4e1c\u7701\u5e02json\n    var isFinishLoadJson2 = false;  // \u5e7f\u4e1c\u7701json\n\n    // \u6a21\u578b\u6e32\u67d3\u987a\u5e8f\n    const renderOrderNoTransparent = 0;\n    const renderOrderGroundPlane = 100;\n    const renderOrderFlyLinePlane = 110;\n    const renderOrderPillar = 120;\n    const renderOrderFlyLine = 130;\n\n    var imageUrl = '##pluginResource/data/three/images/';\n    var jsonUrl = '##pluginResource/data/three/guangdongMap/';\n    var mapExtrudeHeight = 0.3;\n    var mapPlaneOpacity = 0.76;\n\n    var flyLine = null;\n    var flyLineShaderArr = [];\n    var flyLineColor1 = new THREE.Color(0.3, 1.0, 1.0);\n    var flyLineColor2 = new THREE.Color(0.0, 0.75, 0.9);\n    var currflyLineHighLightIndex = 0.0;\n\n    var flyLinePlaneArr = [];\n\n    var groundImageColor = 0x236191;\n\n    var chinaLineColor = 0x345F8B;\n    var chinaPlaneColor = 0x004488;\n    var provinceLineColor = 0x83D0FF;\n    var provinceLineHighLightColor = 0xffffff;\n    var provincePlaneColor = 0x006b88;\n    var selectedColor = 0x3583E5;\n\n    var provinceWallColor = 0x065976;\n    var wallHighLightColor = 0x1490AD;\n    var wallAniStartPoint = 0;\n    var wallMesh = null;\n    var wallMaterialShader = null;\n    var aniPlaneShader = {value: null};\n    var initAniPlaneRadius = -30;\n    var aniCityPlaneShader = {value: null};\n    var provinceLinePointCount = 1931;\n    var provinceLineAniPointIndex1 = 0;\n    var provinceLineAniPointIndex2 = 965;\n    // \u53c2\u4e0e\u52a8\u753b\u6548\u679c\u70b9\u7684\u6570\u91cf\n    var provinceLineAniPointCount = 400;\n\n    var composer;\n    var renderer = null;\n    var line = null;\n    var pointArr = [];\n    var lineGroup = new THREE.Group();\n    var shapeGroup = new THREE.Group();\n\n    var chooseMeshArrObj = {\n        '\u5e7f\u5dde': [113.280637, 23.225178],\n        '\u6df1\u5733': [114.885947, 22.547],\n        '\u73e0\u6d77': [113.553986, 22.224979],\n        '\u4f5b\u5c71': [113.122717, 23.028762],\n        '\u4e1c\u839e': [113.746262, 22.846237],\n        '\u4e2d\u5c71': [113.382391, 22.521113],\n        '\u4e91\u6d6e': [111.584439, 23.029801],\n        '\u8302\u540d': [110.919229, 21.659751],\n        '\u97f6\u5173': [114.191544, 24.801322],\n    };\n\n    var chooseMesh = null;\n\n    var clock = new THREE.Clock();\n\n    var gridColor = 0x007090;\n    var RColor = 0x666666;\n    var ground1 = addGround(50, 150, gridColor, 0.03, RColor);\n    ground1.position.x += 110;\n    ground1.position.y += 28;\n    scene.add(ground1);\n\n    var groundImageMesh1 = addGroundImageMesh1(imageUrl + 'circle2.png', 6.8, 6.8);\n    groundImageMesh1.position.x += 113.42393493652344;\n    groundImageMesh1.position.y += 22.86424446105957;\n    groundImageMesh1.position.z -= 0.03;\n    scene.add(groundImageMesh1);\n\n    var groundImageMesh2 = addGroundImageMesh1(imageUrl + 'circle3.png', 7.5, 7.5);\n    groundImageMesh2.position.x += 113.42393493652344;\n    groundImageMesh2.position.y += 22.86424446105957;\n    groundImageMesh2.position.z -= 0.02;\n    scene.add(groundImageMesh2);\n\n    var loader = new THREE.FileLoader();\n    loader.setResponseType('json');\n\n    if (true) {\n        loader.load(jsonUrl + '/\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd.json', function (data) {\n            data.features.forEach(function (area) {\n                var mesh = null;\n\n                if (area.geometry.type === \"Polygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        area.geometry.coordinates[0].forEach((elem) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        line = createAreaLine(pointArr, chinaLineColor);\n                        line.position.z = 0.04;\n                        lineGroup.add(line);\n\n                        mesh = createShapePlaneMesh(vector2Arr, 0.01, 0x0C2437, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        mesh.position.z -= 0.05;\n                        shapeGroup.add(mesh);\n                    });\n                } else if (area.geometry.type === \"MultiPolygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        polygon[0].forEach((elem, i) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        line = createAreaLine(pointArr, chinaLineColor);\n                        line.position.z -= 0.04;\n                        lineGroup.add(line);\n\n                        mesh = createShapePlaneMesh(vector2Arr, 0.01, 0x0C2437, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        mesh.position.z -= 0.05;\n                        shapeGroup.add(mesh);\n                    });\n                }\n            });\n        });\n    }\n\n    if (true) {\n        loader.load(jsonUrl + '\u5e7f\u4e1c\u7701\u5e02.json', function (data) {\n            data.features.forEach(function (area) {\n                var mesh = null;\n                if (area.geometry.type === \"Polygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        area.geometry.coordinates[0].forEach((elem) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        line = createAreaLine(pointArr, provinceLineColor);\n                        line.position.z += mapExtrudeHeight + 0.01;\n                        lineGroup.add(line);\n                        mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                        mesh.renderOrder = renderOrderGroundPlane;\n                        mesh.material.transparent = true;\n                        mesh.material.opacity = mapPlaneOpacity;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                        wallMesh.renderOrder = renderOrderNoTransparent;\n                        scene.add(wallMesh);\n                    });\n                } else if (area.geometry.type === \"MultiPolygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        polygon[0].forEach((elem, i) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        line = createAreaLine(pointArr, provinceLineColor);\n                        line.position.z += mapExtrudeHeight + 0.01;\n                        lineGroup.add(line);\n\n                        // \u5e95\u9762\n                        mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                        mesh.renderOrder = renderOrderGroundPlane;\n                        mesh.material.transparent = true;\n                        mesh.material.opacity = mapPlaneOpacity;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                        wallMesh.renderOrder = renderOrderNoTransparent;\n                        scene.add(wallMesh);\n                    });\n                }\n            });\n\n            isFinishLoadJson1 = true;\n            loadJsonFinished();\n        });\n    }\n\n    scene.add(lineGroup);\n    scene.add(shapeGroup);\n\n    var aniLineGeometry = null;\n    if (true) {\n        loader.load(jsonUrl + '/\u5e7f\u4e1c\u7701.json', function (data) {\n            data.features.forEach(function (area) {\n                if (area.geometry.type === \"Polygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        area.geometry.coordinates[0].forEach((elem) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                    });\n                } else if (area.geometry.type === \"MultiPolygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        polygon[0].forEach((elem, i) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        if (vector2Arr.length == provinceLinePointCount) {\n                            aniLineGeometry = new THREE.BufferGeometry();\n                            var vertices = new Float32Array(pointArr);\n                            var attribute = new THREE.BufferAttribute(vertices, 3);\n                            aniLineGeometry.attributes.position = attribute;\n                            // console.log('aniLineGeometry: ', aniLineGeometry);\n                            setProvinceLineAniColor(\n                                aniLineGeometry,\n                                provinceLinePointCount,\n                                provinceLineAniPointCount,\n                                provinceLineAniPointIndex1,\n                                provinceLineAniPointIndex2\n                            )\n\n                            var material = new THREE.LineBasicMaterial({\n                                vertexColors: THREE.VertexColors,\n                            });\n                            var aniProvinceLine = new THREE.LineLoop(aniLineGeometry, material);\n                            aniProvinceLine.position.z += mapExtrudeHeight + 0.01;\n                            scene.add(aniProvinceLine);\n\n                            var box3 = new THREE.Box3();\n                            box3.expandByObject(aniProvinceLine);\n                        }\n\n                        wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, true);  // 0x026086\n                        wallMesh.renderOrder = renderOrderNoTransparent;\n                        scene.add(wallMesh);\n                    });\n                }\n            });\n\n            isFinishLoadJson2 = true;\n            loadJsonFinished();\n        });\n    }\n\n    // \u5de6\u4e0b\u4fa7\u5149 \u989c\u8272 \u5f3a\u5ea6 \u8ddd\u79bb\n    var pointLight1 = new THREE.PointLight(0xffffff, 1.5, 1000);\n    pointLight1.position.set(0, 0, -10);\n\n    // \u5de6\u4e0a\u4fa7\u5149\n    var pointLight2 = new THREE.PointLight(0xffffff, 15, 1000);\n    pointLight2.position.set(50, 150.48, 0);\n\n    // // \u4e0a\u65b9\u5149\n    var pointLight3 = new THREE.PointLight(0xffffff, 1.2, 1000);\n    pointLight3.position.set(104, 28.48, 300);\n\n    var directionalLight1 = new THREE.DirectionalLight(0x888888, 2);//\u5149\u6e90\u989c\u8272\n    directionalLight1.position.set(137, 1000, 100);//\u5149\u6e90\u4f4d\u7f6e\n    scene.add(directionalLight1);//\u5149\u6e90\u6dfb\u52a0\u5230\u573a\u666f\u4e2d\n\n    var directionalLight2 = new THREE.DirectionalLight(0x888888, 12);//\u5149\u6e90\u989c\u8272\n    directionalLight2.position.set(137, 300, 100);//\u5149\u6e90\u4f4d\u7f6e\n\n    var ambient = new THREE.AmbientLight(0x666666, 3.5);\n    scene.add(ambient);\n    // 3D label\n    var provinceNameLabel = createProvinceNameLabel(chooseMeshArrObj['\u5e7f\u5dde']);\n    scene.add(provinceNameLabel);\n    var renderWidth = window.innerWidth;\n    var renderHeight = window.innerHeight;\n    var camera = new THREE.PerspectiveCamera(45, window.innerWidth / window.innerHeight, 0.01, 15000);\n    renderer = new THREE.WebGLRenderer({antialias: true, depth: true, logarithmicDepthBuffer: true}); // depth: true, logarithmicDepthBuffer: true\n    renderer.setSize(renderWidth, renderHeight);\n    renderer.autoClear = false;\n    renderer.sortObjects = false; // \u5c1d\u8bd5\u81ea\u52a8\u6392\u5e8f\u5bf9\u8c61\n    render.outputEncoding = THREE.sRGBEncoding; // srg\u989c\u8272\n    renderer.setClearColor(0x004466, 0.6);  //0x001111\n    document.body.appendChild(renderer.domElement);\n    renderer.domElement.style.width = `${renderWidth}px`; // \u8bbe\u7f6eHTML\u753b\u5e03\u7684\u5b9e\u9645\u663e\u793a\u5c3a\u5bf8\n    renderer.domElement.style.height = `${renderHeight}px`;\n\n    // CSS3DRenderer\n    var labelRenderer = new CSS3DRenderer();\n    labelRenderer.setSize(renderWidth, renderHeight);\n    labelRenderer.domElement.style.position = 'absolute';\n\n    labelRenderer.domElement.style.top = '0px';\n    labelRenderer.domElement.style.left = '0px';\n    labelRenderer.domElement.style.pointerEvents = 'none';\n    document.body.appendChild(labelRenderer.domElement);\n    addEventListener('mousemove', onMouseMove);\n    addEventListener('resize', onResize);\n    var controls = new THREE.OrbitControls(camera, renderer.domElement);\n    controls.enableDamping = true; // \u542f\u7528\u52a8\u6001\u963b\u5c3c\u65f6\u9700\u8981\u4e00\u4e2a\u52a8\u753b\u5faa\u73af\n    controls.dampingFactor = 0.03;\n    controls.mouseButtons = {\n        LEFT: THREE.MOUSE.ROTATE, // \u65cb\u8f6c\n        MIDDLE: THREE.MOUSE.DOLLY,  // \u7f29\u653e\n        RIGHT: THREE.MOUSE.PAN,  // \u79fb\u52a8\n    };\n    controls.minAzimuthAngle = -Math.PI / 4; // \u5de6\u4fa745\u5ea6\n    controls.maxAzimuthAngle = Math.PI / 4; // \u53f3\u4fa745\u5ea6\n\n    controls.minPolarAngle = Math.PI / 2; // 90\u5ea6 \u76f4\u89d2\n    controls.maxPolarAngle = Math.PI / 1.05; // 180\u5ea6\uff0c\u5373\u6c34\u5e73\u7ebf\n\n    controls.target.set(113.42393493652344, 22.86424446105957, 0);\n\n    camera.position.set(113.43, 15.58, 4.5);\n    camera.lookAt(113.42393493652344, 22.86424446105957, 0);\n\n    render();\n\n    function render() {\n        const delta = clock.getDelta();\n        if (null != aniLineGeometry) {\n            provinceLineAniPointIndex1 += delta * 60;\n            if (provinceLineAniPointIndex1 >= provinceLinePointCount)\n                provinceLineAniPointIndex1 = 0;\n\n            provinceLineAniPointIndex2 += delta * 60;\n            if (provinceLineAniPointIndex2 >= provinceLinePointCount)\n                provinceLineAniPointIndex2 = 0;\n\n            setProvinceLineAniColor(\n                aniLineGeometry,\n                provinceLinePointCount,\n                provinceLineAniPointCount,\n                provinceLineAniPointIndex1,\n                provinceLineAniPointIndex2\n            );\n        }\n\n        if (null != wallMaterialShader) {\n            wallMaterialShader.uniforms.wallAniStartPoint.value += (delta * 0.08);\n            if (wallMaterialShader.uniforms.wallAniStartPoint.value > mapExtrudeHeight)\n                wallMaterialShader.uniforms.wallAniStartPoint.value = 0;\n        }\n\n        if (null != aniPlaneShader.value) {\n            aniPlaneShader.value.uniforms.currR.value += (delta * 15);\n            if (aniPlaneShader.value.uniforms.currR.value > 100)\n                aniPlaneShader.value.uniforms.currR.value = initAniPlaneRadius;\n        }\n\n        if (null != aniCityPlaneShader.value) {\n            aniCityPlaneShader.value.uniforms.currR.value += (delta * 0.08);\n            if (aniCityPlaneShader.value.uniforms.currR.value > 0.2)\n                aniCityPlaneShader.value.uniforms.currR.value = -0.3;\n\n            if (aniCityPlaneShader.value.uniforms.currR.value > 0)\n                aniCityPlaneShader.value.uniforms.outOpacity.value = (0.2 - aniCityPlaneShader.value.uniforms.currR.value) / 0.2;\n            else\n                aniCityPlaneShader.value.uniforms.outOpacity.value = 0;\n        }\n\n        groundImageMesh1.rotateZ(delta * 0.15);\n        groundImageMesh2.rotateZ(-delta * 0.15);\n\n        if (flyLineShaderArr.length > 0) {\n            for (var i = 0; i < flyLineShaderArr.length; i++) {\n                flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value += delta * (flyLineShaderArr[i].uniforms.pointCount.value / 2.2);\n                if (flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value > flyLineShaderArr[i].uniforms.pointCount.value * 3)\n                    flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value = 0.0;\n            }\n        }\n        if (flyLinePlaneArr.length > 0) {\n            for (var i = 0; i < flyLinePlaneArr.length; i++) {\n                flyLinePlaneArr[i].rotateZ(delta * 0.8);\n            }\n        }\n\n        renderer.clear();\n        renderer.render(scene, camera);\n\n        labelRenderer.render(scene, camera);\n        controls.update();\n\n        requestAnimationFrame(render);\n    }\n\n    function loadJsonFinished() {\n        if (!isFinishLoadJson1 || !isFinishLoadJson2)\n            return;\n\n        // \u98de\u7ebf\u5f00\u59cb\u4f4d\u7f6e\u7684\u57fa\u5ea7\n        var flyLinePlane = createFlyLinePlane(chooseMeshArrObj['\u5e7f\u5dde'], 0.2, 0.2, mapExtrudeHeight, imageUrl + 'circle5.png');\n        flyLinePlaneArr.push(flyLinePlane);\n        scene.add(flyLinePlane);\n        var flyLinePlane1 = createFlyLinePlane(chooseMeshArrObj['\u8302\u540d'], 0.2, 0.2, mapExtrudeHeight, imageUrl + 'circle5.png');\n        flyLinePlaneArr.push(flyLinePlane1);\n        scene.add(flyLinePlane1);\n        var flyLinePlane2 = createFlyLinePlane(chooseMeshArrObj['\u6df1\u5733'], 0.2, 0.2, mapExtrudeHeight, imageUrl + 'circle5.png');\n        flyLinePlaneArr.push(flyLinePlane2);\n        scene.add(flyLinePlane2);\n        var flyLinePlane3 = createFlyLinePlane(chooseMeshArrObj['\u4e91\u6d6e'], 0.2, 0.2, mapExtrudeHeight, imageUrl + 'circle5.png');\n        flyLinePlaneArr.push(flyLinePlane3);\n        scene.add(flyLinePlane3);\n        var flyLinePlane4 = createFlyLinePlane(chooseMeshArrObj['\u4e1c\u839e'], 0.2, 0.2, mapExtrudeHeight, imageUrl + 'circle5.png');\n        flyLinePlaneArr.push(flyLinePlane4);\n        scene.add(flyLinePlane4);\n        var flyLinePlane5 = createFlyLinePlane(chooseMeshArrObj['\u97f6\u5173'], 0.2, 0.2, mapExtrudeHeight, imageUrl + 'circle5.png');\n        flyLinePlaneArr.push(flyLinePlane5);\n        scene.add(flyLinePlane5);\n\n        // \u98de\u7ebf\n        var flyLine = createFlyLine(chooseMeshArrObj['\u5e7f\u5dde'], chooseMeshArrObj['\u8302\u540d'], mapExtrudeHeight); // \u4e91\u6d6e \u8302\u540d \u6df1\u5733\n        scene.add(flyLine);\n        var flyLine1 = createFlyLine(chooseMeshArrObj['\u5e7f\u5dde'], chooseMeshArrObj['\u6df1\u5733'], mapExtrudeHeight); // \u4e91\u6d6e \u8302\u540d \u6df1\u5733\n        scene.add(flyLine1);\n        var flyLine2 = createFlyLine(chooseMeshArrObj['\u5e7f\u5dde'], chooseMeshArrObj['\u4e91\u6d6e'], mapExtrudeHeight); // \u4e91\u6d6e \u8302\u540d \u6df1\u5733\n        scene.add(flyLine2);\n        var flyLine3 = createFlyLine(chooseMeshArrObj['\u5e7f\u5dde'], chooseMeshArrObj['\u4e1c\u839e'], mapExtrudeHeight); // \u4e91\u6d6e \u8302\u540d \u6df1\u5733\n        scene.add(flyLine3);\n        var flyLine4 = createFlyLine(chooseMeshArrObj['\u5e7f\u5dde'], chooseMeshArrObj['\u97f6\u5173'], mapExtrudeHeight); // \u4e91\u6d6e \u8302\u540d \u6df1\u5733\n        scene.add(flyLine4);\n\n        // \u67f1\u5b50\n        var pillar1 = createPillar(chooseMeshArrObj['\u5e7f\u5dde'], 0.03, 1, mapExtrudeHeight);\n        scene.add(pillar1);\n        var pillar2 = createPillar(chooseMeshArrObj['\u8302\u540d'], 0.03, 0.3, mapExtrudeHeight);\n        scene.add(pillar2);\n        var pillar3 = createPillar(chooseMeshArrObj['\u6df1\u5733'], 0.03, 0.94, mapExtrudeHeight);\n        scene.add(pillar3);\n        var pillar4 = createPillar(chooseMeshArrObj['\u4e91\u6d6e'], 0.03, 0.5, mapExtrudeHeight);\n        scene.add(pillar4);\n        var pillar5 = createPillar(chooseMeshArrObj['\u4e1c\u839e'], 0.03, 0.55, mapExtrudeHeight);\n        scene.add(pillar5);\n        var pillar6 = createPillar(chooseMeshArrObj['\u97f6\u5173'], 0.03, 0.6, mapExtrudeHeight);\n        scene.add(pillar6);\n\n        var label1 = createCityLabel(chooseMeshArrObj['\u5e7f\u5dde'], 1, mapExtrudeHeight, '\u5e7f\u5dde\u5e02', 'GUANGZHOU', 51, 1);\n        scene.add(label1);\n\n        var label2 = createCityLabel(chooseMeshArrObj['\u8302\u540d'], 0.3, mapExtrudeHeight, '\u8302\u540d\u5e02', 'MAOMING', 18, 6);\n        scene.add(label2);\n\n        var label2 = createCityLabel(chooseMeshArrObj['\u6df1\u5733'], 0.94, mapExtrudeHeight, '\u6df1\u5733\u5e02', 'SHENZHEN', 48, 2);\n        scene.add(label2);\n\n        var label3 = createCityLabel(chooseMeshArrObj['\u4e91\u6d6e'], 0.5, mapExtrudeHeight, '\u4e91\u6d6e\u5e02', 'YUNFU', 23, 5);\n        scene.add(label3);\n\n        var label4 = createCityLabel(chooseMeshArrObj['\u4e1c\u839e'], 0.55, mapExtrudeHeight, '\u4e1c\u839e\u5e02', 'DONGGUAN', 28, 4);\n        scene.add(label4);\n\n        var label5 = createCityLabel(chooseMeshArrObj['\u97f6\u5173'], 0.6, mapExtrudeHeight, '\u97f6\u5173\u5e02', 'SHAOGUAN', 35, 3);\n        scene.add(label5);\n\n        // \u5927\u5730\u5706\u5708\u52a8\u753b\n        var aniPlane = createAniPlane([113.42393493652344, 22.86424446105957], 0, 0x185889, initAniPlaneRadius, 5.0, aniPlaneShader);\n        scene.add(aniPlane);\n    }\n\n    var currSelMesh = null;\n\n    function onMouseMove(event) {\n        if (chooseMesh && chooseMesh.isAllowedChangeColor) {\n            chooseMesh.material.transparent = true;\n            chooseMesh.material.opacity = 0.8;\n            chooseMesh.material.color.set(provincePlaneColor);\n        }\n\n        var sx = event.clientX;\n        var sy = event.clientY;\n\n        var x = (sx / window.innerWidth) * 2 - 1;\n        var y = -(sy / window.innerHeight) * 2 + 1;\n\n        var raycaster = new THREE.Raycaster();\n        raycaster.setFromCamera(new THREE.Vector2(x, y), camera);\n        var intersects = raycaster.intersectObjects(shapeGroup.children);\n        if (intersects.length > 0) {\n            chooseMesh = intersects[0].object;\n            if (chooseMesh.isAllowedChangeColor) {\n\n                chooseMesh.material.opacity = 0.92;\n                chooseMesh.material.color.set(selectedColor);\n            }\n        } else {\n        }\n    }\n\n    function onResize(event) {\n        renderWidth = window.innerWidth;\n        renderHeight = window.innerHeight;\n        renderer.setSize(renderWidth, renderHeight);\n        renderer.domElement.style.width = `${renderWidth}px`; // \u8bbe\u7f6eHTML\u753b\u5e03\u7684\u5b9e\u9645\u663e\u793a\u5c3a\u5bf8\n        renderer.domElement.style.height = `${renderHeight}px`;\n        labelRenderer.setSize(renderWidth, renderHeight);\n\n        camera.aspect = renderWidth / renderHeight;\n        camera.updateProjectionMatrix();\n    }\n\n    function createAreaLine(pointArr, lineColor) {\n        var geometry = new THREE.BufferGeometry();\n        var vertices = new Float32Array(pointArr);\n        var attribute = new THREE.BufferAttribute(vertices, 3);\n        geometry.attributes.position = attribute;\n        var material = new THREE.LineBasicMaterial({\n            color: lineColor,  //0x00ffff 0x00B2DF\n        });\n        var line = new THREE.LineLoop(geometry, material);\n        return line;\n    }\n\n    function createAreaMesh(vector2Arr, meshHeight, meshColor) {\n        var material = new THREE.MeshPhongMaterial({\n            color: meshColor, //0x1C394C 0x004444  0x00B2DF\n            side: THREE.DoubleSide,// THREE.FrontSide // THREE.BackSide // THREE.DoubleSide,\n        });\n\n        var shape = new THREE.Shape(vector2Arr);\n        var geometry = new THREE.ExtrudeBufferGeometry(\n            shape,\n            {\n                depth: meshHeight,  // \u62c9\u4f38\n                bevelEnabled: false\n            }\n        );\n        var mesh = new THREE.Mesh(geometry, material);\n        return mesh;\n    }\n\n    function createShapePlaneMesh(vector2Arr, meshHeight, meshColor, isAllowedChangeColor) {\n        var material = new THREE.MeshPhysicalMaterial({\n            color: meshColor, //0x1C394C 0x004444  0x00B2DF 0x0C2437\n            side: THREE.DoubleSide,// THREE.FrontSide // THREE.BackSide // THREE.DoubleSide,\n        });\n        var shape = new THREE.Shape(vector2Arr);\n        // \u521b\u5efa\u51e0\u4f55\u4f53\n        var geometry = new THREE.ShapeGeometry(shape);\n        // \u521b\u5efa\u7f51\u683c\n        var mesh = new THREE.Mesh(geometry, material);\n        mesh.position.z += meshHeight;\n        mesh.isAllowedChangeColor = isAllowedChangeColor;\n        return mesh;\n    }\n\n    function createWallMaterial(isShowAni) {\n        var wallMaterial = new THREE.MeshBasicMaterial({\n            color: provinceWallColor,\n            side: isShowAni ? THREE.FrontSide : THREE.BackSide,  // THREE.Front DoubleSide\n        });\n\n        if (isShowAni) {\n            wallMaterial.onBeforeCompile = function (shader) {\n                wallMaterialShader = shader;\n\n                shader.uniforms.wallHeight = {value: mapExtrudeHeight};\n                shader.uniforms.wallAniStartPoint = {value: wallAniStartPoint};\n                shader.uniforms.wallColor = {value: new THREE.Color(provinceWallColor)};\n                shader.uniforms.wallHighLightColor = {value: new THREE.Color(wallHighLightColor)};\n\n                shader.vertexShader = shader.vertexShader.replace(\n                    'void main() {',\n                    ['varying vec3 vPos;',\n                        'void main() {',\n                        'vPos = position;',\n                    ].join('\\n')\n                )\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'void main() {',\n                    ['uniform float wallHeight;',\n                        'uniform float wallAniStartPoint;',\n                        'uniform vec3 wallColor;',\n                        'uniform vec3 wallHighLightColor;',\n                        'varying vec3 vPos;',\n                        'void main() {',\n                    ].join('\\n')\n                )\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                    wall_output_fragment\n                )\n            }\n        }\n        return wallMaterial;\n    }\n\n    // \u6ca1\u6709\u52a8\u753b\u7684\u6750\u8d28\n    var wallNotAniMaterial = createWallMaterial(false);\n    // \u6709\u52a8\u753b\u7684\u6750\u8d28\n    var wallAniMaterial = createWallMaterial(true);\n\n    // c\u662f\u4e8c\u7ef4\u5411\u91cf\u6570\u7ec4\uff0ch\u662f\u62c9\u4f38\u9ad8\u5ea6\uff0ctextureFileName\u662f\u7eb9\u7406\u56fe\u7247\u540d\u79f0\uff0ccolor1\u662f\u989c\u8272\uff0copacity1\u662f\u900f\u660e\u5ea6\n    function createWallMesh(c, h, textureFileName, color1, opacity1, isShowAni) {\n        // \u521b\u5efa\u51e0\u4f55\u4f53\n        const geometry1 = new THREE.BufferGeometry();\n        var posArr = [];\n        var uvArr = [];\n        for (var i = 0; i < c.length - 1; i++) {\n            posArr.push(c[i].x, c[i].y, 0, c[i + 1].x, c[i + 1].y, 0, c[i + 1].x, c[i + 1].y, h);\n            // \u7b2c\u4e8c\u4e2a\u9762\uff0c\u5de6\u4e0b\u89d2 \u53f3\u4e0a\u89d2 \u5de6\u4e0a\u89d2\n            posArr.push(c[i].x, c[i].y, 0, c[i + 1].x, c[i + 1].y, h, c[i].x, c[i].y, h);\n            // \u6307\u5b9a\u5bf9\u5e94UV\u5750\u6807 2\u4e2a\u4e00\u7ec4\n            uvArr.push(0, 0, 1, 0, 1, 1);\n            uvArr.push(0, 0, 1, 1, 0, 1);\n        }\n\n        //\u8bbe\u7f6e\u513f\u4f55\u4f53attributes\u5c5e\u6027\u7684\u4f4d\u7f6eposition\u5a32\u6027\n        geometry1.attributes.position = new THREE.BufferAttribute(new Float32Array(posArr), 3);\n        geometry1.attributes.uv = new THREE.BufferAttribute(new Float32Array(uvArr), 2);\n        geometry1.computeVertexNormals();\n        const mesh = new THREE.Mesh(geometry1, isShowAni ? wallAniMaterial : wallNotAniMaterial);\n\n        return mesh;\n    }\n\n    function createCityLabel(p, height, meshHeight, cityName, cityPinyin, peopleCount, order) {\n        var div = document.createElement('div');\n        div.innerHTML = '<div class=\"label-div\"><div class=\"count-div\"><span class=\"count-left\">' + peopleCount + '</span><span class=\"count-right\">\u4e07\u4eba</span></div><div class=\"city-div\"><div class=\"city-name\">' + cityName + '</div><div class=\"city-py\">' + cityPinyin + '</div></div><div class=\"number-div fluorescent-number\">' + order + '</div></div>'; // \u5e7f\u4e1c\u7701\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n\n\n        var label = new CSS3DObject(div);\n        label.scale.set(0.006, 0.006, 0.006);\n        label.position.set(p[0], p[1], height + meshHeight + 0.3);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createProvinceNameLabel(p) {\n        var div = document.createElement('div');\n        div.innerHTML = '\u5e7f\u4e1c\u7701'; //\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n        div.style.padding = '1px 0.5px';\n        div.style.color = '#ffffff';\n        div.style.fontSize = '5px';\n        div.style.textAlign = 'center';\n        div.style.position = 'absolute';\n        div.style.backgroundColor = 'rgba(25, 25, 25, 0.4)';\n        div.style.borderRadius = '3px';\n\n        var label = new CSS3DObject(div);\n        label.scale.set(0.05, 0.05, 0.05);\n        label.position.set(p[0], p[1] - 2.4, 0.1);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createPlane() {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.5, 0.5);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            map: textureLoader.load('image/\u5e7f\u4e1c.png'),\n            side: THREE.DoubleSide,\n            transparent: true,\n        });\n        var planeMesh = new THREE.Mesh(plane, planeMaterial);\n        return planeMesh;\n    }\n\n    // rangeSize\u8303\u56f4 divisions\u5706\u70b9\u4e2a\u6570\n    function addGround(rangeSize, divisions, gridColor, R, RColor) {\n        var group = new THREE.Group();\n        var interval = rangeSize / divisions;\n        var range1 = rangeSize / 2;\n        var geoArr = [];\n        for (var i = 0; i < divisions; i++) {\n            for (var j = 0; j < divisions; j++) {\n                var geometry = new THREE.CircleBufferGeometry(R, 20, 20);\n                geometry.rotateX(Math.PI / 2);\n                geometry.translate(-range1 + i * interval, 0.05, -range1 + j * interval);\n                geoArr.push(geometry);\n            }\n        }\n        var bufferGeo = THREE.BufferGeometryUtils.mergeBufferGeometries(geoArr);\n\n        var material = new THREE.MeshBasicMaterial({\n            color: gridColor,\n            side: THREE.DoubleSide,\n            transparent: true,\n            opacity: 0.3,\n            // depthTest: false,\n            // depthWrite: false\n        });\n        var mesh = new THREE.Mesh(bufferGeo, material);\n        mesh.position.y -= 0.1;\n        // mesh.renderOrder = 4;\n        group.add(mesh);\n        group.rotateX(Math.PI / 2);\n\n        return group;\n    }\n\n    function addGroundImageMesh1(imageFile, width, height) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(width, height);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            color: groundImageColor,\n            map: textureLoader.load(imageFile),\n            side: THREE.FrontSide,\n            transparent: true,\n            opacity: 0.3,\n            // depthTest: false,\n        });\n        var goundImageMesh = new THREE.Mesh(plane, planeMaterial);\n        return goundImageMesh;\n    }\n\n    // germetry\u88ab\u4fee\u6539\u7684\u51e0\u4f55\u4f53\uff0cpointCount\u662fline\u4e0a\u6240\u6709\u70b9\u7684\u6570\u91cf\uff0caniPointCount\u53c2\u4e0e\u52a8\u753b\u70b9\u7684\u6570\u91cf\uff0c index1 index2\u662f\u4e24\u6bb5\u52a8\u753b\u5f00\u59cb\u7684\u8d77\u59cb\u70b9\n    function setProvinceLineAniColor(geometry, pointCount, aniPointCount, index1, index2) {\n        var color1 = new THREE.Color(provinceLineHighLightColor); // provinceLineHighLightColor 0x99ffff\n        var color2 = new THREE.Color(provinceLineColor);\n\n        // begin\u7684\u4f4d\u7f6e\u5927\u4e8eindex\u4f4d\u7f6e\n        var begin1 = index1 + aniPointCount;\n        if (begin1 > pointCount)\n            begin1 -= pointCount;\n\n        var begin2 = index2 + aniPointCount;\n        if (begin2 > pointCount)\n            begin2 -= pointCount;\n        // console.log('end', end1, end2);\n\n        var colorArr = [];\n        for (var i = 0; i < pointCount; i++) {\n            var color = color2;\n            // \u5f53\u524d\u70b9\u662f\u5426\u5728\u52a8\u753b\u4e2d\uff0cindex:-1\u662f\u4e0d\u5728\u52a8\u753b\u533a\u57df\u4e2d\uff0c>0\u8868\u793a\u5728\u52a8\u753b\u4e2d\u7684\u7b2c\u51e0\u4e2a\u70b9\n            var index = -1;\n\n            // \u7b2c\u4e00\u6bb5\u52a8\u753b\u8bbe\u7f6e\n            if (begin1 > index1) { // \u7b2c\u4e00\u6bb5\u52a8\u753b\u6b63\u5e38\u987a\u5e8f\n                if (i <= begin1 && i >= index1) {\n                    index = begin1 - i;\n                }\n            } else { // \u7b2c\u4e00\u6bb5\u52a8\u753b\u8d85\u8fc7\u7ed3\u5c3e\u5904\n                if (i >= 0 && i <= begin1) {\n                    index = begin1 - i;\n                } else if (i >= index1 && i < pointCount) {\n                    index = begin1 + (pointCount - i);\n                }\n            }\n\n            // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u8bbe\u7f6e\n            if (begin2 > index2) { // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u6b63\u5e38\u987a\u5e8f\n                if (i <= begin2 && i >= index2) {\n                    index = begin2 - i;\n                    // console.log('index 2', begin2, i, index);\n                }\n            } else { // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u8d85\u8fc7\u7ed3\u5c3e\u5904\n                if (i >= 0 && i <= begin2) {\n                    index = begin2 - i;\n                } else if (i >= index2 && i < pointCount) {\n                    index = begin2 + (pointCount - i);\n                }\n            }\n\n            if (-1 != index) {\n                color = color1.clone().lerp(color2, index / aniPointCount);\n            }\n            colorArr.push(color.r, color.g, color.b);\n        }\n\n        geometry.attributes.color = new THREE.BufferAttribute(new Float32Array(colorArr), 3);\n    }\n\n    function createFlyLine(p1, p2, meshHeight) {\n        var p_1 = new THREE.Vector3(p1[0], p1[1], meshHeight);  // mapExtrudeHeight\n        var p_2 = new THREE.Vector3(p2[0], p2[1], meshHeight);\n        var midPoint = new THREE.Vector3();\n        midPoint.addVectors(p_1, p_2).divideScalar(2);\n        midPoint.z = 1.2;\n        var curve = new THREE.QuadraticBezierCurve3(p_1, midPoint, p_2);\n\n        var vectorDifference = new THREE.Vector3().subVectors(p_1, p_2);\n        // \u83b7\u53d6\u5411\u91cf\u7684\u957f\u5ea6\uff0c\u5373\u4e24\u70b9\u4e4b\u95f4\u7684\u8ddd\u79bb\n        var distance = vectorDifference.length();\n        var pointCount = Math.ceil(distance * 600); // \u5411\u4e0a\u53d6\u6574 \u901a\u8fc7\u8ddd\u79bb\u6765\u786e\u5b9a\u70b9\u7684\u6570\u91cf\n        var points = curve.getPoints(pointCount); // getSpacedPoints\n        var geometry = new THREE.BufferGeometry();\n        geometry.setFromPoints(points);\n        const indexs = [];\n        for (let i = 0; i < geometry.attributes.position.count; i++) {\n            indexs.push(i * 1.0);\n        }\n\n        const indexsAttribute = new THREE.BufferAttribute(new Float32Array(indexs), 1);\n        geometry.attributes.pointIndex = indexsAttribute;\n        var material = new THREE.PointsMaterial({\n            // side: THREE.FrontSide,\n            color: 0x00ffff,  // 0x0088ff\n            // linewidth: 0.0025,\n            // linewidth: 0.02,\n            transparent: true,\n            // opacity: 0.25,\n            size: 0.1,\n            depthWrite: false,\n            depthTest: false, // \u9700\u8981\u5199\n        });\n        if (true) {\n            material.onBeforeCompile = function (shader) {\n                flyLineShaderArr.push(shader);\n\n                shader.uniforms.meshHeight = {value: meshHeight};\n                shader.uniforms.flyLineColor1 = {value: flyLineColor1};\n                shader.uniforms.flyLineColor2 = {value: flyLineColor2};\n                shader.uniforms.pointCount = {value: indexs.length / 1.0};\n                shader.uniforms.cityDistance = {value: distance};\n                shader.uniforms.currflyLineHighLightIndex = {value: currflyLineHighLightIndex};\n                shader.vertexShader = shader.vertexShader.replace(\n                    'void main() {',\n                    ['attribute float pointIndex;',\n                        'varying vec3 vPos;',\n                        'varying float vPointIndex;',\n                        'void main() {',\n                        'vPos = position;',\n                        'vPointIndex = pointIndex;',\n                    ].join('\\n')\n                );\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'void main() {',\n                    ['uniform float meshHeight;',\n                        'uniform vec3 flyLineColor1;',\n                        'uniform vec3 flyLineColor2;',\n                        'uniform float pointCount;',\n                        'uniform float cityDistance;',\n                        'uniform float currflyLineHighLightIndex;',\n                        'varying vec3 vPos;',\n                        'varying float vPointIndex;',\n                        'void main() {',\n                    ].join('\\n')\n                )\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                    flyLine_output_fragment\n                )\n            }\n        }\n\n        var line = new THREE.Points(geometry, material);\n        line.renderOrder = renderOrderFlyLine;\n        return line;\n    }\n\n    // \u98de\u7ebf\u8d77\u70b9\u4e0b\u9762\u7684\u8f6c\u76d8 p\u662f\u5750\u6807 meshHeight\u6a21\u578b\u9ad8\u5ea6\uff0cimageFile\u56fe\u7247\u6587\u4ef6\n    function createFlyLinePlane(p, width, height, meshHeight, imageFile) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.2, 0.2);  // width, height\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            map: textureLoader.load(imageFile),\n            side: THREE.DoubleSide,\n            transparent: true,\n            opacity: 1,\n        });\n\n        var flyLinePlane = new THREE.Mesh(plane, planeMaterial);\n\n        // flyLinePlane.rotateX(Math.PI / 2);\n        flyLinePlane.position.set(p[0], p[1], meshHeight + 0.02);\n        flyLinePlane.renderOrder = renderOrderFlyLinePlane;\n        return flyLinePlane;\n    }\n\n    function createPillar(p, r, height, meshHeight) {\n        var geometry = new THREE.CylinderGeometry(r, r, height, 32); // \u53c2\u6570\uff1a\u534a\u5f84\u9876\u90e8, \u534a\u5f84\u5e95\u90e8, \u9ad8\u5ea6, \u5206\u6bb5\u6570\n        var material = new THREE.MeshPhysicalMaterial({\n            vertexColors: THREE.VertexColors,\n            transparent: true,\n            opacity: 0.65,\n        });\n\n        var color1 = new THREE.Color(0x33ffff);\n        var color2 = new THREE.Color(0x66FFFF);\n        // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n        const colors = [];\n        const vertexCount = geometry.attributes.position.count;\n        for (let i = 0; i < vertexCount; i++) {\n            let y = geometry.attributes.position.array[i * 3 + 1];\n            var color = color1.clone().lerp(color2, (y + height / 2) / height);\n            colors.push(color.r, color.g, color.b);\n        }\n        const colorAttribute = new THREE.BufferAttribute(new Float32Array(colors), 3);\n        geometry.setAttribute('color', colorAttribute);\n\n        var cylinder = new THREE.Mesh(geometry, material); // \u521b\u5efa\u7f51\u683c\u5bf9\u8c61\n        cylinder.rotateX(Math.PI / 2);\n        cylinder.position.set(p[0], p[1], meshHeight + height / 2 + 0.02);  //\n        cylinder.renderOrder = renderOrderPillar;\n        return cylinder;\n    }\n\n    // p\u5706\u5fc3\u5750\u6807 circleColor\u989c\u8272\uff0cinitRadius\u8d77\u59cb\u534a\u5f84\uff0ccircleWidth\u5706\u5708\u5bbd\u5ea6\n    function createAniPlane(p, meshHeight, circleColor, initRadius, circleWidth, shaderObj) {\n        var plane = new THREE.PlaneGeometry(50, 50);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            color: circleColor, // 0x185889,\n            side: THREE.FrontSide,\n            transparent: true,\n            opacity: 0.05,\n            // depthWrite: false,\n            // depthTest: false,\n        });\n\n        planeMaterial.onBeforeCompile = function (shader) {\n            shaderObj.value = shader;\n\n            // \u5f53\u524d\u6700\u65b0\u534a\u5f84\u503c\n            shader.uniforms.currR = {value: initRadius};  // initAniPlaneRadius\n            shader.uniforms.circleWidth = {value: circleWidth};  // 5.0\n            shader.uniforms.outOpacity = {value: 1.0};  // \u5916\u90e8\u589e\u52a0\u4e00\u4e2a\u900f\u660e\u5ea6\n\n            shader.vertexShader = shader.vertexShader.replace(\n                'void main() {',\n                ['varying vec3 vPos;',\n                    'void main() {',\n                    'vPos = position;',\n                ].join('\\n')\n            )\n            // console.log('vertexShader: ', shader.vertexShader);\n\n            shader.fragmentShader = shader.fragmentShader.replace(\n                'void main() {',\n                ['uniform float currR;',\n                    'uniform float circleWidth;',\n                    'uniform float outOpacity;',\n                    'varying vec3 vPos;',\n                    'void main() {',\n                ].join('\\n')\n            )\n\n            shader.fragmentShader = shader.fragmentShader.replace(\n                'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                aniGroundCirclePlane_output_fragment\n            )\n        }\n\n        var planeMesh = new THREE.Mesh(plane, planeMaterial);\n        planeMesh.position.set(p[0], p[1], meshHeight);\n        return planeMesh;\n    }\n\n    function createMirror() {\n\n    }\n</script>\n</body>\n\n</html>");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        String resourceDataPath = jsResourcePath.substring(0, jsResourcePath.length() - 7) + File.separator + "pluginResource";
        String htmlString = Map_GuangDong_Three.generateDefaultOption();
        htmlString = htmlString.replaceAll("##plugin", jsResourcePath);
        htmlString = htmlString.replaceAll("##pluginResource", resourceDataPath);
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(htmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String showLabel = optionObject.getString("showLabel");
        String area = optionObject.getString("area");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legend = legendArray.getJSONObject(0);
        JSONArray legendData = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            legendData.add((Object)seriesDatas[i]);
        }
        legend.put("data", (Object)legendData);
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            if (optionObject.containsKey((Object)"isParam")) {
                String are = optionObject.getString("paramValue");
                seriesObject.put("mapType", (Object)are);
                seriesObject.put("area", (Object)are);
                area = are;
            } else {
                seriesObject.put("mapType", (Object)area);
            }
            seriesObject.put("type", (Object)"map");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null && showLabel.equals("true")) {
                JSONObject showLabelObj = new JSONObject();
                showLabelObj.put("show", (Object)true);
                showLabelObj.put("formatter", (Object)labelFormatter);
                seriesObject.put("label", (Object)showLabelObj);
            }
            if (optionObject.containsKey((Object)"map-top")) {
                String top = optionObject.getString("map-top");
                seriesObject.put("top", (Object)top);
            }
            if (optionObject.containsKey((Object)"map-bottom")) {
                String bottom = optionObject.getString("map-bottom");
                seriesObject.put("bottom", (Object)bottom);
            }
            if (optionObject.containsKey((Object)"map-left")) {
                String left = optionObject.getString("map-left");
                seriesObject.put("left", (Object)left);
            }
            if (optionObject.containsKey((Object)"map-right")) {
                String right = optionObject.getString("map-right");
                seriesObject.put("right", (Object)right);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONObject dataObject = new JSONObject();
                String cData = categoryDatas[j];
                if ("china".equals(area)) {
                    if (cData.endsWith("\u7701")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u76f4\u8f96\u5e02")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u5e02")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u56de\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u58ee\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 6);
                    } else if (cData.endsWith("\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    }
                }
                dataObject.put("name", (Object)cData);
                dataObject.put("value", (Object)valueDatas[i + j * seriesDatas.length]);
                seriesDataArray.add((Object)dataObject);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/china.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/anhui.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/aomen.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/beijing.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/chongqing.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/fujian.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/gansu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guangdong.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guangxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guizhou.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hainan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hebei.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/heilongjiang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/henan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hubei.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hunan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jiangsu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jiangxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jilin.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/liaoning.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/neimenggu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/ningxia.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/qinghai.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shandong.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanghai.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanxi1.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/sichuan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/tianjin.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/taiwan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xianggang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xinjiang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xizang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/yunnan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/zhejiang.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u5e7f\u4e1c\u7701\u98de\u7ebf\u56fe";
    }

    public static String getClassName() {
        return "Map_GuangDong_Three";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        return optionJson.toString();
    }
}

