/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import sun.misc.BASE64Encoder;

public class OCEANBASE {
    public Class clz;
    public Object instance;
    public Connection connection = null;
    public ResultSet rs;
    public PreparedStatement ps;
    public JSONObject connObject = new JSONObject();
    public String connFileName;
    public int indexNum = -1;
    public long lastUpdateTime = 0L;
    public String connUrl;
    public String connUserName;
    public String connPass;
    public long lastConnectTime = 0L;

    public boolean setConnFileName(String fileName) {
        try {
            String str;
            this.connFileName = fileName;
            File jsonFile = new File(fileName);
            this.lastUpdateTime = jsonFile.lastModified();
            FileInputStream fis = new FileInputStream(jsonFile);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            String jsonText = sb.toString();
            JSONArray jsonArray = JSONArray.parseArray((String)jsonText);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String name = object.getString("name");
                this.connObject.put(name, (Object)object);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setConnObject(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            String name = object.getString("name");
            this.connObject.put(name, (Object)object);
        }
    }

    public boolean forClassWithFirst(String path) {
        try {
            String str;
            File jsonFile = new File(path);
            FileInputStream fis = new FileInputStream(jsonFile);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            String jsonText = sb.toString();
            JSONArray jsonArray = JSONArray.parseArray((String)jsonText);
            JSONObject object = jsonArray.getJSONObject(0);
            String type = object.getString("type");
            if ("SQLITE".equals(type)) {
                Class.forName("org.sqlite.JDBC");
            } else if ("ORACLE".equals(type)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if ("MYSQL".equals(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if ("SQL SERVER".equals(type)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if ("POSTGRESQL".equals(type)) {
                Class.forName("org.postgresql.Driver");
            } else if ("ODBC".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("EXCEL".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("ACCESS".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("SAP".equals(type)) {
                Class.forName("com.sap.db.jdbc.Driver");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean connect(String connName, String url) {
        JSONObject object = this.connObject.getJSONObject(connName);
        String username = object.getString("username");
        String password = object.getString("password");
        String type = object.getString("type");
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            this.connection = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean connect(String url, String username, String password) {
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            this.connection = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getTableName(String type, String url, String username, String password, int page, int pageSize, String keyword) {
        JSONObject res = new JSONObject();
        JSONArray tables = new JSONArray();
        String sql = "SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema=(select database()) AND table_type='BASE TABLE'";
        System.out.println("sql:" + sql);
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            Connection connection = DriverManager.getConnection(url, username, password);
            PreparedStatement ps = connection.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (keyword != null) {
                    if (!tableName.contains(keyword)) continue;
                    tables.add((Object)tableName);
                    continue;
                }
                tables.add((Object)tableName);
            }
            rs.close();
            ps.close();
            connection.close();
            JSONArray pageArray = new JSONArray();
            int start = pageSize * (page - 1);
            int end = pageSize * page;
            for (int i = start; i < end; ++i) {
                if (i >= tables.size()) continue;
                String tableName = tables.getString(i);
                pageArray.add((Object)tableName);
            }
            res.put("total", (Object)tables.size());
            res.put("page", (Object)pageArray);
            return res.toJSONString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject getResultsByPage(String connName, String sql, int count) {
        JSONObject object = this.connObject.getJSONObject(connName);
        String type = object.getString("type");
        JSONObject res = new JSONObject();
        ArrayList list = new ArrayList();
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            int total = 0;
            String totalSql = "select count(*) from (" + sql + ") A";
            PreparedStatement ps1 = this.connection.prepareStatement(totalSql);
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                total = rs1.getInt(1);
            }
            res.put("total", (Object)total);
            this.ps = this.connection.prepareStatement(sql);
            this.rs = this.ps.executeQuery();
            ResultSetMetaData metaData = this.rs.getMetaData();
            while (this.rs.next() && count > 0) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                int cols_len = metaData.getColumnCount();
                for (int i = 0; i < cols_len; ++i) {
                    Object col_value;
                    String col_name = metaData.getColumnLabel(i + 1);
                    if (col_name == null) {
                        col_name = metaData.getColumnName(i + 1);
                    }
                    col_value = (col_value = this.rs.getObject(i + 1)) == null ? "" : col_value.toString();
                    map.put(col_name, col_value);
                }
                list.add(map);
                --count;
            }
            res.put("list", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public static boolean testConnection(String type, String url, String username, String password) {
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            Connection connection = DriverManager.getConnection(url, username, password);
            connection.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getFieldNames(String sqlStr) {
        JSONArray names = new JSONArray();
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            PreparedStatement ps = this.connection.prepareStatement(sqlStr);
            this.rs = ps.executeQuery();
            ResultSetMetaData data = this.rs.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                String columnName = data.getColumnLabel(i);
                names.add((Object)columnName);
            }
        }
        catch (Exception e) {
            return null;
        }
        return names.toString();
    }

    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFieldTypeByIndex(int index) {
        try {
            int retType;
            ResultSetMetaData data = this.rs.getMetaData();
            int columnType = data.getColumnType(index);
            if (columnType == 1 || columnType == 12 || columnType == -1 || columnType == -15) {
                retType = 1;
            } else if (columnType == -7 || columnType == -6 || columnType == 5 || columnType == 4) {
                retType = 2;
            } else if (columnType == 8 || columnType == 6 || columnType == 7) {
                retType = 3;
            } else if (columnType == 91 || columnType == -15 || columnType == -16) {
                retType = 4;
            } else if (columnType == 92 || columnType == 93) {
                retType = 5;
            } else if (columnType == 16) {
                retType = 6;
            } else if (columnType == -4) {
                retType = 7;
            } else if (columnType == 3 || columnType == 2) {
                retType = 9;
            } else if (columnType == -5) {
                retType = 8;
            } else if (columnType == -9) {
                retType = 10;
            } else {
                if (columnType == 2005) {
                    return 11;
                }
                retType = 1;
            }
            return retType;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getFieldNameByIndex(int index) {
        try {
            ResultSetMetaData data = this.rs.getMetaData();
            String columnType = data.getColumnLabel(index);
            return columnType;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getValueByIndex(int index, int type) {
        try {
            if (type == 1) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 2) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 3) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 4) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                if (timestamp == null) {
                    return "";
                }
                long time = timestamp.getTime();
                return String.valueOf(time);
            }
            if (type == 5) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                if (timestamp == null) {
                    return "";
                }
                long time = timestamp.getTime();
                return String.valueOf(time);
            }
            if (type == 6) {
                return this.rs.getString(index) == null ? "" : this.rs.getString(index);
            }
            if (type == 7) {
                Blob blob = this.rs.getBlob(index);
                InputStream msgContent = blob.getBinaryStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[100];
                int n = 0;
                while (-1 != (n = msgContent.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                return new BASE64Encoder().encode(output.toByteArray());
            }
            if (type == 8) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 9) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getIsNullByIndex(int index, int type) {
        try {
            if (type == 1) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 2) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 3) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 4) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                return timestamp == null;
            }
            if (type == 5) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                return timestamp == null;
            }
            if (type == 6) {
                return this.rs.getString(index) == null;
            }
            if (type == 7) {
                Blob blob = this.rs.getBlob(index);
                return blob == null;
            }
            if (type == 8) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 9) {
                String value = this.rs.getString(index);
                return value == null;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public int getIntValueByIndex(int index) {
        try {
            return this.rs.getInt(index);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getLongValueByIndex(int index) {
        try {
            return this.rs.getLong(index);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public double getDoubleValueByIndex(int index) {
        try {
            return this.rs.getDouble(index);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getStringValueByIndex(int index) {
        try {
            return this.rs.getString(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getBytesValueByIndex(int index) {
        try {
            return this.rs.getBytes(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getBooleanValueByIndex(int index) {
        try {
            return this.rs.getBoolean(index);
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getDateValueByIndex(int index) {
        try {
            Date date = this.rs.getDate(index);
            return date == null ? 0L : date.getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getDateTimeValueByIndex(int index) {
        try {
            Timestamp time = this.rs.getTimestamp(index);
            return time == null ? 0L : time.getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public byte[] getBlobValueByIndex(int index) {
        try {
            Blob blob = this.rs.getBlob(index);
            BufferedInputStream is = new BufferedInputStream(blob.getBinaryStream());
            byte[] bytes = new byte[(int)blob.length()];
            int len = bytes.length;
            int read = 0;
            for (int offset = 0; offset < len && (read = ((InputStream)is).read(bytes, offset, len - offset)) >= 0; offset += read) {
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getClobValueByIndex(int index) {
        try {
            int bytesRead;
            Clob clob = this.rs.getClob(index);
            Reader reader = clob.getCharacterStream();
            BufferedReader br = new BufferedReader(reader);
            StringBuilder stringBuilder = new StringBuilder();
            char[] buffer = new char[1024];
            while ((bytesRead = br.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, bytesRead);
            }
            return stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean open(String sql, int fetchSize) {
        try {
            this.ps = this.connection.prepareStatement(sql);
            this.ps.setFetchSize(fetchSize);
            this.rs = this.ps.executeQuery();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("close", new Class[0]);
                boolean flag = (Boolean)method.invoke(this.instance, new Object[0]);
                return flag;
            }
            this.rs.close();
            this.ps.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFieldCount() {
        try {
            ResultSetMetaData data = this.rs.getMetaData();
            return data.getColumnCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getConnURL(String connName) {
        try {
            JSONObject object = this.connObject.getJSONObject(connName);
            String url = object.getString("url");
            if (url.contains("sqlite")) {
                Class.forName("org.sqlite.JDBC");
            } else if (url.contains("postgresql")) {
                Class.forName("org.postgresql.Driver");
            } else if (url.contains("oracle")) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if (url.contains("mysql")) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if (url.contains("sqlserver")) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if (url.contains("odbc")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if (url.contains("Excel")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if (url.contains("Access")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if (url.contains("db2")) {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
            } else if (url.contains("informix")) {
                Class.forName("com.informix.jdbc.IfxDriver");
            } else if (url.contains("hive")) {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
            } else if (url.contains("sap")) {
                Class.forName("com.sap.db.jdbc.Driver");
            } else if (url.contains("ignite")) {
                Class.forName("org.apache.ignite.IgniteJdbcDriver");
            } else if (url.contains("oceanbase")) {
                Class.forName("com.oceanbase.jdbc.Driver");
            }
            if (this.connObject == null || object == null) {
                return null;
            }
            return object.getString("url");
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getIntTest() {
        return 6;
    }

    public String getStringTest() {
        return "\u76c8\u5e06\u6570\u636eABC122!@#";
    }

    public boolean disConnect() {
        this.indexNum = -1;
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("disConnect", new Class[0]);
                boolean flag = (Boolean)method.invoke(this.instance, new Object[0]);
                this.instance = null;
                return flag;
            }
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.ps != null) {
                this.rs.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public boolean isCacheObject() {
        return this.connection != null;
    }

    public static void main(String[] args) throws Exception {
        long cur = System.nanoTime();
        OCEANBASE db = new OCEANBASE();
        for (int i = 0; i < 10000000; ++i) {
            db.getIntTest();
        }
        long end = System.nanoTime();
        System.out.println(end - cur);
        long cur1 = System.nanoTime();
        for (int i = 0; i < 10000000; ++i) {
            db.getStringTest();
        }
        long end1 = System.nanoTime();
        System.out.println(end1 - cur1);
    }
}

