/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Map_HuNan_3D_ZQ {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Map_HuNan_3D_ZQ.generateDefaultOption();
            String clazzName = Map_HuNan_3D_ZQ.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String resourceDataPath = websiteName + File.separator + "pluginResource";
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", new JSONObject().toString());
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                String htmlString = option.replaceAll("##plugin", websiteName);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(htmlString);
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", new JSONObject().toString());
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Map_HuNan_3D_ZQ.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>\n<html>\n\n<head>\n    <meta charset=utf-8>\n    <title>\u5730\u56fe\u7279\u6548</title>\n    <style>\n        body {\n            margin: 0;\n        }\n\n        canvas {\n            width: 100%;\n            height: 100%;\n            display: block;\n        }\n    </style>\n    <link href=\"##plugin/pluginResource/data/three/hunan3DMap/css/labelStyles.css\" rel=\"stylesheet\">\n</head>\n\n<body>\n<script src=\"##plugin/plugin/jquery-1.11.3.min.js\"></script>\n<script src=\"##plugin/plugin/build/three.js\"></script>\n<script src=\"##plugin/plugin/three/js/controls/OrbitControls.js\"></script>\n<script src=\"##plugin/plugin/three/js/loaders/OBJLoader.js\"></script>\n<script src=\"##plugin/plugin/three/js/loaders/MTLLoader.js\"></script>\n<script src=\"##plugin/plugin/three/js/utils/BufferGeometryUtils.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/EffectComposer.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/RenderPass.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/UnrealBloomPass.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/ShaderPass.js\"></script>\n<script src=\"##plugin/plugin/three/js/shaders/LuminosityHighPassShader.js\"></script>\n<script src=\"##plugin/plugin/three/js/shaders/CopyShader.js\"></script>\n<script src=\"##plugin/plugin/three/js/objects/Reflector.js\"></script>\n<script src=\"##plugin/plugin/three/js/shaders/WaterRefractionShader.js\"></script>\n<script type='module'>\n    import {LineSegmentsGeometry} from '##plugin/plugin/three/jsm/lines/LineSegmentsGeometry.js';\n    import {LineGeometry} from '##plugin/plugin/three/jsm/lines/LineGeometry.js';\n    import {Line2} from '##plugin/plugin/three/jsm/lines/Line2.js';\n    import {LineMaterial} from '##plugin/plugin/three/jsm/lines/LineMaterial.js';\n    import {\n        CSS3DRenderer,\n        CSS3DObject\n    } from '##plugin/plugin/three/jsm/renderers/CSS3DRenderer.js';\n    import {Reflector} from '##plugin/plugin/three/jsm/objects/Reflector.js';\n    import {ReflectorRTT} from '##plugin/plugin/three/jsm/objects/ReflectorRTT.js';\n    import wall_output_fragment from '##plugin/plugin/three/js/wall_output_fragment.glsl.js'\n    import flyLine_output_fragment from '##plugin/plugin/three/js/flyLine_output_fragment.glsl.js'\n    import flyLine_output_vertex from '##plugin/plugin/three/js/flyLine_output_vertex.glsl.js'\n    import aniGroundCirclePlane_output_fragment\n        from '##plugin/plugin/three/js/aniGroundCirclePlane_output_fragment.glsl.js'\n    var scene = new THREE.Scene();\n    // \u7701\u4e2d\u5fc3\u5750\u6807\n    var provinceCenter = {x: 111.82393493652344, y: 27.06424446105957};\n    // \u662f\u5426\u663e\u793a\u6240\u6709\u7701\u8f6e\u5ed3\u7ebf\n    var isShowAllProvinceLine = true;\n    // \u5927\u5730\u5706\u5708\u53d1\u6563\u52a8\u753b\u901f\u5ea6\n    var groundCircleAniSpeed = 10;\n    var isFinishLoadJson1 = false;  // \u6e56\u5357\u7701\u5e02json\n    var isFinishLoadJson2 = false;  // \u6e56\u5357\u7701json\n    // \u6a21\u578b\u6e32\u67d3\u987a\u5e8f\n    const renderOrderNoTransparent = 0;\n    const renderOrderGroundPlane = 100;\n    const renderOrderFlyLinePlane = 110;\n    const renderOrderPillar = 120;\n    const renderOrderFlyLine = 130;\n    var imageUrl = '##plugin/pluginResource/data/three/hunan3DMap/image/'\n    var mapExtrudeHeight = 0.3;\n    var mapPlaneOpacity = 0.76;\n    // var flyHeight = 0.6;\n    var flyLine = null;\n    var flyLineShaderArr = [];\n    var flyLineColor1 = new THREE.Color(0.3, 1.0, 1.0); // \n    var flyLineColor2 = new THREE.Color(0.0, 0.75, 0.9); // \n    var currflyLineHighLightIndex = 0.0;\n    var flyLinePlaneArr = [];\n    var groundImageColor = 0x236191;\n    var chinaLineColor = 0x7A9DC1;  //0x7A9DC1;  //0x345F8B;\n    var chinaPlaneColor = 0x050B18; //0x004488;\n    var provinceLineColor = 0x4470B2; //0x83E1FF;// 0x83EBFF;\n    var provinceLineHighLightColor = 0xffffff;  // 0xbbffff;\n    var provincePlaneColor = 0x101b32;  //0x050725;//142362  //0x0E1741; //0x006b88;\n    var provincePlaneOpacity = 0.85;\n    var selectedColor = 0x6688DE; //0x4694D3;\n    var provinceWallColor = 0x1B3979;\n    var wallHighLightColor = 0x49A9D7;// 0x1F65AF;\n    var wallAniStartPoint = 0;  // \u968f\u7740\u65f6\u95f4\u589e\u52a0\uff0c\u8d85\u8fc7mapExtrudeHeight\u503c\u540e\uff0c\u6062\u590d\u52300\n    var wallMesh = null;\n    var wallMaterialShader = null;\n    // \u5927\u80cc\u666f\u5706\u5708\u52a8\u753b\n    var aniPlaneShader = {value: null};\n    var initAniPlaneRadius = -30;\n    var aniCityPlaneShader = {value: null};\n    var provinceLinePointCount = 2067;\n    // \u52a8\u753b\u5f00\u59cb\u70b9\u7684index\uff0c\u968f\u7740\u65f6\u95f4\u53d8\u5316\n    var provinceLineAniPointIndex1 = 0;\n    var provinceLineAniPointIndex2 = 1033;  // 2067 / 2\n    // \u53c2\u4e0e\u52a8\u753b\u6548\u679c\u70b9\u7684\u6570\u91cf\n    var provinceLineAniPointCount = 450;\n    var composer;\n    var renderer = null;\n    var line = null;\n    var pointArr = [];\n    var lineGroup = new THREE.Group();\n    var shapeGroup = new THREE.Group();\n    var areaDataObj = {\n        '\u957f\u6c99\u5e02': 1343, // \u957f\u6c99\n        '\u682a\u6d32\u5e02':22 , // \u682a\u6d32\n        '\u6e58\u6f6d\u5e02':111 , // \u682a\u6d32\n        '\u8861\u9633\u5e02':35 , // \u682a\u6d32\n        '\u90b5\u9633\u5e02':46 , // \u682a\u6d32\n        '\u5e38\u5fb7\u5e02': 77, // \u5e38\u5fb7\n        '\u5f20\u5bb6\u754c\u5e02': 85,  // \u5f20\u5bb6\u754c\n        '\u76ca\u9633\u5e02': 44,  // \u5f20\u5bb6\u754c\n        '\u6e58\u897f': 16, // \u6e58\u897f\n        '\u6000\u5316\u5e02': 98,  // \u6000\u5316\n        '\u5a04\u5e95\u5e02': 200,  // \u90b5\u9633\n        '\u5cb3\u9633\u5e02': 76,  // \u5cb3\u9633\n        '\u6c38\u5dde\u5e02': 133, // \u6c38\u5dde\n        '\u90f4\u5dde\u5e02': 45 // \u90f4\u5dde\n    };\n\n    // \u53ef\u88ab\u9009\u62e9\u7684\u9762 \u7ec4\n    var chooseMeshArrObj = {\n        '\u957f\u6c99\u5e02': [112.982279, 28.19409], // \u957f\u6c99\n        '\u682a\u6d32\u5e02':[113.451737,27.235806] , // \u682a\u6d32\n        '\u6e58\u6f6d\u5e02':[112.744052,27.62973] , // \u682a\u6d32\n        '\u8861\u9633\u5e02':[112.607693,26.700358] , // \u682a\u6d32\n        '\u90b5\u9633\u5e02':[111.06923,27.137842] , // \u682a\u6d32\n        '\u5e38\u5fb7\u5e02': [111.691347, 29.040225], // \u5e38\u5fb7\n        '\u5f20\u5bb6\u754c\u5e02': [110.479921, 29.327401],  // \u5f20\u5bb6\u754c\n        '\u76ca\u9633\u5e02': [112.355042,28.570066],  // \u5f20\u5bb6\u754c\n        '\u6e58\u897f': [109.739735, 28.714296], // \u6e58\u897f\n        '\u6000\u5316\u5e02': [109.97824, 27.550082],  // \u6000\u5316\n        '\u5a04\u5e95\u5e02': [111.808497,27.728136],  // \u90b5\u9633\n        '\u5cb3\u9633\u5e02': [113.432855, 29.17029],  // \u5cb3\u9633\n        '\u6c38\u5dde\u5e02': [111.808019, 25.634516], // \u6c38\u5dde\n        '\u90f4\u5dde\u5e02': [113.032067, 25.793589] // \u90f4\u5dde\n    };\n    var chooseMesh = null;\n    var clock = new THREE.Clock();\n    // \u80cc\u666f\u5706\u70b9\n    // var rangeSize = 2000;\n    // var divisions = 25;\n    var gridColor = 0x007090;\n    var RColor = 0x666666;\n    var ground1 = addGround(50, 150, gridColor, 0.03, RColor);\n    ground1.position.x += 110;\n    ground1.position.y += 28;\n    scene.add(ground1);\n\n    // \u80cc\u666f\u5927\u5706\u5708\n    var groundImageMesh1 = addGroundImageMesh1(imageUrl + 'circle2.png', 6.8, 6.8);\n    groundImageMesh1.position.x += provinceCenter.x;\n    groundImageMesh1.position.y += provinceCenter.y;\n    groundImageMesh1.position.z -= 0.03;\n    scene.add(groundImageMesh1);\n\n    var groundImageMesh2 = addGroundImageMesh1(imageUrl + 'circle3.png', 7.5, 7.5);\n    // groundImageMesh.rotateX(-Math.PI / 2);\n    groundImageMesh2.position.x += provinceCenter.x;\n    groundImageMesh2.position.y += provinceCenter.y;\n    groundImageMesh2.position.z -= 0.02;\n    scene.add(groundImageMesh2);\n    var loader = new THREE.FileLoader();\n    loader.setResponseType('json');\n    var jsonBase = \"##plugin/pluginResource/data/three/hunan3DMap/\";\n    if (true) { // \u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd(\u7701)\n        loader.load(isShowAllProvinceLine ? jsonBase + 'geo/\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd(\u7701).json' : jsonBase + 'geo/\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd.json', function (data) {\n            data.features.forEach(function (area) {\n                var mesh = null;\n\n                if (area.geometry.type === \"Polygon\") {\n                    // console.log('Polygon');\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        area.geometry.coordinates[0].forEach((elem) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        line = createAreaLine(pointArr, chinaLineColor);\n                        line.position.z = 0.04;\n                        lineGroup.add(line);\n\n                        mesh = createShapePlaneMesh(vector2Arr, 0.01, chinaPlaneColor, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        mesh.position.z -= 0.05;\n                        shapeGroup.add(mesh);\n                    });\n                } else if (area.geometry.type === \"MultiPolygon\") {\n                    // console.log('MultiPolygon');\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        polygon[0].forEach((elem, i) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        line = createAreaLine(pointArr, chinaLineColor);\n                        line.position.z -= 0.04;\n                        lineGroup.add(line);\n\n                        mesh = createShapePlaneMesh(vector2Arr, 0.01, chinaPlaneColor, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        mesh.position.z -= 0.05;\n                        shapeGroup.add(mesh);\n                    });\n                }\n            });\n        });  // end load\n    }\n\n    if (true) {\n        loader.load(jsonBase + 'geo/\u6e56\u5357\u7701(\u5e02).json', function (data) {\n            data.features.forEach(function (area) {\n                var mesh = null;\n\n                if (area.geometry.type === \"Polygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        area.geometry.coordinates[0].forEach((elem) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        // console.log('vector2Arr.length: ', vector2Arr.length);\n                        line = createAreaLine(pointArr, provinceLineColor);\n                        line.position.z += mapExtrudeHeight + 0.01;\n                        lineGroup.add(line);\n\n                        // \u5e95\u9762\n                        mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                        mesh.renderOrder = renderOrderGroundPlane;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        // chooseMeshArrObj[mesh.name] = mesh;\n\n                        wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                        wallMesh.renderOrder = renderOrderNoTransparent;\n                        // console.log('wallMesh: ', wallMesh);\n                        scene.add(wallMesh);\n                    });\n                } else if (area.geometry.type === \"MultiPolygon\") {\n                    // console.log('MultiPolygon');\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        polygon[0].forEach((elem, i) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        // console.log('vector2Arr.length1: ', vector2Arr.length);\n                        line = createAreaLine(pointArr, provinceLineColor);\n                        line.position.z += mapExtrudeHeight + 0.01;\n                        lineGroup.add(line);\n\n                        // \u5e95\u9762\n                        mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                        mesh.renderOrder = renderOrderNoTransparent;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n\n                        mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                        mesh.renderOrder = renderOrderGroundPlane;\n                        // mesh.material.transparent = true;\n                        // mesh.material.opacity = mapPlaneOpacity;\n                        mesh.name = area.properties.name;\n                        mesh.center = area.properties.center;\n                        mesh.centroid = area.properties.centroid;\n                        shapeGroup.add(mesh);\n                        wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                        wallMesh.renderOrder = renderOrderNoTransparent;\n                        scene.add(wallMesh);\n                    });\n                }\n            });\n\n            isFinishLoadJson1 = true;\n            loadJsonFinished();\n        });  // end load\n    }\n\n    scene.add(lineGroup);\n    scene.add(shapeGroup);\n\n    // \u7701\u8fb9\u7ebf\u5899\u52a8\u753b\u7528\n    var aniLineGeometry = null;\n    if (true) {\n        loader.load(jsonBase + 'geo/\u6e56\u5357\u7701.json', function (data) {\n            data.features.forEach(function (area) {\n                if (area.geometry.type === \"Polygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        area.geometry.coordinates[0].forEach((elem) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                    });\n                } else if (area.geometry.type === \"MultiPolygon\") {\n                    area.geometry.coordinates.forEach(polygon => {\n                        pointArr = [];\n                        var vector2Arr = [];\n                        polygon[0].forEach((elem, i) => {\n                            pointArr.push(elem[0], elem[1], 0);\n                            vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                        });\n                        // console.log('vector2Arr.length2: ', vector2Arr.length); // \u6b64\u4ee3\u7801\u53ef\u4ee5\u83b7\u53d6\u7701\u8f6e\u5ed3\u70b9\u6570\u91cf\uff0c\u8bbe\u7f6eprovinceLinePointCount\n                        if (vector2Arr.length == provinceLinePointCount) {\n                            aniLineGeometry = new THREE.BufferGeometry();\n                            var vertices = new Float32Array(pointArr);\n                            var attribute = new THREE.BufferAttribute(vertices, 3);\n                            aniLineGeometry.attributes.position = attribute;\n                            // console.log('aniLineGeometry: ', aniLineGeometry);\n                            setProvinceLineAniColor(\n                                aniLineGeometry,\n                                provinceLinePointCount,\n                                provinceLineAniPointCount,\n                                provinceLineAniPointIndex1,\n                                provinceLineAniPointIndex2\n                            )\n                            var material = new THREE.LineBasicMaterial({\n                                vertexColors: THREE.VertexColors,\n                            });\n                            var aniProvinceLine = new THREE.LineLoop(aniLineGeometry, material);\n                            aniProvinceLine.position.z += mapExtrudeHeight + 0.01;\n                            scene.add(aniProvinceLine);\n                            var box3 = new THREE.Box3();\n                            box3.expandByObject(aniProvinceLine);\n                        }\n\n                        wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, true);  // 0x026086\n                        wallMesh.renderOrder = renderOrderNoTransparent;\n                        scene.add(wallMesh);\n                    });\n                }\n            });\n\n            isFinishLoadJson2 = true;\n            loadJsonFinished();\n        });  // end load\n    }\n\n    // \u5de6\u4e0b\u4fa7\u5149 \u989c\u8272 \u5f3a\u5ea6 \u8ddd\u79bb\n    var pointLight1 = new THREE.PointLight(0xffffff, 1.5, 1000);\n    pointLight1.position.set(0, 0, -10);\n    // scene.add(pointLight1);\n\n    // \u5de6\u4e0a\u4fa7\u5149\n    var pointLight2 = new THREE.PointLight(0xffffff, 15, 1000);\n    // point.position.set(50, 50.48, 0);\n    pointLight2.position.set(50, 150.48, 0);\n    // scene.add(pointLight2);\n\n    // // \u4e0a\u65b9\u5149\n    var pointLight3 = new THREE.PointLight(0xffffff, 1.2, 1000);\n    pointLight3.position.set(104, 28.48, 300);\n    // scene.add(pointLight3);\n\n    var directionalLight1 = new THREE.DirectionalLight(0x888888, 2);//\u5149\u6e90\u989c\u8272\n    directionalLight1.position.set(137, 1000, 100);//\u5149\u6e90\u4f4d\u7f6e\n    scene.add(directionalLight1);//\u5149\u6e90\u6dfb\u52a0\u5230\u573a\u666f\u4e2d\n\n    var directionalLight2 = new THREE.DirectionalLight(0x888888, 12);//\u5149\u6e90\u989c\u8272\n    directionalLight2.position.set(137, 300, 100);//\u5149\u6e90\u4f4d\u7f6e\n    // scene.add(directionalLight2);//\u5149\u6e90\u6dfb\u52a0\u5230\u573a\u666f\u4e2d\n\n    var ambient = new THREE.AmbientLight(0x666666, 3.5);\n    // var ambient = new THREE.AmbientLight(0xffffff);\n    scene.add(ambient);\n    var renderWidth = window.innerWidth;\n    var renderHeight = window.innerHeight;\n    var camera = new THREE.PerspectiveCamera(45, window.innerWidth / window.innerHeight, 0.01, 15000);\n\n    // WebGLRenderer\n    renderer = new THREE.WebGLRenderer({antialias: true}); // depth: true, logarithmicDepthBuffer: true\n    renderer.setSize(renderWidth, renderHeight);\n    renderer.autoClear = false;\n    renderer.sortObjects = false; // \u5c1d\u8bd5\u81ea\u52a8\u6392\u5e8f\u5bf9\u8c61\n    render.outputEncoding = THREE.sRGBEncoding; // srg\u989c\u8272\n    // renderer.setClearColor(0x6675aa, 1);\n    renderer.setClearColor(0x004466, 0.6);  //0x001111\n    document.body.appendChild(renderer.domElement);\n    renderer.domElement.style.width = `${renderWidth}px`; // \u8bbe\u7f6eHTML\u753b\u5e03\u7684\u5b9e\u9645\u663e\u793a\u5c3a\u5bf8\n    renderer.domElement.style.height = `${renderHeight}px`;\n\n    // CSS3DRenderer\n    var labelRenderer = new CSS3DRenderer();\n    labelRenderer.setSize(renderWidth, renderHeight);\n    labelRenderer.domElement.style.position = 'absolute';\n\n    labelRenderer.domElement.style.top = '0px';\n    labelRenderer.domElement.style.left = '0px';\n    labelRenderer.domElement.style.pointerEvents = 'none';\n    document.body.appendChild(labelRenderer.domElement);\n\n    addEventListener('mousemove', onMouseMove);\n    addEventListener('resize', onResize);\n\n    // \u9f20\u6807\u64cd\u4f5c\n    var controls = new THREE.OrbitControls(camera, renderer.domElement);\n    // controls.maxPolarAngle = Math.PI / 2;\n    controls.enableDamping = true; // \u542f\u7528\u52a8\u6001\u963b\u5c3c\u65f6\u9700\u8981\u4e00\u4e2a\u52a8\u753b\u5faa\u73af\n    controls.dampingFactor = 0.03;\n    // controls.screenSpacePanning = false;\n    controls.mouseButtons = {\n        LEFT: THREE.MOUSE.ROTATE, // \u65cb\u8f6c\n        MIDDLE: THREE.MOUSE.DOLLY,  // \u7f29\u653e\n        RIGHT: THREE.MOUSE.PAN,  // \u79fb\u52a8\n    };\n    controls.minAzimuthAngle = -Math.PI / 4; // \u5de6\u4fa745\u5ea6\n    controls.maxAzimuthAngle = Math.PI / 4; // \u53f3\u4fa745\u5ea6\n    controls.minPolarAngle = Math.PI / 2; // 90\u5ea6 \u76f4\u89d2\n    controls.maxPolarAngle = Math.PI / 1.05; // 180\u5ea6\uff0c\u5373\u6c34\u5e73\u7ebf\n\n    controls.target.set(provinceCenter.x, provinceCenter.y, 0);\n\n    // camera\u5199\u5728\u8c03\u7528render()\u4e4b\u540e\n    camera.position.set(111.83, 21.98, 3.8);\n    camera.lookAt(provinceCenter.x, provinceCenter.y, 0);\n\n    render();\n\n    function render() {\n        const delta = clock.getDelta();\n        if (null != aniLineGeometry) {\n            provinceLineAniPointIndex1 += delta * 60;\n            if (provinceLineAniPointIndex1 >= provinceLinePointCount)\n                provinceLineAniPointIndex1 = 0;\n\n            provinceLineAniPointIndex2 += delta * 60;\n            if (provinceLineAniPointIndex2 >= provinceLinePointCount)\n                provinceLineAniPointIndex2 = 0;\n\n            setProvinceLineAniColor(\n                aniLineGeometry,\n                provinceLinePointCount,\n                provinceLineAniPointCount,\n                provinceLineAniPointIndex1,\n                provinceLineAniPointIndex2\n            );\n        }\n\n        if (null != wallMaterialShader) {\n            wallMaterialShader.uniforms.wallAniStartPoint.value += (delta * 0.08);\n            if (wallMaterialShader.uniforms.wallAniStartPoint.value > mapExtrudeHeight)\n                wallMaterialShader.uniforms.wallAniStartPoint.value = 0;\n            // console.log('wallAniStartPoint:', wallMaterialShader.uniforms.wallAniStartPoint.value);\n        }\n\n        if (null != aniPlaneShader.value) {\n            aniPlaneShader.value.uniforms.currR.value += (delta * groundCircleAniSpeed);  // 10\u63a7\u5236\u53d1\u6563\u901f\u5ea6\n            if (aniPlaneShader.value.uniforms.currR.value > 100)\n                aniPlaneShader.value.uniforms.currR.value = initAniPlaneRadius;\n        }\n\n        if (null != aniCityPlaneShader.value) {\n            aniCityPlaneShader.value.uniforms.currR.value += (delta * 0.08);\n            if (aniCityPlaneShader.value.uniforms.currR.value > 0.2)\n                aniCityPlaneShader.value.uniforms.currR.value = -0.3;\n\n            if (aniCityPlaneShader.value.uniforms.currR.value > 0)\n                aniCityPlaneShader.value.uniforms.outOpacity.value = (0.2 - aniCityPlaneShader.value.uniforms.currR.value) / 0.2;\n            else\n                aniCityPlaneShader.value.uniforms.outOpacity.value = 0;\n        }\n\n        groundImageMesh1.rotateZ(delta * 0.15);\n        groundImageMesh2.rotateZ(-delta * 0.15);\n\n        if (flyLineShaderArr.length > 0) {\n            for (var i = 0; i < flyLineShaderArr.length; i++) {\n                flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value += delta * (flyLineShaderArr[i].uniforms.pointCount.value / 2.2);\n                if (flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value > flyLineShaderArr[i].uniforms.pointCount.value * 3)\n                    flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value = 0.0;\n            }\n        }\n        renderer.clear();\n        renderer.render(scene, camera);\n        labelRenderer.render(scene, camera);\n        // renderer.render(scene, camera);\n        controls.update();\n\n        // mesh.rotateY(0.01);\n        requestAnimationFrame(render);\n        // frame.update(delta).updateNode(groundMirrorMaterial);\n    }\n\n    function loadJsonFinished() {\n\n        if (!isFinishLoadJson1 || !isFinishLoadJson2)\n            return;\n\n        $.each(chooseMeshArrObj , function(key,e){\n            var flyLinePlane = createFlyLinePlane(e, 0.2, 0.2, mapExtrudeHeight, imageUrl + '11.png');\n            flyLinePlaneArr.push(flyLinePlane);\n            scene.add(flyLinePlane);\n\n            var pillar1 = createPillar(e, 0.03, 0.3, mapExtrudeHeight);\n            scene.add(pillar1);\n\n            var label1 = createCityLabel(e, 0.25, mapExtrudeHeight, key, 'CHANGSHA', areaDataObj[key], 1);\n            scene.add(label1);\n        })\n        // \u5927\u5730\u53d1\u6563\u5706\u5708\u52a8\u753b\n        var aniPlane = createAniPlane([provinceCenter.x, provinceCenter.y], 0, 0x185889, initAniPlaneRadius, 5.0, aniPlaneShader);\n        scene.add(aniPlane);\n    }\n\n    var currSelMesh = null;\n\n    function onMouseMove(event) {\n        if (chooseMesh && chooseMesh.isAllowedChangeColor) {\n            chooseMesh.material.transparent = false;\n            chooseMesh.geometry.setAttribute('color', chooseMesh.colorAttribute_noSel);\n            chooseMesh.geometry.attributes.position.needsUpdate = true;\n        }\n\n        var sx = event.clientX;\n        var sy = event.clientY;\n\n        var x = (sx / window.innerWidth) * 2 - 1;\n        var y = -(sy / window.innerHeight) * 2 + 1;\n\n        var raycaster = new THREE.Raycaster();\n        raycaster.setFromCamera(new THREE.Vector2(x, y), camera);\n        var intersects = raycaster.intersectObjects(shapeGroup.children);\n        if (intersects.length > 0) {\n            chooseMesh = intersects[0].object;\n            if (chooseMesh.isAllowedChangeColor) {\n                chooseMesh.material.transparent = true;\n                chooseMesh.material.opacity = provincePlaneOpacity;\n                // chooseMesh.material.color.set(selectedColor);\n                chooseMesh.geometry.setAttribute('color', chooseMesh.colorAttribute_sel);\n                chooseMesh.geometry.attributes.position.needsUpdate = true;\n            }\n        } else {\n\n        }\n    }  // onMouseDown end\n\n    function onResize(event) {\n        renderWidth = window.innerWidth;\n        renderHeight = window.innerHeight;\n        renderer.setSize(renderWidth, renderHeight);\n        renderer.domElement.style.width = `${renderWidth}px`; // \u8bbe\u7f6eHTML\u753b\u5e03\u7684\u5b9e\u9645\u663e\u793a\u5c3a\u5bf8\n        renderer.domElement.style.height = `${renderHeight}px`;\n        labelRenderer.setSize(renderWidth, renderHeight);\n\n        camera.aspect = renderWidth / renderHeight;\n        // \u66f4\u65b0\u76f8\u673a\u7684\u6295\u5f71\u77e9\u9635 \u5fc5\u5199\n        camera.updateProjectionMatrix();\n    }\n\n    function createAreaLine(pointArr, lineColor) {\n        var geometry = new THREE.BufferGeometry();\n        var vertices = new Float32Array(pointArr);\n        var attribute = new THREE.BufferAttribute(vertices, 3);\n        geometry.attributes.position = attribute;\n        var material = new THREE.LineBasicMaterial({\n            color: lineColor,  //0x00ffff 0x00B2DF\n            // depthWrite: false,\n        });\n        var line = new THREE.LineLoop(geometry, material);\n        return line;\n    }\n\n    function createAreaMesh(vector2Arr, meshHeight, meshColor) {\n        var material = new THREE.MeshPhongMaterial({\n            color: meshColor, //0x1C394C 0x004444  0x00B2DF\n            side: THREE.DoubleSide,// THREE.FrontSide // THREE.BackSide // THREE.DoubleSide,\n            // depthTest: false,\n            // depthWrite: false,\n        });\n\n        var shape = new THREE.Shape(vector2Arr);\n        // console.log(vector2Arr);\n        // var geometry = new THREE.ShapeBufferGeometry(shape);\n        var geometry = new THREE.ExtrudeBufferGeometry(\n            shape,\n            {\n                depth: meshHeight,  // \u62c9\u4f38\n                bevelEnabled: false\n            }\n        );\n        var mesh = new THREE.Mesh(geometry, material);\n        return mesh;\n    }\n\n    // \u57ce\u5e02\u533a\u5757\n    function createShapePlaneMesh(vector2Arr, meshHeight, meshColor, isAllowedChangeColor) {\n        var material;\n\n        if (isAllowedChangeColor) {\n            material = new THREE.MeshPhysicalMaterial({\n                vertexColors: THREE.VertexColors,\n            });\n        } else {\n            material = new THREE.MeshPhysicalMaterial({\n                color: meshColor, //0x1C394C 0x004444  0x00B2DF 0x0C2437\n                side: THREE.DoubleSide,// THREE.FrontSide // THREE.BackSide // THREE.DoubleSide,\n            });\n        }\n\n        var shape = new THREE.Shape(vector2Arr);\n        // \u521b\u5efa\u51e0\u4f55\u4f53\n        var geometry = new THREE.ShapeGeometry(shape);\n\n        var colorAttribute_noSel;\n        var colorAttribute_sel;\n        if (isAllowedChangeColor) {\n            // console.log(geometry.attributes.position.array);\n            let minY = 0;\n            let maxY = 0;\n            for (let i = 0; i < geometry.attributes.position.count; i++) {\n                if (i == 0) {\n                    minY = geometry.attributes.position.array[i * 3 + 1];\n                    maxY = geometry.attributes.position.array[i * 3 + 1];\n                } else {\n                    if (minY > geometry.attributes.position.array[i * 3 + 1])\n                        minY = geometry.attributes.position.array[i * 3 + 1];\n                    if (maxY < geometry.attributes.position.array[i * 3 + 1])\n                        maxY = geometry.attributes.position.array[i * 3 + 1];\n                }\n            }\n\n            minY *= 10000;\n            maxY *= 10000;\n\n            let intervalY = maxY - minY;\n            let R1 = 14;\n            let G1 = 23;\n            let B1 = 66;\n            let R2 = 15;\n            let G2 = 26;\n            let B2 = 70;\n\n            let R3 = R1 - R2;\n            let G3 = G1 - G2;\n            let B3 = B1 - B2;\n\n            // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n            const colors = [];\n            const vertexCount = geometry.attributes.position.count;\n            for (let i = 0; i < vertexCount; i++) {\n                let y = geometry.attributes.position.array[i * 3 + 1];\n                let scaleY = (y * 10000 - minY) / intervalY / 0.05;  // 0.3\u8868\u793a\u6e10\u53d8\u901f\u5ea6\uff0c\u8d8a\u5c0f\u8d8a\u4ee5\u4e0a\u9762\u8272\u4e3a\u4e3b\n                colors.push((scaleY * R3 + R2) / 255, (scaleY * G3 + G2) / 255, (scaleY * B3 + B2) / 255);\n            }\n\n            // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n            colorAttribute_noSel = new THREE.BufferAttribute(new Float32Array(colors), 3);\n            geometry.setAttribute('color', colorAttribute_noSel);\n\n            // \u9009\u4e2d\u6e10\u53d8\u4e0a\u7aef\u8272\n            let R4 = 49;\n            let G4 = 143;\n            let B4 = 222;\n\n            // \u6e10\u53d8\u4e0b\u7aef\u8272\n            let R5 = 93;\n            let G5 = 162;\n            let B5 = 218;\n\n            let R6 = R4 - R5;\n            let G6 = G4 - G5;\n            let B6 = B4 - B5;\n\n            // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n            const colors1 = [];\n            for (let i = 0; i < vertexCount; i++) {\n                let y = geometry.attributes.position.array[i * 3 + 1];\n                let scaleY = (y * 10000 - minY) / intervalY / 0.5;  // 0.3\u8868\u793a\u6e10\u53d8\u901f\u5ea6\uff0c\u8d8a\u5c0f0.2\u8d8a\u4ee5\u4e0a\u9762\u8272\u4e3a\u4e3b\n                // \u8fd9\u91cc\u7b80\u5355\u5730\u4f7f\u7528\u968f\u673a\u989c\u8272\uff0c\u4f60\u9700\u8981\u6839\u636e\u4f60\u7684\u9700\u6c42\u6765\u786e\u5b9a\u6bcf\u4e2a\u9876\u70b9\u7684\u989c\u8272\n                // colors.push((scaleY * R3 + R2) / 255, (scaleY * G3 + G2) / 255, (scaleY * B3 + B2) / 255);\n                colors1.push((scaleY * R6 + R5) / 255, (scaleY * G6 + G5) / 255, (scaleY * B6 + B5) / 255);\n                // colors.push(Math.random(), Math.random(), Math.random());\n                // console.log(colors);\n            }\n\n            // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n            colorAttribute_sel = new THREE.BufferAttribute(new Float32Array(colors1), 3);\n        }\n\n        // \u521b\u5efa\u7f51\u683c\n        var mesh = new THREE.Mesh(geometry, material);\n        mesh.position.z += meshHeight;\n\n        mesh.isAllowedChangeColor = isAllowedChangeColor;\n        if (isAllowedChangeColor) {\n            mesh.colorAttribute_noSel = colorAttribute_noSel;\n            mesh.colorAttribute_sel = colorAttribute_sel;\n        }\n\n        return mesh;\n    }\n\n    function createWallMaterial(isShowAni) {\n        var wallMaterial = new THREE.MeshBasicMaterial({\n            color: provinceWallColor,\n            side: isShowAni ? THREE.FrontSide : THREE.BackSide,  // THREE.Front DoubleSide\n        });\n\n        if (isShowAni) {\n            wallMaterial.onBeforeCompile = function (shader) {\n                wallMaterialShader = shader;\n\n                shader.uniforms.wallHeight = {value: mapExtrudeHeight};\n                shader.uniforms.wallAniStartPoint = {value: wallAniStartPoint};\n                shader.uniforms.wallColor = {value: new THREE.Color(provinceWallColor)};\n                shader.uniforms.wallHighLightColor = {value: new THREE.Color(wallHighLightColor)};\n\n                shader.vertexShader = shader.vertexShader.replace(\n                    'void main() {',\n                    ['varying vec3 vPos;',\n                        'void main() {',\n                        'vPos = position;',\n                    ].join('\\n')\n                )\n                // console.log('vertexShader: ', shader.vertexShader);\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'void main() {',\n                    ['uniform float wallHeight;',\n                        'uniform float wallAniStartPoint;',\n                        'uniform vec3 wallColor;',\n                        'uniform vec3 wallHighLightColor;',\n                        'varying vec3 vPos;',\n                        'void main() {',\n                    ].join('\\n')\n                )\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                    wall_output_fragment\n                )\n            }\n\n            // console.log('fragmentShader: ', shader.fragmentShader);\n        }\n        return wallMaterial;\n    }\n\n    // \u6ca1\u6709\u52a8\u753b\u7684\u6750\u8d28\n    var wallNotAniMaterial = createWallMaterial(false);\n    // \u6709\u52a8\u753b\u7684\u6750\u8d28\n    var wallAniMaterial = createWallMaterial(true);\n\n    // c\u662f\u4e8c\u7ef4\u5411\u91cf\u6570\u7ec4\uff0ch\u662f\u62c9\u4f38\u9ad8\u5ea6\uff0ctextureFileName\u662f\u7eb9\u7406\u56fe\u7247\u540d\u79f0\uff0ccolor1\u662f\u989c\u8272\uff0copacity1\u662f\u900f\u660e\u5ea6\n    function createWallMesh(c, h, textureFileName, color1, opacity1, isShowAni) {\n        // \u521b\u5efa\u51e0\u4f55\u4f53\n        const geometry1 = new THREE.BufferGeometry();\n        var posArr = [];\n        var uvArr = [];\n        for (var i = 0; i < c.length - 1; i++) {\n            posArr.push(c[i].x, c[i].y, 0, c[i + 1].x, c[i + 1].y, 0, c[i + 1].x, c[i + 1].y, h);\n            // \u7b2c\u4e8c\u4e2a\u9762\uff0c\u5de6\u4e0b\u89d2 \u53f3\u4e0a\u89d2 \u5de6\u4e0a\u89d2\n            posArr.push(c[i].x, c[i].y, 0, c[i + 1].x, c[i + 1].y, h, c[i].x, c[i].y, h);\n            // \u6307\u5b9a\u5bf9\u5e94UV\u5750\u6807 2\u4e2a\u4e00\u7ec4\n            uvArr.push(0, 0, 1, 0, 1, 1);\n            uvArr.push(0, 0, 1, 1, 0, 1);\n        }\n\n        //\u8bbe\u7f6e\u513f\u4f55\u4f53attributes\u5c5e\u6027\u7684\u4f4d\u7f6eposition\u5a32\u6027\n        geometry1.attributes.position = new THREE.BufferAttribute(new Float32Array(posArr), 3);\n        geometry1.attributes.uv = new THREE.BufferAttribute(new Float32Array(uvArr), 2);\n        geometry1.computeVertexNormals();\n\n        const mesh = new THREE.Mesh(geometry1, isShowAni ? wallAniMaterial : wallNotAniMaterial);\n        return mesh;\n    }\n\n    function createCityLabel(p, height, meshHeight, cityName, cityPinyin, peopleCount, order) {\n        var div = document.createElement('div');\n        // div.innerHTML = '<div class=\"label-div\"><div class=\"count-div\"><span class=\"count-left\">51</span><span class=\"count-right\">\u4e07\u4eba</span></div><div class=\"city-div\"><div class=\"city-name\">\u6c38\u5dde\u5e02</div><div class=\"city-py\">Maoming</div></div><div class=\"number-div fluorescent-number\">6</div></div>'; //\u6e56\u5357\u7701\n        div.innerHTML = '<div class=\"label-div\"><div class=\"count-div\">' + peopleCount + '</div><div class=\"name-div\">' + cityName + '</div></div>'; //\u6e56\u5357\u7701\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n        var label = new CSS3DObject(div);\n        label.scale.set(0.006, 0.006, 0.006);\n        label.position.set(p[0], p[1], height + meshHeight + 0.3);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createProvinceNameLabel(p) {\n        var div = document.createElement('div');\n        div.innerHTML = '\u6e56\u5357\u7701'; //\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n        div.style.padding = '1px 0.5px';\n        div.style.color = '#ffffff';\n        div.style.fontSize = '5px';\n        div.style.textAlign = 'center';\n        div.style.position = 'absolute';\n        div.style.backgroundColor = 'rgba(25, 25, 25, 0.4)';\n        div.style.borderRadius = '3px';\n\n        var label = new CSS3DObject(div);\n        // label.position.x = x;\n        // label.position.y = y;\n        // label.position.z = 1.0;\n        label.scale.set(0.03, 0.03, 0.03);\n        label.position.set(p[0], p[1], 0.1);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createPlane() {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.5, 0.5);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            map: textureLoader.load('image/\u6e56\u5357.png'),\n            side: THREE.DoubleSide,\n            transparent: true,\n        });\n        var planeMesh = new THREE.Mesh(plane, planeMaterial);\n        return planeMesh;\n    }\n\n    // rangeSize\u8303\u56f4 divisions\u5706\u70b9\u4e2a\u6570\n    function addGround(rangeSize, divisions, gridColor, R, RColor) {\n        var group = new THREE.Group();\n        var interval = rangeSize / divisions;\n        var range1 = rangeSize / 2;\n        var geoArr = [];\n        for (var i = 0; i < divisions; i++) {\n            for (var j = 0; j < divisions; j++) {\n                var geometry = new THREE.CircleBufferGeometry(R, 20, 20);\n                geometry.rotateX(Math.PI / 2);\n                geometry.translate(-range1 + i * interval, 0.05, -range1 + j * interval);\n                geoArr.push(geometry);\n            }\n        }\n        var bufferGeo = THREE.BufferGeometryUtils.mergeBufferGeometries(geoArr);\n\n        var material = new THREE.MeshBasicMaterial({\n            color: gridColor,\n            side: THREE.DoubleSide,\n            transparent: true,\n            opacity: 0.3,\n            // depthTest: false,\n            // depthWrite: false\n        });\n        var mesh = new THREE.Mesh(bufferGeo, material);\n        mesh.position.y -= 0.1;\n        // mesh.renderOrder = 4;\n        group.add(mesh);\n        group.rotateX(Math.PI / 2);\n\n        return group;\n    }\n\n    function addGroundImageMesh1(imageFile, width, height) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(width, height);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            color: groundImageColor,\n            map: textureLoader.load(imageFile),\n            side: THREE.FrontSide,\n            transparent: true,\n            opacity: 0.3,\n            // depthTest: false,\n        });\n        var goundImageMesh = new THREE.Mesh(plane, planeMaterial);\n        return goundImageMesh;\n    }\n\n    // germetry\u88ab\u4fee\u6539\u7684\u51e0\u4f55\u4f53\uff0cpointCount\u662fline\u4e0a\u6240\u6709\u70b9\u7684\u6570\u91cf\uff0caniPointCount\u53c2\u4e0e\u52a8\u753b\u70b9\u7684\u6570\u91cf\uff0c index1 index2\u662f\u4e24\u6bb5\u52a8\u753b\u5f00\u59cb\u7684\u8d77\u59cb\u70b9\n    function setProvinceLineAniColor(geometry, pointCount, aniPointCount, index1, index2) {\n        var color1 = new THREE.Color(provinceLineHighLightColor); // provinceLineHighLightColor 0x99ffff\n        var color2 = new THREE.Color(provinceLineColor);\n\n        // begin\u7684\u4f4d\u7f6e\u5927\u4e8eindex\u4f4d\u7f6e\n        var begin1 = index1 + aniPointCount;\n        if (begin1 > pointCount)\n            begin1 -= pointCount;\n\n        var begin2 = index2 + aniPointCount;\n        if (begin2 > pointCount)\n            begin2 -= pointCount;\n        // console.log('end', end1, end2);\n\n        var colorArr = [];\n        for (var i = 0; i < pointCount; i++) {\n            var color = color2;\n            // \u5f53\u524d\u70b9\u662f\u5426\u5728\u52a8\u753b\u4e2d\uff0cindex:-1\u662f\u4e0d\u5728\u52a8\u753b\u533a\u57df\u4e2d\uff0c>0\u8868\u793a\u5728\u52a8\u753b\u4e2d\u7684\u7b2c\u51e0\u4e2a\u70b9\n            var index = -1;\n\n            // \u7b2c\u4e00\u6bb5\u52a8\u753b\u8bbe\u7f6e\n            if (begin1 > index1) { // \u7b2c\u4e00\u6bb5\u52a8\u753b\u6b63\u5e38\u987a\u5e8f\n                if (i <= begin1 && i >= index1) {\n                    index = begin1 - i;\n                    // console.log('index 1', begin1, i, index);\n                }\n            } else { // \u7b2c\u4e00\u6bb5\u52a8\u753b\u8d85\u8fc7\u7ed3\u5c3e\u5904\n                if (i >= 0 && i <= begin1) {\n                    index = begin1 - i;\n                } else if (i >= index1 && i < pointCount) {\n                    index = begin1 + (pointCount - i);\n                }\n                // console.log('index 2', i, index);\n            }\n\n            // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u8bbe\u7f6e\n            if (begin2 > index2) { // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u6b63\u5e38\u987a\u5e8f\n                if (i <= begin2 && i >= index2) {\n                    index = begin2 - i;\n                    // console.log('index 2', begin2, i, index);\n                }\n            } else { // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u8d85\u8fc7\u7ed3\u5c3e\u5904\n                if (i >= 0 && i <= begin2) {\n                    index = begin2 - i;\n                } else if (i >= index2 && i < pointCount) {\n                    index = begin2 + (pointCount - i);\n                }\n                // console.log('index 2', i, index);\n            }\n\n            // if (i == 0)\n            //   console.log('index 1', index);\n            // if (i == 965 )\n            //   console.log('index 2', index);\n\n            if (-1 != index) {\n                color = color1.clone().lerp(color2, index / aniPointCount);\n                // color = new THREE.Color(0xff0000);\n\n                // if (i == 0)\n                //   console.log('color 0:', index, aniPointCount, color, color1, color2);\n\n                // if (i == 965)\n                //   console.log('color 965:', index, aniPointCount, color, color1, color2);\n            }\n\n            colorArr.push(color.r, color.g, color.b);\n        }\n        // console.log('colorArr count:', colorArr.length);\n\n        geometry.attributes.color = new THREE.BufferAttribute(new Float32Array(colorArr), 3);\n        // geometry.colorsNeedUpdate = true;\n    }\n\n    function createFlyLine(p1, p2, meshHeight) {\n        // console.log(p1, p2);\n        var p_1 = new THREE.Vector3(p1[0], p1[1], meshHeight);  // mapExtrudeHeight\n        var p_2 = new THREE.Vector3(p2[0], p2[1], meshHeight);\n        var midPoint = new THREE.Vector3();\n        midPoint.addVectors(p_1, p_2).divideScalar(2);\n        // midPoint.z = p_1.clone().sub(p_2).length() / 4;\n        // \u98de\u7ebf\u9ad8\u5ea6\n        midPoint.z = 1.2;\n        var curve = new THREE.QuadraticBezierCurve3(p_1, midPoint, p_2);\n\n        var vectorDifference = new THREE.Vector3().subVectors(p_1, p_2);\n        // \u83b7\u53d6\u5411\u91cf\u7684\u957f\u5ea6\uff0c\u5373\u4e24\u70b9\u4e4b\u95f4\u7684\u8ddd\u79bb\n        var distance = vectorDifference.length();\n        var pointCount = Math.ceil(distance * 600); // \u5411\u4e0a\u53d6\u6574 \u901a\u8fc7\u8ddd\u79bb\u6765\u786e\u5b9a\u70b9\u7684\u6570\u91cf\n        // console.log('distance:', distance);\n\n        var points = curve.getPoints(pointCount); // getSpacedPoints\n        var geometry = new THREE.BufferGeometry();\n        geometry.setFromPoints(points);\n        const indexs = [];\n        for (let i = 0; i < geometry.attributes.position.count; i++) {\n            indexs.push(i * 1.0);\n        }\n\n        const indexsAttribute = new THREE.BufferAttribute(new Float32Array(indexs), 1);\n        geometry.attributes.pointIndex = indexsAttribute;\n\n        var material = new THREE.PointsMaterial({\n            color: 0x00ffff,  // 0x0088ff\n            transparent: true,\n            // opacity: 0.25,\n            size: 0.1,\n            depthWrite: false,\n            depthTest: false, // \u9700\u8981\u5199\n        });\n        if (true) {\n            material.onBeforeCompile = function (shader) {\n                flyLineShaderArr.push(shader);\n\n                shader.uniforms.meshHeight = {value: meshHeight};\n                shader.uniforms.flyLineColor1 = {value: flyLineColor1};\n                shader.uniforms.flyLineColor2 = {value: flyLineColor2};\n                shader.uniforms.pointCount = {value: indexs.length / 1.0};\n                shader.uniforms.cityDistance = {value: distance};\n                shader.uniforms.currflyLineHighLightIndex = {value: currflyLineHighLightIndex};\n\n                // shader.uniforms.wallHighLightColor = { value: new THREE.Color(wallHighLightColor) };\n                // console.log('shader:', shader);\n\n                shader.vertexShader = shader.vertexShader.replace(\n                    'void main() {',\n                    ['attribute float pointIndex;',\n                        // 'uniform float pointCount;',\n                        // 'uniform float currflyLineHighLightIndex;',\n                        'varying vec3 vPos;',\n                        'varying float vPointIndex;',\n                        'void main() {',\n                        'vPos = position;',\n                        'vPointIndex = pointIndex;',\n                    ].join('\\n')\n                );\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'void main() {',\n                    ['uniform float meshHeight;',\n                        'uniform vec3 flyLineColor1;',\n                        'uniform vec3 flyLineColor2;',\n                        'uniform float pointCount;',\n                        'uniform float cityDistance;',\n                        'uniform float currflyLineHighLightIndex;',\n                        'varying vec3 vPos;',\n                        'varying float vPointIndex;',\n                        'void main() {',\n                    ].join('\\n')\n                )\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                    flyLine_output_fragment\n                )\n\n                // console.log('fragmentShader: ', shader.fragmentShader);\n            }\n        }\n\n        var line = new THREE.Points(geometry, material);\n        line.renderOrder = renderOrderFlyLine;\n        // console.log('line:', line);\n        return line;\n    }\n\n    // \u98de\u7ebf\u8d77\u70b9\u4e0b\u9762\u7684\u8f6c\u76d8 p\u662f\u5750\u6807 meshHeight\u6a21\u578b\u9ad8\u5ea6\uff0cimageFile\u56fe\u7247\u6587\u4ef6\n    function createFlyLinePlane(p, width, height, meshHeight, imageFile) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.2, 0.2);  // width, height\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            // color: 0x000000,\n\n            map: textureLoader.load(imageFile),\n            side: THREE.DoubleSide,\n            transparent: true,\n            // emissive: 0xffffff, // \u81ea\u53d1\u5149\u989c\u8272\uff08\u7ea2\u8272\uff09\n            // emissiveIntensity: 2.0, // \u81ea\u53d1\u5149\u5f3a\u5ea6\n            opacity: 0.9,\n            // depthWrite: false,\n        });\n        var flyLinePlane = new THREE.Mesh(plane, planeMaterial);\n\n        // flyLinePlane.rotateX(Math.PI / 2);\n        flyLinePlane.position.set(p[0], p[1], meshHeight + 0.02);\n        flyLinePlane.renderOrder = renderOrderFlyLinePlane;\n        return flyLinePlane;\n    }\n    function createPillar(p, r, height, meshHeight) {\n        // var textureLoader = new THREE.TextureLoader();\n        // \u521b\u5efa\u5706\u67f1\u4f53\u7684\u51e0\u4f55\u4f53\u548c\u6750\u8d28\n        var geometry = new THREE.CylinderGeometry(r / 4, r, height, 32); // \u53c2\u6570\uff1a\u534a\u5f84\u9876\u90e8, \u534a\u5f84\u5e95\u90e8, \u9ad8\u5ea6, \u5206\u6bb5\u6570\n        var material = new THREE.MeshPhysicalMaterial({\n            // map: textureLoader.load(imageUrl + 'hh.png'),\n            // color: 0x66FFFF,\n            vertexColors: THREE.VertexColors,\n            transparent: true,\n            opacity: 0.6,\n        });\n\n        var color1 = new THREE.Color(0xFFFFFF); // \u5e95\n        var color2 = new THREE.Color(0x004488);\n        // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n        const colors = [];\n        const vertexCount = geometry.attributes.position.count;\n        for (let i = 0; i < vertexCount; i++) {\n            let y = geometry.attributes.position.array[i * 3 + 1];\n            var color = color1.clone().lerp(color2, (y + height / 2) / height);\n            colors.push(color.r, color.g, color.b);\n        }\n        // console.log(colors);\n        // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n        const colorAttribute = new THREE.BufferAttribute(new Float32Array(colors), 3);\n        geometry.setAttribute('color', colorAttribute);\n\n        var cylinder = new THREE.Mesh(geometry, material); // \u521b\u5efa\u7f51\u683c\u5bf9\u8c61\n        cylinder.rotateX(Math.PI / 2);\n        cylinder.position.set(p[0], p[1], meshHeight + height / 2 + 0.02);  //\n        cylinder.renderOrder = renderOrderPillar;\n        return cylinder;\n    }\n\n    // p\u5706\u5fc3\u5750\u6807 circleColor\u989c\u8272\uff0cinitRadius\u8d77\u59cb\u534a\u5f84\uff0ccircleWidth\u5706\u5708\u5bbd\u5ea6\n    function createAniPlane(p, meshHeight, circleColor, initRadius, circleWidth, shaderObj) {\n        var plane = new THREE.PlaneGeometry(50, 50);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            color: circleColor, // 0x185889,\n            side: THREE.FrontSide,\n            transparent: true,\n            opacity: 0.05,\n            // depthWrite: false,\n            // depthTest: false,\n        });\n\n        planeMaterial.onBeforeCompile = function (shader) {\n            shaderObj.value = shader;\n\n            // \u5f53\u524d\u6700\u65b0\u534a\u5f84\u503c\n            shader.uniforms.currR = {value: initRadius};  // initAniPlaneRadius\n            shader.uniforms.circleWidth = {value: circleWidth};  // 5.0\n            shader.uniforms.outOpacity = {value: 1.0};  // \u5916\u90e8\u589e\u52a0\u4e00\u4e2a\u900f\u660e\u5ea6\n\n            shader.vertexShader = shader.vertexShader.replace(\n                'void main() {',\n                ['varying vec3 vPos;',\n                    'void main() {',\n                    'vPos = position;',\n                ].join('\\n')\n            )\n            // console.log('vertexShader: ', shader.vertexShader);\n\n            shader.fragmentShader = shader.fragmentShader.replace(\n                'void main() {',\n                ['uniform float currR;',\n                    'uniform float circleWidth;',\n                    'uniform float outOpacity;',\n                    'varying vec3 vPos;',\n                    'void main() {',\n                ].join('\\n')\n            )\n\n            shader.fragmentShader = shader.fragmentShader.replace(\n                'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                aniGroundCirclePlane_output_fragment\n            )\n        }\n\n        var planeMesh = new THREE.Mesh(plane, planeMaterial);\n        planeMesh.position.set(p[0], p[1], meshHeight);\n        return planeMesh;\n    }\n\n    function createMirror() {\n\n    }\n</script>\n</body>\n\n</html>");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        JSONObject saveJson = optionObject.getJSONObject("saveJson");
        String areaColumn = saveJson.getString("areaColumn");
        String valueColumn = saveJson.getString("valueColumn");
        String[] areas = areaColumn.split(",");
        String[] values = valueColumn.split(",");
        String chartBg = saveJson.getString("chartBg");
        String geo = saveJson.getString("geo");
        String camera = saveJson.getString("camera");
        String butCss = saveJson.getString("butCss");
        String proCityFont = saveJson.getString("proCityFont");
        String proNumFont = saveJson.getString("proNumFont");
        String cityFont = saveJson.getString("cityFont");
        String numFont = saveJson.getString("numFont");
        String chartBgColor = chartBg == null ? "0x261802" : chartBg.replace("#", "0x");
        jsResourcePath = jsResourcePath.substring(0, jsResourcePath.length() - 7);
        String unit = saveJson.getString("unit");
        String uni = unit == null ? "" : unit;
        JSONObject areaObj = new JSONObject();
        for (int i = 0; i < areas.length; ++i) {
            String area = areas[i];
            String value = values[i];
            areaObj.put(area, (Object)value);
        }
        StringBuffer stringHtml = new StringBuffer();
        stringHtml.append("<!DOCTYPE html>\n<html>\n\n<head>\n    <meta charset=utf-8>\n    <title>\u5730\u56fe\u7279\u6548</title>\n    <style>\n        body {\n            margin: 0;\n        }\n\n        canvas {\n            width: 100%;\n            height: 100%;\n            display: block;\n        }\n        .return{\n" + butCss + "        }\n        .count-div{" + proNumFont + "}        .name-div{" + proCityFont + "}        .count-div-1{" + numFont + "}        .name-div-1{" + cityFont + "}    </style>\n    <link href=\"##plugin/pluginResource/data/three/hunan3DMap/css/labelStyles.css\" rel=\"stylesheet\">\n</head>\n\n<body>\n<button class=\"return\">\u8fd4\u56de</button>\n<script src=\"##plugin/plugin/jquery-1.11.3.min.js\"></script>\n<script src=\"##plugin/plugin/build/three.js\"></script>\n<script src=\"##plugin/plugin/three/js/controls/OrbitControls.js\"></script>\n<script src=\"##plugin/plugin/three/js/loaders/OBJLoader.js\"></script>\n<script src=\"##plugin/plugin/three/js/loaders/MTLLoader.js\"></script>\n<script src=\"##plugin/plugin/three/js/utils/BufferGeometryUtils.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/EffectComposer.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/RenderPass.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/UnrealBloomPass.js\"></script>\n<script src=\"##plugin/plugin/three/js/postprocessing/ShaderPass.js\"></script>\n<script src=\"##plugin/plugin/three/js/shaders/LuminosityHighPassShader.js\"></script>\n<script src=\"##plugin/plugin/three/js/shaders/CopyShader.js\"></script>\n<script src=\"##plugin/plugin/three/js/objects/Reflector.js\"></script>\n<script src=\"##plugin/plugin/three/js/shaders/WaterRefractionShader.js\"></script>\n<script type='module'>\n    import {LineSegmentsGeometry} from '##plugin/plugin/three/jsm/lines/LineSegmentsGeometry.js';\n    import {LineGeometry} from '##plugin/plugin/three/jsm/lines/LineGeometry.js';\n    import {Line2} from '##plugin/plugin/three/jsm/lines/Line2.js';\n    import {LineMaterial} from '##plugin/plugin/three/jsm/lines/LineMaterial.js';\n    import {\n        CSS3DRenderer,\n        CSS3DObject\n    } from '##plugin/plugin/three/jsm/renderers/CSS3DRenderer.js';\n    import {Reflector} from '##plugin/plugin/three/jsm/objects/Reflector.js';\n    import {ReflectorRTT} from '##plugin/plugin/three/jsm/objects/ReflectorRTT.js';\n    import wall_output_fragment from '##plugin/plugin/three/js/wall_output_fragment.glsl.js'\n    import flyLine_output_fragment from '##plugin/plugin/three/js/flyLine_output_fragment.glsl.js'\n    import flyLine_output_vertex from '##plugin/plugin/three/js/flyLine_output_vertex.glsl.js'\n    import aniGroundCirclePlane_output_fragment\n        from '##plugin/plugin/three/js/aniGroundCirclePlane_output_fragment.glsl.js'\n\n    var provinceFlag = true;\n    var scene = new THREE.Scene();\n    // \u7701\u4e2d\u5fc3\u5750\u6807\n    var provinceCenter = {x: 111.65393493652344, y: 26.66424446105957};\n    var centerObj = " + geo + "\n    var cityNameArray = ['\u957f\u6c99\u5e02', '\u5e38\u5fb7\u5e02', '\u6c38\u5dde\u5e02', '\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde', '\u5cb3\u9633\u5e02', '\u5f20\u5bb6\u754c\u5e02', '\u76ca\u9633\u5e02', '\u6e58\u6f6d\u5e02', '\u682a\u6d32\u5e02', '\u8861\u9633\u5e02', '\u90f4\u5dde\u5e02', '\u90b5\u9633\u5e02', '\u6000\u5316\u5e02', '\u5a04\u5e95\u5e02']\n    // \u662f\u5426\u663e\u793a\u6240\u6709\u7701\u8f6e\u5ed3\u7ebf\n    var isShowAllProvinceLine = true;\n    // \u5927\u5730\u5706\u5708\u53d1\u6563\u52a8\u753b\u901f\u5ea6\n    var groundCircleAniSpeed = 10;\n    var isFinishLoadJson1 = false;  // \u6e56\u5357\u7701\u5e02json\n    var isFinishLoadJson2 = false;  // \u6e56\u5357\u7701json\n    // \u6a21\u578b\u6e32\u67d3\u987a\u5e8f\n    const renderOrderNoTransparent = 0;\n    const renderOrderGroundPlane = 100;\n    const renderOrderFlyLinePlane = 110;\n    const renderOrderPillar = 120;\n    const renderOrderFlyLine = 130;\n    var imageUrl = '##plugin/pluginResource/data/three/hunan3DMap/image/'\n    var mapExtrudeHeight = 0.3;\n    var mapPlaneOpacity = 0.76;\n    // var flyHeight = 0.6;\n    var flyLine = null;\n    var flyLineShaderArr = [];\n    var flyLineColor1 = new THREE.Color(0.3, 1.0, 1.0); // \n    var flyLineColor2 = new THREE.Color(0.0, 0.75, 0.9); // \n    var currflyLineHighLightIndex = 0.0;\n    var flyLinePlaneArr = [];\n    var groundImageColor = 0x236191;\n    var chinaLineColor = 0x7A9DC1;  //0x7A9DC1;  //0x345F8B;\n    var chinaPlaneColor = " + chartBgColor + "; //0x004488;\n    var provinceLineColor = 0x4470B2; //0x83E1FF;// 0x83EBFF;\n    var provinceLineHighLightColor = 0xffffff;  // 0xbbffff;\n    var provincePlaneColor = 0x101b32;  //0x050725;//142362  //0x0E1741; //0x006b88;\n    var provincePlaneOpacity = 0.85;\n    var selectedColor = 0x6688DE; //0x4694D3;\n    var provinceWallColor = 0x1B3979;\n    var wallHighLightColor = 0x49A9D7;// 0x1F65AF;\n    var wallAniStartPoint = 0;  // \u968f\u7740\u65f6\u95f4\u589e\u52a0\uff0c\u8d85\u8fc7mapExtrudeHeight\u503c\u540e\uff0c\u6062\u590d\u52300\n    var wallMesh = null;\n    var wallMaterialShader = null;\n    // \u5927\u80cc\u666f\u5706\u5708\u52a8\u753b\n    var aniPlaneShader = {value: null};\n    var initAniPlaneRadius = -30;\n    var aniCityPlaneShader = {value: null};\n    var provinceLinePointCount = 2067;\n    // \u52a8\u753b\u5f00\u59cb\u70b9\u7684index\uff0c\u968f\u7740\u65f6\u95f4\u53d8\u5316\n    var provinceLineAniPointIndex1 = 0;\n    var provinceLineAniPointIndex2 = 1033;  // 2067 / 2\n    // \u53c2\u4e0e\u52a8\u753b\u6548\u679c\u70b9\u7684\u6570\u91cf\n    var provinceLineAniPointCount = 450;\n    var composer;\n    var renderer = null;\n    var line = null;\n    var curMesh;\n    var pointArr = [];\n    var lineGroup = new THREE.Group();\n    var shapeGroup = new THREE.Group();\n    var aniPlane = createAniPlane([centerObj['\u6e56\u5357\u7701'].x, centerObj['\u6e56\u5357\u7701'].y], 0, 0x185889, initAniPlaneRadius, 5.0, aniPlaneShader); //\u5149\u5708\u5bf9\u8c61\n    var areaDataObj = " + areaObj.toString() + " ;\n\n    var meshObj = {\n        '\u6e56\u5357\u7701': {\n            '\u957f\u6c99\u5e02': [112.982279, 28.19409], // \u957f\u6c99\n            '\u682a\u6d32\u5e02': [113.451737, 27.235806], // \u682a\u6d32\n            '\u6e58\u6f6d\u5e02': [112.744052, 27.62973], // \u682a\u6d32\n            '\u8861\u9633\u5e02': [112.607693, 26.700358], // \u682a\u6d32\n            '\u90b5\u9633\u5e02': [111.06923, 27.137842], // \u682a\u6d32\n            '\u5e38\u5fb7\u5e02': [111.691347, 29.040225], // \u5e38\u5fb7\n            '\u5f20\u5bb6\u754c\u5e02': [110.479921, 29.327401],  // \u5f20\u5bb6\u754c\n            '\u76ca\u9633\u5e02': [112.355042, 28.570066],  // \u5f20\u5bb6\u754c\n            '\u6e58\u897f': [109.739735, 28.714296], // \u6e58\u897f\n            '\u6000\u5316\u5e02': [109.97824, 27.550082],  // \u6000\u5316\n            '\u5a04\u5e95\u5e02': [111.808497, 27.728136],  // \u90b5\u9633\n            '\u5cb3\u9633\u5e02': [113.432855, 29.17029],  // \u5cb3\u9633\n            '\u6c38\u5dde\u5e02': [111.808019, 25.634516], // \u6c38\u5dde\n            '\u90f4\u5dde\u5e02': [113.032067, 25.793589] // \u90f4\u5dde\n        },\n        '\u957f\u6c99\u5e02': {\n            '\u8299\u84c9\u533a': [113.068094, 28.193106], // \u957f\u6c99\n            '\u5929\u5fc3\u533a': [112.97307, 28.032375], // \u682a\u6d32\n            '\u5cb3\u9e93\u533a': [112.781591, 28.113044], // \u682a\u6d32\n            '\u5f00\u798f\u533a': [112.985525, 28.351336], // \u682a\u6d32\n            '\u96e8\u82b1\u533a': [113.156337, 28.009937], // \u682a\u6d32\n            '\u671b\u57ce\u533a': [112.719549, 28.467458], // \u5e38\u5fb7\n            '\u957f\u6c99\u53bf': [113.280098, 28.437888],  // \u5f20\u5bb6\n            '\u6d4f\u9633\u5e02': [113.633301, 28.141112],  // \u5f20\u5bb6\u754c\n            '\u5b81\u4e61\u5e02': [112.353182, 28.153928]\n        },\n        '\u5e38\u5fb7\u5e02': {\n            '\u6b66\u9675\u533a': [111.690718, 29.040477], // \u957f\u6c99\n            '\u9f0e\u57ce\u533a': [111.585327, 28.714426], // \u682a\u6d32\n            '\u5b89\u4e61\u53bf': [112.172289, 29.414483], // \u682a\u6d32\n            '\u6c49\u5bff\u53bf': [112.068506, 28.807319], // \u682a\u6d32\n            '\u6fa7\u53bf': [111.661682, 29.74264], // \u682a\u6d32\n            '\u4e34\u6fa7\u53bf': [111.545602, 29.303217], // \u5e38\u5fb7\n            '\u6843\u6e90\u53bf': [111.284503, 28.902734],  // \u5f20\u5bb6\u754c\n            '\u77f3\u95e8\u53bf': [111.079087, 29.784703],  // \u5f20\u5bb6\u754c\n            '\u6d25\u5e02\u5e02': [111.879609, 29.630867]\n        },\n        '\u6c38\u5dde\u5e02':{\n            '\u96f6\u9675\u533a': [111.426348,26.023347], // \u957f\u6c99\n            '\u51b7\u6c34\u6ee9\u533a': [111.607156,26.434364], // \u682a\u6d32\n            '\u7941\u9633\u5e02': [111.85734,26.585929], // \u682a\u6d32\n            '\u4e1c\u5b89\u53bf': [111.313035,26.397278], // \u682a\u6d32\n            '\u53cc\u724c\u53bf': [111.762146,25.859397], // \u682a\u6d32\n            '\u9053\u53bf': [111.591614,25.518444], // \u5e38\u5fb7\n            '\u6c5f\u6c38\u53bf': [111.246803,25.198154],  // \u5f20\u5bb6\u754c\n            '\u5b81\u8fdc\u53bf': [111.944529,25.584112],  // \u5f20\u5bb6\u754c\n            '\u84dd\u5c71\u53bf': [112.194195,25.375255],\n            '\u65b0\u7530\u53bf': [112.220341,25.906927],\n            '\u6c5f\u534e\u7476\u65cf\u81ea\u6cbb\u53bf': [111.777276,24.902596]\n        },\n        '\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde':{\n            '\u5409\u9996\u5e02': [109.738273,28.214827], // \u957f\u6c99\n            '\u6cf8\u6eaa\u53bf': [110.014428,28.214516], // \u682a\u6d32\n            '\u51e4\u51f0\u53bf': [109.499191,27.948308], // \u682a\u6d32\n            '\u82b1\u57a3\u53bf': [109.479063,28.481352], // \u682a\u6d32\n            '\u4fdd\u9756\u53bf': [109.651445,28.709605], // \u682a\u6d32\n            '\u53e4\u4e08\u53bf': [109.949592,28.516973], // \u5e38\u5fb7\n            '\u6c38\u987a\u53bf': [109.853292,28.998068],  // \u5f20\u5bb6\u754c\n            '\u9f99\u5c71\u53bf': [109.441189,29.153438]  // \u5f20\u5bb6\u754c\n        },\n        '\u5cb3\u9633\u5e02':{\n            '\u5cb3\u9633\u697c\u533a': [113.140751,29.266784], // \u957f\u6c99\n            '\u4e91\u6eaa\u533a': [113.27387,29.473395], // \u682a\u6d32\n            '\u541b\u5c71\u533a': [112.804082,29.538062], // \u682a\u6d32\n            '\u5cb3\u9633\u53bf': [113.316073,29.044843], // \u682a\u6d32\n            '\u534e\u5bb9\u53bf': [112.559369,29.524107], // \u682a\u6d32\n            '\u6e58\u9634\u53bf': [112.789748,28.677498], // \u5e38\u5fb7\n            '\u5e73\u6c5f\u53bf': [113.593751,28.701523],  // \u5f20\u5bb6\u754c\n            '\u6c68\u7f57\u5e02': [113.079419,28.703149],  // \u5f20\u5bb6\u754c\n            '\u4e34\u6e58\u5e02': [113.550809,29.471594]\n        },\n        '\u5f20\u5bb6\u754c\u5e02':{\n            '\u6c38\u5b9a\u533a': [110.384559,29.125961], // \u957f\u6c99\n            '\u6b66\u9675\u6e90\u533a': [110.54758,29.347827], // \u682a\u6d32\n            '\u6148\u5229\u53bf': [111.032702,29.423876], // \u682a\u6d32\n            '\u6851\u690d\u53bf': [110.164039,29.399939] // \u682a\u6d32\n        },\n        '\u76ca\u9633\u5e02':{\n            '\u8d44\u9633\u533a': [112.33084,28.612771], // \u957f\u6c99\n            '\u8d6b\u5c71\u533a': [112.360946,28.368327], // \u682a\u6d32\n            '\u5357\u53bf': [112.410399,29.272181], // \u682a\u6d32\n            '\u6843\u6c5f\u53bf': [111.939732,28.520993], // \u682a\u6d32\n            '\u5b89\u5316\u53bf':[111.221824,28.377421],\n            '\u6c85\u6c5f\u5e02':[112.561088,28.939713]\n        },\n        '\u6e58\u6f6d\u5e02':{\n            '\u96e8\u6e56\u533a': [112.807427,27.86077], // \u957f\u6c99\n            '\u5cb3\u5858\u533a': [112.997707,27.828854], // \u682a\u6d32\n            '\u6e58\u6f6d\u53bf': [112.752829,27.478601], // \u682a\u6d32\n            '\u6e58\u4e61\u5e02': [112.325217,27.734918], // \u682a\u6d32\n            '\u97f6\u5c71\u5e02':[112.52848,27.922682]\n        },\n        '\u682a\u6d32\u5e02':{\n            '\u8377\u5858\u533a': [113.282548,27.783036], // \u957f\u6c99\n            '\u82a6\u6dde\u533a': [113.155169,27.827246], // \u682a\u6d32\n            '\u77f3\u5cf0\u533a': [113.11295,27.871945], // \u682a\u6d32\n            '\u5929\u5143\u533a': [113.066252,27.726909], // \u682a\u6d32\n            '\u6e0c\u53e3\u533a':[113.126175,27.305844],\n            '\u6538\u53bf':[113.345774,27.000071],\n            '\u8336\u9675\u53bf':[113.645654,26.701089],\n            '\u708e\u9675\u53bf':[113.844178,26.274699],\n            '\u91b4\u9675\u5e02':[113.464077,27.557636]\n        },\n        '\u8861\u9633\u5e02': {\n            '\u73e0\u6656\u533a': [112.671137,26.876829], // \u957f\u6c99\n            '\u96c1\u5cf0\u533a': [112.60766,26.832564], // \u682a\u6d32\n            '\u77f3\u9f13\u533a': [112.604714,26.96244], // \u682a\u6d32\n            '\u84b8\u6e58\u533a': [112.543531,26.879172], // \u682a\u6d32\n            '\u5357\u5cb3\u533a':[112.696422,27.257198],\n            '\u8861\u9633\u53bf':[112.347267,27.102969],\n            '\u8861\u5357\u53bf':[112.677459,26.639973],\n            '\u8861\u5c71\u53bf':[112.86971,27.234808],\n            '\u8861\u4e1c\u53bf':[113.022238,27.079133],\n            '\u7941\u4e1c\u53bf':[111.954938,26.800476],\n            '\u8012\u9633\u5e02':[112.915707,26.418715],\n            '\u5e38\u5b81\u5e02':[112.430033,26.359289]\n        },\n        '\u90f4\u5dde\u5e02':{\n            '\u5317\u6e56\u533a': [112.889908,25.656767], // \u957f\u6c99\n            '\u82cf\u4ed9\u533a': [113.088391,25.79316], // \u682a\u6d32\n            '\u6842\u9633\u53bf': [112.601309,25.886825], // \u682a\u6d32\n            '\u5b9c\u7ae0\u53bf': [112.847884,25.194345], // \u682a\u6d32\n            '\u6c38\u5174\u53bf':[113.192019,26.209137],\n            '\u5609\u79be\u53bf':[112.407365,25.630813],\n            '\u4e34\u6b66\u53bf':[112.560747,25.339025],\n            '\u6c5d\u57ce\u53bf':[113.66981,25.550089],\n            '\u6842\u4e1c\u53bf':[113.900394,25.979584],\n            '\u5b89\u4ec1\u53bf':[113.358845,26.575557],\n            '\u8d44\u5174\u5e02':[113.45746,25.932234]\n        },\n        '\u90b5\u9633\u5e02':{\n            '\u53cc\u6e05\u533a': [111.546436,27.241775], // \u957f\u6c99\n            '\u5927\u7965\u533a': [111.455515,27.159475], // \u682a\u6d32\n            '\u5317\u5854\u533a': [111.420079,27.248192], // \u682a\u6d32\n            '\u65b0\u90b5\u53bf': [111.464608,27.425567], // \u682a\u6d32\n            '\u90b5\u9633\u53bf':[111.225512,26.929422],\n            '\u9686\u56de\u53bf':[110.965394,27.346434],\n            '\u6d1e\u53e3\u53bf':[110.592108,27.09772],\n            '\u7ee5\u5b81\u53bf':[110.199275,26.707518],\n            '\u65b0\u5b81\u53bf':[110.917976,26.541665],\n            '\u57ce\u6b65\u82d7\u65cf\u81ea\u6cbb\u53bf':[110.318488,26.318776],\n            '\u6b66\u5188\u5e02':[110.739073,26.781347],\n            '\u90b5\u4e1c\u5e02':[111.850315,27.187043]\n        },\n        '\u6000\u5316\u5e02':{\n            '\u9e64\u57ce\u533a': [109.947186,27.611957], // \u957f\u6c99\n            '\u4e2d\u65b9\u53bf': [110.160324,27.508841], // \u682a\u6d32\n            '\u6c85\u9675\u53bf': [110.595225,28.570921], // \u682a\u6d32\n            '\u8fb0\u6eaa\u53bf': [110.265855,27.990091], // \u682a\u6d32\n            '\u6e86\u6d66\u53bf':[110.650583,27.831449],\n            '\u4f1a\u540c\u53bf':[109.803953,26.908949],\n            '\u9ebb\u9633\u82d7\u65cf\u81ea\u6cbb\u53bf':[109.722413,27.784229],\n            '\u65b0\u6643\u4f97\u65cf\u81ea\u6cbb\u53bf':[109.161744,27.22862],\n            '\u82b7\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf':[109.603294,27.395167],\n            '\u9756\u5dde\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u53bf':[109.584585,26.542872],\n            '\u901a\u9053\u4f97\u65cf\u81ea\u6cbb\u53bf':[109.736712,26.208635],\n            '\u6d2a\u6c5f\u5e02':[110.27934,27.182457]\n        },\n        '\u5a04\u5e95\u5e02':{\n            '\u5a04\u661f\u533a': [112.008845,27.71829], // \u957f\u6c99\n            '\u53cc\u5cf0\u53bf': [112.184985,27.448684], // \u682a\u6d32\n            '\u65b0\u5316\u53bf': [111.238328,27.867886], // \u682a\u6d32\n            '\u51b7\u6c34\u6c5f\u5e02': [111.48582,27.681492], // \u682a\u6d32\n            '\u6d9f\u6e90\u5e02':[111.782213,27.742378]\n        }\n    }\n\nvar cameraObj = " + camera + ";\n");
        stringHtml.append("    // \u53ef\u88ab\u9009\u62e9\u7684\u9762 \u7ec4\n    var chooseMesh = null;\n    var clock = new THREE.Clock();\n    // \u80cc\u666f\u5706\u70b9\n    // var rangeSize = 2000;\n    // var divisions = 25;\n    var gridColor = 0x007090;\n    var RColor = 0x666666;\n    var ground1 = addGround(50, 150, gridColor, 0.03, RColor);\n    ground1.position.x += 110;\n    ground1.position.y += 28;\n    scene.add(ground1);\n\n    // \u80cc\u666f\u5927\u5706\u5708\n    var groundImageMesh1 = addGroundImageMesh1(imageUrl + 'circle2.png', 6.8, 6.8);\n    groundImageMesh1.position.x += provinceCenter.x;\n    groundImageMesh1.position.y += provinceCenter.y;\n    groundImageMesh1.position.z -= 0.03;\n    scene.add(groundImageMesh1);\n\n    var groundImageMesh2 = addGroundImageMesh1(imageUrl + 'circle3.png', 7.5, 7.5);\n    // groundImageMesh.rotateX(-Math.PI / 2);\n    groundImageMesh2.position.x += provinceCenter.x;\n    groundImageMesh2.position.y += provinceCenter.y;\n    groundImageMesh2.position.z -= 0.02;\n    scene.add(groundImageMesh2);\n    var loader = new THREE.FileLoader();\n    loader.setResponseType('json');\n    var jsonBase = \"##plugin/pluginResource/data/three/hunan3DMap/\";\n    // \u7701\u8fb9\u7ebf\u5899\u52a8\u753b\u7528\n    var aniLineGeometry = null;\n\n    $('.return').unbind().bind('click' , function (event){\n        event.stopPropagation();\n        returnToP();\n    });\n\n    addLight();\n    loadProvinceJson();\n\n\n    var renderWidth = window.innerWidth;\n    var renderHeight = window.innerHeight;\n    var camera = new THREE.PerspectiveCamera(45, window.innerWidth / window.innerHeight, 0.01, 15000);\n    var labelRenderer = new CSS3DRenderer();\n    renderer = new THREE.WebGLRenderer({antialias: true}); // depth: true, logarithmicDepthBuffer: true\n    var controls = new THREE.OrbitControls(camera, renderer.domElement);\n\n    setCamera(\"\u6e56\u5357\u7701\");\n\n    render();\n\n    function render() {\n        const delta = clock.getDelta();\n        if (null != aniLineGeometry) {\n            provinceLineAniPointIndex1 += delta * 60;\n            if (provinceLineAniPointIndex1 >= provinceLinePointCount)\n                provinceLineAniPointIndex1 = 0;\n\n            provinceLineAniPointIndex2 += delta * 60;\n            if (provinceLineAniPointIndex2 >= provinceLinePointCount)\n                provinceLineAniPointIndex2 = 0;\n\n            setProvinceLineAniColor(\n                aniLineGeometry,\n                provinceLinePointCount,\n                provinceLineAniPointCount,\n                provinceLineAniPointIndex1,\n                provinceLineAniPointIndex2\n            );\n        }\n\n        if (null != wallMaterialShader) {\n            if(provinceFlag){\n                wallMaterialShader.uniforms.wallAniStartPoint.value += (delta * 0.08);\n            }else{\n                wallMaterialShader.uniforms.wallAniStartPoint.value += (delta * 0.03);\n            }\n            if (wallMaterialShader.uniforms.wallAniStartPoint.value > mapExtrudeHeight)\n                wallMaterialShader.uniforms.wallAniStartPoint.value = 0;\n            // console.log('wallAniStartPoint:', wallMaterialShader.uniforms.wallAniStartPoint.value);\n        }\n\n        if (null != aniPlaneShader.value) {\n            aniPlaneShader.value.uniforms.currR.value += (delta * groundCircleAniSpeed);  // 10\u63a7\u5236\u53d1\u6563\u901f\u5ea6\n            if (aniPlaneShader.value.uniforms.currR.value > 100)\n                aniPlaneShader.value.uniforms.currR.value = initAniPlaneRadius;\n        }\n\n        if (null != aniCityPlaneShader.value) {\n            aniCityPlaneShader.value.uniforms.currR.value += (delta * 0.08);\n            if (aniCityPlaneShader.value.uniforms.currR.value > 0.2)\n                aniCityPlaneShader.value.uniforms.currR.value = -0.3;\n\n            if (aniCityPlaneShader.value.uniforms.currR.value > 0)\n                aniCityPlaneShader.value.uniforms.outOpacity.value = (0.2 - aniCityPlaneShader.value.uniforms.currR.value) / 0.2;\n            else\n                aniCityPlaneShader.value.uniforms.outOpacity.value = 0;\n        }\n\n        groundImageMesh1.rotateZ(delta * 0.15);\n        groundImageMesh2.rotateZ(-delta * 0.15);\n\n        if (flyLineShaderArr.length > 0) {\n            for (var i = 0; i < flyLineShaderArr.length; i++) {\n                flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value += delta * (flyLineShaderArr[i].uniforms.pointCount.value / 2.2);\n                if (flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value > flyLineShaderArr[i].uniforms.pointCount.value * 3)\n                    flyLineShaderArr[i].uniforms.currflyLineHighLightIndex.value = 0.0;\n            }\n        }\n        renderer.clear();\n        renderer.render(scene, camera);\n        labelRenderer.render(scene, camera);\n        // renderer.render(scene, camera);\n        controls.update();\n\n        // mesh.rotateY(0.01);\n        requestAnimationFrame(render);\n        // frame.update(delta).updateNode(groundMirrorMaterial);\n    }\n\n    function loadJsonFinished(cityName) {\n\n        if (!isFinishLoadJson1 || !isFinishLoadJson2)\n            return;\n\n        $.each(meshObj[cityName], function (key, e) {\n            var flyLinePlane;\n            if(cityName == '\u6e56\u5357\u7701'){\n                flyLinePlane = createFlyLinePlane(e, 0.2, 0.2, mapExtrudeHeight, imageUrl + '11.png');\n            }else{\n                flyLinePlane = createFlyLinePlane1(e, 0.2, 0.2, mapExtrudeHeight, imageUrl + '11.png');\n            }\n            flyLinePlaneArr.push(flyLinePlane);\n            scene.add(flyLinePlane);\n            var pillar1;\n            if(cityName == '\u6e56\u5357\u7701'){\n                pillar1 = createPillar(e, 0.03, 0.3, mapExtrudeHeight);\n            }else{\n                pillar1 = createPillar1(e, 0.03, 0.3, mapExtrudeHeight);\n            }\n            scene.add(pillar1);\n            var label1;\n            if(cityName == '\u6e56\u5357\u7701'){\n                label1 = createCityLabel(e, 0.25, mapExtrudeHeight, key, 'CHANGSHA', areaDataObj[key], 1);\n            }else{\n                label1 = createCityLabel1(e, 0.25, mapExtrudeHeight, key, 'CHANGSHA', areaDataObj[key], 1);\n            }\n            scene.add(label1);\n        })\n        // \u5927\u5730\u53d1\u6563\u5706\u5708\u52a8\u753b\n\n        if(cityName == '\u6e56\u5357\u7701'){\n            scene.add(aniPlane);\n        }else{\n            scene.remove(aniPlane);\n        }\n\n    }\n\n    var currSelMesh = null;\n\n    function onMouseMove(event) {\n        if (chooseMesh && chooseMesh.isAllowedChangeColor) {\n            chooseMesh.material.transparent = false;\n            chooseMesh.geometry.setAttribute('color', chooseMesh.colorAttribute_noSel);\n            chooseMesh.geometry.attributes.position.needsUpdate = true;\n        }\n\n        var sx = event.clientX;\n        var sy = event.clientY;\n\n        var x = (sx / window.innerWidth) * 2 - 1;\n        var y = -(sy / window.innerHeight) * 2 + 1;\n\n        var raycaster = new THREE.Raycaster();\n        raycaster.setFromCamera(new THREE.Vector2(x, y), camera);\n        var intersects = raycaster.intersectObjects(shapeGroup.children);\n        if (intersects.length > 0) {\n            chooseMesh = intersects[0].object;\n            if (chooseMesh.isAllowedChangeColor) {\n                chooseMesh.material.transparent = true;\n                chooseMesh.material.opacity = provincePlaneOpacity;\n                // chooseMesh.material.color.set(selectedColor);\n                chooseMesh.geometry.setAttribute('color', chooseMesh.colorAttribute_sel);\n                chooseMesh.geometry.attributes.position.needsUpdate = true;\n            }\n        } else {\n\n        }\n    }  // onMouseDown end\n\n    function onMouseClick(event) {\n\n        if(provinceFlag){\n            if(chooseMesh.name != '\u6e56\u5357\u7701' && $.inArray(chooseMesh.name , cityNameArray) != -1){\n                provinceFlag = false;\n                for (let i = scene.children.length - 1; i >= 0; i--) {\n                    let obj = scene.children[i];\n                    scene.remove(obj)\n                }\n                lineGroup.traverse(child => {\n                    if (child.isMesh) {\n                        child.geometry.dispose();\n                        child.material.dispose();\n                    }\n                });\n\n                shapeGroup.traverse(child => {\n                    if (child.isMesh) {\n                        child.geometry.dispose();\n                        child.material.dispose();\n                    }\n                });\n\n                lineGroup = new THREE.Group();\n                shapeGroup = new THREE.Group();\n\n                scene.remove(groundImageMesh1);\n                scene.remove(groundImageMesh2);\n\n                curMesh = chooseMesh.name;\n\n                addLight();\n                loadCityJson(chooseMesh.name);\n                setCamera(chooseMesh.name);\n                mapExtrudeHeight = 0.1;\n                $('.return').show();\n                render();\n\n            }\n\n        }else{\n            if($.inArray(chooseMesh.name , cityNameArray) !=  -1 && chooseMesh.name != curMesh){\n                for (let i = scene.children.length - 1; i >= 0; i--) {\n                    let obj = scene.children[i];\n                    scene.remove(obj)\n                }\n\n\n                lineGroup.traverse(child => {\n                    if (child.isMesh) {\n                        child.geometry.dispose();\n                        child.material.dispose();\n                    }\n                });\n\n                shapeGroup.traverse(child => {\n                    if (child.isMesh) {\n                        child.geometry.dispose();\n                        child.material.dispose();\n                    }\n                });\n\n                lineGroup = new THREE.Group();\n                shapeGroup = new THREE.Group();\n                curMesh = chooseMesh.name;\n                addLight();\n                loadCityJson(chooseMesh.name);\n                setCamera(chooseMesh.name);\n                mapExtrudeHeight = 0.1;\n                render();\n            }else{\n                console.log(chooseMesh.name);\n            }\n        }\n    }\n\n    function returnToP(){\n        $('.return').hide();\n        provinceFlag = true;\n\n        for (let i = scene.children.length - 1; i >= 0; i--) {\n            let obj = scene.children[i];\n            scene.remove(obj)\n        }\n\n\n        lineGroup.traverse(child => {\n            if (child.isMesh) {\n                child.geometry.dispose();\n                child.material.dispose();\n            }\n        });\n\n        shapeGroup.traverse(child => {\n            if (child.isMesh) {\n                child.geometry.dispose();\n                child.material.dispose();\n            }\n        });\n\n\n        lineGroup = new THREE.Group();\n        shapeGroup = new THREE.Group();\n        addLight();\n        loadProvinceJson();\n        setCamera('\u6e56\u5357\u7701');\n        mapExtrudeHeight = 0.3;\n        render();\n        scene.add(groundImageMesh1);\n        scene.add(groundImageMesh2);\n    }\n\n    function onResize(event) {\n        renderWidth = window.innerWidth;\n        renderHeight = window.innerHeight;\n        renderer.setSize(renderWidth, renderHeight);\n        renderer.domElement.style.width = `${renderWidth}px`; // \u8bbe\u7f6eHTML\u753b\u5e03\u7684\u5b9e\u9645\u663e\u793a\u5c3a\u5bf8\n        renderer.domElement.style.height = `${renderHeight}px`;\n        labelRenderer.setSize(renderWidth, renderHeight);\n\n        camera.aspect = renderWidth / renderHeight;\n        // \u66f4\u65b0\u76f8\u673a\u7684\u6295\u5f71\u77e9\u9635 \u5fc5\u5199\n        camera.updateProjectionMatrix();\n    }\n\n    function createAreaLine(pointArr, lineColor) {\n        var geometry = new THREE.BufferGeometry();\n        var vertices = new Float32Array(pointArr);\n        var attribute = new THREE.BufferAttribute(vertices, 3);\n        geometry.attributes.position = attribute;\n        var material = new THREE.LineBasicMaterial({\n            color: lineColor,  //0x00ffff 0x00B2DF\n            // depthWrite: false,\n        });\n        var line = new THREE.LineLoop(geometry, material);\n        return line;\n    }\n\n    function createAreaMesh(vector2Arr, meshHeight, meshColor) {\n        var material = new THREE.MeshPhongMaterial({\n            color: meshColor, //0x1C394C 0x004444  0x00B2DF\n            side: THREE.DoubleSide,// THREE.FrontSide // THREE.BackSide // THREE.DoubleSide,\n            // depthTest: false,\n            // depthWrite: false,\n        });\n\n        var shape = new THREE.Shape(vector2Arr);\n        // console.log(vector2Arr);\n        // var geometry = new THREE.ShapeBufferGeometry(shape);\n        var geometry = new THREE.ExtrudeBufferGeometry(\n            shape,\n            {\n                depth: meshHeight,  // \u62c9\u4f38\n                bevelEnabled: false\n            }\n        );\n        var mesh = new THREE.Mesh(geometry, material);\n        return mesh;\n    }\n\n    // \u57ce\u5e02\u533a\u5757\n    function createShapePlaneMesh(vector2Arr, meshHeight, meshColor, isAllowedChangeColor) {\n        var material;\n\n        if (isAllowedChangeColor) {\n            material = new THREE.MeshPhysicalMaterial({\n                vertexColors: THREE.VertexColors,\n            });\n        } else {\n            material = new THREE.MeshPhysicalMaterial({\n                color: meshColor, //0x1C394C 0x004444  0x00B2DF 0x0C2437\n                side: THREE.DoubleSide,// THREE.FrontSide // THREE.BackSide // THREE.DoubleSide,\n            });\n        }\n\n        var shape = new THREE.Shape(vector2Arr);\n        // \u521b\u5efa\u51e0\u4f55\u4f53\n        var geometry = new THREE.ShapeGeometry(shape);\n\n        var colorAttribute_noSel;\n        var colorAttribute_sel;\n        if (isAllowedChangeColor) {\n            // console.log(geometry.attributes.position.array);\n            let minY = 0;\n            let maxY = 0;\n            for (let i = 0; i < geometry.attributes.position.count; i++) {\n                if (i == 0) {\n                    minY = geometry.attributes.position.array[i * 3 + 1];\n                    maxY = geometry.attributes.position.array[i * 3 + 1];\n                } else {\n                    if (minY > geometry.attributes.position.array[i * 3 + 1])\n                        minY = geometry.attributes.position.array[i * 3 + 1];\n                    if (maxY < geometry.attributes.position.array[i * 3 + 1])\n                        maxY = geometry.attributes.position.array[i * 3 + 1];\n                }\n            }\n\n            minY *= 10000;\n            maxY *= 10000;\n\n            let intervalY = maxY - minY;\n            let R1 = 14;\n            let G1 = 23;\n            let B1 = 66;\n            let R2 = 15;\n            let G2 = 26;\n            let B2 = 70;\n\n            let R3 = R1 - R2;\n            let G3 = G1 - G2;\n            let B3 = B1 - B2;\n\n            // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n            const colors = [];\n            const vertexCount = geometry.attributes.position.count;\n            for (let i = 0; i < vertexCount; i++) {\n                let y = geometry.attributes.position.array[i * 3 + 1];\n                let scaleY = (y * 10000 - minY) / intervalY / 0.05;  // 0.3\u8868\u793a\u6e10\u53d8\u901f\u5ea6\uff0c\u8d8a\u5c0f\u8d8a\u4ee5\u4e0a\u9762\u8272\u4e3a\u4e3b\n                colors.push((scaleY * R3 + R2) / 255, (scaleY * G3 + G2) / 255, (scaleY * B3 + B2) / 255);\n            }\n\n            // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n            colorAttribute_noSel = new THREE.BufferAttribute(new Float32Array(colors), 3);\n            geometry.setAttribute('color', colorAttribute_noSel);\n\n            // \u9009\u4e2d\u6e10\u53d8\u4e0a\u7aef\u8272\n            let R4 = 49;\n            let G4 = 143;\n            let B4 = 222;\n\n            // \u6e10\u53d8\u4e0b\u7aef\u8272\n            let R5 = 93;\n            let G5 = 162;\n            let B5 = 218;\n\n            let R6 = R4 - R5;\n            let G6 = G4 - G5;\n            let B6 = B4 - B5;\n\n            // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n            const colors1 = [];\n            for (let i = 0; i < vertexCount; i++) {\n                let y = geometry.attributes.position.array[i * 3 + 1];\n                let scaleY = (y * 10000 - minY) / intervalY / 0.5;  // 0.3\u8868\u793a\u6e10\u53d8\u901f\u5ea6\uff0c\u8d8a\u5c0f0.2\u8d8a\u4ee5\u4e0a\u9762\u8272\u4e3a\u4e3b\n                // \u8fd9\u91cc\u7b80\u5355\u5730\u4f7f\u7528\u968f\u673a\u989c\u8272\uff0c\u4f60\u9700\u8981\u6839\u636e\u4f60\u7684\u9700\u6c42\u6765\u786e\u5b9a\u6bcf\u4e2a\u9876\u70b9\u7684\u989c\u8272\n                // colors.push((scaleY * R3 + R2) / 255, (scaleY * G3 + G2) / 255, (scaleY * B3 + B2) / 255);\n                colors1.push((scaleY * R6 + R5) / 255, (scaleY * G6 + G5) / 255, (scaleY * B6 + B5) / 255);\n                // colors.push(Math.random(), Math.random(), Math.random());\n                // console.log(colors);\n            }\n\n            // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n            colorAttribute_sel = new THREE.BufferAttribute(new Float32Array(colors1), 3);\n        }\n\n        // \u521b\u5efa\u7f51\u683c\n        var mesh = new THREE.Mesh(geometry, material);\n        mesh.position.z += meshHeight;\n\n        mesh.isAllowedChangeColor = isAllowedChangeColor;\n        if (isAllowedChangeColor) {\n            mesh.colorAttribute_noSel = colorAttribute_noSel;\n            mesh.colorAttribute_sel = colorAttribute_sel;\n        }\n\n        return mesh;\n    }\n\n    function createWallMaterial(isShowAni) {\n        var wallMaterial = new THREE.MeshBasicMaterial({\n            color: provinceWallColor,\n            side: isShowAni ? THREE.FrontSide : THREE.BackSide,  // THREE.Front DoubleSide\n        });\n\n        if (isShowAni) {\n            wallMaterial.onBeforeCompile = function (shader) {\n                wallMaterialShader = shader;\n\n                shader.uniforms.wallHeight = {value: mapExtrudeHeight};\n                shader.uniforms.wallAniStartPoint = {value: wallAniStartPoint};\n                shader.uniforms.wallColor = {value: new THREE.Color(provinceWallColor)};\n                shader.uniforms.wallHighLightColor = {value: new THREE.Color(wallHighLightColor)};\n\n                shader.vertexShader = shader.vertexShader.replace(\n                    'void main() {',\n                    ['varying vec3 vPos;',\n                        'void main() {',\n                        'vPos = position;',\n                    ].join('\\n')\n                )\n                // console.log('vertexShader: ', shader.vertexShader);\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'void main() {',\n                    ['uniform float wallHeight;',\n                        'uniform float wallAniStartPoint;',\n                        'uniform vec3 wallColor;',\n                        'uniform vec3 wallHighLightColor;',\n                        'varying vec3 vPos;',\n                        'void main() {',\n                    ].join('\\n')\n                )\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                    wall_output_fragment\n                )\n            }\n\n            // console.log('fragmentShader: ', shader.fragmentShader);\n        }\n        return wallMaterial;\n    }\n\n    // \u6ca1\u6709\u52a8\u753b\u7684\u6750\u8d28\n    var wallNotAniMaterial = createWallMaterial(false);\n    // \u6709\u52a8\u753b\u7684\u6750\u8d28\n    var wallAniMaterial = createWallMaterial(true);\n\n    // c\u662f\u4e8c\u7ef4\u5411\u91cf\u6570\u7ec4\uff0ch\u662f\u62c9\u4f38\u9ad8\u5ea6\uff0ctextureFileName\u662f\u7eb9\u7406\u56fe\u7247\u540d\u79f0\uff0ccolor1\u662f\u989c\u8272\uff0copacity1\u662f\u900f\u660e\u5ea6\n    function createWallMesh(c, h, textureFileName, color1, opacity1, isShowAni) {\n        // \u521b\u5efa\u51e0\u4f55\u4f53\n        const geometry1 = new THREE.BufferGeometry();\n        var posArr = [];\n        var uvArr = [];\n        for (var i = 0; i < c.length - 1; i++) {\n            posArr.push(c[i].x, c[i].y, 0, c[i + 1].x, c[i + 1].y, 0, c[i + 1].x, c[i + 1].y, h);\n            // \u7b2c\u4e8c\u4e2a\u9762\uff0c\u5de6\u4e0b\u89d2 \u53f3\u4e0a\u89d2 \u5de6\u4e0a\u89d2\n            posArr.push(c[i].x, c[i].y, 0, c[i + 1].x, c[i + 1].y, h, c[i].x, c[i].y, h);\n            // \u6307\u5b9a\u5bf9\u5e94UV\u5750\u6807 2\u4e2a\u4e00\u7ec4\n            uvArr.push(0, 0, 1, 0, 1, 1);\n            uvArr.push(0, 0, 1, 1, 0, 1);\n        }\n\n        //\u8bbe\u7f6e\u513f\u4f55\u4f53attributes\u5c5e\u6027\u7684\u4f4d\u7f6eposition\u5a32\u6027\n        geometry1.attributes.position = new THREE.BufferAttribute(new Float32Array(posArr), 3);\n        geometry1.attributes.uv = new THREE.BufferAttribute(new Float32Array(uvArr), 2);\n        geometry1.computeVertexNormals();\n\n        const mesh = new THREE.Mesh(geometry1, isShowAni ? wallAniMaterial : wallNotAniMaterial);\n        return mesh;\n    }\n\n    function createCityLabel(p, height, meshHeight, cityName, cityPinyin, peopleCount, order) {\n        var div = document.createElement('div');\n        // div.innerHTML = '<div class=\"label-div\"><div class=\"count-div\"><span class=\"count-left\">51</span><span class=\"count-right\">\u4e07\u4eba</span></div><div class=\"city-div\"><div class=\"city-name\">\u6c38\u5dde\u5e02</div><div class=\"city-py\">Maoming</div></div><div class=\"number-div fluorescent-number\">6</div></div>'; //\u6e56\u5357\u7701\n        div.innerHTML = '<div class=\"label-div\"><div class=\"count-div\">' + peopleCount + '</div><div class=\"name-div\">' + cityName + '</div></div>'; //\u6e56\u5357\u7701\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n        var label = new CSS3DObject(div);\n        label.scale.set(0.006, 0.006, 0.006);\n        label.position.set(p[0], p[1], height + meshHeight + 0.3);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createCityLabel1(p, height, meshHeight, cityName, cityPinyin, peopleCount, order) {\n        var div = document.createElement('div');\n        // div.innerHTML = '<div class=\"label-div\"><div class=\"count-div\"><span class=\"count-left\">51</span><span class=\"count-right\">\u4e07\u4eba</span></div><div class=\"city-div\"><div class=\"city-name\">\u6c38\u5dde\u5e02</div><div class=\"city-py\">Maoming</div></div><div class=\"number-div fluorescent-number\">6</div></div>'; //\u6e56\u5357\u7701\n        div.innerHTML = '<div class=\"label-div-1\"><div class=\"count-div-1\">' + peopleCount + '</div><div class=\"name-div-1\">' + cityName + '</div></div>'; //\u6e56\u5357\u7701\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n        var label = new CSS3DObject(div);\n        label.scale.set(0.003, 0.003, 0.003);\n        label.position.set(p[0], p[1], height + meshHeight/4);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createProvinceNameLabel(p) {\n        var div = document.createElement('div');\n        div.innerHTML = '\u6e56\u5357\u7701'; //\n        div.style.userSelect = 'none';\n        div.style.pointerEvents = 'none';\n        div.style.padding = '1px 0.5px';\n        div.style.color = '#ffffff';\n        div.style.fontSize = '5px';\n        div.style.textAlign = 'center';\n        div.style.position = 'absolute';\n        div.style.backgroundColor = 'rgba(25, 25, 25, 0.4)';\n        div.style.borderRadius = '3px';\n\n        var label = new CSS3DObject(div);\n        // label.position.x = x;\n        // label.position.y = y;\n        // label.position.z = 1.0;\n        label.scale.set(0.03, 0.03, 0.03);\n        label.position.set(p[0], p[1], 0.1);\n        label.rotateX(Math.PI / 2);\n        return label;\n    }\n\n    function createPlane() {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.5, 0.5);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            map: textureLoader.load('image/\u6e56\u5357.png'),\n            side: THREE.DoubleSide,\n            transparent: true,\n        });\n        var planeMesh = new THREE.Mesh(plane, planeMaterial);\n        return planeMesh;\n    }\n\n    // rangeSize\u8303\u56f4 divisions\u5706\u70b9\u4e2a\u6570\n    function addGround(rangeSize, divisions, gridColor, R, RColor) {\n        var group = new THREE.Group();\n        var interval = rangeSize / divisions;\n        var range1 = rangeSize / 2;\n        var geoArr = [];\n        for (var i = 0; i < divisions; i++) {\n            for (var j = 0; j < divisions; j++) {\n                var geometry = new THREE.CircleBufferGeometry(R, 20, 20);\n                geometry.rotateX(Math.PI / 2);\n                geometry.translate(-range1 + i * interval, 0.05, -range1 + j * interval);\n                geoArr.push(geometry);\n            }\n        }\n        var bufferGeo = THREE.BufferGeometryUtils.mergeBufferGeometries(geoArr);\n\n        var material = new THREE.MeshBasicMaterial({\n            color: gridColor,\n            side: THREE.DoubleSide,\n            transparent: true,\n            opacity: 0.3,\n            // depthTest: false,\n            // depthWrite: false\n        });\n        var mesh = new THREE.Mesh(bufferGeo, material);\n        mesh.position.y -= 0.1;\n        // mesh.renderOrder = 4;\n        group.add(mesh);\n        group.rotateX(Math.PI / 2);\n\n        return group;\n    }\n\n    function addGroundImageMesh1(imageFile, width, height) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(width, height);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            color: groundImageColor,\n            map: textureLoader.load(imageFile),\n            side: THREE.FrontSide,\n            transparent: true,\n            opacity: 0.3,\n            // depthTest: false,\n        });\n        var goundImageMesh = new THREE.Mesh(plane, planeMaterial);\n        return goundImageMesh;\n    }\n\n    // germetry\u88ab\u4fee\u6539\u7684\u51e0\u4f55\u4f53\uff0cpointCount\u662fline\u4e0a\u6240\u6709\u70b9\u7684\u6570\u91cf\uff0caniPointCount\u53c2\u4e0e\u52a8\u753b\u70b9\u7684\u6570\u91cf\uff0c index1 index2\u662f\u4e24\u6bb5\u52a8\u753b\u5f00\u59cb\u7684\u8d77\u59cb\u70b9\n    function setProvinceLineAniColor(geometry, pointCount, aniPointCount, index1, index2) {\n        var color1 = new THREE.Color(provinceLineHighLightColor); // provinceLineHighLightColor 0x99ffff\n        var color2 = new THREE.Color(provinceLineColor);\n\n        // begin\u7684\u4f4d\u7f6e\u5927\u4e8eindex\u4f4d\u7f6e\n        var begin1 = index1 + aniPointCount;\n        if (begin1 > pointCount)\n            begin1 -= pointCount;\n\n        var begin2 = index2 + aniPointCount;\n        if (begin2 > pointCount)\n            begin2 -= pointCount;\n        // console.log('end', end1, end2);\n\n        var colorArr = [];\n        for (var i = 0; i < pointCount; i++) {\n            var color = color2;\n            // \u5f53\u524d\u70b9\u662f\u5426\u5728\u52a8\u753b\u4e2d\uff0cindex:-1\u662f\u4e0d\u5728\u52a8\u753b\u533a\u57df\u4e2d\uff0c>0\u8868\u793a\u5728\u52a8\u753b\u4e2d\u7684\u7b2c\u51e0\u4e2a\u70b9\n            var index = -1;\n\n            // \u7b2c\u4e00\u6bb5\u52a8\u753b\u8bbe\u7f6e\n            if (begin1 > index1) { // \u7b2c\u4e00\u6bb5\u52a8\u753b\u6b63\u5e38\u987a\u5e8f\n                if (i <= begin1 && i >= index1) {\n                    index = begin1 - i;\n                    // console.log('index 1', begin1, i, index);\n                }\n            } else { // \u7b2c\u4e00\u6bb5\u52a8\u753b\u8d85\u8fc7\u7ed3\u5c3e\u5904\n                if (i >= 0 && i <= begin1) {\n                    index = begin1 - i;\n                } else if (i >= index1 && i < pointCount) {\n                    index = begin1 + (pointCount - i);\n                }\n                // console.log('index 2', i, index);\n            }\n\n            // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u8bbe\u7f6e\n            if (begin2 > index2) { // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u6b63\u5e38\u987a\u5e8f\n                if (i <= begin2 && i >= index2) {\n                    index = begin2 - i;\n                    // console.log('index 2', begin2, i, index);\n                }\n            } else { // \u7b2c\u4e8c\u6bb5\u52a8\u753b\u8d85\u8fc7\u7ed3\u5c3e\u5904\n                if (i >= 0 && i <= begin2) {\n                    index = begin2 - i;\n                } else if (i >= index2 && i < pointCount) {\n                    index = begin2 + (pointCount - i);\n                }\n                // console.log('index 2', i, index);\n            }\n\n            // if (i == 0)\n            //   console.log('index 1', index);\n            // if (i == 965 )\n            //   console.log('index 2', index);\n\n            if (-1 != index) {\n                color = color1.clone().lerp(color2, index / aniPointCount);\n                // color = new THREE.Color(0xff0000);\n\n                // if (i == 0)\n                //   console.log('color 0:', index, aniPointCount, color, color1, color2);\n\n                // if (i == 965)\n                //   console.log('color 965:', index, aniPointCount, color, color1, color2);\n            }\n\n            colorArr.push(color.r, color.g, color.b);\n        }\n        // console.log('colorArr count:', colorArr.length);\n\n        geometry.attributes.color = new THREE.BufferAttribute(new Float32Array(colorArr), 3);\n        // geometry.colorsNeedUpdate = true;\n    }\n\n    function createFlyLine(p1, p2, meshHeight) {\n        // console.log(p1, p2);\n        var p_1 = new THREE.Vector3(p1[0], p1[1], meshHeight);  // mapExtrudeHeight\n        var p_2 = new THREE.Vector3(p2[0], p2[1], meshHeight);\n        var midPoint = new THREE.Vector3();\n        midPoint.addVectors(p_1, p_2).divideScalar(2);\n        // midPoint.z = p_1.clone().sub(p_2).length() / 4;\n        // \u98de\u7ebf\u9ad8\u5ea6\n        midPoint.z = 1.2;\n        var curve = new THREE.QuadraticBezierCurve3(p_1, midPoint, p_2);\n\n        var vectorDifference = new THREE.Vector3().subVectors(p_1, p_2);\n        // \u83b7\u53d6\u5411\u91cf\u7684\u957f\u5ea6\uff0c\u5373\u4e24\u70b9\u4e4b\u95f4\u7684\u8ddd\u79bb\n        var distance = vectorDifference.length();\n        var pointCount = Math.ceil(distance * 600); // \u5411\u4e0a\u53d6\u6574 \u901a\u8fc7\u8ddd\u79bb\u6765\u786e\u5b9a\u70b9\u7684\u6570\u91cf\n        // console.log('distance:', distance);\n\n        var points = curve.getPoints(pointCount); // getSpacedPoints\n        var geometry = new THREE.BufferGeometry();\n        geometry.setFromPoints(points);\n        const indexs = [];\n        for (let i = 0; i < geometry.attributes.position.count; i++) {\n            indexs.push(i * 1.0);\n        }\n\n        const indexsAttribute = new THREE.BufferAttribute(new Float32Array(indexs), 1);\n        geometry.attributes.pointIndex = indexsAttribute;\n\n        var material = new THREE.PointsMaterial({\n            color: 0x00ffff,  // 0x0088ff\n            transparent: true,\n            // opacity: 0.25,\n            size: 0.1,\n            depthWrite: false,\n            depthTest: false, // \u9700\u8981\u5199\n        });\n        if (true) {\n            material.onBeforeCompile = function (shader) {\n                flyLineShaderArr.push(shader);\n\n                shader.uniforms.meshHeight = {value: meshHeight};\n                shader.uniforms.flyLineColor1 = {value: flyLineColor1};\n                shader.uniforms.flyLineColor2 = {value: flyLineColor2};\n                shader.uniforms.pointCount = {value: indexs.length / 1.0};\n                shader.uniforms.cityDistance = {value: distance};\n                shader.uniforms.currflyLineHighLightIndex = {value: currflyLineHighLightIndex};\n\n                // shader.uniforms.wallHighLightColor = { value: new THREE.Color(wallHighLightColor) };\n                // console.log('shader:', shader);\n\n                shader.vertexShader = shader.vertexShader.replace(\n                    'void main() {',\n                    ['attribute float pointIndex;',\n                        // 'uniform float pointCount;',\n                        // 'uniform float currflyLineHighLightIndex;',\n                        'varying vec3 vPos;',\n                        'varying float vPointIndex;',\n                        'void main() {',\n                        'vPos = position;',\n                        'vPointIndex = pointIndex;',\n                    ].join('\\n')\n                );\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'void main() {',\n                    ['uniform float meshHeight;',\n                        'uniform vec3 flyLineColor1;',\n                        'uniform vec3 flyLineColor2;',\n                        'uniform float pointCount;',\n                        'uniform float cityDistance;',\n                        'uniform float currflyLineHighLightIndex;',\n                        'varying vec3 vPos;',\n                        'varying float vPointIndex;',\n                        'void main() {',\n                    ].join('\\n')\n                )\n\n                shader.fragmentShader = shader.fragmentShader.replace(\n                    'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                    flyLine_output_fragment\n                )\n\n                // console.log('fragmentShader: ', shader.fragmentShader);\n            }\n        }\n\n        var line = new THREE.Points(geometry, material);\n        line.renderOrder = renderOrderFlyLine;\n        // console.log('line:', line);\n        return line;\n    }\n\n    // \u98de\u7ebf\u8d77\u70b9\u4e0b\u9762\u7684\u8f6c\u76d8 p\u662f\u5750\u6807 meshHeight\u6a21\u578b\u9ad8\u5ea6\uff0cimageFile\u56fe\u7247\u6587\u4ef6\n    function createFlyLinePlane(p, width, height, meshHeight, imageFile) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.2, 0.2);  // width, height\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            // color: 0x000000,\n\n            map: textureLoader.load(imageFile),\n            side: THREE.DoubleSide,\n            transparent: true,\n            // emissive: 0xffffff, // \u81ea\u53d1\u5149\u989c\u8272\uff08\u7ea2\u8272\uff09\n            // emissiveIntensity: 2.0, // \u81ea\u53d1\u5149\u5f3a\u5ea6\n            opacity: 0.9,\n            // depthWrite: false,\n        });\n        var flyLinePlane = new THREE.Mesh(plane, planeMaterial);\n\n        // flyLinePlane.rotateX(Math.PI / 2);\n        flyLinePlane.position.set(p[0], p[1], meshHeight + 0.02);\n        flyLinePlane.renderOrder = renderOrderFlyLinePlane;\n        return flyLinePlane;\n    }\n\n    function createFlyLinePlane1(p, width, height, meshHeight, imageFile) {\n        var textureLoader = new THREE.TextureLoader();\n        var plane = new THREE.PlaneGeometry(0.05, 0.05);  // width, height\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            // color: 0x000000,\n\n            map: textureLoader.load(imageFile),\n            side: THREE.DoubleSide,\n            transparent: true,\n            // emissive: 0xffffff, // \u81ea\u53d1\u5149\u989c\u8272\uff08\u7ea2\u8272\uff09\n            // emissiveIntensity: 2.0, // \u81ea\u53d1\u5149\u5f3a\u5ea6\n            opacity: 0.9,\n            // depthWrite: false,\n        });\n        var flyLinePlane = new THREE.Mesh(plane, planeMaterial);\n\n        // flyLinePlane.rotateX(Math.PI / 2);\n        flyLinePlane.position.set(p[0], p[1], meshHeight + 0.02);\n        flyLinePlane.renderOrder = renderOrderFlyLinePlane;\n        return flyLinePlane;\n    }\n\n    function createPillar(p, r, height, meshHeight) {\n        // var textureLoader = new THREE.TextureLoader();\n        // \u521b\u5efa\u5706\u67f1\u4f53\u7684\u51e0\u4f55\u4f53\u548c\u6750\u8d28\n        var geometry = new THREE.CylinderGeometry(r / 4, r, height, 32); // \u53c2\u6570\uff1a\u534a\u5f84\u9876\u90e8, \u534a\u5f84\u5e95\u90e8, \u9ad8\u5ea6, \u5206\u6bb5\u6570\n        var material = new THREE.MeshPhysicalMaterial({\n            // map: textureLoader.load(imageUrl + 'hh.png'),\n            // color: 0x66FFFF,\n            vertexColors: THREE.VertexColors,\n            transparent: true,\n            opacity: 0.6,\n        });\n\n        var color1 = new THREE.Color(0xFFFFFF); // \u5e95\n        var color2 = new THREE.Color(0x004488);\n        // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n        const colors = [];\n        const vertexCount = geometry.attributes.position.count;\n        for (let i = 0; i < vertexCount; i++) {\n            let y = geometry.attributes.position.array[i * 3 + 1];\n            var color = color1.clone().lerp(color2, (y + height / 2) / height);\n            colors.push(color.r, color.g, color.b);\n        }\n        // console.log(colors);\n        // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n        const colorAttribute = new THREE.BufferAttribute(new Float32Array(colors), 3);\n        geometry.setAttribute('color', colorAttribute);\n\n        var cylinder = new THREE.Mesh(geometry, material); // \u521b\u5efa\u7f51\u683c\u5bf9\u8c61\n        cylinder.rotateX(Math.PI / 2);\n        cylinder.position.set(p[0], p[1], meshHeight + height / 2 + 0.02);  //\n        cylinder.renderOrder = renderOrderPillar;\n        return cylinder;\n    }\n\n    function createPillar1(p, r, height, meshHeight) {\n        // var textureLoader = new THREE.TextureLoader();\n        // \u521b\u5efa\u5706\u67f1\u4f53\u7684\u51e0\u4f55\u4f53\u548c\u6750\u8d28\n        var geometry = new THREE.CylinderGeometry(r / 16, r/4, height/4, 32); // \u53c2\u6570\uff1a\u534a\u5f84\u9876\u90e8, \u534a\u5f84\u5e95\u90e8, \u9ad8\u5ea6, \u5206\u6bb5\u6570\n        var material = new THREE.MeshPhysicalMaterial({\n            // map: textureLoader.load(imageUrl + 'hh.png'),\n            // color: 0x66FFFF,\n            vertexColors: THREE.VertexColors,\n            transparent: true,\n            opacity: 0.9,\n        });\n\n        var color1 = new THREE.Color(0xFFFFFF); // \u5e95\n        var color2 = new THREE.Color(0x004488);\n        // \u521b\u5efa\u4e00\u4e2a\u4e0e\u9876\u70b9\u6570\u91cf\u76f8\u5339\u914d\u7684\u989c\u8272\u6570\u7ec4\n        const colors = [];\n        const vertexCount = geometry.attributes.position.count;\n        for (let i = 0; i < vertexCount; i++) {\n            let y = geometry.attributes.position.array[i * 3 + 1];\n            var color = color1.clone().lerp(color2, (y + height / 2) / height);\n            colors.push(color.r, color.g, color.b);\n        }\n        // console.log(colors);\n        // \u5c06\u989c\u8272\u6570\u7ec4\u8f6c\u6362\u4e3a THREE.Color \u6570\u7ec4\n        const colorAttribute = new THREE.BufferAttribute(new Float32Array(colors), 3);\n        geometry.setAttribute('color', colorAttribute);\n\n        var cylinder = new THREE.Mesh(geometry, material); // \u521b\u5efa\u7f51\u683c\u5bf9\u8c61\n        cylinder.rotateX(Math.PI / 2);\n        cylinder.position.set(p[0], p[1], meshHeight + height / 5 );  //\n        cylinder.renderOrder = renderOrderPillar;\n        return cylinder;\n    }\n\n    // p\u5706\u5fc3\u5750\u6807 circleColor\u989c\u8272\uff0cinitRadius\u8d77\u59cb\u534a\u5f84\uff0ccircleWidth\u5706\u5708\u5bbd\u5ea6\n    function createAniPlane(p, meshHeight, circleColor, initRadius, circleWidth, shaderObj) {\n        var plane = new THREE.PlaneGeometry(50, 50);\n        var planeMaterial = new THREE.MeshBasicMaterial({\n            color: circleColor, // 0x185889,\n            side: THREE.FrontSide,\n            transparent: true,\n            opacity: 0.05,\n            // depthWrite: false,\n            // depthTest: false,\n        });\n\n        planeMaterial.onBeforeCompile = function (shader) {\n            shaderObj.value = shader;\n\n            // \u5f53\u524d\u6700\u65b0\u534a\u5f84\u503c\n            shader.uniforms.currR = {value: initRadius};  // initAniPlaneRadius\n            shader.uniforms.circleWidth = {value: circleWidth};  // 5.0\n            shader.uniforms.outOpacity = {value: 1.0};  // \u5916\u90e8\u589e\u52a0\u4e00\u4e2a\u900f\u660e\u5ea6\n\n            shader.vertexShader = shader.vertexShader.replace(\n                'void main() {',\n                ['varying vec3 vPos;',\n                    'void main() {',\n                    'vPos = position;',\n                ].join('\\n')\n            )\n            // console.log('vertexShader: ', shader.vertexShader);\n\n            shader.fragmentShader = shader.fragmentShader.replace(\n                'void main() {',\n                ['uniform float currR;',\n                    'uniform float circleWidth;',\n                    'uniform float outOpacity;',\n                    'varying vec3 vPos;',\n                    'void main() {',\n                ].join('\\n')\n            )\n\n            shader.fragmentShader = shader.fragmentShader.replace(\n                'gl_FragColor = vec4( outgoingLight, diffuseColor.a );',\n                aniGroundCirclePlane_output_fragment\n            )\n        }\n\n        var planeMesh = new THREE.Mesh(plane, planeMaterial);\n        planeMesh.position.set(p[0], p[1], meshHeight);\n        return planeMesh;\n    }\n\n    function createMirror() {\n\n    }\n\n    function loadProvinceJson() {\n        if (true) { // \u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd(\u7701)\n            loader.load(isShowAllProvinceLine ? jsonBase + 'geo/\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd(\u7701).json' : jsonBase + 'geo/\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd.json', function (data) {\n                data.features.forEach(function (area) {\n                    var mesh = null;\n\n                    if (area.geometry.type === \"Polygon\") {\n                        // console.log('Polygon');\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            area.geometry.coordinates[0].forEach((elem) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            line = createAreaLine(pointArr, chinaLineColor);\n                            line.position.z = 0.04;\n                            lineGroup.add(line);\n\n                            mesh = createShapePlaneMesh(vector2Arr, 0.01, chinaPlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            mesh.position.z -= 0.05;\n                            shapeGroup.add(mesh);\n                        });\n                    } else if (area.geometry.type === \"MultiPolygon\") {\n                        // console.log('MultiPolygon');\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            polygon[0].forEach((elem, i) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            line = createAreaLine(pointArr, chinaLineColor);\n                            line.position.z -= 0.04;\n                            lineGroup.add(line);\n\n                            mesh = createShapePlaneMesh(vector2Arr, 0.01, chinaPlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            mesh.position.z -= 0.05;\n                            shapeGroup.add(mesh);\n                        });\n                    }\n                });\n            });  // end load\n        }\n        if (true) {\n            loader.load(jsonBase + 'geo/\u6e56\u5357\u7701(\u5e02).json', function (data) {\n                data.features.forEach(function (area) {\n                    var mesh = null;\n\n                    if (area.geometry.type === \"Polygon\") {\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            area.geometry.coordinates[0].forEach((elem) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            // console.log('vector2Arr.length: ', vector2Arr.length);\n                            line = createAreaLine(pointArr, provinceLineColor);\n                            line.position.z += mapExtrudeHeight + 0.01;\n                            lineGroup.add(line);\n\n                            // \u5e95\u9762\n                            mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n\n                            mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                            mesh.renderOrder = renderOrderGroundPlane;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n\n                            // chooseMeshArrObj[mesh.name] = mesh;\n\n                            wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                            wallMesh.renderOrder = renderOrderNoTransparent;\n                            // console.log('wallMesh: ', wallMesh);\n                            scene.add(wallMesh);\n                        });\n                    } else if (area.geometry.type === \"MultiPolygon\") {\n                        // console.log('MultiPolygon');\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            polygon[0].forEach((elem, i) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            // console.log('vector2Arr.length1: ', vector2Arr.length);\n                            line = createAreaLine(pointArr, provinceLineColor);\n                            line.position.z += mapExtrudeHeight + 0.01;\n                            lineGroup.add(line);\n\n                            // \u5e95\u9762\n                            mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n\n                            mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                            mesh.renderOrder = renderOrderGroundPlane;\n                            // mesh.material.transparent = true;\n                            // mesh.material.opacity = mapPlaneOpacity;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n                            wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                            wallMesh.renderOrder = renderOrderNoTransparent;\n                            scene.add(wallMesh);\n                        });\n                    }\n                });\n\n                isFinishLoadJson1 = true;\n                loadJsonFinished('\u6e56\u5357\u7701');\n            });  // end load\n        }\n        scene.add(lineGroup);\n        scene.add(shapeGroup);\n        if (true) {\n            loader.load(jsonBase + 'geo/\u6e56\u5357\u7701.json', function (data) {\n                data.features.forEach(function (area) {\n                    if (area.geometry.type === \"Polygon\") {\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            area.geometry.coordinates[0].forEach((elem) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                        });\n                    } else if (area.geometry.type === \"MultiPolygon\") {\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            polygon[0].forEach((elem, i) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            // console.log('vector2Arr.length2: ', vector2Arr.length); // \u6b64\u4ee3\u7801\u53ef\u4ee5\u83b7\u53d6\u7701\u8f6e\u5ed3\u70b9\u6570\u91cf\uff0c\u8bbe\u7f6eprovinceLinePointCount\n                            if (vector2Arr.length == provinceLinePointCount) {\n                                aniLineGeometry = new THREE.BufferGeometry();\n                                var vertices = new Float32Array(pointArr);\n                                var attribute = new THREE.BufferAttribute(vertices, 3);\n                                aniLineGeometry.attributes.position = attribute;\n                                // console.log('aniLineGeometry: ', aniLineGeometry);\n                                setProvinceLineAniColor(\n                                    aniLineGeometry,\n                                    provinceLinePointCount,\n                                    provinceLineAniPointCount,\n                                    provinceLineAniPointIndex1,\n                                    provinceLineAniPointIndex2\n                                )\n                                var material = new THREE.LineBasicMaterial({\n                                    vertexColors: THREE.VertexColors,\n                                });\n                                var aniProvinceLine = new THREE.LineLoop(aniLineGeometry, material);\n                                aniProvinceLine.position.z += mapExtrudeHeight + 0.01;\n                                scene.add(aniProvinceLine);\n                                var box3 = new THREE.Box3();\n                                box3.expandByObject(aniProvinceLine);\n                            }\n\n                            wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, true);  // 0x026086\n                            wallMesh.renderOrder = renderOrderNoTransparent;\n                            scene.add(wallMesh);\n                        });\n                    }\n                });\n\n                isFinishLoadJson2 = true;\n                loadJsonFinished('\u6e56\u5357\u7701');\n            });  // end load\n        }\n    }\n\n    function loadCityJson(cityName) {\n\n        if (true) { // \u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd(\u7701)\n            loader.load(isShowAllProvinceLine ? jsonBase + 'geo/\u6e56\u5357\u7701(\u5e02).json' : jsonBase + 'geo/\u6e56\u5357\u7701.json', function (data) {\n                data.features.forEach(function (area) {\n                    var mesh = null;\n\n                    if (area.geometry.type === \"Polygon\") {\n                        // console.log('Polygon');\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            area.geometry.coordinates[0].forEach((elem) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            line = createAreaLine(pointArr, chinaLineColor);\n                            line.position.z = 0.04;\n                            lineGroup.add(line);\n\n                            mesh = createShapePlaneMesh(vector2Arr, 0.01, chinaPlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            mesh.position.z -= 0.05;\n                            shapeGroup.add(mesh);\n                        });\n                    } else if (area.geometry.type === \"MultiPolygon\") {\n                        // console.log('MultiPolygon');\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            polygon[0].forEach((elem, i) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            line = createAreaLine(pointArr, chinaLineColor);\n                            line.position.z -= 0.04;\n                            lineGroup.add(line);\n\n                            mesh = createShapePlaneMesh(vector2Arr, 0.01, chinaPlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            mesh.position.z -= 0.05;\n                            shapeGroup.add(mesh);\n                        });\n                    }\n                });\n            });  // end load\n        }\n        if (true) {\n            loader.load(jsonBase + 'geo/' + cityName + '.json', function (data) {\n                data.features.forEach(function (area) {\n                    var mesh = null;\n\n                    if (area.geometry.type === \"Polygon\") {\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            area.geometry.coordinates[0].forEach((elem) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            // console.log('vector2Arr.length: ', vector2Arr.length);\n                            line = createAreaLine(pointArr, provinceLineColor);\n                            line.position.z += mapExtrudeHeight + 0.01;\n                            lineGroup.add(line);\n\n                            // \u5e95\u9762\n                            mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n\n                            mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                            mesh.renderOrder = renderOrderGroundPlane;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n\n                            // chooseMeshArrObj[mesh.name] = mesh;\n\n                            wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                            wallMesh.renderOrder = renderOrderNoTransparent;\n                            // console.log('wallMesh: ', wallMesh);\n                            scene.add(wallMesh);\n                        });\n                    } else if (area.geometry.type === \"MultiPolygon\") {\n                        // console.log('MultiPolygon');\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            polygon[0].forEach((elem, i) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            // console.log('vector2Arr.length1: ', vector2Arr.length);\n                            line = createAreaLine(pointArr, provinceLineColor);\n                            line.position.z += mapExtrudeHeight + 0.01;\n                            lineGroup.add(line);\n\n                            // \u5e95\u9762\n                            mesh = createShapePlaneMesh(vector2Arr, 0.03, provincePlaneColor, false);\n                            mesh.renderOrder = renderOrderNoTransparent;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n\n                            mesh = createShapePlaneMesh(vector2Arr, mapExtrudeHeight, provincePlaneColor, true);\n                            mesh.renderOrder = renderOrderGroundPlane;\n                            // mesh.material.transparent = true;\n                            // mesh.material.opacity = mapPlaneOpacity;\n                            mesh.name = area.properties.name;\n                            mesh.center = area.properties.center;\n                            mesh.centroid = area.properties.centroid;\n                            shapeGroup.add(mesh);\n                            wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, false);  // 0x026086\n                            wallMesh.renderOrder = renderOrderNoTransparent;\n                            scene.add(wallMesh);\n                        });\n                    }\n                });\n\n                isFinishLoadJson1 = true;\n                loadJsonFinished(cityName);\n            });  // end load\n        }\n        scene.add(lineGroup);\n        scene.add(shapeGroup);\n        if (true) {\n            loader.load(jsonBase + 'geo/' + cityName + '.json', function (data) {\n                data.features.forEach(function (area) {\n                    if (area.geometry.type === \"Polygon\") {\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            area.geometry.coordinates[0].forEach((elem) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                        });\n                    } else if (area.geometry.type === \"MultiPolygon\") {\n                        area.geometry.coordinates.forEach(polygon => {\n                            pointArr = [];\n                            var vector2Arr = [];\n                            polygon[0].forEach((elem, i) => {\n                                pointArr.push(elem[0], elem[1], 0);\n                                vector2Arr.push(new THREE.Vector2(elem[0], elem[1]));\n                            });\n                            // console.log('vector2Arr.length2: ', vector2Arr.length); // \u6b64\u4ee3\u7801\u53ef\u4ee5\u83b7\u53d6\u7701\u8f6e\u5ed3\u70b9\u6570\u91cf\uff0c\u8bbe\u7f6eprovinceLinePointCount\n                            if (vector2Arr.length == provinceLinePointCount) {\n                                aniLineGeometry = new THREE.BufferGeometry();\n                                var vertices = new Float32Array(pointArr);\n                                var attribute = new THREE.BufferAttribute(vertices, 3);\n                                aniLineGeometry.attributes.position = attribute;\n                                // console.log('aniLineGeometry: ', aniLineGeometry);\n                                setProvinceLineAniColor(\n                                    aniLineGeometry,\n                                    provinceLinePointCount,\n                                    provinceLineAniPointCount,\n                                    provinceLineAniPointIndex1,\n                                    provinceLineAniPointIndex2\n                                )\n                                var material = new THREE.LineBasicMaterial({\n                                    vertexColors: THREE.VertexColors,\n                                });\n                                var aniProvinceLine = new THREE.LineLoop(aniLineGeometry, material);\n                                aniProvinceLine.position.z += mapExtrudeHeight + 0.01;\n                                scene.add(aniProvinceLine);\n                                var box3 = new THREE.Box3();\n                                box3.expandByObject(aniProvinceLine);\n                            }\n\n                            wallMesh = createWallMesh(vector2Arr, mapExtrudeHeight, 'hh.png', provinceWallColor, 1, true);  // 0x026086\n                            wallMesh.renderOrder = renderOrderNoTransparent;\n                            scene.add(wallMesh);\n                        });\n                    }\n                });\n\n                isFinishLoadJson2 = true;\n                loadJsonFinished(cityName);\n            });  // end load\n        }\n    }\n\n    function addLight(){\n        // \u5de6\u4e0b\u4fa7\u5149 \u989c\u8272 \u5f3a\u5ea6 \u8ddd\u79bb\n        var pointLight1 = new THREE.PointLight(0xffffff, 1.5, 1000);\n        pointLight1.position.set(0, 0, -10);\n        // scene.add(pointLight1);\n\n        // \u5de6\u4e0a\u4fa7\u5149\n        var pointLight2 = new THREE.PointLight(0xffffff, 15, 1000);\n        // point.position.set(50, 50.48, 0);\n        pointLight2.position.set(50, 150.48, 0);\n        // scene.add(pointLight2);\n\n        // // \u4e0a\u65b9\u5149\n        var pointLight3 = new THREE.PointLight(0xffffff, 1.2, 1000);\n        pointLight3.position.set(104, 28.48, 300);\n        // scene.add(pointLight3);\n\n        var directionalLight1 = new THREE.DirectionalLight(0x888888, 2);//\u5149\u6e90\u989c\u8272\n        directionalLight1.position.set(137, 1000, 100);//\u5149\u6e90\u4f4d\u7f6e\n        scene.add(directionalLight1);//\u5149\u6e90\u6dfb\u52a0\u5230\u573a\u666f\u4e2d\n\n        var directionalLight2 = new THREE.DirectionalLight(0x888888, 12);//\u5149\u6e90\u989c\u8272\n        directionalLight2.position.set(137, 300, 100);//\u5149\u6e90\u4f4d\u7f6e\n        // scene.add(directionalLight2);//\u5149\u6e90\u6dfb\u52a0\u5230\u573a\u666f\u4e2d\n\n        var ambient = new THREE.AmbientLight(0x666666, 3.5);\n        // var ambient = new THREE.AmbientLight(0xffffff);\n        scene.add(ambient);\n    }\n\n    function setCamera(cityName){\n        // WebGLRenderer\n        renderer.setSize(renderWidth, renderHeight);\n        renderer.autoClear = false;\n        renderer.sortObjects = false; // \u5c1d\u8bd5\u81ea\u52a8\u6392\u5e8f\u5bf9\u8c61\n        render.outputEncoding = THREE.sRGBEncoding; // srg\u989c\u8272\n        // renderer.setClearColor(0x6675aa, 1);\n        renderer.setClearColor(0x004466, 0.6);  //0x001111\n        document.body.appendChild(renderer.domElement);\n        renderer.domElement.style.width = `${renderWidth}px`; // \u8bbe\u7f6eHTML\u753b\u5e03\u7684\u5b9e\u9645\u663e\u793a\u5c3a\u5bf8\n        renderer.domElement.style.height = `${renderHeight}px`;\n\n        // CSS3DRenderer\n        labelRenderer.setSize(renderWidth, renderHeight);\n        labelRenderer.domElement.style.position = 'absolute';\n\n        labelRenderer.domElement.style.top = '0px';\n        labelRenderer.domElement.style.left = '0px';\n        labelRenderer.domElement.style.pointerEvents = 'none';\n        document.body.appendChild(labelRenderer.domElement);\n\n        addEventListener('mousemove', onMouseMove);\n        addEventListener('resize', onResize);\n        addEventListener('click', onMouseClick);\n\n        // \u9f20\u6807\u64cd\u4f5c\n        // controls.maxPolarAngle = Math.PI / 2;\n        controls.enableDamping = true; // \u542f\u7528\u52a8\u6001\u963b\u5c3c\u65f6\u9700\u8981\u4e00\u4e2a\u52a8\u753b\u5faa\u73af\n        controls.dampingFactor = 0.03;\n        // controls.screenSpacePanning = false;\n        controls.mouseButtons = {\n            LEFT: THREE.MOUSE.ROTATE, // \u65cb\u8f6c\n            MIDDLE: THREE.MOUSE.DOLLY,  // \u7f29\u653e\n            RIGHT: THREE.MOUSE.PAN,  // \u79fb\u52a8\n        };\n        controls.minAzimuthAngle = -Math.PI / 4; // \u5de6\u4fa745\u5ea6\n        controls.maxAzimuthAngle = Math.PI / 4; // \u53f3\u4fa745\u5ea6\n        controls.minPolarAngle = Math.PI / 2; // 90\u5ea6 \u76f4\u89d2\n        controls.maxPolarAngle = Math.PI / 1.05; // 180\u5ea6\uff0c\u5373\u6c34\u5e73\u7ebf\n\n        controls.target.set(centerObj[cityName].x, centerObj[cityName].y , 0);\n\n        // camera\u5199\u5728\u8c03\u7528render()\u4e4b\u540e\n        camera.position.set(cameraObj[cityName][0], cameraObj[cityName][1], cameraObj[cityName][2]);\n        camera.lookAt(centerObj[cityName].x, centerObj[cityName].y, 0);\n    }\n\n</script>\n</body>\n\n</html>");
        String htmlString = stringHtml.toString();
        htmlString = htmlString.replaceAll("##plugin", jsResourcePath);
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(htmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String showLabel = optionObject.getString("showLabel");
        String area = optionObject.getString("area");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legend = legendArray.getJSONObject(0);
        JSONArray legendData = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            legendData.add((Object)seriesDatas[i]);
        }
        legend.put("data", (Object)legendData);
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            if (optionObject.containsKey((Object)"isParam")) {
                String are = optionObject.getString("paramValue");
                seriesObject.put("mapType", (Object)are);
                seriesObject.put("area", (Object)are);
                area = are;
            } else {
                seriesObject.put("mapType", (Object)area);
            }
            seriesObject.put("type", (Object)"map");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null && showLabel.equals("true")) {
                JSONObject showLabelObj = new JSONObject();
                showLabelObj.put("show", (Object)true);
                showLabelObj.put("formatter", (Object)labelFormatter);
                seriesObject.put("label", (Object)showLabelObj);
            }
            if (optionObject.containsKey((Object)"map-top")) {
                String top = optionObject.getString("map-top");
                seriesObject.put("top", (Object)top);
            }
            if (optionObject.containsKey((Object)"map-bottom")) {
                String bottom = optionObject.getString("map-bottom");
                seriesObject.put("bottom", (Object)bottom);
            }
            if (optionObject.containsKey((Object)"map-left")) {
                String left = optionObject.getString("map-left");
                seriesObject.put("left", (Object)left);
            }
            if (optionObject.containsKey((Object)"map-right")) {
                String right = optionObject.getString("map-right");
                seriesObject.put("right", (Object)right);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONObject dataObject = new JSONObject();
                String cData = categoryDatas[j];
                if ("china".equals(area)) {
                    if (cData.endsWith("\u7701")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u76f4\u8f96\u5e02")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u5e02")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u56de\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u58ee\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 6);
                    } else if (cData.endsWith("\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    }
                }
                dataObject.put("name", (Object)cData);
                dataObject.put("value", (Object)valueDatas[i + j * seriesDatas.length]);
                seriesDataArray.add((Object)dataObject);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/china.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/anhui.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/aomen.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/beijing.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/chongqing.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/fujian.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/gansu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guangdong.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guangxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guizhou.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hainan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hebei.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/heilongjiang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/henan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hubei.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hunan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jiangsu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jiangxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jilin.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/liaoning.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/neimenggu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/ningxia.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/qinghai.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shandong.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanghai.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanxi1.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/sichuan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/tianjin.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/taiwan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xianggang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xinjiang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xizang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/yunnan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/zhejiang.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u6e56\u5357\u77013D\u94bb\u53d6\u5730\u56fe";
    }

    public static String getClassName() {
        return "Map_HuNan_3D_ZQ";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        return optionJson.toString();
    }
}

