/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.MarkerSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.List;

public class PolylineSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IMarkerCapable {
    protected List<Point> points = new ArrayList<Point>();

    protected List<Point> getPoints() {
        return this.points;
    }

    protected void setPoints(String pointsAttribute) {
        if (pointsAttribute == null) {
            return;
        }
        List<String> points = SvgCssUtils.splitValueList(pointsAttribute);
        if (points.size() % 2 != 0) {
            throw new SvgProcessingException("Points attribute {0} on polyline tag does not contain a valid set of points").setMessageParams(new Object[]{pointsAttribute});
        }
        this.points.clear();
        for (int i = 0; i < points.size(); i += 2) {
            float x = CssDimensionParsingUtils.parseAbsoluteLength((String)points.get(i));
            float y = CssDimensionParsingUtils.parseAbsoluteLength((String)points.get(i + 1));
            this.points.add(new Point((double)x, (double)y));
        }
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        this.setPoints(this.getAttribute("points"));
        if (this.points.size() > 1) {
            Point firstPoint = this.points.get(0);
            double minX = firstPoint.getX();
            double minY = firstPoint.getY();
            double maxX = minX;
            double maxY = minY;
            for (int i = 1; i < this.points.size(); ++i) {
                Point current = this.points.get(i);
                double currentX = current.getX();
                minX = Math.min(minX, currentX);
                maxX = Math.max(maxX, currentX);
                double currentY = current.getY();
                minY = Math.min(minY, currentY);
                maxY = Math.max(maxY, currentY);
            }
            double width = maxX - minX;
            double height = maxY - minY;
            return new Rectangle((float)minX, (float)minY, (float)width, (float)height);
        }
        return null;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        String pointsAttribute = this.attributesAndStyles.containsKey("points") ? (String)this.attributesAndStyles.get("points") : null;
        this.setPoints(pointsAttribute);
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% polyline\n");
        if (this.points.size() > 1) {
            Point currentPoint = this.points.get(0);
            canvas.moveTo(currentPoint.getX(), currentPoint.getY());
            for (int x = 1; x < this.points.size(); ++x) {
                currentPoint = this.points.get(x);
                canvas.lineTo(currentPoint.getX(), currentPoint.getY());
            }
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PolylineSvgNodeRenderer copy = new PolylineSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public void drawMarker(SvgDrawContext context, MarkerVertexType markerVertexType) {
        Point point = null;
        if (MarkerVertexType.MARKER_START.equals((Object)markerVertexType)) {
            point = this.points.get(0);
        } else if (MarkerVertexType.MARKER_END.equals((Object)markerVertexType)) {
            point = this.points.get(this.points.size() - 1);
        }
        if (point != null) {
            String moveX = SvgCssUtils.convertDoubleToString(CssUtils.convertPtsToPx((double)point.getX()));
            String moveY = SvgCssUtils.convertDoubleToString(CssUtils.convertPtsToPx((double)point.getY()));
            MarkerSvgNodeRenderer.drawMarker(context, moveX, moveY, markerVertexType, this);
        }
    }

    @Override
    public double getAutoOrientAngle(MarkerSvgNodeRenderer marker, boolean reverse) {
        if (this.points.size() > 1) {
            Vector v = new Vector(0.0f, 0.0f, 0.0f);
            if ("marker-end".equals(marker.attributesAndStyles.get("marker"))) {
                Point lastPoint = this.points.get(this.points.size() - 1);
                Point secondToLastPoint = this.points.get(this.points.size() - 2);
                v = new Vector((float)(lastPoint.getX() - secondToLastPoint.getX()), (float)(lastPoint.getY() - secondToLastPoint.getY()), 0.0f);
            } else if ("marker-start".equals(marker.attributesAndStyles.get("marker"))) {
                Point firstPoint = this.points.get(0);
                Point secondPoint = this.points.get(1);
                v = new Vector((float)(secondPoint.getX() - firstPoint.getX()), (float)(secondPoint.getY() - firstPoint.getY()), 0.0f);
            }
            Vector xAxis = new Vector(1.0f, 0.0f, 0.0f);
            double rotAngle = SvgCoordinateUtils.calculateAngleBetweenTwoVectors(xAxis, v);
            return v.get(1) >= 0.0f && !reverse ? rotAngle : rotAngle * -1.0;
        }
        return 0.0;
    }
}

