/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EFMultiTabs {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = "{}";
            String clazzName = EFMultiTabs.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>\n<html>\n<head>\n    <title></title>\n    <!-- \u5f15\u5165 Semantic UI \u6837\u5f0f -->\n    <link rel=\"stylesheet\" href=\"" + jsResourceHttp + "/semantic/css/semantic.min.css\">\n    <link rel=\"stylesheet\" href=\"" + jsResourceHttp + "/multiTabs/basic.css\">\n    <style>\n\n        html,body{\n            width:100%;\n            height:100%;\n            padding:0px;\n            margin:0px;\n        }\n\n        .main-container {\n            width:100%;\n            height:100%;\n        }\n        .nested-tabs {\n            margin-top: 15px;\n            border: 1px solid #ddd;\n            padding: 10px;\n        }\n        iframe {\n            width: 100%;\n            height: 100%;\n            border: none;\n        }\n\n        .ui.segment {\n            margin:0!important;\n            padding:5px !important;\n        }\n\n        .bottom{\n            height:calc(100% - 40px);\n        }\n\n\n\n    </style>\n</head>\n<body>\n<div class=\"main-container\">\n    <div class=\"ui pointing secondary menu\">\n        <a class=\"item\" data-tab=\"first\">First</a>\n        <a class=\"item\" data-tab=\"second\">Second</a>\n        <a class=\"item active\" data-tab=\"third\">Third</a>\n    </div>\n    <div class=\"ui tab segment\" data-tab=\"first\">\n        <div class=\"ui top attached tabular menu\">\n            <a class=\"active item\" data-tab=\"first/a\">1A</a>\n            <a class=\"item\" data-tab=\"first/b\">1B</a>\n            <a class=\"item\" data-tab=\"first/c\">1C</a>\n        </div>\n        <div class=\"ui bottom attached active tab segment\" data-tab=\"first/a\">\n            1A\n        </div>\n        <div class=\"ui bottom attached tab segment\" data-tab=\"first/b\">\n            1B\n        </div>\n        <div class=\"ui bottom attached tab segment\" data-tab=\"first/c\">\n            1C\n        </div>\n    </div>\n    <div class=\"ui tab segment\" data-tab=\"second\">\n        <div class=\"ui top attached tabular menu\">\n            <a class=\"item active\" data-tab=\"second/a\">2A</a>\n            <a class=\"item\" data-tab=\"second/b\">2B</a>\n            <a class=\"item\" data-tab=\"second/c\">2C</a>\n        </div>\n        <div class=\"ui bottom attached tab segment active\" data-tab=\"second/a\">2A</div>\n        <div class=\"ui bottom attached tab segment\" data-tab=\"second/b\">2B</div>\n        <div class=\"ui bottom attached tab segment\" data-tab=\"second/c\">2C</div>\n    </div>\n    <div class=\"ui tab segment active\" data-tab=\"third\">\n        <div class=\"ui top attached tabular menu\">\n            <a class=\"item active\" data-tab=\"third/a\">3A</a>\n            <a class=\"item\" data-tab=\"third/b\">3B</a>\n            <a class=\"item\" data-tab=\"third/c\">3C</a>\n        </div>\n        <div class=\"ui bottom attached tab segment active\" data-tab=\"third/a\">3A</div>\n        <div class=\"ui bottom attached tab segment\" data-tab=\"third/b\">3B</div>\n        <div class=\"ui bottom attached tab segment\" data-tab=\"third/c\">3C</div>\n    </div>\n</div>\n\n\n<!-- \u5f15\u5165 jQuery \u548c Semantic UI JS -->\n<script src=\"" + jsResourceHttp + "/jquery-1.11.3.min.js\"></script>\n<script src=\"" + jsResourceHttp + "/semantic/semantic.min.js\"></script>\n<script>\n    $(document).ready(function() {\n\n        $('.main-container').children('.tab').css('height' , $('.main-container').height() - 54);\n\n        // \u521d\u59cb\u5316\u4e3b\u9009\u9879\u5361\n        $('.main-container .item').tab({\n            // \u4e3b\u9009\u9879\u5361\u5207\u6362\u65f6\u521d\u59cb\u5316\u5d4c\u5957\u9009\u9879\u5361\n            onVisible: function() {\n                // \u5ef6\u8fdf\u786e\u4fddDOM\u52a0\u8f7d\u5b8c\u6210\n                setTimeout(initNestedTabs, 50);\n            }\n        });\n\n        // \u521d\u59cb\u5316\u5d4c\u5957\u9009\u9879\u5361\n        function initNestedTabs() {\n            $('.bottom .item').tab({\n                // \u5d4c\u5957\u9009\u9879\u5361\u5207\u6362\u65f6\u52a0\u8f7diframe\n                onVisible: function(target) {\n                    const $iframe = $(target).find('iframe');\n                    // \u5ef6\u8fdf\u52a0\u8f7d\u907f\u514d\u91cd\u590d\u8bf7\u6c42\n                    if (!$iframe.attr('src')) {\n                        $iframe.attr('src', $iframe.data('src'));\n                    }\n                }\n            }); // \u9ed8\u8ba4\u663e\u793a\u7b2c\u4e00\u4e2a\u5b50\u9009\u9879\u5361\n        }\n\n        // \u9ed8\u8ba4\u521d\u59cb\u5316\u5d4c\u5957\u9009\u9879\u5361\n        initNestedTabs();\n    });\n</script>\n</body>\n</html>\n");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFMultiTabs.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", opJson.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("  elem: '#table'");
        sb.append("   ,height: 312");
        sb.append("   ,url: '/static/json/table/user.json'");
        sb.append("   ,page: true ");
        sb.append("   ,cols: [[ ");
        sb.append("    {field: 'id', title: 'ID', width:80, sort: true, fixed: 'left'}");
        sb.append("    ,{field: 'username', title: '\u7528\u6237\u540d', width:80}");
        sb.append("    ,{field: 'sex', title: '\u6027\u522b', width:80, sort: true}");
        sb.append("    ,{field: 'city', title: '\u57ce\u5e02', width:80}");
        sb.append("    ,{field: 'sign', title: '\u7b7e\u540d', width: 177}");
        sb.append("    ,{field: 'experience', title: '\u79ef\u5206', width: 80, sort: true}");
        sb.append("    ,{field: 'score', title: '\u8bc4\u5206', width: 80, sort: true}");
        sb.append("    ,{field: 'classify', title: '\u804c\u4e1a', width: 80}");
        sb.append("   ,{field: 'words', title: '\u5b57\u6570', width: 135, sort: true}");
        sb.append("   ]]");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        try {
            String labelName;
            JSONObject opt;
            int i;
            String value;
            JSONObject param;
            int i2;
            String paramStr = "";
            JSONObject paramsObj = JSONObject.parseObject((String)reportInfo);
            JSONArray reportParams = paramsObj.getJSONArray("reportParams");
            JSONArray templateParams = new JSONArray();
            for (i2 = 0; i2 < reportParams.size(); ++i2) {
                param = reportParams.getJSONObject(i2);
                for (String key : param.keySet()) {
                    value = (String)param.get((Object)key);
                    if (key.startsWith("ef") || value.equals("")) continue;
                    templateParams.add((Object)param);
                }
            }
            for (i2 = 0; i2 < templateParams.size(); ++i2) {
                param = templateParams.getJSONObject(i2);
                for (String key : param.keySet()) {
                    value = (String)param.get((Object)key);
                    if (i2 == templateParams.size() - 1) {
                        paramStr = paramStr + key + "=" + value;
                        continue;
                    }
                    paramStr = paramStr + key + "=" + value + "&";
                }
            }
            StringBuffer sb = new StringBuffer();
            String base = jsResourcePath.substring(0, jsResourcePath.length() - 7);
            JSONObject tabOption = JSONObject.parseObject((String)option);
            String token = tabOption.getString("token");
            JSONArray options = tabOption.getJSONArray("option");
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang='zh-cmn-Hans'>");
            sb.append("<head>");
            sb.append(" <meta charset='UTF-8'>");
            sb.append("        <meta http-equiv='pragma' content='no-cache'>");
            sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
            sb.append("        <meta http-equiv='expires' content='0'>");
            sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
            sb.append("        <meta name='format-detection' content='telephone=no'>");
            sb.append("        <meta name='format-detection' content='email=no'>");
            sb.append("        <meta name='format-detection' content='adress=no'>");
            sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
            sb.append("<script src='" + jsResourcePath + "/semantic/semantic.min.js'></script>");
            sb.append("<link href='" + jsResourcePath + "/semantic/css/semantic.min.css' rel='stylesheet'>");
            sb.append("<link href='" + jsResourcePath + "/multiTabs/basic.css' rel='stylesheet'>");
            sb.append("</head>");
            sb.append("<style>");
            sb.append("    html, body {");
            sb.append("    border: 0px;");
            sb.append("    margin: 0px;");
            sb.append("    padding: 0px;");
            sb.append("    width: 100%;");
            sb.append("    height: 100%;");
            sb.append(" }");
            sb.append("</style>");
            sb.append("<body style='margin:0px;padding:0px;'>");
            sb.append("<div class=\"main-container\">\n");
            sb.append("    <div class=\"ui pointing secondary menu\">\n");
            for (i = 0; i < options.size(); ++i) {
                opt = options.getJSONObject(i);
                labelName = opt.getString("labelName");
                if (i == 0) {
                    sb.append("     <a class='active item' data-tab='tab_" + i + "'>" + labelName + "</a>\n");
                    continue;
                }
                sb.append("     <a class='item' data-tab='tab_" + i + "'>" + labelName + "</a>\n");
            }
            sb.append("     </div>\n");
            for (i = 0; i < options.size(); ++i) {
                JSONObject labelObj;
                int j;
                if (i == 0) {
                    sb.append("     <div class='ui active tab segment' data-tab='tab_" + i + "'>\n");
                } else {
                    sb.append("     <div class='ui tab segment' data-tab='tab_" + i + "'>\n");
                }
                sb.append("         <div class=\"ui top attached tabular menu\">\n");
                opt = options.getJSONObject(i);
                labelName = opt.getString("labelName");
                JSONArray secLabels = opt.getJSONArray("secLabels");
                for (j = 0; j < secLabels.size(); ++j) {
                    labelObj = secLabels.getJSONObject(j);
                    if (j == 0) {
                        sb.append("<a class='active item' data-tab='tab_" + i + "_" + j + "'>" + labelObj.getString("title") + "</a>\n");
                        continue;
                    }
                    sb.append("<a class='item' data-tab='tab_" + i + "_" + j + "'>" + labelObj.getString("title") + "</a>\n");
                }
                sb.append("</div>");
                for (j = 0; j < secLabels.size(); ++j) {
                    String url;
                    labelObj = secLabels.getJSONObject(j);
                    String id = labelObj.getString("templateId");
                    if (j == 0) {
                        sb.append("<div class='ui bottom attached active tab segment'  data-tab='tab_" + i + "_" + j + "' id ='tab_" + i + "_" + j + "'>\n");
                        url = base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                        url = paramStr.equals("") ? base + "/reportTab.html?id=" + id + "&token=" + token : base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                        if (i == 0) {
                            sb.append("<iframe  class='tab_" + i + "' id='frame_" + id + "' src='" + url + "' style='width:100%;height:100%' frameborder='0' scrolling='no' ></iframe>");
                        } else {
                            sb.append("<iframe  class='tab_" + i + "' id='frame_" + id + "' style='width:100%;height:100%;' frameborder='0' scrolling='no'  hidden='true'></iframe>");
                        }
                        sb.append("</div>");
                        continue;
                    }
                    sb.append("<div class='ui bottom attached tab segment' data-tab='tab_" + i + "_" + j + "' id ='tab_" + i + "_" + j + "'>\n");
                    url = base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                    url = paramStr.equals("") ? base + "/reportTab.html?id=" + id + "&token=" + token : base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                    if (i == 0) {
                        sb.append("<iframe  class='tab_" + i + "' id='frame_" + id + "'  style='width:100%;height:100%' frameborder='0' scrolling='no' ></iframe>");
                    } else {
                        sb.append("<iframe  class='tab_" + i + "' id='frame_" + id + "'  style='width:100%;height:100%;' frameborder='0' scrolling='no'  hidden='true'></iframe>");
                    }
                    sb.append("</div>");
                }
                sb.append("</div>");
            }
            sb.append("</div>");
            sb.append("</body>");
            sb.append("<script type='text/javascript'>\n");
            sb.append("let urlMap = {};");
            for (i = 0; i < options.size(); ++i) {
                opt = options.getJSONObject(i);
                JSONArray secLabels = opt.getJSONArray("secLabels");
                for (int j = 0; j < secLabels.size(); ++j) {
                    JSONObject labelObj = secLabels.getJSONObject(j);
                    String id = labelObj.getString("templateId");
                    String url = base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                    String tabId = "tab_" + i + "_" + j;
                    sb.append("urlMap['" + tabId + "'] = '" + url + "';");
                }
            }
            sb.append("console.log(urlMap);");
            sb.append(" $(document).ready(function() {\n\n        $('.main-container').children('.tab').css('height' , $('.main-container').height() - 54);\n\n        // \u521d\u59cb\u5316\u4e3b\u9009\u9879\u5361\n        $('.main-container .item').tab({\n            // \u4e3b\u9009\u9879\u5361\u5207\u6362\u65f6\u521d\u59cb\u5316\u5d4c\u5957\u9009\u9879\u5361\n            onVisible: function(target) {\n                if(urlMap[target] == undefined){                    let firstFrame = $('.' + target).eq(0);\n                    firstFrame.show();\n                    if (firstFrame.attr('src') == undefined) {\n                        firstFrame.attr('src', urlMap[firstFrame.parent().attr('id')]);\n                    }                }else{                let id = $('#' + target);                    id.find('iframe').show();                    if (id.find('iframe').attr('src') == undefined) {\n                        id.find('iframe').attr('src', urlMap[target]);\n                    }\n               }                // \u5ef6\u8fdf\u786e\u4fddDOM\u52a0\u8f7d\u5b8c\u6210\n                //setTimeout(initNestedTabs, 50);\n            }\n        });\n\n        // \u521d\u59cb\u5316\u5d4c\u5957\u9009\u9879\u5361\n        function initNestedTabs() {\n            $('.bottom').tab({\n                // \u5d4c\u5957\u9009\u9879\u5361\u5207\u6362\u65f6\u52a0\u8f7diframe\n                onVisible: function(target) {\n                    const $iframe = $(target).find('iframe');\n                    console.log(!$iframe.attr('src'))                    // \u5ef6\u8fdf\u52a0\u8f7d\u907f\u514d\u91cd\u590d\u8bf7\u6c42\n                    if (!$iframe.attr('src')) {\n                        $iframe.attr('src', $iframe.data('src'));\n                    }\n                }\n            }); // \u9ed8\u8ba4\u663e\u793a\u7b2c\u4e00\u4e2a\u5b50\u9009\u9879\u5361\n        }\n\n        // \u9ed8\u8ba4\u521d\u59cb\u5316\u5d4c\u5957\u9009\u9879\u5361\n        initNestedTabs();\n    });");
            sb.append("</script>");
            sb.append("</html>");
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(sb.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        String base = jsResourcePath.substring(0, jsResourcePath.length() - 7);
        JSONObject tabOption = JSONObject.parseObject((String)option);
        String token = tabOption.getString("token");
        JSONArray columns = tabOption.getJSONArray("columns");
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/slick.min.js'></script>");
        sb.append("<link href='" + jsResourcePath + "/slick.css' rel='stylesheet'>");
        sb.append("<link href='" + jsResourcePath + "/slick.min.css' rel='stylesheet'>");
        sb.append("</head>");
        sb.append("<style>");
        sb.append("    html, body {");
        sb.append("    border: 0px;");
        sb.append("    margin: 0px;");
        sb.append("    padding: 0px;");
        sb.append("    height: 100%;");
        sb.append(" }");
        sb.append("</style>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div class=\"ui container\">");
        sb.append("<div class=\"ui slider\">");
        for (int i = 0; i < columns.size(); ++i) {
            JSONObject obj = columns.getJSONObject(i);
            String id = obj.getString("id");
            String name = obj.getString("name");
            String css = obj.getString("css");
            if (css.contains("@base")) {
                css = css.replace("@base", base + "/pluginResource/upload");
                css = css + ";background-size:100% 100%;";
                css = css + "background-repeat:no-repeat;cursor:pointer;";
            }
            sb.append("<button style=\"" + css + "\" onclick='change(" + id + ")'>" + name + "</button>");
            String url = base + "/reportTab.html?id=" + id + "&token=" + token;
            if (i == 0) {
                sb.append("<div><iframe id='frame_" + id + "' src='" + url + "' style='width:100%;height:100%' frameborder='0' scrolling='no'></iframe></div>");
                continue;
            }
            sb.append("<div><iframe id='frame_" + id + "' style='width:100%;height:100%;' frameborder='0' scrolling='no' hidden='true'></iframe></div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("function change(id){\n                       let token='" + token + "';                       let base = '" + base + "';                      var fId='frame_' + id;                       $('body').find('iframe').hide();\n                       console.log($('#' + fId).attr('src'));if($('#' + fId).attr('src') == undefined){$('#' + fId).attr('src',base + '/reportTab.html?id=' + id + '&token=' + token)};$('#' + fId).attr('hidden' , 'false').show();\n                    }");
        sb.append("$(document).ready(function(){");
        sb.append("$('.ui.slider').slick({\n    dots: true,  // \u663e\u793a\u70b9\u5bfc\u822a\n    infinite: true,  // \u65e0\u9650\u5faa\u73af\n    speed: 500,  // \u8fc7\u6e21\u901f\u5ea6\n    slidesToShow: 1,  // \u6bcf\u6b21\u663e\u793a1\u5f20\u56fe\n    adaptiveHeight: true  // \u9ad8\u5ea6\u81ea\u9002\u5e94\n  });");
        sb.append("});\n");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        return 0;
    }

    public static String getPluginName() {
        return "\u591a\u7ea7Tab\u9875\u63d2\u4ef6";
    }

    public static String getClassName() {
        return "EFMultiTabs";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        return new JSONObject().toString();
    }
}

