/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.Locale;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;
import javax.help.search.IndexerKit;

public class DefaultIndexerKit
extends IndexerKit {
    protected boolean documentStarted;
    private boolean debugFlag = false;

    public DefaultIndexerKit() {
        this.locale = Locale.getDefault();
    }

    @Override
    public Object clone() {
        return new DefaultIndexerKit();
    }

    @Override
    public String getContentType() {
        return "";
    }

    @Override
    public void parse(Reader reader, String string, boolean bl, IndexBuilder indexBuilder, ConfigFile configFile) throws IOException {
        this.debug("parsing " + string);
    }

    @Override
    public int parseIntoTokens(String string, int n) {
        int n2 = n;
        try {
            BreakIterator breakIterator = BreakIterator.getWordInstance(this.locale);
            breakIterator.setText(string);
            int n3 = breakIterator.first();
            int n4 = breakIterator.next();
            while (n4 != -1) {
                int n5;
                String string2 = new String(string.substring(n3, n4));
                string2 = string2.trim();
                if ((string2 = string2.toLowerCase(this.locale)).length() > 1) {
                    this.storeToken(string2, n2 + n3);
                } else if (string2.length() == 1 && ((n5 = Character.getType(string2.charAt(0))) == 9 || n5 == 10 || n5 == 2 || n5 == 5 || n5 == 11 || n5 == 3 || n5 == 0 || n5 == 1)) {
                    this.storeToken(string2, n2 + n3);
                }
                n3 = n4;
                n4 = breakIterator.next();
            }
            n2 += string.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    @Override
    protected void startStoreDocument(String string) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.openDocument(this.config.getURLString(string));
    }

    @Override
    protected void endStoreDocument() throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.closeDocument();
    }

    @Override
    protected void storeToken(String string, int n) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        if (!this.documentStarted) {
            try {
                this.startStoreDocument(this.file);
                this.documentStarted = true;
            }
            catch (Exception exception) {
                if (this.debugFlag) {
                    exception.printStackTrace();
                }
                throw new IOException("Can't store Document");
            }
        }
        this.builder.storeLocation(string, n);
    }

    @Override
    protected void storeTitle(String string) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.storeTitle(string);
    }

    private void debug(String string) {
        if (this.debugFlag) {
            System.err.println("DefaultIndexKit: " + string);
        }
    }
}

